/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.common.util;

import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ListSortUtils {
    private static final Log log = LogFactory.getLog(ListSortUtils.class);

    public static <E> void sort(List<E> list, final boolean isAsc, final String ... sortNameArr) {
        list.sort(new Comparator<E>(){

            @Override
            public int compare(E a, E b) {
                int ret = 0;
                try {
                    for (int i = 0; i < sortNameArr.length && 0 == (ret = ListSortUtils.compareObject(sortNameArr[i], isAsc, a, b)); ++i) {
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                return ret;
            }
        });
    }

    public static <E> void sort(List<E> list, final String[] sortNameArr, final boolean[] typeArr) {
        if (sortNameArr.length != typeArr.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u6027\u6570\u7ec4\u5143\u7d20\u4e2a\u6570\u548c\u5347\u964d\u5e8f\u6570\u7ec4\u5143\u7d20\u4e2a\u6570\u4e0d\u76f8\u7b49\u3002", (String)"ListSortUtils_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        list.sort(new Comparator<E>(){

            @Override
            public int compare(E a, E b) {
                int ret = 0;
                try {
                    for (int i = 0; i < sortNameArr.length && 0 == (ret = ListSortUtils.compareObject(sortNameArr[i], typeArr[i], a, b)); ++i) {
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                return ret;
            }
        });
    }

    private static <E> int compareObject(String sortName, boolean isAsc, E a, E b) throws Exception {
        Object value1 = ListSortUtils.forceGetFieldValue(a, sortName);
        Object value2 = ListSortUtils.forceGetFieldValue(b, sortName);
        String str1 = value1.toString();
        String str2 = value2.toString();
        if (value1 instanceof Number && value2 instanceof Number) {
            int maxlen = Math.max(str1.length(), str2.length());
            str1 = ListSortUtils.addZero2Str((Number)value1, maxlen);
            str2 = ListSortUtils.addZero2Str((Number)value2, maxlen);
        } else if (value1 instanceof Date && value2 instanceof Date) {
            long time1 = ((Date)value1).getTime();
            long time2 = ((Date)value2).getTime();
            int maxlen = Long.toString(Math.max(time1, time2)).length();
            str1 = ListSortUtils.addZero2Str(time1, maxlen);
            str2 = ListSortUtils.addZero2Str(time2, maxlen);
        }
        int ret = isAsc ? str1.compareTo(str2) : str2.compareTo(str1);
        return ret;
    }

    private static String addZero2Str(Number numObj, int length) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(length);
        nf.setMinimumIntegerDigits(length);
        return nf.format(numObj);
    }

    private static Object forceGetFieldValue(Object obj, String fieldName) throws Exception {
        if (obj instanceof DynamicObject) {
            return ((DynamicObject)obj).get(fieldName);
        }
        Field field = obj.getClass().getDeclaredField(fieldName);
        Object object = null;
        boolean accessible = field.isAccessible();
        if (!accessible) {
            object = field.get(obj);
            return object;
        }
        object = field.get(obj);
        return object;
    }
}

