/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;

public class AggregateListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(AggregateListPlugin.class);

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection rowDataCol = e.getPageData();
        if (rowDataCol != null && rowDataCol.size() > 0) {
            ReserveHelper.mergeQtyForHighHot("msmod_reserveaggre", rowDataCol);
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (!"ide_formdesigner".equals(this.getView().getFormShowParameter().getParentFormId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"showdetail", "resum", "showreserve"});
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        StringBuilder errSb = new StringBuilder();
        try {
            DynamicObject rowData = e.getRowData();
            rowData.set("avbbaseqty", (Object)rowData.getBigDecimal("baseqty").subtract(rowData.getBigDecimal("lockbaseqty")));
            rowData.set("avbqty", (Object)rowData.getBigDecimal("qty").subtract(rowData.getBigDecimal("lockqty")));
            rowData.set("avbqty2nd", (Object)rowData.getBigDecimal("qty2nd").subtract(rowData.getBigDecimal("lockqty2nd")));
        }
        catch (Exception ex) {
            errSb.append(ex.getMessage());
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("lockbaseqty".equals(args.getFieldName())) {
            BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
            ListShowParameter fsp = new ListShowParameter();
            fsp.setBillFormId("msmod_reserve_record");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            QFilter filter = new QFilter("aggregateid", "=", currentRow.getPrimaryKeyValue());
            fsp.getListFilterParameter().setFilter(filter);
            this.getView().showForm((FormShowParameter)fsp);
            args.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        int checkAgg = 0;
        try {
            Map<String, Object> aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
            if (((Boolean)aggregateCfg.get("isAggregate")).booleanValue()) {
                if (!((Boolean)aggregateCfg.get("isAggregateInit")).booleanValue()) {
                    checkAgg = 1;
                }
            } else {
                checkAgg = 2;
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        if (checkAgg == 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u603b\u91cf\u9884\u7559\u8bbe\u7f6e\u542f\u7528\u540e\u672a\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u8bf7\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"ReserveHelper_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            e.getQFilters().add(new QFilter("1", "!=", (Object)1));
        } else if (checkAgg == 2) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u603b\u91cf\u9884\u7559\u3002", (String)"AggregateReportPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            e.getQFilters().add(new QFilter("1", "!=", (Object)1));
        }
    }
}

