/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;

public class AggregateReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(AggregateReportPlugin.class);

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        for (SortAndFilterEvent event : list) {
            event.setSort(true);
            event.setFilter(true);
        }
        this.getView().updateView();
    }

    public void registerListener(EventObject eventObject) {
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        try {
            Map<String, Object> aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
            if (aggregateCfg == null) {
                return false;
            }
            if (((Boolean)aggregateCfg.get("isAggregate")).booleanValue()) {
                if (((Boolean)aggregateCfg.get("isAggregateInit")).booleanValue()) {
                    return true;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u603b\u91cf\u9884\u7559\u8bbe\u7f6e\u542f\u7528\u540e\u672a\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u8bf7\u8fdb\u884c\u521d\u59cb\u5316\u3002", (String)"ReserveHelper_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                return false;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u603b\u91cf\u9884\u7559\u3002", (String)"AggregateReportPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            return false;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        try {
            Object obj = this.getModel().getValue("material");
            if (obj == null) {
                queryParam.setCustomFilter(null);
            } else {
                DynamicObjectCollection col = (DynamicObjectCollection)obj;
                if (col.size() == 0) {
                    queryParam.setCustomFilter(null);
                } else {
                    HashSet<Object> materialIdSet = new HashSet<Object>(8);
                    for (DynamicObject m : col) {
                        materialIdSet.add(m.get("fbasedataid_id"));
                    }
                    ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
                    QFilter qFilter = new QFilter("material", "in", materialIdSet);
                    qFilterList.add(qFilter);
                    queryParam.setCustomFilter(qFilterList);
                }
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        StringBuilder errSb = new StringBuilder();
        try {
            DynamicObject rowData = e.getRowData();
            rowData.set("avbbaseqty", (Object)rowData.getBigDecimal("baseqty").subtract(rowData.getBigDecimal("lockbaseqty")));
            rowData.set("avbqty", (Object)rowData.getBigDecimal("qty").subtract(rowData.getBigDecimal("lockqty")));
            rowData.set("avbqty2nd", (Object)rowData.getBigDecimal("qty2nd").subtract(rowData.getBigDecimal("lockqty2nd")));
        }
        catch (Exception ex) {
            errSb.append(ex.getMessage());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent paramEvent) {
        int row = paramEvent.getRowIndex();
        Object aggId = this.getModel().getEntryRowEntity("reportlistap", row).getPkValue();
        ListShowParameter fsp = new ListShowParameter();
        fsp.setBillFormId("msmod_reserve_record");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        QFilter filter = new QFilter("aggregateid", "=", aggId);
        fsp.getListFilterParameter().setFilter(filter);
        this.getView().showForm((FormShowParameter)fsp);
    }
}

