/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.ConvRateContext;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.SchemeHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.record.RequestBillEntryParam;
import kd.mpscmm.msbd.reserve.business.strategy.QtyStore;
import kd.mpscmm.msbd.reserve.business.strategy.RuleEngine;
import kd.mpscmm.msbd.reserve.business.strategy.StrategyEngine;
import kd.mpscmm.msbd.reserve.business.strategy.engine.parser.FilterParser;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.EntryReserveResult;
import kd.mpscmm.msbd.reserve.business.strategy.result.ReserveResultType;
import kd.mpscmm.msbd.reserve.business.strategy.result.StdInvResult;
import kd.mpscmm.msbd.reserve.common.colsAssist.ManualReserveEntryRuleParam;

public class ManualReserveMainPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ManualReserveMainPlugin.class);
    private Map<String, String> supplyFieldMap = ManualReserveMainPlugin.getSupplyFieldMap();
    private Map<String, String> supplyFieldBillMap = ManualReserveMainPlugin.getSupplyFieldBilMap();
    private Map<Long, ManualReserveEntryRuleParam> entryRuleParamMap = new HashMap<Long, ManualReserveEntryRuleParam>(8);
    private Set<Long> supplyEntryIdSet = new HashSet<Long>(8);
    private boolean qtyChanged;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"auto_assign", "bt_save"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            String schemeId = (String)this.getView().getFormShowParameter().getCustomParam("schemeId");
            DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(schemeId), (String)"msmod_reserve_scheme");
            DynamicObject requestBill = this.getRequestBill();
            if (requestBill == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u9700\u6c42\u5355\u636e\u7684\u5206\u5f55\u4fe1\u606f\u6709\u8bef\u3002", (String)"ManualReserveMainPlugin_12", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                return;
            }
            ColsMap colsMap = ColsMapHelper.findBillColMaps(requestBill.getDataEntityType().getName(), "msmod_std_request_bill");
            ReserveContext context = new ReserveContext(requestBill, scheme);
            List<RequestBillEntryParam> reserveEntryParams = this.getSortRequestBillEntryParamList(context, colsMap, requestBill);
            this.fillRequestInfo(context, requestBill, reserveEntryParams, colsMap);
            this.dealSupplyInfo(scheme.getDynamicObjectCollection("strategy_entry"), context, reserveEntryParams);
        }
        catch (Exception ex) {
            this.getModel().beginInit();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"auto_assign", "bt_save"});
            this.getView().updateView();
            this.getModel().endInit();
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private List<RequestBillEntryParam> getSortRequestBillEntryParamList(ReserveContext context, ColsMap colsMap, DynamicObject requestBill) {
        List<RequestBillEntryParam> reserveEntryParams = context.getRequestBillEntryParamList();
        reserveEntryParams.sort(new Comparator<RequestBillEntryParam>(){

            @Override
            public int compare(RequestBillEntryParam o1, RequestBillEntryParam o2) {
                return o1.getBillEntry().getInt("seq") - o2.getBillEntry().getInt("seq");
            }
        });
        return reserveEntryParams;
    }

    private void dealSupplyInfo(DynamicObjectCollection strategyList, ReserveContext context, List<RequestBillEntryParam> requestBillEntryParams) {
        Map<Long, List<DynamicObject>> entryStrategyMap = this.getBillEntryMapValidateStrategies(strategyList, requestBillEntryParams);
        ArrayList<DataSet> dataSetList = new ArrayList<DataSet>(16);
        for (int i = 0; i < requestBillEntryParams.size(); ++i) {
            this.supplyEntryIdSet = new HashSet<Long>(8);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.getDataEntity(true);
            model.beginInit();
            model.setEntryCurrentRowIndex("entryentity", i);
            RequestBillEntryParam billEntryParam = requestBillEntryParams.get(i);
            for (DynamicObject strategy : entryStrategyMap.get(billEntryParam.getPkvalue())) {
                ReserveHelper.checkAggregateConfig(context, strategy);
                List<DataSet> oneDataSetList = this.getSupplyDataSetByOneStrategy(context, billEntryParam, strategy);
                if (oneDataSetList.size() == 0) continue;
                dataSetList.addAll(oneDataSetList);
            }
            this.fillSupplierInfo(dataSetList, model);
            model.endInit();
            this.getView().updateView("invaccsubentry");
        }
    }

    private Map<Long, List<DynamicObject>> getBillEntryMapValidateStrategies(DynamicObjectCollection strategyList, List<RequestBillEntryParam> requestBillEntryParams) {
        HashMap<Long, List<DynamicObject>> entryStrategyMap = new HashMap<Long, List<DynamicObject>>(8);
        Collection<DynamicObject> allStrategyList = ReserveHelper.getStrategyMap(strategyList).values();
        for (RequestBillEntryParam entryParam : requestBillEntryParams) {
            ArrayList<DynamicObject> validateStrategyList = new ArrayList<DynamicObject>(8);
            for (DynamicObject strategy : allStrategyList) {
                String strategyFilter = strategy.getString("filter_value_tag");
                if (!FilterParser.execExcelFormulaHasNoEntry(strategyFilter, entryParam.getBillEntry())) continue;
                validateStrategyList.add(strategy);
            }
            entryStrategyMap.put(entryParam.getPkvalue(), validateStrategyList);
        }
        return entryStrategyMap;
    }

    private Set<Long> getBillEntryIdSet() {
        HashSet<Long> billEntryIdList = new HashSet<Long>(8);
        String billEntryIds = (String)this.getView().getFormShowParameter().getCustomParam("billEntryIds");
        if (billEntryIds != null) {
            billEntryIdList = new HashSet((Collection)SerializationUtils.fromJsonString((String)billEntryIds, ArrayList.class));
        }
        return billEntryIdList;
    }

    private DynamicObject getRequestBill() {
        String billName = (String)this.getView().getFormShowParameter().getCustomParam("billName");
        Long billId = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("billId").toString());
        DynamicObject requestBill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billName);
        this.removeUnSelectBillEntry(billName, requestBill);
        return requestBill;
    }

    private void removeUnSelectBillEntry(String billName, DynamicObject requestBill) {
        Set<Long> billEntryIdList = this.getBillEntryIdSet();
        if (billEntryIdList.isEmpty()) {
            return;
        }
        ColsMap billColsMap = ColsMapHelper.findDemandBillColMap(billName);
        if (billColsMap.getByBalCol("bill_entry") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9700\u6c42\u5355\u636e\u7684\u6620\u5c04\u914d\u7f6e\uff1abill_entry\u6ca1\u6709\u914d\u7f6e\u3002", (String)"ManualReserveMainPlugin_13", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        DynamicObjectCollection billEntryCol = requestBill.getDynamicObjectCollection(billColsMap.getByBalCol("bill_entry"));
        Iterator it = billEntryCol.iterator();
        while (it.hasNext()) {
            if (billEntryIdList.contains(((DynamicObject)it.next()).getLong("id"))) continue;
            it.remove();
        }
    }

    private List<DataSet> getSupplyDataSetByOneStrategy(ReserveContext context, RequestBillEntryParam billEntryParam, DynamicObject strategy) {
        ArrayList<DataSet> dataSetList = new ArrayList<DataSet>(16);
        DynamicObjectCollection orderRuleEntryList = this.getOrderRuleList(strategy);
        try {
            for (DynamicObject rule : orderRuleEntryList) {
                DataSet readData = RuleEngine.executeBatch(context, rule, Collections.singletonList(billEntryParam));
                if (readData == null) continue;
                this.buildEntryRuleParamMap(rule, readData);
                dataSetList.add(readData);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return dataSetList;
    }

    private void buildEntryRuleParamMap(DynamicObject rule, DataSet readData) {
        DynamicObject supSrcObj = rule.getDynamicObject("supsrcobj");
        String supBillFormId = supSrcObj == null ? "im_inv_realbalance" : (String)supSrcObj.getPkValue();
        String supBillFormName = supSrcObj == null ? "im_inv_realbalance" : supSrcObj.getLocaleString("name").getLocaleValue();
        ManualReserveEntryRuleParam reserveEntryRuleParam = new ManualReserveEntryRuleParam();
        reserveEntryRuleParam.setSupplyFormId(supBillFormId);
        reserveEntryRuleParam.setSupplyFormName(supBillFormName);
        reserveEntryRuleParam.setPredict(rule.getBoolean("ispredict"));
        DataSet readDataCopy = readData.copy();
        while (readDataCopy.hasNext()) {
            this.entryRuleParamMap.put(readDataCopy.next().getLong("id"), reserveEntryRuleParam);
        }
    }

    private DynamicObjectCollection getOrderRuleList(DynamicObject strategy) {
        DynamicObjectCollection ruleEntryList = strategy.getDynamicObjectCollection("rule_entry");
        DynamicObjectCollection orderRuleList = SchemeHelper.sortCollectionByField(ruleEntryList, "rule_seq");
        Map<Object, DynamicObject> ruleMap = StrategyEngine.getRuleMap(ruleEntryList);
        DynamicObjectCollection tempCol = new DynamicObjectCollection();
        for (DynamicObject rule : orderRuleList) {
            DynamicObject ruleEntry = rule.getDynamicObject("reserve_inv_rule");
            if (ruleEntry == null) continue;
            tempCol.add((Object)ruleMap.get(ruleEntry.getPkValue()));
        }
        return tempCol;
    }

    private void fillSupplierInfo(List<DataSet> dataSetList, AbstractFormDataModel model) {
        for (DataSet readData : dataSetList) {
            HashSet<String> fieldNameSet = new HashSet<String>(Arrays.asList(readData.getRowMeta().getFieldNames()));
            if (!readData.hasNext()) continue;
            long invId = readData.copy().next().getLong("id");
            if (invId == 0L) {
                this.fillSupplierInfoByAggregateReserve(model, readData, fieldNameSet);
                continue;
            }
            this.fillSupplierInfoByDetailReserve(model, readData, fieldNameSet);
        }
    }

    private void fillSupplierInfoByDetailReserve(AbstractFormDataModel model, DataSet readData, Set<String> fieldNameSet) {
        String[] rowMeta = readData.getRowMeta().getFieldNames();
        List<String> rowName = Arrays.asList(rowMeta);
        while (readData.hasNext()) {
            Row row = readData.next();
            if (this.supplyEntryIdSet.contains(row.getLong("entryid"))) continue;
            int rowIndex = model.createNewEntryRow("invaccsubentry");
            model.setValue("material", row.get("materiel"), rowIndex);
            if (fieldNameSet.contains("unit") && fieldNameSet.contains("qty")) {
                model.setValue("unit", row.get("unit"), rowIndex);
                model.setValue("qty", (Object)row.getBigDecimal("qty"), rowIndex);
                model.setValue("lockqty", (Object)row.getBigDecimal("reserve_qty"), rowIndex);
                model.setValue("avbqty", (Object)row.getBigDecimal("avbqty"), rowIndex);
            }
            model.setValue("baseunit", row.get("baseunit"), rowIndex);
            model.setValue("baseqty", (Object)row.getBigDecimal("baseqty"), rowIndex);
            model.setValue("lockbaseqty", (Object)row.getBigDecimal("reserve_base_qty"), rowIndex);
            model.setValue("avbbaseqty", (Object)row.getBigDecimal("avbbaseqty"), rowIndex);
            if (fieldNameSet.contains("unit2nd") && fieldNameSet.contains("qty2nd")) {
                model.setValue("unit2nd", row.get("unit2nd"), rowIndex);
                model.setValue("qty2nd", (Object)row.getBigDecimal("qty2nd"), rowIndex);
                model.setValue("lockqty2nd", (Object)row.getBigDecimal("reserve_qty2nd"), rowIndex);
                model.setValue("avbqty2nd", (Object)row.getBigDecimal("avbqty2nd"), rowIndex);
            }
            for (Map.Entry<String, String> map : this.supplyFieldMap.entrySet()) {
                String value = map.getValue();
                if (!fieldNameSet.contains(value)) continue;
                model.setValue(map.getKey(), row.get(value), rowIndex);
            }
            ManualReserveEntryRuleParam entryRuleParam = this.entryRuleParamMap.get(row.get("id"));
            model.setValue("ispredict", (Object)entryRuleParam.isPredict(), rowIndex);
            model.setValue("bar_obj", (Object)entryRuleParam.getSupplyFormId(), rowIndex);
            model.setValue("bar_name", (Object)entryRuleParam.getSupplyFormName(), rowIndex);
            model.setValue("bar_source_type", (Object)"1", rowIndex);
            model.setValue("barentryseq", row.get("seq"), rowIndex);
            model.setValue("bal_id", row.get("id"), rowIndex);
            model.setValue("aggregateid", (Object)row.getLong("aggid"), rowIndex);
            if (fieldNameSet.contains("owner") && rowName.contains("owner_type") && row.getString("owner_type") != null && !"".equals(row.getString("owner_type")) && !"0".equals(row.getString("owner_type"))) {
                DynamicObject owner = BusinessDataServiceHelper.newDynamicObject((String)row.getString("owner_type"));
                owner.set("id", (Object)row.getLong("owner"));
                model.setValue("owner", (Object)owner, rowIndex);
            }
            if (fieldNameSet.contains("keeper") && rowName.contains("keeper_type") && row.getString("keeper_type") != null && !"".equals(row.getString("keeper_type")) && !"0".equals(row.getString("keeper_type"))) {
                DynamicObject keeper = BusinessDataServiceHelper.newDynamicObject((String)row.getString("keeper_type"));
                keeper.set("id", (Object)row.getLong("keeper"));
                model.setValue("keeper", (Object)keeper, rowIndex);
            }
            this.supplyEntryIdSet.add(row.getLong("id"));
            ++rowIndex;
        }
    }

    private void fillSupplierInfoByAggregateReserve(AbstractFormDataModel model, DataSet readData, Set<String> fieldNameSet) {
        List aggregateField = (List)ReserveAggregateHelper.getAggregateConfig().get("aggregateField");
        String[] rowMeta = readData.getRowMeta().getFieldNames();
        List<String> rowName = Arrays.asList(rowMeta);
        while (readData.hasNext()) {
            Row row = readData.next();
            if (row.getBigDecimal("baseqty") == null || BigDecimal.ZERO.compareTo(row.getBigDecimal("baseqty")) >= 0 || row.getBigDecimal("lockbaseqty") != null && BigDecimal.ZERO.compareTo(row.getBigDecimal("baseqty").subtract(row.getBigDecimal("lockbaseqty"))) >= 0 || row.get("aggid") != null && row.getLong("aggid") != 0L && this.supplyEntryIdSet.contains(row.getLong("aggid"))) continue;
            int rowIndex = model.createNewEntryRow("invaccsubentry");
            model.setValue("material", row.get("materiel"), rowIndex);
            aggregateField.remove("owner");
            aggregateField.remove("keeper");
            for (String field : aggregateField) {
                if ("materiel".equals(field)) continue;
                String key = this.supplyFieldBillMap.get(field);
                if (key == null) {
                    key = field;
                }
                if (!rowName.contains(field)) continue;
                model.setValue(key, row.get(field), rowIndex);
            }
            if (aggregateField.contains("unit")) {
                model.setValue("qty", (Object)row.getBigDecimal("qty"), rowIndex);
                if (row.getBigDecimal("qty") != null) {
                    BigDecimal lockQty = row.getBigDecimal("lockqty");
                    if (lockQty == null) {
                        lockQty = BigDecimal.ZERO;
                    }
                    model.setValue("lockqty", (Object)lockQty, rowIndex);
                    model.setValue("avbqty", (Object)row.getBigDecimal("qty").subtract(lockQty), rowIndex);
                }
            }
            model.setValue("baseqty", (Object)row.getBigDecimal("baseqty"), rowIndex);
            BigDecimal lockBaseQty = row.getBigDecimal("lockbaseqty");
            if (lockBaseQty == null) {
                lockBaseQty = BigDecimal.ZERO;
            }
            model.setValue("lockbaseqty", (Object)lockBaseQty, rowIndex);
            model.setValue("avbbaseqty", (Object)row.getBigDecimal("baseqty").subtract(lockBaseQty), rowIndex);
            if (fieldNameSet.contains("unit2nd") && aggregateField.contains("unit2nd")) {
                model.setValue("qty2nd", (Object)row.getBigDecimal("qty2nd"), rowIndex);
                BigDecimal lockQty2nd = row.getBigDecimal("lockqty2nd");
                if (lockQty2nd == null) {
                    lockQty2nd = BigDecimal.ZERO;
                }
                model.setValue("lockqty2nd", (Object)lockQty2nd, rowIndex);
                if (row.getBigDecimal("qty2nd") != null) {
                    model.setValue("avbqty2nd", (Object)row.getBigDecimal("qty2nd").subtract(lockQty2nd), rowIndex);
                }
            }
            ManualReserveEntryRuleParam entryRuleParam = this.entryRuleParamMap.get(row.getLong("id"));
            model.setValue("ispredict", (Object)entryRuleParam.isPredict(), rowIndex);
            model.setValue("bar_obj", (Object)entryRuleParam.getSupplyFormId(), rowIndex);
            model.setValue("bar_name", (Object)entryRuleParam.getSupplyFormName(), rowIndex);
            model.setValue("bar_source_type", (Object)"1", rowIndex);
            model.setValue("aggregateid", (Object)row.getLong("aggid"), rowIndex);
            if (fieldNameSet.contains("owner") && rowName.contains("owner_type") && row.getString("owner_type") != null && !"".equals(row.getString("owner_type")) && !"0".equals(row.getString("owner_type"))) {
                DynamicObject owner = BusinessDataServiceHelper.newDynamicObject((String)row.getString("owner_type"));
                owner.set("id", (Object)row.getLong("owner"));
                model.setValue("owner", (Object)owner, rowIndex);
            }
            if (fieldNameSet.contains("keeper") && rowName.contains("keeper_type") && row.getString("keeper_type") != null && !"".equals(row.getString("keeper_type")) && !"0".equals(row.getString("keeper_type"))) {
                DynamicObject keeper = BusinessDataServiceHelper.newDynamicObject((String)row.getString("keeper_type"));
                keeper.set("id", (Object)row.getLong("keeper"));
                model.setValue("keeper", (Object)keeper, rowIndex);
            }
            this.supplyEntryIdSet.add(row.getLong("aggid"));
            ++rowIndex;
        }
    }

    private void fillRequestInfo(ReserveContext context, DynamicObject requestBill, List<RequestBillEntryParam> reserveEntryParams, ColsMap colsMap) {
        this.getModel().deleteEntryData("entryentity");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.getDataEntity(true);
        model.beginInit();
        List<String> aggregateField = context.getAggregateField();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < reserveEntryParams.size(); ++i) {
            BigDecimal reserveQtyUnit2nd;
            RequestBillEntryParam requestBillEntryParam = reserveEntryParams.get(i);
            DynamicObject requestEntry = requestBillEntryParam.getBillEntry();
            QtyStore qtyStore = requestBillEntryParam.getDefaultQtyStore();
            BigDecimal reserveBaseQty = qtyStore.getLockBaseQty() == null ? BigDecimal.ZERO : qtyStore.getLockBaseQty().abs();
            BigDecimal bigDecimal = reserveQtyUnit2nd = qtyStore.getLockQty2end() == null ? BigDecimal.ZERO : qtyStore.getLockQty2end().abs();
            if ("msmod_reservebill".equals(requestBill.getDataEntityType().getName())) {
                Object pkValue = null;
                if (requestEntry.getDynamicObject("reserveobj") != null) {
                    pkValue = requestEntry.getDynamicObject("reserveobj").getPkValue();
                }
                vs.addField("reserveobjtype", new Object[]{requestEntry.get("reserveobjtype")});
                vs.addField("reserveobj", new Object[]{pkValue});
            }
            if (colsMap.getByBalCol("bill_entry.material") != null) {
                String key = colsMap.getByBalCol("bill_entry.material").replace(requestEntry.getDataEntityType().getName() + ".", "");
                vs.addField("bill_entry_material", new Object[]{requestEntry.get(key + "_id")});
            }
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "bill_entry_unit", true);
            vs.addField("bill_entry_qty", new Object[]{this.getBillEntryFieldDecimalValue(colsMap, requestEntry, "bill_entry_qty")});
            if (aggregateField.contains("unit") || colsMap.getByBalCol("bill_entry.unit") != null) {
                BigDecimal reserveQty = this.getReserveQty(colsMap, requestEntry, reserveBaseQty);
                vs.addField("reservedqty", new Object[]{reserveQty});
                vs.addField("realqty", new Object[]{this.getBillEntryFieldDecimalValue(colsMap, requestEntry, "bill_entry_qty").subtract(reserveQty)});
            }
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "bill_entry_base_unit", true);
            vs.addField("bill_entry_base_qty", new Object[]{this.getBillEntryFieldDecimalValue(colsMap, requestEntry, "bill_entry_base_qty")});
            vs.addField("basereservedqty", new Object[]{reserveBaseQty});
            vs.addField("realbaseqty", new Object[]{this.getBillEntryFieldDecimalValue(colsMap, requestEntry, "bill_entry_base_qty").subtract(reserveBaseQty)});
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "bill_entry_aux_unit", true);
            if (aggregateField.contains("unit2nd") || colsMap.getByBalCol("bill_entry.aux_unit") != null) {
                vs.addField("bill_entry_aux_qty", new Object[]{this.getBillEntryFieldDecimalValue(colsMap, requestEntry, "bill_entry_aux_qty")});
                vs.addField("reservedunit2ndqty", new Object[]{reserveQtyUnit2nd});
                vs.addField("realunit2ndqty", new Object[]{this.getBillEntryFieldDecimalValue(colsMap, requestEntry, "bill_entry_aux_qty").subtract(reserveQtyUnit2nd)});
            }
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "r_biz_date", false);
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "r_invorg", true);
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "bill_entry_flexfield", true);
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "bill_entry_lot_number", false);
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "bill_entry_warehouse", true);
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "bill_entry_location", true);
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "r_sale_org", true);
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "r_bill_no", false);
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "r_customer", true);
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "r_sale_operator", true);
            this.setRequestFieldValue(requestBill, vs, colsMap, requestEntry, "r_sale_dept", true);
            if (requestEntry.getDataEntityType() instanceof EntryType) {
                vs.addField("bill_entry_seq", new Object[]{requestEntry.getString("seq")});
            }
            vs.addField("r_formid", new Object[]{requestBill.getDynamicObjectType().getName()});
            vs.addField("r_bill_id", new Object[]{requestBill.get("id")});
            vs.addField("bill_entry_entry_id", new Object[]{requestEntry.get("id")});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u9884\u7559\u7684\u7269\u6599\uff0c\u8bf7\u68c0\u67e5\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u4ee5\u53ca\u9884\u7559\u7b56\u7565\u3002", (String)"ManualReserveMainPlugin_5", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        this.getView().updateView("entryentity");
    }

    private BigDecimal getReserveQty(ColsMap colsMap, DynamicObject requestEntry, BigDecimal reserveBaseQty) {
        ConvRateContext conRate = new ConvRateContext();
        DynamicObject materialDyc = BusinessDataServiceHelper.newDynamicObject((String)"bd_material");
        materialDyc.set("id", requestEntry.get(this.getBillEntryRealFieldName(colsMap, requestEntry, "bill_entry_material") + "_id"));
        DynamicObject baseUnitDyc = BusinessDataServiceHelper.newDynamicObject((String)"bd_measureunits");
        baseUnitDyc.set("id", requestEntry.get(this.getBillEntryRealFieldName(colsMap, requestEntry, "bill_entry_base_unit") + "_id"));
        DynamicObject unitDyc = BusinessDataServiceHelper.newDynamicObject((String)"bd_measureunits");
        String unitName = this.getBillEntryRealFieldName(colsMap, requestEntry, "bill_entry_unit");
        if (unitName == null) {
            return BigDecimal.ZERO;
        }
        unitDyc.set("id", requestEntry.get(unitName + "_id"));
        return conRate.getSrcQty(reserveBaseQty, materialDyc.getLong("id"), unitDyc.getLong("id"), baseUnitDyc.getLong("id"));
    }

    private void setRequestFieldValue(DynamicObject requestBill, TableValueSetter vs, ColsMap colsMap, DynamicObject requestEntry, String modelField, boolean needId) {
        String realModelField = modelField;
        if (modelField.startsWith("r_")) {
            realModelField = modelField.substring(2);
        } else if (modelField.startsWith("bill_entry_")) {
            realModelField = modelField.replace("bill_entry_", "bill_entry.");
        }
        String mapFieldName = colsMap.getByBalCol(realModelField);
        if (mapFieldName != null) {
            int pointPos = mapFieldName.indexOf(46);
            if (pointPos > 0) {
                if (needId) {
                    vs.addField(modelField, new Object[]{requestEntry.get(mapFieldName.substring(pointPos + 1) + "_id")});
                } else {
                    vs.addField(modelField, new Object[]{requestEntry.get(mapFieldName.substring(pointPos + 1))});
                }
            } else if (needId) {
                vs.addField(modelField, new Object[]{requestBill.get(mapFieldName + "_id")});
            } else {
                vs.addField(modelField, new Object[]{requestBill.get(mapFieldName)});
            }
        }
    }

    private BigDecimal getBillEntryFieldDecimalValue(ColsMap colsMap, DynamicObject requestEntry, String modelField) {
        BigDecimal result = BigDecimal.ZERO;
        String fieldName = this.getBillEntryRealFieldName(colsMap, requestEntry, modelField);
        if (fieldName != null) {
            result = ColsMapHelper.getMpingQty(requestEntry, fieldName);
        }
        return result;
    }

    private String getBillEntryRealFieldName(ColsMap colsMap, DynamicObject requestEntry, String modelField) {
        String name = null;
        String colField = modelField.replace("bill_entry_", "bill_entry.");
        if (colsMap.getByBalCol(colField) != null) {
            name = colsMap.getByBalCol(colField).replace(requestEntry.getDataEntityType().getName() + ".", "");
        }
        return name;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        int subIndex = this.getModel().getEntryCurrentRowIndex("invaccsubentry");
        Object newValue = e.getChangeSet()[0].getNewValue();
        DynamicObject materialDyc = (DynamicObject)this.getModel().getValue("bill_entry_material", index);
        DynamicObject baseUnitDyc = (DynamicObject)this.getModel().getValue("bill_entry_base_unit", index);
        DynamicObject unitDyc = (DynamicObject)this.getModel().getValue("bill_entry_unit", index);
        DynamicObject unit2ndDyc = (DynamicObject)this.getModel().getValue("bill_entry_aux_unit", index);
        ConvRateContext conRate = new ConvRateContext();
        DynamicObjectCollection subDycCol = this.getModel().getEntryEntity("invaccsubentry");
        DynamicObject subMaterialDyc = null;
        DynamicObject subBaseUnitDyc = null;
        DynamicObject subUnitDyc = null;
        DynamicObject subUnit2ndDyc = null;
        if (subDycCol.size() > 0) {
            subMaterialDyc = ((DynamicObject)subDycCol.get(subIndex)).getDynamicObject("material");
            subMaterialDyc = this.getMaterialByMatBiz(subMaterialDyc);
            subBaseUnitDyc = ((DynamicObject)subDycCol.get(subIndex)).getDynamicObject("baseunit");
            subUnitDyc = ((DynamicObject)subDycCol.get(subIndex)).getDynamicObject("unit");
            subUnit2ndDyc = ((DynamicObject)subDycCol.get(subIndex)).getDynamicObject("unit2nd");
        }
        materialDyc = this.getMaterialByMatBiz(materialDyc);
        switch (key) {
            case "realqty": {
                if (this.qtyChanged || materialDyc == null || unitDyc == null) break;
                this.qtyChanged = true;
                this.changeBaseQtyAnd2ndQty(index, (BigDecimal)newValue, materialDyc, baseUnitDyc, unitDyc, unit2ndDyc, conRate);
                break;
            }
            case "realbaseqty": {
                if (this.qtyChanged || materialDyc == null) break;
                this.qtyChanged = true;
                this.changeQtyAnd2ndQty(index, (BigDecimal)newValue, materialDyc, baseUnitDyc, unitDyc, unit2ndDyc, conRate);
                break;
            }
            case "realunit2ndqty": {
                if (this.qtyChanged || unit2ndDyc == null || materialDyc == null) break;
                this.qtyChanged = true;
                this.changeBaseQtyAndQty(index, (BigDecimal)newValue, materialDyc, baseUnitDyc, unitDyc, unit2ndDyc, conRate);
                break;
            }
            case "reserveaccunitqty": {
                if (subUnitDyc == null) {
                    this.getModel().setValue("reserveaccunitqty", (Object)BigDecimal.ZERO, subIndex, index);
                    break;
                }
                if (this.qtyChanged || subMaterialDyc == null) break;
                this.qtyChanged = true;
                this.changeSubBaseQtyAnd2ndQty(index, subIndex, (BigDecimal)newValue, conRate, subMaterialDyc, subBaseUnitDyc, subUnitDyc, subUnit2ndDyc);
                break;
            }
            case "reserveaccqty": {
                if (this.qtyChanged || subMaterialDyc == null) break;
                this.qtyChanged = true;
                this.changeSubQtyAnd2ndQty(index, subIndex, (BigDecimal)newValue, conRate, subMaterialDyc, subBaseUnitDyc, subUnitDyc, subUnit2ndDyc);
                break;
            }
            case "reserveaccunit2ndqty": {
                if (this.qtyChanged || subUnit2ndDyc == null || subMaterialDyc == null) break;
                this.qtyChanged = true;
                this.changeSubBaseQtyAndQty(index, subIndex, (BigDecimal)newValue, conRate, subMaterialDyc, subBaseUnitDyc, subUnitDyc, subUnit2ndDyc);
                break;
            }
        }
    }

    private void changeSubBaseQtyAndQty(int index, int subIndex, BigDecimal newValue, ConvRateContext conRate, DynamicObject subMaterialDyc, DynamicObject subBaseUnitDyc, DynamicObject subUnitDyc, DynamicObject subUnit2ndDyc) {
        if (this.checkDir(subMaterialDyc, "B")) {
            BigDecimal baseQty = conRate.getSrcQty(newValue, subMaterialDyc.getLong("id"), subBaseUnitDyc.getLong("id"), subUnit2ndDyc.getLong("id"));
            this.getModel().setValue("reserveaccqty", (Object)baseQty, subIndex, index);
            if (subUnitDyc != null) {
                this.getModel().setValue("reserveaccunitqty", (Object)conRate.getSrcQty(baseQty, subMaterialDyc.getLong("id"), subUnitDyc.getLong("id"), subBaseUnitDyc.getLong("id")), subIndex, index);
            }
        }
    }

    private void changeSubBaseQtyAnd2ndQty(int index, int subIndex, BigDecimal newValue, ConvRateContext conRate, DynamicObject subMaterialDyc, DynamicObject subBaseUnitDyc, DynamicObject subUnitDyc, DynamicObject subUnit2ndDyc) {
        BigDecimal baseQty = conRate.getSrcQty(newValue, subMaterialDyc.getLong("id"), subBaseUnitDyc.getLong("id"), subUnitDyc.getLong("id"));
        this.getModel().setValue("reserveaccqty", (Object)baseQty, subIndex, index);
        if (subUnit2ndDyc != null && this.checkDir(subMaterialDyc, "A")) {
            BigDecimal unit2ndQty = conRate.getSrcQty(baseQty, subMaterialDyc.getLong("id"), subUnit2ndDyc.getLong("id"), subBaseUnitDyc.getLong("id"));
            BigDecimal realUnit2ndQty = (BigDecimal)this.getModel().getValue("avbqty2nd", subIndex, index);
            this.getModel().setValue("reserveaccunit2ndqty", (Object)(unit2ndQty.compareTo(realUnit2ndQty) > 0 ? realUnit2ndQty : unit2ndQty), subIndex, index);
        }
    }

    private void changeSubQtyAnd2ndQty(int index, int subIndex, BigDecimal newValue, ConvRateContext conRate, DynamicObject subMaterialDyc, DynamicObject subBaseUnitDyc, DynamicObject subUnitDyc, DynamicObject subUnit2ndDyc) {
        if (subUnitDyc == null) {
            this.getModel().setValue("reserveaccunitqty", (Object)BigDecimal.ZERO, subIndex, index);
        } else {
            BigDecimal qty = conRate.getSrcQty(newValue, subMaterialDyc.getLong("id"), subUnitDyc.getLong("id"), subBaseUnitDyc.getLong("id"));
            this.getModel().setValue("reserveaccunitqty", (Object)qty, subIndex, index);
        }
        if (subUnit2ndDyc != null && this.checkDir(subMaterialDyc, "A")) {
            BigDecimal unit2ndQty = conRate.getSrcQty(newValue, subMaterialDyc.getLong("id"), subUnit2ndDyc.getLong("id"), subBaseUnitDyc.getLong("id"));
            BigDecimal realUnit2ndQty = (BigDecimal)this.getModel().getValue("avbqty2nd", subIndex, index);
            this.getModel().setValue("reserveaccunit2ndqty", (Object)(unit2ndQty.compareTo(realUnit2ndQty) > 0 ? realUnit2ndQty : unit2ndQty), subIndex, index);
        }
    }

    private void changeBaseQtyAndQty(int index, BigDecimal newValue, DynamicObject materialDyc, DynamicObject baseUnitDyc, DynamicObject unitDyc, DynamicObject unit2ndDyc, ConvRateContext conRate) {
        if (this.checkDir(materialDyc, "B")) {
            BigDecimal baseQty = conRate.getSrcQty(newValue, materialDyc.getLong("id"), baseUnitDyc.getLong("id"), unit2ndDyc.getLong("id"));
            this.getModel().setValue("realbaseqty", (Object)baseQty, index);
            this.getModel().setValue("realqty", (Object)conRate.getSrcQty(baseQty, materialDyc.getLong("id"), unitDyc.getLong("id"), baseUnitDyc.getLong("id")), index);
        }
    }

    private void changeBaseQtyAnd2ndQty(int index, BigDecimal newValue, DynamicObject materialDyc, DynamicObject baseUnitDyc, DynamicObject unitDyc, DynamicObject unit2ndDyc, ConvRateContext conRate) {
        BigDecimal baseQty = conRate.getSrcQty(newValue, materialDyc.getLong("id"), baseUnitDyc.getLong("id"), unitDyc.getLong("id"));
        this.getModel().setValue("realbaseqty", (Object)baseQty, index);
        if (unit2ndDyc != null && this.checkDir(materialDyc, "A")) {
            BigDecimal unit2ndQty = conRate.getSrcQty(baseQty, materialDyc.getLong("id"), unit2ndDyc.getLong("id"), baseUnitDyc.getLong("id"));
            BigDecimal auxQty = (BigDecimal)this.getModel().getValue("bill_entry_aux_qty", index);
            BigDecimal reservedUnit2ndQty = (BigDecimal)this.getModel().getValue("reservedunit2ndqty", index);
            BigDecimal realUnit2ndQty = auxQty.subtract(reservedUnit2ndQty);
            this.getModel().setValue("realunit2ndqty", (Object)(unit2ndQty.compareTo(realUnit2ndQty) > 0 ? realUnit2ndQty : unit2ndQty), index);
        }
    }

    private void changeQtyAnd2ndQty(int index, BigDecimal newValue, DynamicObject materialDyc, DynamicObject baseUnitDyc, DynamicObject unitDyc, DynamicObject unit2ndDyc, ConvRateContext conRate) {
        if (unitDyc != null) {
            BigDecimal qty = conRate.getSrcQty(newValue, materialDyc.getLong("id"), unitDyc.getLong("id"), baseUnitDyc.getLong("id"));
            this.getModel().setValue("realqty", (Object)qty, index);
        }
        if (unit2ndDyc != null && this.checkDir(materialDyc, "A")) {
            BigDecimal unit2ndQty = conRate.getSrcQty(newValue, materialDyc.getLong("id"), unit2ndDyc.getLong("id"), baseUnitDyc.getLong("id"));
            BigDecimal auxQty = (BigDecimal)this.getModel().getValue("bill_entry_aux_qty", index);
            BigDecimal reservedUnit2ndQty = (BigDecimal)this.getModel().getValue("reservedunit2ndqty", index);
            BigDecimal realUnit2ndQty = auxQty.subtract(reservedUnit2ndQty);
            this.getModel().setValue("realunit2ndqty", (Object)(unit2ndQty.compareTo(realUnit2ndQty) > 0 ? realUnit2ndQty : unit2ndQty), index);
        }
    }

    private DynamicObject getMaterialByMatBiz(DynamicObject material) {
        if (material == null) {
            return null;
        }
        if ("bd_materialinventoryinfo".equals(material.getDataEntityType().getName()) || "bd_materialpurchaseinfo".equals(material.getDataEntityType().getName()) || "bd_materialsalinfo".equals(material.getDataEntityType().getName())) {
            QFilter qFilter1 = new QFilter("id", "=", material.getDynamicObject("masterid").getPkValue());
            material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{qFilter1});
        } else {
            QFilter qFilter1 = new QFilter("id", "=", material.getPkValue());
            material = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (QFilter[])new QFilter[]{qFilter1});
        }
        return material;
    }

    public void click(EventObject evt) {
        try {
            String key;
            super.click(evt);
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "auto_assign": {
                    this.autoAssign();
                    break;
                }
                case "bt_save": {
                    this.doSave();
                    break;
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            logger.info(ResManager.loadKDString((String)"\u624b\u5de5\u9884\u7559\u754c\u9762\u5df2\u5931\u6548\u3002", (String)"ManualReserveMainPlugin_6", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
    }

    private void doSave() {
        IDataModel model = this.getView().getModel();
        if (!this.isBaseQtyGraterZero()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u9700\u6c42\u4fe1\u606f\u201c\u53ef\u9884\u7559\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"ManualReserveMainPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            return;
        }
        String msg = this.checkSupplyEqualDemand();
        if (!msg.isEmpty()) {
            this.getView().showMessage(msg);
            return;
        }
        String schemeId = (String)this.getView().getFormShowParameter().getCustomParam("schemeId");
        DynamicObject scheme = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(schemeId), (String)"msmod_reserve_scheme");
        DynamicObject requestBill = this.getRequestBill();
        ReserveContext context = new ReserveContext(requestBill, scheme);
        context.getDemandColsMap(requestBill.getDynamicObjectType().getName());
        BillReserveResult result = this.getValidateSelectRow(model, context);
        if (ReserveResultType.Failed == result.getReserveResultType()) {
            this.getView().showMessage(result.getErrorMsg());
            return;
        }
        ThreadCache.put((Object)"ReserveOpName", (Object)"save");
        ThreadCache.put((Object)"ReserveOpType", (Object)"manualreserve");
        ReserveHelper.handleBillResult(result, context);
        if (ReserveResultType.Failed == result.getReserveResultType()) {
            this.getView().showErrorNotification(result.getErrorMsg());
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9884\u7559\u6210\u529f\u3002", (String)"ManualReserveMainPlugin_16", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private boolean isBaseQtyGraterZero() {
        boolean result = false;
        DynamicObjectCollection demandEntry = this.getView().getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : demandEntry) {
            BigDecimal realDemandQty = dynamicObject.getBigDecimal("realbaseqty");
            if (realDemandQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    protected String checkSupplyEqualDemand() {
        StringBuilder msgBuilder = new StringBuilder();
        DynamicObjectCollection demandEntry = this.getView().getModel().getEntryEntity("entryentity");
        for (int i = 0; i < demandEntry.size(); ++i) {
            BigDecimal realDemandQty = ((DynamicObject)demandEntry.get(i)).getBigDecimal("realbaseqty");
            BigDecimal realDemandQty2nd = ((DynamicObject)demandEntry.get(i)).getBigDecimal("realunit2ndqty");
            this.getModel().setEntryCurrentRowIndex("entryentity", i);
            DynamicObjectCollection supplyCol = ((DynamicObject)demandEntry.get(i)).getDynamicObjectCollection("invaccsubentry");
            for (int j = 0; j < supplyCol.size(); ++j) {
                realDemandQty = realDemandQty.subtract(((DynamicObject)supplyCol.get(j)).getBigDecimal("reserveaccqty"));
                realDemandQty2nd = realDemandQty2nd.subtract(((DynamicObject)supplyCol.get(j)).getBigDecimal("reserveaccunit2ndqty"));
            }
            if (realDemandQty.compareTo(BigDecimal.ZERO) != 0) {
                String msg = ResManager.loadKDString((String)"\u9700\u6c42\u4fe1\u606f\u7b2c%1$s\u884c\u7684\u4f9b\u5e94\u4fe1\u606f\u7684\u7d2f\u8ba1\u9884\u7559\u57fa\u672c\u6570\u91cf\uff0c\u4e0d\u7b49\u4e8e\u9700\u6c42\u4fe1\u606f\u7684\u53ef\u9884\u7559\u57fa\u672c\u6570\u91cf\u3002", (String)"ManualReserveMainPlugin_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
                msgBuilder.append(String.format(msg + "\r\n", i + 1));
            }
            if (realDemandQty2nd.compareTo(BigDecimal.ZERO) >= 0) continue;
            String msg = ResManager.loadKDString((String)"\u9700\u6c42\u4fe1\u606f\u7b2c%1$s\u884c\u7684\u4f9b\u5e94\u4fe1\u606f\u7684\u7d2f\u8ba1\u9884\u7559\u8f85\u52a9\u6570\u91cf\uff0c\u5927\u4e8e\u9700\u6c42\u4fe1\u606f\u7684\u53ef\u9884\u7559\u8f85\u52a9\u6570\u91cf\u3002", (String)"ManualReserveMainPlugin_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
            msgBuilder.append(String.format(msg, i + 1));
        }
        return msgBuilder.toString();
    }

    private BillReserveResult getValidateSelectRow(IDataModel model, ReserveContext context) {
        DynamicObjectCollection demandEntry = model.getEntryEntity("entryentity");
        BillReserveResult result = new BillReserveResult();
        result.setBillId(context.getRequestBillId());
        result.setBillResultHandler(context.getSchemeResultHandlerType());
        List<EntryReserveResult> entryReserveResultList = result.getEntryResultList();
        for (int i = 0; i < demandEntry.size(); ++i) {
            DynamicObject demand = (DynamicObject)demandEntry.get(i);
            BigDecimal realDemandQty = demand.getBigDecimal("realbaseqty");
            if (realDemandQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            model.setEntryCurrentRowIndex("entryentity", i);
            EntryReserveResult entryReserveResult = new EntryReserveResult();
            entryReserveResult.setEntryId(demand.get("bill_entry_entry_id"));
            entryReserveResult.setSeq(demand.getInt("bill_entry_seq"));
            if ("msmod_reservebill".equals(demand.getString("r_formid_id"))) {
                entryReserveResult.setReserveObjTypeId(demand.get("reserveobjtype"));
                entryReserveResult.setReserveObj(demand.get("reserveobj"));
            }
            List<StdInvResult> invResultList = entryReserveResult.getStdInvResultList();
            BigDecimal realSupplyQty = new BigDecimal(0);
            BigDecimal realSupplyUnitQty = new BigDecimal(0);
            BigDecimal realSupply2ndQty = new BigDecimal(0);
            DynamicObjectCollection supplyCol = demand.getDynamicObjectCollection("invaccsubentry");
            for (int j = 0; j < supplyCol.size(); ++j) {
                DynamicObject supply = (DynamicObject)supplyCol.get(j);
                BigDecimal realSubSupplyQty = supply.getBigDecimal("reserveaccqty");
                BigDecimal realSubSupplyUnitQty = supply.getBigDecimal("reserveaccunitqty");
                BigDecimal realSubSupply2ndQty = supply.getBigDecimal("reserveaccunit2ndqty");
                BigDecimal bigDecimal = realSubSupply2ndQty = realSubSupply2ndQty.compareTo(BigDecimal.ZERO) > 0 ? realSubSupply2ndQty : BigDecimal.ZERO;
                if (realSubSupplyQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                invResultList.add(this.getStdInvResultForSave(supply, realSubSupplyQty, realSubSupplyUnitQty, realSubSupply2ndQty, context));
                realSupplyQty = realSupplyQty.add(realSubSupplyQty);
                realSupplyUnitQty = realSupplyUnitQty.add(realSubSupplyUnitQty);
                realSupply2ndQty = realSupply2ndQty.add(realSubSupply2ndQty);
            }
            entryReserveResultList.add(entryReserveResult);
        }
        result.setReserveResultType(ReserveResultType.FullSuccess);
        return result;
    }

    private StdInvResult getStdInvResultForSave(DynamicObject supply, BigDecimal realSubSupplyQty, BigDecimal realSubSupplyUnitQty, BigDecimal realSubSupply2ndQty, ReserveContext context) {
        StdInvResult stdInvResult = new StdInvResult();
        HashMap<String, Object> invInfo = new HashMap<String, Object>(8);
        invInfo.put("id", supply.getLong("bal_id"));
        invInfo.put("source_bal_obj", supply.getString("bar_obj"));
        invInfo.put("entryid", supply.getLong("invaccid"));
        invInfo.put("source_type", supply.getString("bar_source_type"));
        invInfo.put("ispredict", supply.getBoolean("ispredict"));
        invInfo.put("aggid", supply.getLong("aggregateid"));
        if (!supply.getBoolean("ispredict") && context.isAggregate() && context.getScheme().getBoolean("aggregate")) {
            invInfo.put("materiel", supply.getDynamicObject("material").get("id"));
            for (String field : context.getAggregateField()) {
                if ("materiel".equals(field)) continue;
                String key = this.supplyFieldBillMap.get(field);
                if (key == null) {
                    key = field;
                }
                if (supply.get(key) instanceof DynamicObject) {
                    invInfo.put(field, supply.getDynamicObject(key).get("id"));
                    continue;
                }
                invInfo.put(field, supply.get(key));
            }
        }
        stdInvResult.setInvInfo(invInfo);
        stdInvResult.setPredict(supply.getBoolean("ispredict"));
        stdInvResult.setBaseQty(realSubSupplyQty);
        stdInvResult.setQty(realSubSupplyUnitQty);
        stdInvResult.setQty2nd(realSubSupply2ndQty);
        return stdInvResult;
    }

    private void autoAssign() {
        if (!this.isBaseQtyGraterZero()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u9700\u6c42\u4fe1\u606f\u201c\u53ef\u9884\u7559\u57fa\u672c\u6570\u91cf\u201d\u3002", (String)"ManualReserveMainPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection demandEntry = model.getEntryEntity("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int selectRow = 0;
        if (entryGrid.getSelectRows().length > 0) {
            selectRow = entryGrid.getSelectRows()[0];
        }
        HashMap<String, QtyStore> supplyHaveAssignMap = new HashMap<String, QtyStore>(8);
        ConvRateContext conRate = new ConvRateContext();
        model.beginInit();
        for (int i = 0; i < demandEntry.size(); ++i) {
            DynamicObject demand = (DynamicObject)demandEntry.get(i);
            this.getModel().setEntryCurrentRowIndex("entryentity", i);
            DynamicObjectCollection supplyDycCol = demand.getDynamicObjectCollection("invaccsubentry");
            this.clearSupplyQty(model, i, supplyDycCol);
            this.signOneRequiredEntry(model, supplyHaveAssignMap, i, demand, supplyDycCol, conRate);
        }
        model.endInit();
        entryGrid.selectRows(selectRow, true);
    }

    private void signOneRequiredEntry(IDataModel model, Map<String, QtyStore> supplyHaveAssignMap, int i, DynamicObject demand, DynamicObjectCollection supplyDycCol, ConvRateContext conRate) {
        BigDecimal requiredBaseQty = demand.getBigDecimal("realbaseqty");
        BigDecimal requiredQty2end = demand.getBigDecimal("realunit2ndqty");
        for (int j = 0; j < supplyDycCol.size(); ++j) {
            DynamicObject supplyDyc = (DynamicObject)supplyDycCol.get(j);
            String supplyId = (String)supplyDyc.get("invaccid");
            if (StringUtils.isEmpty((CharSequence)supplyId)) {
                try {
                    supplyId = supplyDyc.get("aggregateid") == null ? "" : supplyDyc.get("aggregateid").toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            QtyStore qtyStore = supplyHaveAssignMap.get(supplyId) == null ? new QtyStore(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO) : supplyHaveAssignMap.get(supplyId);
            BigDecimal haveAssignBaseQty = qtyStore.getBaseQty();
            BigDecimal haveAssignQty2end = qtyStore.getQty2end();
            BigDecimal haveAssignQty = qtyStore.getQty();
            BigDecimal supplyBaseQty = supplyDyc.getBigDecimal("avbbaseqty");
            BigDecimal supplyQty2end = supplyDyc.getBigDecimal("avbqty2nd");
            supplyQty2end = supplyQty2end.compareTo(BigDecimal.ZERO) > 0 ? supplyQty2end : BigDecimal.ZERO;
            BigDecimal supplyQty = supplyDyc.getBigDecimal("avbqty");
            BigDecimal realSupplyBaseQty = supplyBaseQty.subtract(haveAssignBaseQty);
            BigDecimal realSupplyQty2end = supplyQty2end.compareTo(BigDecimal.ZERO) > 0 ? supplyQty2end.subtract(haveAssignQty2end) : BigDecimal.ZERO;
            realSupplyQty2end = realSupplyQty2end.compareTo(BigDecimal.ZERO) > 0 ? realSupplyQty2end : BigDecimal.ZERO;
            BigDecimal realSupplyQty = supplyQty.subtract(haveAssignBaseQty);
            if (realSupplyBaseQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            DynamicObject unitDyc = (DynamicObject)model.getValue("unit", j);
            if (unitDyc == null) {
                realSupplyQty = BigDecimal.ZERO;
            }
            if (requiredBaseQty.compareTo(realSupplyBaseQty) >= 0) {
                model.setValue("reserveaccqty", (Object)realSupplyBaseQty, j, i);
                requiredBaseQty = requiredBaseQty.subtract(realSupplyBaseQty);
                model.setValue("reserveaccunitqty", (Object)realSupplyQty, j, i);
                realSupplyQty2end = realSupplyQty2end.min(requiredQty2end);
                model.setValue("reserveaccunit2ndqty", (Object)realSupplyQty2end, j, i);
                requiredQty2end = requiredQty2end.subtract(realSupplyQty2end);
                qtyStore.setBaseQty(haveAssignBaseQty.add(realSupplyBaseQty));
            } else {
                model.setValue("reserveaccqty", (Object)requiredBaseQty, j, i);
                DynamicObject materialDyc = (DynamicObject)model.getValue("material", j);
                DynamicObject baseUnitDyc = (DynamicObject)model.getValue("baseunit", j);
                if (unitDyc != null) {
                    realSupplyQty = conRate.getSrcQty(requiredBaseQty, materialDyc.getLong("id"), unitDyc.getLong("id"), baseUnitDyc.getLong("id"));
                }
                model.setValue("reserveaccunitqty", (Object)realSupplyQty, j, i);
                realSupplyQty2end = realSupplyQty2end.min(requiredQty2end);
                model.setValue("reserveaccunit2ndqty", (Object)realSupplyQty2end, j, i);
                qtyStore.setBaseQty(haveAssignBaseQty.add(requiredBaseQty));
                requiredBaseQty = BigDecimal.ZERO;
            }
            qtyStore.setQty(haveAssignQty.add(realSupplyQty));
            qtyStore.setQty2end(haveAssignQty2end.add(realSupplyQty2end));
            supplyHaveAssignMap.put(supplyId, qtyStore);
            if (requiredBaseQty.compareTo(BigDecimal.ZERO) <= 0) break;
        }
    }

    private void clearSupplyQty(IDataModel model, int i, DynamicObjectCollection supplyDycCol) {
        for (int j = 0; j < supplyDycCol.size(); ++j) {
            model.setValue("reserveaccqty", null, j, i);
            model.setValue("reserveaccunitqty", null, j, i);
            model.setValue("reserveaccunit2ndqty", null, j, i);
        }
    }

    protected boolean checkDir(DynamicObject material, String dir) {
        if (material == null) {
            return false;
        }
        String unitConvertDir = material.getString("unitconvertdir");
        Object auxptyUnitId = material.get("auxptyunit");
        boolean isUseAuxptyUnit = auxptyUnitId != null && unitConvertDir != null;
        return isUseAuxptyUnit && (unitConvertDir.equalsIgnoreCase(dir) || "C".equalsIgnoreCase(unitConvertDir));
    }

    private static Map<String, String> getSupplyFieldMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(64);
        fieldMap.put("org", "org");
        fieldMap.put("ownertype", "owner_type");
        fieldMap.put("warehouse", "warehouse");
        fieldMap.put("location", "location");
        fieldMap.put("project", "project");
        fieldMap.put("producedate", "producedate");
        fieldMap.put("expirydate", "expirydate");
        fieldMap.put("invstatus", "invstatus");
        fieldMap.put("invtype", "invtype");
        fieldMap.put("keepertype", "keeper_type");
        fieldMap.put("bar_no", "billnum");
        fieldMap.put("bizdate", "bizdate");
        fieldMap.put("supplier", "supplier");
        fieldMap.put("lotnumber", "lotnum");
        fieldMap.put("supplyauxpty", "auxpty");
        fieldMap.put("invaccid", "entryid");
        return fieldMap;
    }

    private static Map<String, String> getSupplyFieldBilMap() {
        HashMap<String, String> fieldMap = new HashMap<String, String>(64);
        fieldMap.put("org", "org");
        fieldMap.put("owner_type", "ownertype");
        fieldMap.put("warehouse", "warehouse");
        fieldMap.put("location", "location");
        fieldMap.put("project", "project");
        fieldMap.put("producedate", "producedate");
        fieldMap.put("expirydate", "expirydate");
        fieldMap.put("invstatus", "invstatus");
        fieldMap.put("invtype", "invtype");
        fieldMap.put("keeper_type", "keepertype");
        fieldMap.put("billnum", "bar_no");
        fieldMap.put("bizdate", "bizdate");
        fieldMap.put("supplier", "supplier");
        fieldMap.put("lotnum", "lotnumber");
        fieldMap.put("auxpty", "supplyauxpty");
        fieldMap.put("entryid", "invaccid");
        fieldMap.put("owner", "owner");
        fieldMap.put("unit", "unit");
        fieldMap.put("baseunit", "baseunit");
        return fieldMap;
    }
}

