/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;

public class NegativeInvTipConfEdit
extends AbstractBasePlugIn {
    private static volatile Integer needConfirm = 0;

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        if (needConfirm == 1) {
            needConfirm = 0;
        }
        switch (name = e.getProperty().getName()) {
            case "baltb": {
                this.changedBalTb(e);
                break;
            }
        }
    }

    private void changedBalTb(PropertyChangedArgs e) {
        if (e.getChangeSet()[0].getOldValue() == null) {
            this.handleBalTbChange();
        } else {
            ConfirmCallBackListener callBack = new ConfirmCallBackListener("confirm_baltb_flag", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u4f59\u989d\u8868\u5c06\u6e05\u7a7a\u5355\u636e\u8303\u56f4\u53ca\u5237\u65b0\u7ef4\u5ea6\u914d\u7f6e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"NegativeInvTipConfEdit_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBack);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)"confirm_baltb_flag", (CharSequence)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.handleBalTbChange();
        }
    }

    private void handleBalTbChange() {
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObject balTb = data.getDynamicObject("baltb");
        model.deleteEntryData("entryentity");
        ArrayList<String> keyCols = new ArrayList<String>();
        keyCols.add("keycol");
        if (balTb != null) {
            BalanceTB tb = BalanceTB.getBalanceTB((String)balTb.getString("number"));
            if (tb != null) {
                keyCols.addAll(tb.getKeyCols());
            }
            this.initColsEntry(balTb.getString("id"), keyCols, new ArrayList<String>(0), new HashMap<String, Integer>(0));
        }
        this.initBillScopeSelector();
        this.getModel().setValue("billscope", null);
    }

    private void initColsEntry(String balTbEntity, List<String> keycols, List<String> tipKeyCols, Map<String, Integer> oldShowPropMap) {
        IDataModel model = this.getModel();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)balTbEntity);
        Map fieldsMap = type.getAllFields();
        int[] indexArr = model.batchCreateNewEntryRow("entryentity", keycols.size());
        for (int i = 0; i < keycols.size(); ++i) {
            String col = keycols.get(i);
            model.setValue("balfield", (Object)col, indexArr[i]);
            model.setValue("balfieldname", (Object)((IDataEntityProperty)fieldsMap.get(col)).getDisplayName().getLocaleValue(), indexArr[i]);
            model.setValue("basedataprop", (Object)(fieldsMap.get(col) instanceof BasedataProp), indexArr[i]);
            if (CollectionUtils.isNotEmpty(tipKeyCols) && tipKeyCols.contains(col)) {
                model.setValue("tipcol", (Object)"1", indexArr[i]);
            }
            if (oldShowPropMap == null || oldShowPropMap.get(col) == null) continue;
            model.setValue("showprop", (Object)oldShowPropMap.get(col), indexArr[i]);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.reInitColsEntry();
        this.initBillScopeSelector();
        needConfirm = 1;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (needConfirm == 1) {
            e.setCheckDataChange(false);
        }
    }

    private void reInitColsEntry() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject balTb = dataEntity.getDynamicObject("baltb");
        if (balTb == null) {
            return;
        }
        DynamicObjectCollection entryentitys = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<String> keycols = new ArrayList<String>();
        ArrayList<String> tipKeyCols = new ArrayList<String>();
        HashMap<String, Integer> oldShowPropMap = new HashMap<String, Integer>(16);
        keycols.add("keycol");
        BalanceTB tb = BalanceTB.getBalanceTB((String)balTb.getString("number"));
        keycols.addAll(tb.getKeyCols());
        for (DynamicObject entity : entryentitys) {
            String balField = entity.getString("balfield");
            boolean enable = entity.getBoolean("tipcol");
            if (keycols.contains(balField) && enable) {
                tipKeyCols.add(balField);
            }
            oldShowPropMap.put(balField, entity.getInt("showprop"));
        }
        model.deleteEntryData("entryentity");
        this.initColsEntry(balTb.getString("id"), keycols, tipKeyCols, oldShowPropMap);
    }

    private void initBillScopeSelector() {
        ArrayList<ComboItem> operationItems = new ArrayList<ComboItem>();
        DynamicObject balTb = (DynamicObject)this.getModel().getValue("baltb");
        if (balTb != null) {
            List<DynamicObject> bills = NegativeInvTipConfEdit.getBillScopeList(balTb);
            if (CollectionUtils.isEmpty(bills)) {
                return;
            }
            for (DynamicObject bill : bills) {
                ComboItem item = new ComboItem(LocaleString.fromMap((Map)((Map)bill.get("name"))), bill.getPkValue().toString());
                operationItems.add(item);
            }
        }
        ComboEdit edit = (ComboEdit)this.getView().getControl("billscope");
        edit.setComboItems(operationItems);
    }

    public static List<DynamicObject> getBillScopeList(DynamicObject balTb) {
        QFilter qFilter = new QFilter("balancetablenumber.id", "=", balTb.getPkValue());
        QFilter filter = new QFilter("custstatus", "=", (Object)"1").or(new QFilter("custstatus", "is null", null)).or(new QFilter("custstatus", "=", (Object)" "));
        qFilter.and(filter);
        DynamicObject[] balRuleMap = BusinessDataServiceHelper.load((String)"bal_balanceupdaterule", (String)"id,sourceentitynumber", (QFilter[])qFilter.toArray());
        List<DynamicObject> bills = Arrays.asList(balRuleMap).stream().filter(item -> Objects.nonNull(item) && item.getDynamicObject("sourceentitynumber") != null).map(item -> item.getDynamicObject("sourceentitynumber")).distinct().collect(Collectors.toList());
        return bills;
    }
}

