/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.IntegerEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.flex.FlexValueFormatUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.mpscmm.msbd.reserve.business.helper.NegativeTipHelper;

public class NegativeTipFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        EntryAp entryAp = this.createDynamicEntryAp((FormShowParameter)e.getSource());
        if (entryAp != null) {
            HashMap<String, String> mapEntry = new HashMap<String, String>(2);
            mapEntry.put("id", "entryentity");
            mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
            e.getItems().add(mapEntry);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    public void createNewData(BizDataEventArgs e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object customParam = parameter.getCustomParam("msg");
        if (customParam == null) {
            return;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)customParam.toString());
        HashMap<String, Integer> showPropMap = new HashMap<String, Integer>(16);
        Map<Long, DynamicObject> dataMap = this.getBalData(jsonArray, showPropMap);
        this.setEntityValue(e, jsonArray, dataMap, showPropMap);
    }

    private void setEntityValue(BizDataEventArgs e, JSONArray jsonArray, Map<Long, DynamicObject> dataMap, Map<String, Integer> showPropMap) {
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < jsonArray.size(); ++i) {
            DynamicObject newRow = new DynamicObject(rows.getDynamicObjectType());
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            newRow.set("line", (Object)(i + 1));
            newRow.set("link", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"NegativeTipFormPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            newRow.set("id", (Object)jsonObject.getLong("balId"));
            newRow.set("bill", (Object)jsonObject.getString("bill"));
            if (this.getModel().getDataEntityType().findProperty("period") != null) {
                newRow.set("period", (Object)jsonObject.getInteger("period"));
            }
            newRow.set("qty", (Object)jsonObject.getString("qty"));
            if (dataMap != null) {
                DynamicObject dynamicObject = dataMap.get(jsonObject.getLong("balId"));
                List fields = jsonObject.getJSONArray("fields").toJavaList(String.class);
                for (String field : fields) {
                    if (dynamicObject.get(field) == null || Long.valueOf(0L).equals(dynamicObject.get(field))) continue;
                    newRow.set(field, NegativeTipHelper.getShowValue(dynamicObject, field, showPropMap.get(field)));
                }
                this.setAuxpty(newRow, dynamicObject);
            }
            rows.add((Object)newRow);
        }
        e.setDataEntity((Object)dataEntity);
    }

    private Map<Long, DynamicObject> getBalData(JSONArray jsonArray, Map<String, Integer> showPropMap) {
        int i;
        JSONArray configFields = jsonArray.getJSONObject(0).getJSONArray("config");
        if (configFields == null || configFields.size() == 0) {
            return null;
        }
        String entityName = jsonArray.getJSONObject(0).getString("balentityname");
        ArrayList<Long> balIds = new ArrayList<Long>(jsonArray.size());
        for (i = 0; i < jsonArray.size(); ++i) {
            balIds.add(jsonArray.getJSONObject(i).getLong("balId"));
        }
        for (i = 0; i < configFields.size(); ++i) {
            JSONObject jsonObject = configFields.getJSONObject(i);
            showPropMap.put(jsonObject.getString("field"), jsonObject.getInteger("showprop"));
        }
        StringBuilder buffer = new StringBuilder();
        BalanceTB tb = BalanceTB.getBalanceTB((String)entityName);
        List keyCols = tb.getKeyCols();
        keyCols.forEach(field -> buffer.append((String)field).append(","));
        buffer.append("keycol").append(",");
        buffer.append("id");
        QFilter qFilter = new QFilter("id", "in", balIds);
        DynamicObject[] data = BusinessDataServiceHelper.load((String)entityName, (String)buffer.toString(), (QFilter[])qFilter.toArray());
        Map<Long, DynamicObject> dataMap = Arrays.asList(data).stream().collect(Collectors.toMap(item -> item.getLong("id"), k -> k));
        return dataMap;
    }

    public void beforeBindData(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        EntryAp entryAp = this.createDynamicEntryAp(this.getView().getFormShowParameter());
        if (entryAp != null) {
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            for (Control fieldEdit : fieldEdits) {
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(fieldEdit);
            }
        }
    }

    private EntryAp createDynamicEntryAp(FormShowParameter parameter) {
        Object customParam = parameter.getCustomParam("msg");
        if (customParam == null) {
            return null;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)customParam.toString());
        JSONArray configFields = jsonArray.getJSONObject(0).getJSONArray("config");
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap");
        entryAp.getItems().add(this.createFieldAp("line", "#", "1"));
        entryAp.getItems().add(this.createFieldAp("link", ResManager.loadKDString((String)"\u5e93\u5b58\u8054\u67e5\u660e\u7ec6", (String)"NegativeTipFormPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "3"));
        entryAp.getItems().add(this.createFieldAp("bill", ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f", (String)"NegativeTipFormPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "3"));
        if (CollectionUtils.isNotEmpty((Collection)jsonArray) && jsonArray.getJSONObject(0).containsKey((Object)"period")) {
            entryAp.getItems().add(this.createFieldAp("period", ResManager.loadKDString((String)"\u671f\u95f4", (String)"NegativeTipFormPlugin_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "3"));
        }
        if (configFields != null && jsonArray.size() > 0) {
            for (int i = 0; i < configFields.size(); ++i) {
                JSONObject jsonObject = configFields.getJSONObject(i);
                entryAp.getItems().add(this.createFieldAp(jsonObject.getString("field"), jsonObject.getString("fieldName"), "3"));
            }
        }
        entryAp.getItems().add(this.createFieldAp("qty", ResManager.loadKDString((String)"\u6570\u91cf\u4fe1\u606f", (String)"NegativeTipFormPlugin_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "3"));
        return entryAp;
    }

    private EntryFieldAp createFieldAp(String key, String name, String type) {
        EntryFieldAp fieldAp = new EntryFieldAp();
        fieldAp.setId(key);
        fieldAp.setKey(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setFireUpdEvt(true);
        switch (type) {
            case "1": {
                IntegerField field = new IntegerField();
                field.setId(key);
                field.setKey(key);
                fieldAp.setField((Field)field);
                break;
            }
            case "3": {
                TextField textField = new TextField();
                textField.setId(key);
                textField.setKey(key);
                if ("link".equals(key)) {
                    fieldAp.setHyperlink(true);
                }
                fieldAp.setField((Field)textField);
                break;
            }
        }
        return fieldAp;
    }

    private void registDynamicProps(MainEntityType newMainType) {
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        EntryAp entryAp = this.createDynamicEntryAp(this.getView().getFormShowParameter());
        if (entryAp != null && CollectionUtils.isNotEmpty((Collection)entryAp.getItems())) {
            for (int i = 0; i < entryAp.getItems().size(); ++i) {
                String key = ((ControlAp)entryAp.getItems().get(i)).getKey();
                Object fieldProp = null;
                fieldProp = "line".equals(key) ? new IntegerProp() : new TextProp();
                fieldProp.setName(key);
                fieldProp.setDisplayName(((ControlAp)entryAp.getItems().get(i)).getName());
                fieldProp.setDbIgnore(true);
                fieldProp.setAlias("");
                entryType.registerSimpleProperty((DynamicSimpleProperty)fieldProp);
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if ("line".equals(key)) {
            IntegerEdit integerEdit = new IntegerEdit();
            integerEdit.setKey(key);
            integerEdit.setEntryKey("entryentity");
            integerEdit.setView(this.getView());
            e.setControl((Control)integerEdit);
        } else if (!key.equals("entryentity")) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(key);
            textEdit.setEntryKey("entryentity");
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        Object customParam = this.getView().getFormShowParameter().getCustomParam("msg");
        if (customParam == null) {
            return;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)customParam.toString());
        String entityName = jsonArray.getJSONObject(0).getString("balentityname");
        Long balId = jsonArray.getJSONObject(hyperLinkClickEvent.getRowIndex()).getLong("balId");
        if (fieldName.equals("link") || fieldName.equals("balId")) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(entityName);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPkId((Object)balId);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, null);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
        this.getModel().updateEntryCache(collection);
        this.getView().updateView();
    }

    private void setAuxpty(DynamicObject row, DynamicObject balData) {
        IDataEntityProperty auxptyProp = this.getModel().getDataEntityType().findProperty("auxpty");
        if (auxptyProp == null) {
            return;
        }
        DynamicObject material = balData.getDynamicObject("material");
        DynamicObject flexauxprop = balData.getDynamicObject("auxpty");
        FlexProp flexProp = (FlexProp)this.getModel().getDataEntityType().findProperty("flexfield");
        row.set("materielfield", (Object)material);
        row.set("flexfield", (Object)flexauxprop);
        String reportDisplayValue = FlexValueFormatUtils.getReportDisplayValue((DynamicObject)row, (FlexProp)flexProp);
        row.set("auxpty", (Object)reportDisplayValue);
    }
}

