/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReleaseHelper;
import kd.mpscmm.msbd.reserve.business.ReserveServiceCfgFilterHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.record.RecordReleaseModle;

public class ReleaseCheckToolPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(ReleaseCheckToolPlugin.class);
    private static final String BILLOPERATION = "billoperation";
    private static final String BILLOBJECT = "billobject";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bt_check"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("matchentry1");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid1 = (EntryGrid)this.getView().getControl("ruleentry");
        entryGrid1.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid2 = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid2.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryGrid3 = (EntryGrid)this.getView().getControl("matchentry");
        entryGrid3.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"mapflex", "serviceflex", "ruleflex", "recordflex", "releaseflex", "resultinfoflex", "userecordflex"});
    }

    public void click(EventObject evt) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"mapflex", "serviceflex", "ruleflex", "recordflex", "releaseflex", "resultinfoflex", "userecordflex"});
        String billName = null;
        try {
            DynamicObject billObj = (DynamicObject)this.getModel().getValue(BILLOBJECT);
            if (billObj == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReleaseCheckToolPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                return;
            }
            String opName = (String)this.getModel().getValue(BILLOPERATION);
            if (opName == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReleaseCheckToolPlugin_8", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                return;
            }
            String billNum = (String)this.getModel().getValue("billno");
            if ("".equals(billNum)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReleaseCheckToolPlugin_2", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                return;
            }
            billName = billObj.getString("number");
            ColsMap releaseBillColMap = ColsMapHelper.findReleaseBillColMap(billName);
            Map<String, String> balColMap = releaseBillColMap.getBalColMap();
            if (balColMap.get("billno") == null) {
                this.getModel().setValue("finalresult", (Object)String.format(ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u6620\u5c04\u914d\u7f6e\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u5b57\u6bb5\uff1a%1$s", (String)"ReserveService_7", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), "billno"));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"resultinfoflex"});
                return;
            }
            QFilter releaseBillFilter = new QFilter(balColMap.get("billno"), "=", (Object)billNum);
            DynamicObject releaseBill = BusinessDataServiceHelper.loadSingle((String)billName, (QFilter[])new QFilter[]{releaseBillFilter});
            if (releaseBill == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"ReleaseCheckToolPlugin_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                return;
            }
            if (releaseBill.getBoolean("isvirtualbill")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u865a\u5355\u4e0d\u5141\u8bb8\u91ca\u653e\u3002", (String)"ReleaseCheckToolPlugin_16", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                return;
            }
            Long[] idArr = new Long[]{releaseBill.getLong("id")};
            QFilter releaseFilter = new QFilter("billid", "in", (Object)idArr);
            if (QueryServiceHelper.exists((String)"msmod_release_record", (QFilter[])(releaseFilter = releaseFilter.and("deletestatus", "!=", (Object)"1")).toArray())) {
                this.getModel().setValue("finalresult", (Object)ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u6210\u529f\u91ca\u653e\u9884\u7559\u8bb0\u5f55\u5e76\u51fa\u5e93\u3002", (String)"ReleaseCheckToolPlugin_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"resultinfoflex"});
                return;
            }
            List<String> mustSetFieldList = Collections.singletonList("entryentity.baseqty");
            StringBuilder sb = new StringBuilder();
            for (String field : mustSetFieldList) {
                if (balColMap.get(field) != null) continue;
                sb.append(field).append(',');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                this.getModel().setValue("finalresult", (Object)String.format(ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u6620\u5c04\u914d\u7f6e\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u5b57\u6bb5\uff1a%1$s", (String)"ReserveService_7", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), sb));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"resultinfoflex"});
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"mapflex", "matchentry1"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"matchentry2"});
            this.getModel().setValue("maptype", (Object)ResManager.loadKDString((String)"\u9884\u7559\u91ca\u653e\u6a21\u578b", (String)"ReleaseCheckToolPlugin_9", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            this.getModel().setValue("mapnumber", (Object)releaseBillColMap.getMapNumber());
            this.getModel().setValue("mapname", (Object)releaseBillColMap.getMapName());
            this.getModel().setValue("mapid", (Object)releaseBillColMap.getMapId());
            DynamicObject[] validateReleaseBillArray = this.checkService(opName, billName, releaseBill);
            if (validateReleaseBillArray == null) {
                return;
            }
            List<Object> realIdList = new ArrayList<Object>(8);
            DynamicObject releaseRule = null;
            QFilter fs = new QFilter("release_bill", "=", (Object)billName);
            fs.and("enable", "=", (Object)"1");
            Map releaseRuleMap = BusinessDataServiceHelper.loadFromCache((String)"msmod_release_rule", (QFilter[])fs.toArray());
            if (releaseRuleMap == null || releaseRuleMap.size() == 0) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"ruleflex"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"ruleentry1"});
                this.getModel().setValue("ruleresult", (Object)String.format(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61 %1$s \u6ca1\u6709\u53ef\u7528\u7684\u9884\u7559\u91ca\u653e\u89c4\u5219\uff0c\u5c06\u9ed8\u8ba4\u6309\u7167\u5206\u5f55\u5173\u8054\u5173\u7cfb\u91ca\u653e\u4e0a\u6e38\u5355\u636e\u9884\u7559\u8bb0\u5f55\u3002\u5b58\u5728\u5bf9\u8c61\u9884\u7559\u65f6\uff0c\u91ca\u653e\u5355\u636e\u5fc5\u987b\u914d\u7f6e\u9884\u7559\u91ca\u653e\u89c4\u5219\u624d\u80fd\u91ca\u653e\u5bf9\u8c61\u9884\u7559\u3002", (String)"ReleaseCheckToolPlugin_10", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), billName));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"ruleentry", "rinfo1"});
                realIdList.add(releaseBill.getLong("id"));
                return;
            }
            Map<Object, List<Object>> ruleBillListMap = ReleaseHelper.getValidateReleaseIdListMap(Collections.singletonList(releaseBill), releaseRuleMap);
            for (Map.Entry<Object, List<Object>> entry : ruleBillListMap.entrySet()) {
                Object ruleId = entry.getKey();
                releaseRule = (DynamicObject)releaseRuleMap.get(ruleId);
                realIdList = entry.getValue();
            }
            if (realIdList.size() == 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"resultinfoflex"});
                this.getModel().setValue("finalresult", (Object)ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u7b26\u5408\u9884\u7559\u91ca\u653e\u89c4\u5219\u7684\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\u91ca\u653e\u89c4\u5219\u8fc7\u6ee4\u6761\u4ef6\u5bf9\u5e94\u7684\u5355\u636e\u503c\u3002", (String)"ReleaseCheckToolPlugin_11", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"resultinfoflex"});
                return;
            }
            if (releaseRule != null) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"ruleflex"});
                this.getModel().setValue("rulenumber", (Object)releaseRule.getString("number"));
                this.getModel().setValue("rulename", (Object)releaseRule.getString("name"));
                this.getModel().setValue("ruleid", (Object)releaseRule.getLong("id"));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"rinfo1", "ruleentry1"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"ruleentry"});
            }
            if (this.mergeReserveRecord(billName, realIdList, releaseRule, this.getView())) {
                return;
            }
            this.getModel().setValue("finalresult", (Object)ResManager.loadKDString((String)"\u51fa\u5e93\u9884\u7559\u91ca\u653e\u68c0\u67e5\u5b8c\u6210\u3002\u5f53\u9884\u7559\u91ca\u653e\u5355\u636e\u6267\u884c\u51fa\u5e93\u9884\u7559\u91ca\u653e\u670d\u52a1\u65f6\uff0c\u5c06\u6309\u7167\u9884\u7559\u91ca\u653e\u89c4\u5219\u7684\u9884\u7559\u5b57\u6bb5\u548c\u91ca\u653e\u5355\u636e\u5b57\u6bb5\u7684\u5339\u914d\u5173\u7cfb\uff0c\u91ca\u653e\u76f8\u5e94\u7684\u9884\u7559\u8bb0\u5f55\u3002", (String)"ReleaseCheckToolPlugin_12", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"resultinfoflex"});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getModel().setValue("nomap", (Object)String.format(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61 %1$s \u6ca1\u6709\u5339\u914d\u5230\u53ef\u7528\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff0c\u8bf7\u524d\u5f80 \u9884\u7559\u6620\u5c04\u914d\u7f6e\u83dc\u5355 \u8fdb\u884c\u68c0\u67e5\u3002", (String)"ReleaseCheckToolPlugin_15", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), billName));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"matchentry2", "mapflex"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"matchentry1"});
        }
    }

    private boolean mergeReserveRecord(String billName, List<Object> realIdList, DynamicObject releaseRule, IFormView formView) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"recordflex"});
        RecordReleaseModle releaseModel = RecordReleaseModle.getInstance(billName, realIdList, releaseRule);
        List<DynamicObject> matchReleaseRecord = releaseModel.matchReleaseRecordForCheck(formView);
        return matchReleaseRecord.size() == 0;
    }

    private List<Object> checkReleaseRule(DynamicObject releaseRule, String billName, DynamicObject releaseBill) {
        QFilter fs = new QFilter("release_bill", "=", (Object)billName);
        fs.and("enable", "=", (Object)"1");
        Map releaseRuleMap = BusinessDataServiceHelper.loadFromCache((String)"msmod_release_rule", (QFilter[])fs.toArray());
        List<Object> realIdList = new ArrayList(8);
        if (releaseRuleMap == null || releaseRuleMap.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ruleflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ruleentry1"});
            this.getModel().setValue("ruleresult", (Object)String.format(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61 %1$s \u6ca1\u6709\u53ef\u7528\u7684\u9884\u7559\u91ca\u653e\u89c4\u5219\uff0c\u5c06\u9ed8\u8ba4\u6309\u7167\u5206\u5f55\u5173\u8054\u5173\u7cfb\u91ca\u653e\u4e0a\u6e38\u5355\u636e\u9884\u7559\u8bb0\u5f55\u3002\u5b58\u5728\u5bf9\u8c61\u9884\u7559\u65f6\uff0c\u91ca\u653e\u5355\u636e\u5fc5\u987b\u914d\u7f6e\u9884\u7559\u91ca\u653e\u89c4\u5219\u624d\u80fd\u91ca\u653e\u5bf9\u8c61\u9884\u7559\u3002", (String)"ReleaseCheckToolPlugin_10", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), billName));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"ruleentry", "rinfo1"});
            realIdList.add(releaseBill.getLong("id"));
        } else {
            Map<Object, List<Object>> ruleBillListMap = ReleaseHelper.getValidateReleaseIdListMap(Collections.singletonList(releaseBill), releaseRuleMap);
            for (Map.Entry<Object, List<Object>> entry : ruleBillListMap.entrySet()) {
                Object ruleId = entry.getKey();
                releaseRule = (DynamicObject)releaseRuleMap.get(ruleId);
                realIdList = entry.getValue();
            }
            if (realIdList.size() == 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"resultinfoflex"});
                this.getModel().setValue("finalresult", (Object)ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u7b26\u5408\u9884\u7559\u91ca\u653e\u89c4\u5219\u7684\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\u91ca\u653e\u89c4\u5219\u8fc7\u6ee4\u6761\u4ef6\u5bf9\u5e94\u7684\u5355\u636e\u503c\u3002", (String)"ReleaseCheckToolPlugin_11", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"resultinfoflex"});
                return null;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ruleflex"});
            this.getModel().setValue("rulenumber", (Object)releaseRule.getString("number"));
            this.getModel().setValue("rulename", (Object)releaseRule.getString("name"));
            this.getModel().setValue("ruleid", (Object)releaseRule.getLong("id"));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"rinfo1", "ruleentry1"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ruleentry"});
        }
        return realIdList;
    }

    private DynamicObject[] checkService(String opName, String billName, DynamicObject releaseBill) {
        DynamicObject[] validateTransBillArray;
        String serviceName = (String)this.getModel().getValue("servicename");
        DynamicObject[] validateReleaseBillArray = ReserveServiceCfgFilterHelper.canReserveBillIdDynamic(serviceName, billName, new DynamicObject[]{releaseBill}, opName);
        if (validateReleaseBillArray.length == 0) {
            this.getModel().setValue("sinfo", (Object)String.format(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61 %1$s \u6ca1\u6709\u5339\u914d\u5230\u53ef\u7528\u7684\u51fa\u5e93\u9884\u7559\u91ca\u653e\u670d\u52a1\uff0c\u8bf7\u524d\u5f80 \u9884\u7559\u670d\u52a1\u914d\u7f6e \u83dc\u5355\u8fdb\u884c\u68c0\u67e5\u3002", (String)"ReleaseCheckToolPlugin_5", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), billName));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"serviceflex"});
            return null;
        }
        if ("ReleaseReserved".equals(serviceName) && (validateTransBillArray = ReserveServiceCfgFilterHelper.canReserveBillIdDynamic("ReserveReplace", billName, validateReleaseBillArray, opName)).length > 0) {
            this.getModel().setValue("sinfo", (Object)String.format(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61 %1$s \u540c\u65f6\u914d\u7f6e\u4e86\u9884\u7559\u8f6c\u79fb\u670d\u52a1\u548c\u51fa\u5e93\u9884\u7559\u91ca\u653e\u670d\u52a1\uff0c\u4e0d\u6267\u884c\u51fa\u5e93\u9884\u7559\u91ca\u653e\u670d\u52a1\uff0c\u8bf7\u524d\u5f80 \u9884\u7559\u670d\u52a1\u914d\u7f6e \u83dc\u5355\u8fdb\u884c\u68c0\u67e5\u3002", (String)"ReleaseCheckToolPlugin_6", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), billName));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"serviceflex"});
            return null;
        }
        this.getModel().setValue("sinfo", (Object)String.format(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61\u201c%1$s\u201d\u5df2\u5339\u914d\u5230\u53ef\u7528\u7684\u51fa\u5e93\u9884\u7559\u91ca\u653e\u670d\u52a1\u3002", (String)"ReleaseCheckToolPlugin_7", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), billName));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"serviceflex"});
        return validateReleaseBillArray;
    }

    public void hyperLinkClick(HyperLinkClickEvent paramEvent) {
        String fieldName = paramEvent.getFieldName();
        int row = paramEvent.getRowIndex();
        switch (fieldName) {
            case "mapnumber": {
                this.showForm(row, "matchentry1", "mapid", "msmod_reservemapping");
                break;
            }
            case "rulenumber": {
                this.showForm(row, "ruleentry", "ruleid", "msmod_release_rule");
                break;
            }
            case "recordid": {
                this.showForm(row, "entryentity", "recordid", "msmod_reserve_record");
                break;
            }
            case "recordid1": {
                this.showForm(row, "matchentry", "recordid1", "msmod_reserve_record");
                break;
            }
        }
    }

    private void showForm(int row, String entryName, String idName, String formName) {
        long mapId = this.getModel().getEntryRowEntity(entryName, row).getLong(idName);
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)mapId);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "billobject": {
                this.clearBillOp();
                this.updateBillOp();
                break;
            }
        }
    }

    private void clearBillOp() {
        IDataModel model = this.getModel();
        model.setValue(BILLOPERATION, null);
        ComboEdit comboEdit = (ComboEdit)this.getControl(BILLOPERATION);
        comboEdit.setComboItems(null);
    }

    private void updateBillOp() {
        DynamicObject objectType = (DynamicObject)this.getModel().getValue(BILLOBJECT);
        if (objectType != null) {
            String str = (String)objectType.getPkValue();
            List ops = EntityMetadataCache.getDataEntityOperate((String)str);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
            for (Map op : ops) {
                String opTypeId = (String)op.get("type");
                if (!OperationTypeCache.isEntityOperation((String)opTypeId)) continue;
                String opKey = (String)op.get("key");
                Map mapLocaleString = (Map)op.get("name");
                String opName = opKey;
                if (mapLocaleString != null) {
                    opName = LocaleString.fromMap((Map)mapLocaleString).toString() + "(" + opKey + ")";
                }
                ComboItem comboItem = new ComboItem(new LocaleString(opName), opKey);
                comboItems.add(comboItem);
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl(BILLOPERATION);
            comboEdit.setComboItems(comboItems);
        }
    }
}

