/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;
import kd.mpscmm.msbd.reserve.mservice.ReserveService;

public class RequestBillTestPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        try {
            String key;
            switch (key = e.getOperateKey()) {
                case "plugintest": {
                    this.createInstance((String)this.getModel().getValue("plugin"));
                    break;
                }
                case "servicetest": {
                    this.invokeService((String)this.getModel().getValue("service"), (String)this.getModel().getValue("param"));
                    break;
                }
                case "reserve": 
                case "reservebatch": {
                    BillReserveResult reserve = this.reserve(key);
                    this.getView().showSuccessNotification((Object)((Object)reserve.getReserveResultType()) + "" + reserve.getEntryResultList());
                    break;
                }
                case "release": 
                case "unrelease": {
                    this.release(key);
                }
            }
        }
        catch (Exception e1) {
            StackTraceElement[] stackTrace = e1.getStackTrace();
            StringBuilder msgStr = new StringBuilder(e1.getMessage());
            msgStr.append(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\u4e3a", (String)"RequestBillTestPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            int len = stackTrace.length;
            for (int i = 0; i < len; ++i) {
                if (msgStr.length() > 1000) {
                    msgStr.setLength(1000);
                    break;
                }
                msgStr.append("\r\n at ").append(stackTrace[i]);
            }
            throw new KDBizException(msgStr.toString());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\u3002", (String)"RequestBillTestPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        super.afterDoOperation(e);
    }

    private void release(String key) {
        IDataModel model = this.getModel();
        DynamicObject billData = (DynamicObject)model.getValue("billdata");
        String billno = (String)model.getValue("billno");
        if (billData == null || StringUtils.isBlank((CharSequence)billno)) {
            return;
        }
        String formId = (String)billData.getPkValue();
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((String)formId, (QFilter[])new QFilter("billno", "=", (Object)billno).toArray());
        if ("release".equals(key)) {
            ReserveService.doAuditReleaseReserve(formId, JSON.toJSONString((Object)new Object[]{bill.getPkValue()}));
        } else {
            ReserveService.UnAuditUnReleaseReserve(formId, JSON.toJSONString((Object)new Object[]{bill.getPkValue()}));
        }
    }

    private BillReserveResult reserve(String key) {
        IDataModel model = this.getModel();
        DynamicObject billData = (DynamicObject)model.getValue("billdata");
        String billno = (String)model.getValue("billno");
        if (billData == null || StringUtils.isBlank((CharSequence)billno)) {
            return new BillReserveResult();
        }
        String formId = (String)billData.getPkValue();
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((String)formId, (QFilter[])new QFilter("billno", "=", (Object)billno).toArray());
        return "reserve".equals(key) ? ReserveHelper.reserveBill(bill) : ReserveHelper.reserveOneBill(bill);
    }

    private void invokeService(String name, String param) {
        try {
            Class<?> clz = Class.forName(name);
            Method[] methods = clz.getMethods();
            Method method2 = clz.getMethod("reserveBatch", Collection.class);
            Collection fromJsonString = (Collection)SerializationUtils.fromJsonString((String)param, List.class);
            method2.invoke(clz.newInstance(), fromJsonString);
        }
        catch (Exception e) {
            throw new KDBizException(e.getCause().getMessage());
        }
    }

    private void createInstance(String name) throws Exception {
        Class<?> clz = Class.forName(name);
        IUpgradeService instance = (IUpgradeService)clz.newInstance();
        instance.beforeExecuteSqlWithResult("", "", "scm", "");
    }
}

