/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.reserve.common.util.FormUtil;

public class ReserveDataSourceEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ReserveDataSourceEditPlugin.class);
    public static final String DATA_SOURCE = "data_source";
    public static final String COLS_MAP = "cols_map";

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (logger.isDebugEnabled()) {
            logger.debug("ReserveDataSourceEditPlugin.propertyChanged" + key);
        }
        switch (key) {
            case "data_source": {
                this.setColsMapEnable();
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtil.addF7Listener(this, COLS_MAP);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "cols_map": {
                this.beforeColsMap(showParameter);
                break;
            }
        }
    }

    private void beforeColsMap(ListShowParameter showParameter) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        IDataModel bill = this.getModel();
        DynamicObject dateSource = (DynamicObject)bill.getValue(DATA_SOURCE);
        QFilter filter = new QFilter("source_bill", "=", dateSource.getPkValue());
        filterList.add(filter);
        showParameter.getListFilterParameter().setQFilters(filterList);
    }

    private void setColsMapEnable() {
        Object dataSource = this.getModel().getValue(DATA_SOURCE);
        boolean enable = false;
        if (null != dataSource) {
            enable = true;
        } else {
            this.getModel().setValue(COLS_MAP, null);
        }
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{COLS_MAP});
    }

    public void afterCreateNewData(EventObject e) {
        this.setColsMapEnable();
    }
}

