/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.reserve.business.helper.FormShowHelper;

public class ReserveIgnoreCfgEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final long ignoreCfgId = 1553692015948993536L;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"condition"});
        BasedataEdit edit = (BasedataEdit)this.getControl("bizentity");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        String fieldKey;
        super.click(evt);
        IDataModel model = this.getModel();
        Control control = (Control)evt.getSource();
        switch (fieldKey = control.getKey()) {
            case "condition": {
                this.clickBizEntityCondition(model, control);
                break;
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BaseShowParameter formShowParameter = (BaseShowParameter)e.getFormShowParameter();
        formShowParameter.setPkId((Object)1553692015948993536L);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "bizentity": {
                this.bizObjChange(rowIndex);
                break;
            }
            case "condition": {
                this.bizEntityConditionChange(newValue, rowIndex);
                break;
            }
        }
    }

    private void bizEntityConditionChange(Object newValue, int rowIndex) {
        if (StringUtils.isBlank((Object)newValue)) {
            this.getModel().setValue("conditionformula_tag", null, rowIndex);
            this.getModel().setValue("conditionjson_tag", null, rowIndex);
        }
    }

    private void bizObjChange(int rowIndex) {
        this.getModel().setValue("condition", (Object)"", rowIndex);
        this.getModel().setValue("conditionjson_tag", (Object)"", rowIndex);
        this.getModel().setValue("conditionformula_tag", (Object)"", rowIndex);
        this.getView().updateView("condition", rowIndex);
        this.getView().updateView("conditionjson_tag", rowIndex);
        this.getView().updateView("conditionformula_tag", rowIndex);
    }

    private void clickBizEntityCondition(IDataModel model, Control control) {
        int currentRowIndex = control.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("bizentity", currentRowIndex);
        if (bizEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5355\u636e\u3002", (String)"ReserveIgnoreCfgEditPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            return;
        }
        String bizEntityNumber = bizEntity.getString("number");
        FormShowHelper.showEntryFilterForm((AbstractFormPlugin)this, model, bizEntityNumber, currentRowIndex, "conditionjson_tag", "conditionCB");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        String returnData = (String)evt.getReturnData();
        IDataModel dataModel = this.getModel();
        IPageCache pageCache = this.getPageCache();
        if (actionId == null || returnData == null) {
            return;
        }
        switch (actionId) {
            case "conditionCB": {
                FormShowHelper.closeCallSetEntryCondition(dataModel, pageCache, returnData, "condition", "conditionjson_tag", "conditionformula_tag");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "bizentity": {
                List<String> numbers = this.getBillNumbers();
                if (numbers.size() <= 0) break;
                QFilter filter = new QFilter("number", "not in", (Object)numbers.toArray());
                ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
                param.getListFilterParameter().getQFilters().add(filter);
                break;
            }
        }
    }

    private List<String> getBillNumbers() {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<String> billIds = new ArrayList<String>();
        if (entry != null && entry.size() > 0) {
            entry.forEach(p -> {
                String number = p.getString("bizentity.number");
                if (StringUtils.isNotEmpty((CharSequence)number)) {
                    billIds.add(number);
                }
            });
        }
        return billIds;
    }
}

