/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.reserve.business.helper.ReserveRecordDataSetHelper;

public class ReserveRecordListPlugin
extends AbstractListPlugin {
    private Set<String> billModelFieldSet = new HashSet<String>(Collections.singletonList("bill_entry"));
    private Set<String> balModelFieldSet = new HashSet<String>(16);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "updata": {
                this.upDataInfo();
                break;
            }
        }
    }

    private void upDataInfo() {
        ListSelectedRowCollection reserveIds = this.getSelectedRows();
        Object[] primaryKeyValues = reserveIds.getPrimaryKeyValues();
        ReserveRecordDataSetHelper dataSetHelper = new ReserveRecordDataSetHelper();
        ArrayList<QFilter> recordFilters = new ArrayList<QFilter>(16);
        recordFilters.add(new QFilter("id", "in", (Object)primaryKeyValues));
        DataSet reserveRecord = dataSetHelper.getReserveRecordInfo(recordFilters);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record");
        Row msmodReserveRecords = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)dataEntityType);
        this.initSelectInfo();
        this.billModelFieldSet.addAll(this.balModelFieldSet);
        HashMap maps = new HashMap(((DynamicObject[])msmodReserveRecords).length);
        String[] fieldNames = reserveRecord.getRowMeta().getFieldNames();
        while (reserveRecord.hasNext()) {
            Row row = reserveRecord.next();
            Long reserveid = row.getLong("reserveid");
            HashMap<String, Object> map = new HashMap<String, Object>(((Row)msmodReserveRecords).length);
            block1: for (String billFild : this.billModelFieldSet) {
                if ("bill_entry".equals(billFild)) continue;
                for (String rowName : fieldNames) {
                    if (!rowName.equals(billFild)) continue;
                    map.put(billFild, row.get(billFild));
                    continue block1;
                }
            }
            maps.put(reserveid, map);
        }
        for (Row msmodReserveRecord : msmodReserveRecords) {
            long fid = msmodReserveRecord.getLong("id");
            Map stringObjectMap = (Map)maps.get(fid);
            for (String s : this.billModelFieldSet) {
                if (stringObjectMap.get(s) == null) continue;
                msmodReserveRecord.set(s, stringObjectMap.get(s));
            }
        }
        ArrayList<Row> reserveRecordList = new ArrayList<Row>(1024);
        for (Row msmodReserveRecord : msmodReserveRecords) {
            if (reserveRecordList.size() >= 1000) {
                SaveServiceHelper.save((DynamicObject[])reserveRecordList.toArray(new DynamicObject[0]));
                reserveRecordList.clear();
            }
            reserveRecordList.add(msmodReserveRecord);
        }
        if (!reserveRecordList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])reserveRecordList.toArray(new DynamicObject[0]));
        }
        this.refreshList();
    }

    private void initSelectInfo() {
        Map allFieldMap = MetadataServiceHelper.getDataEntityType((String)"msmod_reserve_record").getAllFields();
        this.billModelFieldSet = new HashSet<String>(Collections.singletonList("bill_entry"));
        this.balModelFieldSet = new HashSet<String>(16);
        for (String key : allFieldMap.keySet()) {
            if (key.startsWith("r_")) {
                this.billModelFieldSet.add(key);
                continue;
            }
            if (!key.startsWith("s_")) continue;
            this.balModelFieldSet.add(key);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        args.setCancel(true);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        BillList list = (BillList)this.getControl("billlistap");
        Long pkIds = (Long)currentRow.getPrimaryKeyValue();
        switch (fieldName) {
            case "bill_no": {
                this.showSrcBill(pkIds, list);
                break;
            }
            case "s_billnum": {
                this.showSupplyBill(pkIds, list);
            }
        }
    }

    private void showSrcBill(Long pkIds, BillList list) {
        DynamicObject selectRowEntry = null;
        if (pkIds != null) {
            selectRowEntry = BusinessDataServiceHelper.loadSingle((Object)pkIds, (String)list.getBillFormId(), (String)"bill_obj,bill_id");
        }
        if (selectRowEntry != null) {
            String billName = selectRowEntry.getDynamicObject("bill_obj").getString("number");
            long bill_id = selectRowEntry.getLong("bill_id");
            this.openBillInfoShowPage(billName, bill_id);
        }
    }

    private void showSupplyBill(Long pkIds, BillList list) {
        DynamicObject selectRowEntry = null;
        if (pkIds != null) {
            selectRowEntry = BusinessDataServiceHelper.loadSingle((Object)pkIds, (String)list.getBillFormId(), (String)"bal_obj,bal_id");
        }
        if (selectRowEntry != null) {
            String billName = selectRowEntry.getDynamicObject("bal_obj").getString("number");
            long bill_id = selectRowEntry.getLong("bal_id");
            this.openBillInfoShowPage(billName, bill_id);
        }
    }

    private void openBillInfoShowPage(String billNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(billNumber);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("create_date desc,bill_no desc,billentry_seq asc");
        e.getQFilters().add(new QFilter("base_qty", "<>", (Object)BigDecimal.ZERO).or(new QFilter("qty", "<>", (Object)BigDecimal.ZERO)).or(new QFilter("qty2nd", "<>", (Object)BigDecimal.ZERO)));
    }

    private void refreshList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            if (!this.isFilterCloseAcctBizTime(commonFilterColumn.getFieldName())) continue;
            commonFilterColumn.setDefaultValue(null);
        }
    }

    protected boolean isFilterCloseAcctBizTime(String fieldName) {
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        return parentFormId != null && fieldName != null && !"ide_formdesigner".equals(parentFormId) && !"sbs_apphome".equals(parentFormId);
    }
}

