/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.common.colsAssist.SelectParams;
import kd.mpscmm.msbd.reserve.common.util.ColsTreeUtil;
import kd.mpscmm.msbd.reserve.common.util.FormUtil;
import kd.mpscmm.msbd.reserve.form.ReserveStrategyEditPlugin;
import org.apache.commons.lang3.StringUtils;

public class ReserveSchemeEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener {
    private static final Log logger = LogFactory.getLog(ReserveStrategyEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"sort_field"});
        FormUtil.addF7Listener((AbstractFormPlugin)this, this, "strategy");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("req_reserve_filter");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        BasedataEdit control = (BasedataEdit)this.getControl("require_bill");
        control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.afterBindData(e);
        this.updateRequestFilterCols(false);
        this.initRequestFilters();
        this.initStrategyDesc();
        this.initReserveAggregate();
    }

    private void initReserveAggregate() {
        Map<String, Object> aggregateConfig = ReserveAggregateHelper.getAggregateConfig();
        Boolean isAggregate = (Boolean)aggregateConfig.get("isAggregate");
        if (isAggregate.booleanValue()) {
            this.getView().setEnable(isAggregate, new String[]{"aggregate"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCreateOrg();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.initCreateOrg();
        this.initStrategyDesc();
    }

    public void afterLoadData(EventObject e) {
        this.translateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateInfo() {
        IDataModel model = this.getModel();
        try {
            OrmLocaleValue remark;
            String localeValue;
            Object remarkObj = this.getModel().getValue("remark");
            if (Objects.nonNull(remarkObj) && remarkObj instanceof OrmLocaleValue && StringUtils.isBlank((CharSequence)(localeValue = (remark = (OrmLocaleValue)remarkObj).getLocaleValue()))) {
                String gLang = remark.get((Object)"GLang");
                this.getModel().setValue("remark", (Object)gLang);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            model.setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int index = valueSet[0].getRowIndex();
        if (logger.isDebugEnabled()) {
            logger.debug("ReserveStrategyEditPlugin.propertyChanged" + key);
        }
        switch (key) {
            case "require_bill": {
                this.updateRequestFilterCols(true);
                this.getModel().deleteEntryData("strategy_entry");
                this.getModel().batchCreateNewEntryRow("strategy_entry", 1);
                this.getModel().deleteEntryData("sort_entry");
                break;
            }
            case "strategy_seq": {
                this.StrategySeqValidate(newValue, index);
                break;
            }
            case "strategy": {
                this.setStrategyDesc(newValue, index);
                break;
            }
        }
    }

    private void setStrategyDesc(Object newValue, int index) {
        IDataModel model = this.getModel();
        if (newValue != null) {
            DynamicObject strategy = (DynamicObject)newValue;
            model.setValue("strategy_desc", strategy.get("desc"), index);
        } else {
            model.setValue("strategy_desc", (Object)"", index);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.beforeSave();
                break;
            }
            case "applyorg": {
                this.showFormByOrg(this.getModel().getValue("id"));
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        IDataEntityProperty p = e.getProperty();
        switch (key = p.getName()) {
            case "strategy": {
                this.beforeSelectStrategy(e);
                break;
            }
            case "require_bill": {
                this.beforeSelectRequestBill(e);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "sort_field": {
                this.clickSortFieldCol(evt, key);
                break;
            }
        }
    }

    private void clickSortFieldCol(EventObject evt, String key) {
        IDataModel model = this.getModel();
        DynamicObject requireBill = (DynamicObject)model.getValue("require_bill");
        if (requireBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u9700\u6c42\u5355\u636e\u201d\u3002", (String)"ReserveSchemeEditPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            return;
        }
        this.showColsTreePage(requireBill.getPkValue().toString(), key);
    }

    private void showColsTreePage(String entityNumber, String key) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludeEntryEntityAsKeyPrefix(true);
        TreeNode node = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        HashSet<String> fieldSet = new HashSet<String>(8);
        this.removeTreeNode(node, fieldSet);
        SelectParams params = new SelectParams();
        params.setJsonTree(SerializationUtils.toJsonString((Object)node));
        FormShowParameter fp = FormUtil.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(fp);
    }

    private void removeTreeNode(TreeNode node, Set<String> field) {
        List children = node.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            if ("billhead".equals(child.getId())) continue;
            iterator.remove();
        }
    }

    private void beforeSelectRequestBill(BeforeF7SelectEvent e) {
        Map fieldMap = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (String)"sourcebill", (QFilter[])new QFilter("targetobj", "=", (Object)"msmod_std_request_bill").toArray());
        Set srcIds = fieldMap.values().stream().map(v -> v.get("sourcebill_id")).collect(Collectors.toSet());
        srcIds.add("msmod_std_request_bill");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", srcIds));
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent e) {
        String fieldName = e.getFieldName();
        if (fieldName.contains("delivery_way")) {
            this.handleDeliveryWayF7Select(e);
        }
    }

    private void handleDeliveryWayF7Select(BeforeFilterF7SelectEvent e) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        QFilter filter = new QFilter("group.number", "=", (Object)"deliverytype");
        filterList.add(filter);
        e.setQfilters(filterList);
    }

    private void initCreateOrg() {
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("create_org", (Object)orgId);
    }

    private void initStrategyDesc() {
        IDataModel model = this.getModel();
        DynamicObjectCollection strategyEntrys = model.getDataEntity().getDynamicObjectCollection("strategy_entry");
        for (DynamicObject entry : strategyEntrys) {
            DynamicObject strategy = entry.getDynamicObject("strategy");
            if (strategy == null) continue;
            Object descObj = strategy.get("desc");
            String desc = "";
            if (descObj instanceof String) {
                desc = (String)descObj;
            } else if (descObj instanceof OrmLocaleValue) {
                desc = ((OrmLocaleValue)descObj).getLocaleValue();
            }
            entry.set("strategy_desc", (Object)desc);
            this.getModel().setDataChanged(false);
        }
    }

    private void StrategySeqValidate(Object newValue, int index) {
        if (newValue == null) {
            return;
        }
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("strategy_entry");
        for (int i = 0; i < entryRowCount; ++i) {
            Integer strategySeq;
            if (i == index || (strategySeq = (Integer)model.getValue("strategy_seq", i)) == null || !newValue.equals(strategySeq)) continue;
            model.beginInit();
            model.setValue("strategy_seq", null, index);
            this.getView().updateView("strategy_seq", index);
            model.endInit();
            String msg = ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u4f18\u5148\u7ea7\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ReserveStrategyEditPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            break;
        }
    }

    private void beforeSelectStrategy(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject requireBill = (DynamicObject)model.getValue("require_bill");
        if (requireBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u9700\u6c42\u5355\u636e\u201d\u3002", (String)"ReserveSchemeEditPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Object pk = requireBill.getPkValue();
        QFilter fs = new QFilter("require_bill", "=", pk);
        int rowCount = model.getEntryRowCount("strategy_entry");
        if (rowCount > 1) {
            HashSet<Object> strategyIds = new HashSet<Object>(rowCount - 1);
            int row = this.getModel().getEntryCurrentRowIndex("strategy_entry");
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject strategy = (DynamicObject)model.getValue("strategy", i);
                if (i == row || strategy == null) continue;
                strategyIds.add(strategy.getPkValue());
            }
            if (!strategyIds.isEmpty()) {
                fs = fs.and(new QFilter("id", "not in", strategyIds));
            }
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(fs);
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        String requestFilter = this.getRequestFilterStr();
        model.setValue("req_filter_value", (Object)requestFilter);
    }

    private void initRequestFilters() {
        String reserveFsStr = this.getModel().getDataEntity().getString("req_filter_value");
        FilterCondition condition = StringUtils.isBlank((CharSequence)reserveFsStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)reserveFsStr, FilterCondition.class);
        this.setFilterGrid("req_reserve_filter", condition);
    }

    protected void setFilterGrid(String gridKey, FilterCondition condition) {
        FilterGrid reserveFilter = (FilterGrid)this.getControl(gridKey);
        reserveFilter.SetValue(condition);
    }

    private void updateRequestFilterCols(boolean changed) {
        MainEntityType entityType = this.getRequireBillMainEntityType();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("req_reserve_filter");
        if (entityType == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(Collections.EMPTY_LIST);
        } else {
            if (changed) {
                filterGrid.SetValue(new FilterCondition());
            }
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView("req_reserve_filter");
    }

    private MainEntityType getRequireBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject requireBill = model.getDataEntity().getDynamicObject("require_bill");
        if (requireBill == null) {
            return null;
        }
        String metaDataNo = requireBill.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
        return mainEntityType;
    }

    private String getRequestFilterStr() {
        return this.getFilterGridCondition("req_reserve_filter");
    }

    private String getFilterGridCondition(String filterName) {
        FilterGrid grid = (FilterGrid)this.getControl(filterName);
        if (grid == null) {
            return null;
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }

    public void showFormByOrg(Object schemeId) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean fromDatabase = dataEntity.getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u9884\u7559\u65b9\u6848\u3002", (String)"ReserveSchemeEditPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("reserveschemeid", schemeId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msmod_scheme_org");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "sort_field": {
                this.callBack4SortFieldCol(e);
                break;
            }
        }
    }

    private void callBack4SortFieldCol(ClosedCallBackEvent e) {
        JSONArray data = ColsTreeUtil.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        this.handleValues(data, "sort_field", "sort_field_no", "sort_entry");
    }

    private void handleValues(JSONArray data, String col, String colNo, String entryField) {
        IDataModel model = this.getModel();
        Set<String> existSortCols = this.getExistCols(col, entryField);
        for (int i = 0; i < data.size(); ++i) {
            JSONObject info = data.getJSONObject(i);
            if (existSortCols.contains(info.getString("id"))) continue;
            int index = i == 0 ? this.getModel().getEntryCurrentRowIndex(entryField) : model.createNewEntryRow(entryField);
            String text = info.getString("text");
            if ("require_bill_col".equals(col)) {
                text = String.format(ResManager.loadKDString((String)"\u5355\u636e.%1$s", (String)"ReserveStrategyEditPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), text);
            }
            model.setValue(col, (Object)text, index);
            model.setValue(colNo, (Object)info.getString("id"), index);
        }
    }

    private Set<String> getExistCols(String colNo, String entryField) {
        HashSet<String> sortCols = new HashSet<String>();
        DynamicObjectCollection sortList = this.getModel().getEntryEntity(entryField);
        for (DynamicObject row : sortList) {
            sortCols.add(row.getString(colNo));
        }
        return sortCols;
    }
}

