/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;

public class ReserveSchemeSelectPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok"});
    }

    public void afterCreateNewData(EventObject e) {
        Long billId;
        String billName = (String)this.getView().getFormShowParameter().getCustomParam("billName");
        List<ComboItem> entryItems = ColsMapHelper.getEffectiveSchemeItem(billName, billId = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("billId").toString()));
        if (entryItems.size() > 0) {
            ComboEdit combo = (ComboEdit)this.getControl("schemelist");
            combo.setComboItems(entryItems);
            this.getModel().setValue("schemelist", (Object)entryItems.get(0).getValue());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btn_ok")) {
            Object schemeId = this.getModel().getValue("schemelist");
            if (ObjectUtils.isEmpty((Object)schemeId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u9884\u7559\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u505a\u9884\u7559\u64cd\u4f5c\u3002", (String)"ReserveSchemeSelectPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(schemeId.toString()));
            DynamicObject selectScheme = QueryServiceHelper.queryOne((String)"msmod_reserve_scheme", (String)"aggregate", (QFilter[])qFilter.toArray());
            boolean isAggregate = selectScheme.getBoolean("aggregate");
            Long billId = Long.valueOf(this.getView().getFormShowParameter().getCustomParam("billId").toString());
            String billName = (String)this.getView().getFormShowParameter().getCustomParam("billName");
            Map<Long, Set<Long>> srcIdsMap = ReserveHelper.getSrcBotpIds(billName, new Long[]{billId});
            HashSet<Long> srcBillIds = new HashSet<Long>(16);
            for (Set<Long> srcIds : srcIdsMap.values()) {
                srcBillIds.addAll(srcIds);
            }
            srcBillIds.add(billId);
            QFilter reF = new QFilter("bill_id", "in", srcBillIds);
            if (isAggregate) {
                reF.and("bal_id", "!=", (Object)0);
                if (QueryServiceHelper.exists((String)"msmod_reserve_record", (QFilter[])reF.toArray())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u5355\u636e\u5df2\u5b58\u5728\u660e\u7ec6\u9884\u7559\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u603b\u91cf\u9884\u7559\uff0c\u8bf7\u66f4\u6362\u9884\u7559\u65b9\u6848\u3002", (String)"ReserveSchemeSelectPlugin_5", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                    return;
                }
            } else {
                reF.and("bal_id", "=", (Object)0);
                if (QueryServiceHelper.exists((String)"msmod_reserve_record", (QFilter[])reF.toArray())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u5355\u636e\u5df2\u5b58\u5728\u603b\u91cf\u9884\u7559\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u518d\u8fdb\u884c\u660e\u7ec6\u9884\u7559\uff0c\u8bf7\u66f4\u6362\u9884\u7559\u65b9\u6848\u3002", (String)"ReserveSchemeSelectPlugin_6", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
                    return;
                }
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>(8);
            returnData.put("schemeId", String.valueOf(schemeId));
            returnData.put("billName", this.getView().getFormShowParameter().getCustomParam("billName"));
            returnData.put("billId", this.getView().getFormShowParameter().getCustomParam("billId"));
            returnData.put("billEntryIds", this.getView().getFormShowParameter().getCustomParam("billEntryIds"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter fp = e.getFormShowParameter();
        DynamicObject requestBill = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf((String)fp.getCustomParam("billId")), (String)fp.getCustomParam("billName").toString());
        if (requestBill == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u5355\u636e\u3002", (String)"ReserveSchemeSelectPlugin_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        long billId = Long.parseLong((String)fp.getCustomParam("billId"));
        String exitReserveRecordMsg = ReserveHelper.checkBOTPExitReserveRecord((String)fp.getCustomParam("billName"), billId);
        if (exitReserveRecordMsg != null) {
            throw new KDBizException(exitReserveRecordMsg);
        }
    }
}

