/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.form;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ReserveStrategyEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
BeforeFilterF7SelectListener,
EntryGridBindDataListener {
    private static final Log logger = LogFactory.getLog(ReserveStrategyEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"pick_inv_rule"});
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("strategy_filter");
        filterGrid.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("rule_entry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        BasedataEdit datas = (BasedataEdit)this.getControl("require_bill");
        if (datas != null) {
            datas.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterBindData(e);
        Boolean isPreset = (Boolean)this.getModel().getValue("ispreset");
        this.getView().setEnable(Boolean.valueOf(isPreset == false), new String[]{"fs_baseinfo", "enable_filter", "advcontoolbarap211", "addrow", "delrow"});
        this.getView().setEnable(Boolean.valueOf(isPreset == false), new String[]{"bar_save"});
        if (isPreset.booleanValue()) {
            DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("rule_entry");
            if (entryEntity == null || entryEntity.isEmpty()) {
                return;
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{"pick_inv_rule"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"rule_seq", "reserve_inv_rule", "rule_way"});
            }
        }
        this.translateInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateInfo() {
        IDataModel model = this.getModel();
        try {
            OrmLocaleValue desc;
            String localeValue;
            Object descObj = this.getModel().getValue("desc");
            if (Objects.nonNull(descObj) && descObj instanceof OrmLocaleValue && StringUtils.isBlank((CharSequence)(localeValue = (desc = (OrmLocaleValue)descObj).getLocaleValue()))) {
                String gLang = desc.get((Object)"GLang");
                this.getModel().setValue("desc", (Object)gLang);
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            model.setDataChanged(false);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        if ("rule_entry".equals(entryName)) {
            RowDataEntity[] rows;
            for (RowDataEntity row : rows = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"rule_result_plugin"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        int index = valueSet[0].getRowIndex();
        if (logger.isDebugEnabled()) {
            logger.debug("ReserveStrategyEditPlugin.propertyChanged" + key);
        }
        switch (key) {
            case "require_bill": {
                this.updateStrategyFilterCols(true);
                this.getModel().deleteEntryData("rule_entry");
                this.getModel().batchCreateNewEntryRow("rule_entry", 1);
                break;
            }
            case "pick_inv_rule": {
                this.updatePickInvRule(newValue, index);
                break;
            }
            case "rule_seq": {
                this.RuleSeqValidate(newValue, index);
                break;
            }
            case "rule_way": {
                this.HandleRuleResultPluginVisible(newValue, index);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent e) {
        String fieldName = e.getFieldName();
        if (fieldName.contains("delivery_way")) {
            this.handleDeliveryWayF7Select(e);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("require_bill".equals(fieldKey)) {
            this.requireBillF7Select(beforeF7SelectEvent);
        }
    }

    private void requireBillF7Select(BeforeF7SelectEvent e) {
        Map fieldMap = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (String)"sourcebill", (QFilter[])new QFilter("targetobj", "=", (Object)"msmod_std_request_bill").toArray());
        Set srcIds = fieldMap.values().stream().map(v -> v.get("sourcebill_id")).collect(Collectors.toSet());
        srcIds.add("msmod_std_request_bill");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", srcIds));
    }

    private void handleDeliveryWayF7Select(BeforeFilterF7SelectEvent e) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        QFilter filter = new QFilter("group.number", "=", (Object)"deliverytype");
        filterList.add(filter);
        e.setQfilters(filterList);
    }

    private void updatePickInvRule(Object newValue, int index) {
        if (newValue == null || newValue.equals("")) {
            this.getModel().setValue("reserve_inv_rule", null, index);
        }
    }

    private void setResultPluginVisible() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int entryRowCount = model.getEntryRowCount("rule_entry");
        for (int i = 0; i < entryRowCount; ++i) {
            String ruleWay = (String)model.getValue("rule_way", i);
            boolean enable = false;
            if (ruleWay != null && ruleWay.equals("4")) {
                enable = true;
            }
            view.setEnable(Boolean.valueOf(enable), i, new String[]{"rule_result_plugin"});
        }
    }

    private void HandleRuleResultPluginVisible(Object newValue, int index) {
        boolean enable = false;
        if (newValue.equals("4")) {
            enable = true;
        } else {
            this.getModel().setValue("rule_result_plugin", (Object)"");
        }
        this.getView().setEnable(Boolean.valueOf(enable), index, new String[]{"rule_result_plugin"});
    }

    private void RuleSeqValidate(Object newValue, int index) {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("rule_entry");
        for (int i = 0; i < entryRowCount; ++i) {
            Integer ruleSeq;
            if (i == index || (ruleSeq = (Integer)model.getValue("rule_seq", i)) == null || newValue == null || ((Integer)newValue).intValue() != ruleSeq.intValue()) continue;
            model.beginInit();
            model.setValue("rule_seq", null, index);
            this.getView().updateView("rule_seq", index);
            model.endInit();
            String msg = ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u4f18\u5148\u7ea7\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"ReserveStrategyEditPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            break;
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "pick_inv_rule": {
                this.showPickInvRuleForm(evt, key);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                this.beforeSave();
                break;
            }
        }
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        String requestFilter = this.getRequestFilterStr();
        model.setValue("filter_value_tag", (Object)requestFilter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateRequestFilterCols();
        this.initRequestFilters();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("rule_entry");
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    private void initRequestFilters() {
        String reserveFsStr = this.getModel().getDataEntity().getString("filter_value_tag");
        FilterCondition condition = StringUtils.isBlank((CharSequence)reserveFsStr) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)reserveFsStr, FilterCondition.class);
        this.setFilterGrid("strategy_filter", condition);
    }

    private void updateRequestFilterCols() {
        MainEntityType entityType = this.getRequireBillMainEntityType();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("strategy_filter");
        if (entityType == null) {
            filterGrid.setFilterColumns(Collections.EMPTY_LIST);
        } else {
            this.setEntryColsFilter(entityType, filterGrid);
        }
        this.getView().updateView("strategy_filter");
    }

    private void setEntryColsFilter(MainEntityType entityType, FilterGrid filterGrid) {
        EntityTypeUtil helper = new EntityTypeUtil();
        List filterColumns = helper.getFilterColumns((IDataEntityType)entityType);
        Map allEntities = entityType.getAllEntities();
        HashSet<String> entryFormIds = new HashSet<String>();
        for (EntityType entitie : allEntities.values()) {
            if (!(entitie instanceof EntryType)) continue;
            entryFormIds.add(entitie.getName());
        }
        ArrayList<Map> cols = new ArrayList<Map>();
        for (Map col : filterColumns) {
            if (!entryFormIds.contains(col.get("entryEntity")) || !this.canAddField(col.get("fieldName").toString())) continue;
            cols.add(col);
        }
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.setFilterColumns(cols);
        filterGrid.setFieldColumns(cols);
    }

    private boolean canAddField(String fieldName) {
        boolean result = false;
        if (!"auxpty".equals(fieldName) && fieldName.indexOf("auxpty.") == -1) {
            result = true;
        }
        return result;
    }

    protected void setFilterGrid(String gridKey, FilterCondition condition) {
        FilterGrid reserveFilter = (FilterGrid)this.getControl(gridKey);
        reserveFilter.SetValue(condition);
    }

    private void showPickInvRuleForm(EventObject evt, String key) {
        DynamicObject requireBill;
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("rule_entry");
        DynamicObject rule = (DynamicObject)model.getValue("reserve_inv_rule", index);
        Long ruleId = null;
        if (rule != null) {
            ruleId = (Long)rule.getPkValue();
        }
        if ((requireBill = model.getDataEntity().getDynamicObject("require_bill")) == null) {
            MainEntityType type = model.getDataEntityType();
            DynamicProperty pro = type.getProperty("require_bill");
            String msg = pro == null ? String.format(ReserveStrategyEditPlugin.getMsgFormNoFiled(), "require_bill") : String.format(ReserveStrategyEditPlugin.getMsgFormChoose(), pro.getDisplayName());
            this.getView().showTipNotification(msg);
            return;
        }
        String requireBillNumber = requireBill.getString("number");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("requirebillNumber", (Object)requireBillNumber);
        jsonObject.put("selectRowIndex", (Object)index);
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId("msmod_reserve_inv_rule");
        parameter.setCustomParam("customParam", (Object)jsonObject);
        parameter.setPkId((Object)ruleId);
        parameter.setCustomParam("selectRowIndex", (Object)index);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "msmod_reserve_inv_rule"));
        this.getView().showForm((FormShowParameter)parameter);
    }

    private static String getMsgFormNoFiled() {
        return ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%1$s\u201d\u4e0d\u5b58\u5728\u3002", (String)"FormUtil_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
    }

    private static String getMsgFormChoose() {
        return ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c%1$s\u201d\u3002", (String)"FormUtil_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        switch (key = e.getActionId()) {
            case "msmod_reserve_inv_rule": {
                this.callBackInvRule(e);
                break;
            }
        }
    }

    private void callBackInvRule(ClosedCallBackEvent e) {
        JSONObject jsonObject = (JSONObject)e.getReturnData();
        if (jsonObject == null) {
            return;
        }
        int index = jsonObject.getIntValue("selectRowIndex");
        String ruleDesc = (String)jsonObject.get((Object)"rule_desc");
        Long ruleId = (Long)jsonObject.get((Object)"rule_id");
        this.getModel().setValue("pick_inv_rule", (Object)ruleDesc, index);
        this.getModel().setValue("reserve_inv_rule", (Object)ruleId, index);
    }

    private void updateStrategyFilterCols(boolean changed) {
        MainEntityType entityType = this.getRequireBillMainEntityType();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("strategy_filter");
        if (entityType == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(Collections.EMPTY_LIST);
        } else {
            if (changed) {
                filterGrid.SetValue(new FilterCondition());
            }
            this.setEntryColsFilter(entityType, filterGrid);
        }
        this.getView().updateView("strategy_filter");
    }

    private MainEntityType getRequireBillMainEntityType() {
        IDataModel model = this.getModel();
        DynamicObject requireBill = model.getDataEntity().getDynamicObject("require_bill");
        if (requireBill == null) {
            return null;
        }
        String metaDataNo = requireBill.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)metaDataNo);
        return mainEntityType;
    }

    private String getRequestFilterStr() {
        return this.getFilterGridCondition("strategy_filter");
    }

    private String getFilterGridCondition(String filterName) {
        FilterGrid grid = (FilterGrid)this.getControl(filterName);
        if (grid == null) {
            return null;
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        return jsonStr;
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"qty"});
        this.setResultPluginVisible();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        ReserveStrategyEditPlugin.setBizChanged(dataEntity);
    }

    private static void setBizChanged(DynamicObject dataEntity) {
        DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
        List collectionProperties = properties.getCollectionProperties(false);
        for (ICollectionProperty collectionPropertie : collectionProperties) {
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(collectionPropertie.getName());
            DataEntityPropertyCollection treeEntryProperties = entryColl.getDynamicObjectType().getProperties();
            IDataEntityProperty property = (IDataEntityProperty)treeEntryProperties.get((Object)"reserve_inv_rule");
            if (property == null) continue;
            for (DynamicObject entry : entryColl) {
                String baseDataIdPropKey;
                IDataEntityProperty baseDataIdProperty;
                if (property instanceof BasedataProp && (baseDataIdProperty = (IDataEntityProperty)treeEntryProperties.get((Object)(baseDataIdPropKey = "reserve_inv_rule_id"))) != null) {
                    entry.getDataEntityState().setBizChanged(baseDataIdProperty.getOrdinal(), false);
                }
                entry.getDataEntityState().setBizChanged(property.getOrdinal(), false);
            }
        }
    }
}

