/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.mservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;
import kd.mpscmm.msbd.reserve.business.ReserveContext;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.datasource.MemoryDataReader;
import kd.mpscmm.msbd.reserve.business.decision.DecisionTreeHelper;
import kd.mpscmm.msbd.reserve.business.decision.Node;
import kd.mpscmm.msbd.reserve.business.decision.NodeResultHelper;
import kd.mpscmm.msbd.reserve.business.decision.SolutionFinder;
import kd.mpscmm.msbd.reserve.business.decision.TreeFactory;
import kd.mpscmm.msbd.reserve.business.decision.evaluator.SolutionFinderFactory;
import kd.mpscmm.msbd.reserve.business.strategy.result.BillReserveResult;

@Deprecated
public class CustomBatchReserveService {
    private static final Log logger = LogFactory.getLog(CustomBatchReserveService.class);
    private static final ThreadLocal<Map> globalContext = new ThreadLocal();
    private static final String BILL_INFO = "bill_info";
    private static final String WAREHOUSE_LIST = "warehouse_list";
    private static final String PROPERTY = "property";

    public CustomBatchReserveService() {
        globalContext.set(new HashMap());
    }

    public List<BillReserveResult> reserveByBills(List<Map<String, Object>> bills) {
        try (TraceSpan batchSpan = Tracer.create((String)"CustomBatchReserveService", (String)"reserveByBills");){
            this.loadAllInvData(bills);
            ArrayList<BillReserveResult> resultList = new ArrayList<BillReserveResult>(bills.size());
            for (Map<String, Object> billInfo : bills) {
                BillReserveResult billResult = this.reserveWithRoute((DynamicObject)billInfo.get(BILL_INFO), (List)billInfo.get(WAREHOUSE_LIST), (String)billInfo.get(PROPERTY));
                MemoryDataReader.writeBackSource(billResult);
                resultList.add(billResult);
            }
            MemoryDataReader.clearData();
            ArrayList<BillReserveResult> arrayList = resultList;
            return arrayList;
        }
    }

    private BillReserveResult reserveWithRoute(DynamicObject stdRequestBill, List<Object> warehouseList, String property) {
        try (TraceSpan batchSpan = Tracer.create((String)"ReserveService", (String)"reserveWithWarehouseList");){
            ReserveContext context = new ReserveContext(stdRequestBill, ReserveAggregateHelper.getAggregateConfig());
            context.setExtensionContext(globalContext.get());
            HashMap<Object, Object> args = new HashMap<Object, Object>(4);
            args.put("request_bill", stdRequestBill);
            args.put(WAREHOUSE_LIST, warehouseList);
            args.put("compare_property", property);
            args.put("context", context);
            TreeFactory treeFactory = DecisionTreeHelper.getTreeFactoryWithScheme(context.getScheme());
            Node root = treeFactory.newTree(args);
            HashMap<Object, Object> solutionFinderArgs = new HashMap<Object, Object>(2);
            solutionFinderArgs.put("scheme", context.getScheme());
            SolutionFinder finder = SolutionFinderFactory.getBestSolutionFinder(solutionFinderArgs);
            Node bestSolutionNode = finder.find(root, args);
            BillReserveResult result = NodeResultHelper.getResult(bestSolutionNode);
            ReserveHelper.validateBillResult(result);
            ReserveHelper.handleBillResult(result, context);
            BillReserveResult billReserveResult = result;
            return billReserveResult;
        }
    }

    private void loadAllInvData(List<Map<String, Object>> bills) {
        HashSet<Object> materialIds = new HashSet<Object>();
        HashSet<String> materialModels = new HashSet<String>();
        for (Map<String, Object> bill : bills) {
            DynamicObject requestBill = (DynamicObject)bill.get(BILL_INFO);
            DynamicObjectCollection entryCol = requestBill.getDynamicObjectCollection("bill_entry");
            for (DynamicObject entry : entryCol) {
                DynamicObject material = entry.getDynamicObject("material");
                if (material != null) {
                    materialIds.add(material.getPkValue());
                    continue;
                }
                materialModels.add(entry.getString("hifi_materialmodel"));
            }
        }
        if (!materialModels.isEmpty()) {
            Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id", (QFilter[])new QFilter("modelnum", "in", materialModels).toArray());
            materialIds.addAll(materials.keySet());
        }
        QFilter filter = new QFilter("material", "in", (Object)materialIds.toArray());
        MemoryDataReader.loadDBData(filter);
    }
}

