/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.mservice.upgrade;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.FieldInfo;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class ReserveRecordUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ReserveRecordUpgradeServiceImpl.class);
    private static final String OLD_RESERVE_RECORD = " SELECT fid, fdemandformid ,fdemandnumber ,fdemandid ,fdemandentryid ,fdemandseq ,freserveoperateid ,fsupplybillid ,freserveqty ,freservebaseqty ,freserveunit2ndqty ,fbillentry ,freserveprctype,freservetime FROM T_SBS_RESERVATION WHERE freserveqty <> 0 OR freservebaseqty <> 0 OR freserveunit2ndqty <> 0";
    private static final String OPERATOR_SQL = " SELECT  fentryid ,foperatorid  FROM t_bd_operatorgroupentry where  foperatorid <> 0 and fopergrptype = 'KCZ' ";
    private static final String UP_INV_REAL_BAL_LOCKQTY = "  update t_im_inv_realbalance_a set flockbaseqty = flockbaseqty + ? ,flockqty = flockqty + ? , flockqty2nd = flockqty2nd + ? where fid = ?";
    private static final String UP_INV_REAL_BAL_AVBQTY_O = " /*dialect*/update (select t.fid ,t.favbbaseqty, t.flockbaseqty, t.favbqty, t.flockqty, t.favbqty2nd,  t.flockqty2nd, t1.fbaseqty, t1.fqty, t1.fqty2nd from t_im_inv_realbalance_a t inner join t_im_inv_realbalance t1 on t1.fid = t.fid) set favbbaseqty = fbaseqty - flockbaseqty, favbqty = fqty - flockqty, favbqty2nd  = fqty2nd - flockqty2nd where fid in ";
    private static final String UP_INV_REAL_BAL_AVBQTY_M = " /*dialect*/update t_im_inv_realbalance_a t join t_im_inv_realbalance t1  on t.fid = t1.fid set t.favbbaseqty = t1.fbaseqty - t.flockbaseqty, t.favbqty = t1.fqty - t.flockqty, t.favbqty2nd = t1.fqty2nd - t.flockqty2nd where  t.fid in ";
    private static final String NEW_RESERVE_RECORD = " INSERT INTO T_MSMOD_RESERVERECORD (fid ,f_bill_obj_id ,f_bill_no ,f_bill_id ,f_billentry_id ,f_bill_souce ,freserveprctype,f_entry_name ,f_billentry_seq ,f_bal_obj_id , f_bal_id , f_base_qty ,f_qty ,f_qty2nd , f_bal_source ,f_creater_id ,f_create_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UP_OLD_RESERVE_RECORD = "  update T_SBS_RESERVATION set freservebaseqty = 0 ,freserveqty =0 , freserveunit2ndqty = 0 where fid in ";
    private static final String BAK_OLD_RESERVE_RECORD = "  SELECT %s INTO T_SBS_RESERVATION_bak%s  FROM T_SBS_RESERVATION ";
    private static final String BAK_NEW_RESERVE_RECORD = "  SELECT %s INTO  T_MSMOD_RESERVERECORD_bak%s   from T_MSMOD_RESERVERECORD ";
    private static final String BAK_INV_REAL_BAL_A = "  SELECT %s INTO  t_im_inv_realbalance_a_bak%s   from t_im_inv_realbalance_a ";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute sysRoute = new DBRoute("sys");
        DBRoute scmRoute = new DBRoute("scm");
        HashMap<Long, Long> operatorMap = new HashMap<Long, Long>(1024);
        this.createBackupTable(scmRoute);
        DataSet operators = DB.queryDataSet((String)ReserveRecordUpgradeServiceImpl.class.getName(), (DBRoute)sysRoute, (String)OPERATOR_SQL);
        while (operators.hasNext()) {
            Row row = operators.next();
            operatorMap.put(row.getLong("fentryid"), row.getLong("foperatorid"));
        }
        DataSet oldReserveRecord = DB.queryDataSet((String)ReserveRecordUpgradeServiceImpl.class.getName(), (DBRoute)scmRoute, (String)OLD_RESERVE_RECORD);
        String balObjId = "im_inv_realbalance";
        ArrayList<Object[]> reserveUpdateList = new ArrayList<Object[]>(1024);
        ArrayList<Object[]> invUpdateList = new ArrayList<Object[]>(1024);
        ArrayList<Long> oldReserveIds = new ArrayList<Long>(1024);
        ArrayList<Long> balIds = new ArrayList<Long>(1024);
        try (TXHandle handle = TX.requiresNew();){
            while (oldReserveRecord.hasNext()) {
                Row row = oldReserveRecord.next();
                Long userId = (Long)operatorMap.get(row.getLong("freserveoperateid"));
                if (userId == null) {
                    userId = 0L;
                }
                oldReserveIds.add(row.getLong("fid"));
                balIds.add(row.getLong("fsupplybillid"));
                invUpdateList.add(new Object[]{row.getBigDecimal("freservebaseqty"), row.getBigDecimal("freserveqty"), row.getBigDecimal("freserveunit2ndqty"), row.getLong("fsupplybillid")});
                reserveUpdateList.add(new Object[]{0L, row.getString("fdemandformid"), row.getString("fdemandnumber"), row.getLong("fdemandid"), row.getLong("fdemandentryid"), "1", row.getString("freserveprctype"), row.getString("fbillentry"), row.getLong("fdemandseq"), balObjId, row.getLong("fsupplybillid"), row.getBigDecimal("freservebaseqty"), row.getBigDecimal("freserveqty"), row.getBigDecimal("freserveunit2ndqty"), "1", userId, row.getDate("freservetime")});
                if (reserveUpdateList.size() < 1000) continue;
                this.updateTable(reserveUpdateList, invUpdateList, oldReserveIds, balIds, scmRoute);
                reserveUpdateList.clear();
                balIds.clear();
                oldReserveIds.clear();
                invUpdateList.clear();
            }
            if (!reserveUpdateList.isEmpty()) {
                this.updateTable(reserveUpdateList, invUpdateList, oldReserveIds, balIds, scmRoute);
            }
        }
        result.setSuccess(true);
        return result;
    }

    private void createBackupTable(DBRoute scmRoute) {
        String format = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String sql = "select fid from  T_SBS_RESERVATION_bak%s where fid = 0";
        try {
            DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)String.format(sql, format));
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            DBType dbType = DB.getDBType((DBRoute)scmRoute);
            switch (dbType.getValue()) {
                case 2: {
                    this.bakOldTableByOracle(scmRoute, format);
                    break;
                }
                case 6: {
                    this.bakOldTableByMySql(scmRoute, format);
                    break;
                }
            }
        }
    }

    private void bakOldTableByOracle(DBRoute scmRoute, String format) {
        DB.execute((DBRoute)scmRoute, (String)this.getBakTableSql(BAK_OLD_RESERVE_RECORD, "T_SBS_RESERVATION", scmRoute, format));
        DB.execute((DBRoute)scmRoute, (String)this.getBakTableSql(BAK_NEW_RESERVE_RECORD, "T_MSMOD_RESERVERECORD", scmRoute, format));
        DB.execute((DBRoute)scmRoute, (String)this.getBakTableSql(BAK_INV_REAL_BAL_A, "t_im_inv_realbalance_a", scmRoute, format));
    }

    private void bakOldTableByMySql(DBRoute scmRoute, String format) {
        String createRecord = " /*dialect*/CREATE TABLE T_SBS_RESERVATION_bak%s  LIKE T_SBS_RESERVATION ";
        String careteNewRecord = " /*dialect*/CREATE TABLE T_MSMOD_RESERVERECORD_bak%s  LIKE T_MSMOD_RESERVERECORD ";
        String createInv = " /*dialect*/CREATE TABLE t_im_inv_realbalance_a_bak%s  LIKE t_im_inv_realbalance_a ";
        String insertRecord = "/*dialect*/insert into T_SBS_RESERVATION_bak%s select %s from T_SBS_RESERVATION";
        String insertNewRecord = "/*dialect*/insert into T_MSMOD_RESERVERECORD_bak%s select %s from T_MSMOD_RESERVERECORD";
        String insertInv = "/*dialect*/insert into t_im_inv_realbalance_a_bak%s select %s from t_im_inv_realbalance_a";
        DB.execute((DBRoute)scmRoute, (String)String.format(createRecord, format));
        DB.execute((DBRoute)scmRoute, (String)String.format(insertRecord, format, this.getSelectField("T_SBS_RESERVATION", scmRoute)));
        DB.execute((DBRoute)scmRoute, (String)String.format(careteNewRecord, format));
        DB.execute((DBRoute)scmRoute, (String)String.format(insertNewRecord, format, this.getSelectField("T_MSMOD_RESERVERECORD", scmRoute)));
        DB.execute((DBRoute)scmRoute, (String)String.format(createInv, format));
        DB.execute((DBRoute)scmRoute, (String)String.format(insertInv, format, this.getSelectField("t_im_inv_realbalance_a", scmRoute)));
    }

    private void updateTable(List<Object[]> reserveUpdateList, List<Object[]> invUpdateList, List<Long> oldReserveIds, List<Long> balIds, DBRoute scmRoute) {
        long[] ids = DB.genLongIds((String)"T_MSMOD_RESERVERECORD", (int)reserveUpdateList.size());
        if (ids.length != reserveUpdateList.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"ids[{%1$s}]\u7684\u5927\u5c0f\u548creserveUpdateList[{%2$s}]\u7684\u5927\u5c0f\u4e0d\u5339\u914d", (String)"ReserveRecordUpgradeServiceImpl_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), ids.length, reserveUpdateList.size()));
        }
        for (int i = 0; i < reserveUpdateList.size(); ++i) {
            reserveUpdateList.get((int)i)[0] = ids[i];
        }
        DB.executeBatch((DBRoute)scmRoute, (String)NEW_RESERVE_RECORD, reserveUpdateList);
        DB.executeBatch((DBRoute)scmRoute, (String)UP_INV_REAL_BAL_LOCKQTY, invUpdateList);
        DBType dbType = DB.getDBType((DBRoute)scmRoute);
        switch (dbType.getValue()) {
            case 2: {
                DB.execute((DBRoute)scmRoute, (String)(UP_INV_REAL_BAL_AVBQTY_O + balIds.toString().replace('[', '(').replace(']', ')')));
                break;
            }
            case 6: {
                DB.execute((DBRoute)scmRoute, (String)(UP_INV_REAL_BAL_AVBQTY_M + balIds.toString().replace('[', '(').replace(']', ')')));
                break;
            }
        }
        DB.execute((DBRoute)scmRoute, (String)(UP_OLD_RESERVE_RECORD + oldReserveIds.toString().replace('[', '(').replace(']', ')')));
    }

    private String getBakTableSql(String sql, String tableName, DBRoute route, String format) {
        StringBuilder sb = this.getSelectField(tableName, route);
        return String.format(sql, sb.toString(), format);
    }

    private StringBuilder getSelectField(String tableName, DBRoute route) {
        List fieldInfo = DB.getFieldInfo((DBRoute)route, (String)tableName);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldInfo.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(((FieldInfo)fieldInfo.get(i)).getFieldName());
        }
        return sb;
    }
}

