/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.op;

import java.util.ArrayList;
import java.util.List;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReleaseHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;

public class ReserveRemoveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ReserveRemoveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("base_qty");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("qty2nd");
        e.getFieldKeys().add("bal_id");
        e.getFieldKeys().add("bal_obj");
        e.getFieldKeys().add("bal_id");
        e.getFieldKeys().add("reserve_scheme");
        e.getFieldKeys().add("ispredict");
        e.getFieldKeys().add("aggregateid");
        List<String> aggregateField = ReserveAggregateHelper.getAggregateField();
        for (String field : aggregateField) {
            e.getFieldKeys().add("s_" + field);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataList = e.getDataEntities();
        logger.info("\u89e3\u9664\u9884\u7559\uff0c\u672c\u6b21\u89e3\u9664\u7684\u8bb0\u5f55\u6570\u91cf\u4e3a\uff1a" + dataList.length);
        ArrayList<Object> ids = new ArrayList<Object>(dataList.length);
        for (DynamicObject data : dataList) {
            ids.add(data.getPkValue());
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] col = BusinessDataServiceHelper.load((String)"msmod_reserve_record", (String)"id,base_qty,qty,qty2nd,expiredate,ispredict,bal_obj,reserve_scheme,bal_id,aggregateid,bill_obj,bill_id,bill_no,billentry_id,billentry_seq", (QFilter[])qFilter.toArray());
        if (col == null || col.length < 1) {
            return;
        }
        ArrayList<DynamicObject> recordList = new ArrayList<DynamicObject>(dataList.length);
        for (DynamicObject reserveRecord : col) {
            reserveRecord.set("bal_obj", (Object)reserveRecord.getDynamicObject("bal_obj").getString("number"));
            if (reserveRecord.getDynamicObject("reserve_scheme") != null) {
                reserveRecord.set("reserve_scheme", reserveRecord.getDynamicObject("reserve_scheme").getPkValue());
            }
            recordList.add(reserveRecord);
        }
        ThreadCache.put((Object)"ReserveOpName", (Object)"remove");
        ThreadCache.put((Object)"ReserveOpType", (Object)"remove");
        ReleaseHelper.removeReserveByReserveRecord(recordList);
    }
}

