/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.op;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.reserve.business.helper.ReserveServiceCfgHelper;

public class ReserveServiceDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("group");
        e.getFieldKeys().add("billobject");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("operation");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashMap<String, Set<String>> serviceMap = new HashMap<String, Set<String>>(dataEntities.length);
        HashMap<String, List<Long>> serviceNameAndIdMap = new HashMap<String, List<Long>>(8);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject serviceGroup = dataEntity.getDynamicObject("group");
            String serviceNumber = serviceGroup.getString("number");
            DynamicObject dynamicObject = dataEntity.getDynamicObject("billobject");
            String billNo = dynamicObject.getString("number");
            Set billSet = serviceMap.computeIfAbsent(serviceNumber, key -> new HashSet());
            billSet.add(billNo);
            Long serviceId = dataEntity.getLong("id");
            String key2 = serviceNumber + billNo;
            ArrayList<Long> idList = (ArrayList<Long>)serviceNameAndIdMap.get(key2);
            if (idList == null) {
                idList = new ArrayList<Long>(8);
            }
            idList.add(serviceId);
            serviceNameAndIdMap.put(key2, idList);
        }
        this.updateBosBizRule(serviceMap, serviceNameAndIdMap);
    }

    private void updateBosBizRule(Map<String, Set<String>> serviceMap, Map<String, List<Long>> serviceNameAndIdMap) {
        for (Map.Entry<String, Set<String>> stringSetEntry : serviceMap.entrySet()) {
            String serviceNumber = stringSetEntry.getKey();
            Set<String> billNoSet = stringSetEntry.getValue();
            for (String billNo : billNoSet) {
                List<Long> serviceIdList = serviceNameAndIdMap.get(serviceNumber + billNo);
                HashSet<String> opValSet = new HashSet<String>(8);
                QFilter qFilter = new QFilter("number", "=", (Object)serviceNumber);
                DynamicObject serviceGroup = QueryServiceHelper.queryOne((String)"msmod_reservesergroup", (String)"id", (QFilter[])qFilter.toArray());
                QFilter fs = new QFilter("group", "=", (Object)serviceGroup.getLong("id")).and(new QFilter("billobject", "=", (Object)billNo)).and("enable", "=", (Object)"1");
                DynamicObjectCollection serviceCol = QueryServiceHelper.query((String)"msmod_reserve_service_cfg", (String)"id,billoperation", (QFilter[])fs.toArray());
                if (serviceCol.size() == serviceIdList.size()) {
                    QFilter delFilter = new QFilter("opbizrule", "=", (Object)serviceNumber).and("objecttype", "=", (Object)billNo);
                    DeleteServiceHelper.delete((String)"bos_opbizruleset", (QFilter[])delFilter.toArray());
                    continue;
                }
                for (DynamicObject serviceCfg : serviceCol) {
                    String[] opArray;
                    if (serviceIdList.contains(serviceCfg.getLong("id"))) continue;
                    for (String op : opArray = serviceCfg.getString("billoperation").split(",")) {
                        if (!StringUtils.isNotEmpty((String)op)) continue;
                        opValSet.add(op);
                    }
                }
                ReserveServiceCfgHelper.updateOpBizInfo(serviceIdList, serviceNumber, billNo, opValSet);
            }
        }
    }
}

