/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.reserve.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.ReserveAggregateHelper;

public class ReserveSchemeValidator
extends AbstractValidator {
    private final List<String> compareList = new ArrayList<String>(Arrays.asList("=", "A", "F"));

    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            this.checkStrategy(entity);
            this.checkSchemeDetail(entity);
        }
    }

    private void checkSchemeDetail(ExtendedDataEntity entity) {
        Map<String, Object> aggregateCfg = ReserveAggregateHelper.getAggregateConfig();
        boolean isAggregate = (Boolean)aggregateCfg.get("isAggregate");
        List aggregateField = (List)aggregateCfg.get("aggregateField");
        boolean compatibleDetail = (Boolean)aggregateCfg.get("compatibleDetail");
        boolean aggregate = (Boolean)entity.getDataEntity().get("aggregate");
        if (isAggregate && compatibleDetail && !aggregate) {
            Map<Object, DynamicObject> reserveRule = this.getAllRuleMap(entity);
            for (Map.Entry<Object, DynamicObject> entry : reserveRule.entrySet()) {
                DynamicObject rule = entry.getValue();
                if (rule.getBoolean("ispredict")) continue;
                DynamicObjectCollection ruleEntryList = rule.getDynamicObjectCollection("rule_entry");
                for (String field : aggregateField) {
                    boolean isFind = false;
                    for (DynamicObject ruleRow : ruleEntryList) {
                        if (!this.compareList.contains(ruleRow.getString("compare_type")) || !field.equals(ruleRow.getString("std_inv_col_no"))) continue;
                        isFind = true;
                        break;
                    }
                    if (isFind) continue;
                    String msg = ResManager.loadKDString((String)"\u542f\u7528\u603b\u91cf\u9884\u7559\uff0c\u660e\u7ec6\u9884\u7559\u65b9\u6848.\u9884\u7559\u7b56\u7565.\u975e\u9884\u8ba1\u5165\u9884\u7559\u89c4\u5219\u9700\u8981\u914d\u7f6e\u6240\u6709\u603b\u91cf\u9884\u7559\u7ef4\u5ea6\u7684\u4f9b\u9700\u5339\u914d\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u9884\u7559\u7b56\u7565.\u9884\u7559\u89c4\u5219\u3002", (String)"ReserveSchemeValidator_4", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]);
                    this.addMessage(entity, msg, ErrorLevel.Error);
                    return;
                }
            }
        }
    }

    private Map<Object, DynamicObject> getAllRuleMap(ExtendedDataEntity entity) {
        DynamicObjectCollection dynamicObjectCollection = entity.getDataEntity().getDynamicObjectCollection("strategy_entry");
        ArrayList<Long> ruleIdList = new ArrayList<Long>(16);
        for (DynamicObject entry : dynamicObjectCollection) {
            DynamicObject object = entry.getDynamicObject("strategy");
            if (object == null) continue;
            DynamicObjectCollection rule_entry = object.getDynamicObjectCollection("rule_entry");
            for (DynamicObject ruleEntry : rule_entry) {
                DynamicObject ruleEntryDynamicObject = ruleEntry.getDynamicObject("reserve_inv_rule");
                Long pkValue = (Long)ruleEntryDynamicObject.getPkValue();
                ruleIdList.add(pkValue);
            }
        }
        QFilter qFilter = new QFilter("id", "in", ruleIdList);
        return BusinessDataServiceHelper.loadFromCache((String)"msmod_reserve_inv_rule", (QFilter[])qFilter.toArray());
    }

    private void checkStrategy(ExtendedDataEntity entity) {
        DynamicObject billObj = entity.getDataEntity();
        boolean isAuto = billObj.getBoolean("autoreserve");
        DynamicObjectCollection strategyEntryList = billObj.getDynamicObjectCollection("strategy_entry");
        if (!isAuto && strategyEntryList.size() > 1) {
            this.addMessage(entity, ResManager.loadKDString((String)"\u624b\u5de5\u9884\u7559\u65b9\u6848\u53ea\u5141\u8bb8\u7ef4\u62a4\u4e00\u6761\u9884\u7559\u7b56\u7565\u3002", (String)"ReserveSchemeValidator_3", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

