/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.mservice.common.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscommon.mservice.common.upgrade.ReserveRecordUpgradeNewServiceImpl;

public class ReserveServiceUpgradeServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ReserveRecordUpgradeNewServiceImpl.class);
    private final DBRoute metaRoute = new DBRoute("sys.meta");
    private final DBRoute scmRoute = new DBRoute("scm");
    private static final Map<String, Long> reserveServiceGroup = new HashMap<String, Long>(16);
    private static final String[] RESERVE_SERVICE = new String[]{"MpsAutoReserve", "ReleaseReserved", "MpsUnAutoReserve", "UnReleaseReserved", "ReserveReplace"};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        if (this.checkUpgrade()) {
            result.setSuccess(true);
            result.setLog("no need to update");
            return result;
        }
        this.getReserveService();
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private void getReserveService() {
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("select fid as id, fopbizrule as opbizrule , fobjecttypeid as objecttype from t_meta_opbizruleset where ", new Object[0]).appendIn("fopbizrule", (Object[])RESERVE_SERVICE);
        logger.info("ReserveServiceUpgradeServiceImpl:\u5f00\u59cb\u67e5\u8be2\u542f\u7528\u64cd\u4f5c\u670d\u52a1\u9884\u7559\u76f8\u5173\u670d\u52a1\u914d\u7f6e\u3002");
        DataSet opBizDatas = DB.queryDataSet((String)ReserveServiceUpgradeServiceImpl.class.getName(), (DBRoute)this.metaRoute, (SqlBuilder)sqlBuilder1);
        logger.info("ReserveServiceUpgradeServiceImpl:\u7ed3\u675f\u67e5\u8be2\u542f\u7528\u64cd\u4f5c\u670d\u52a1\u9884\u7559\u76f8\u5173\u670d\u52a1\u914d\u7f6e\u3002");
        this.insertReserveService(opBizDatas);
    }

    private void insertReserveService(DataSet opBizData) {
        DataSet opBizDataCopy = opBizData.copy();
        ArrayList<Object> opIdList = new ArrayList<Object>(16);
        int count = opBizData.copy().count("id", true);
        long[] reServiceId = DB.genGlobalLongIds((int)count);
        long[] entryIds = DB.genGlobalLongIds((int)1000);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(32);
        ArrayList<Object[]> paramEntryList = new ArrayList<Object[]>(32);
        HashMap<Object, Long> map = new HashMap<Object, Long>(32);
        int i = 0;
        int x = 0;
        while (opBizDataCopy.hasNext()) {
            Row row = opBizDataCopy.next();
            Object id = row.get("id");
            opIdList.add(id);
        }
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("select fid as id,foperationkey as operationkey,fseq as seq from t_meta_opbizrulesetentry where ", new Object[0]).appendIn("fid", opIdList.toArray());
        logger.info("ReserveServiceUpgradeServiceImpl:\u5f00\u59cb\u67e5\u8be2\u542f\u7528\u64cd\u4f5c\u670d\u52a1\u5206\u5f55\u64cd\u4f5c\u3002");
        DataSet opBizEntryDatas = DB.queryDataSet((String)ReserveServiceUpgradeServiceImpl.class.getName(), (DBRoute)this.metaRoute, (SqlBuilder)sqlBuilder1);
        logger.info("ReserveServiceUpgradeServiceImpl:\u7ed3\u675f\u67e5\u8be2\u542f\u7528\u64cd\u4f5c\u670d\u52a1\u5206\u5f55\u64cd\u4f5c\u3002");
        HashMap<Object, List> idToOpKeyMapping = new HashMap<Object, List>(32);
        logger.info("ReserveServiceUpgradeServiceImpl:\u8bbe\u7f6e\u9884\u7559\u670d\u52a1\u914d\u7f6e\u5206\u5f55\u53c2\u6570\u3002");
        while (opBizEntryDatas.hasNext()) {
            Row row = opBizEntryDatas.next();
            Object id = row.get("id");
            Object seq = row.get("seq");
            if (StringUtils.isEmpty((String)row.getString("operationkey"))) continue;
            String operationkey = (String)row.get("operationkey");
            List opKeyList = idToOpKeyMapping.computeIfAbsent(id, k -> new ArrayList(16));
            opKeyList.add(operationkey);
            if (!map.containsKey(id)) {
                map.put(id, reServiceId[i]);
                ++i;
            }
            paramEntryList.add(new Object[]{map.get(id), entryIds[x], seq, operationkey});
            ++x;
        }
        logger.info("ReserveServiceUpgradeServiceImpl:\u8bbe\u7f6e\u9884\u7559\u670d\u52a1\u914d\u7f6e\u5355\u5934\u53c2\u6570\u3002");
        try {
            while (opBizData.hasNext()) {
                StringBuilder billOption = new StringBuilder();
                Row row = opBizData.next();
                if (row.get("opbizrule") == null || "".equals(row.getString("opbizrule"))) continue;
                String opBizRule = (String)row.get("opbizrule");
                if (row.get("objecttype") == null || "".equals(row.getString("objecttype"))) continue;
                String objectType = row.getString("objecttype");
                Object id = row.get("id");
                List opKey = (List)idToOpKeyMapping.get(id);
                billOption.append(",");
                if (opKey == null) continue;
                for (Object opString : opKey) {
                    billOption.append(opString).append(",");
                }
                paramList.add(new Object[]{map.get(id), reserveServiceGroup.get(opBizRule), objectType, billOption.toString(), "C", "1"});
            }
            StringBuilder sqlBuilder2 = new StringBuilder();
            sqlBuilder2.append("insert into t_msmod_reserveservice (fid , fgroupid , fbillobject ,fbilloperation,fstatus,fenable) values(?,?,?,?,?,?)");
            StringBuilder sqlBuilder3 = new StringBuilder();
            sqlBuilder3.append("insert into t_msmod_resservicentry (fid , fentryid ,fseq, foperation) values(?,?,?,?)");
            logger.info("ReserveServiceUpgradeServiceImpl:\u6267\u884c\u63d2\u5165\u64cd\u4f5c\u5f00\u59cb\u3002");
            try (TXHandle handle = TX.requiresNew();){
                try {
                    logger.info("ReserveServiceUpgradeServiceImpl:\u6267\u884c\u63d2\u5165\u5355\u5934Sql\uff1a\u3010insert into t_msmod_reserveservice (insert into t_msmod_reserveservice (fid , fgroupid , fbillobject ,fbilloperation , fstatus , fenable) values(?,?,?,?,?,?)\u3011\uff1b\u66f4\u65b0\u53c2\u6570\u662f\uff1a\u3010" + ((Object)paramList).toString() + "\u3011\u3002");
                    DB.executeBatch((DBRoute)this.scmRoute, (String)sqlBuilder2.toString(), paramList);
                    logger.info("ReserveServiceUpgradeServiceImpl:\u6267\u884c\u63d2\u5165\u5206\u5f55SQL\u8bed\u53e5\u4e3a\uff1a\u3010insert into t_msmod_resservicentry (fid , fentryid ,fseq, foperation) values(?,?,?,?)\u3011\uff1b\u66f4\u65b0\u53c2\u6570\u662f\uff1a\u3010" + ((Object)paramEntryList).toString() + "\u3011\u3002");
                    DB.executeBatch((DBRoute)this.scmRoute, (String)sqlBuilder3.toString(), paramEntryList);
                    logger.info("ReserveServiceUpgradeServiceImpl:\u6267\u884c\u66f4\u65b0\u6210\u529f\u3002");
                    DB.execute((DBRoute)new DBRoute("scm"), (String)"update t_msmod_dbparam set fvalue = '1' where fkey = ?", (Object[])new Object[]{"BillTypeParam"});
                }
                catch (Throwable e) {
                    handle.markRollback();
                    throw e;
                }
            }
        }
        catch (Exception e) {
            logger.error("ReserveServiceUpgradeServiceImpl error : ", (Throwable)e);
        }
    }

    private boolean checkUpgrade() {
        String switchSql = "select fvalue as value from t_msmod_dbparam where fkey = ?";
        boolean flag = false;
        try (DataSet switchSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)new DBRoute("scm"), (String)switchSql, (Object[])new Object[]{"BillTypeParam"});){
            for (Row row : switchSet) {
                String value = row.getString("value");
                if (!"1".equals(value)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    static {
        reserveServiceGroup.put("MpsAutoReserve", 1402037881861730304L);
        reserveServiceGroup.put("ReleaseReserved", 1402139420131331072L);
        reserveServiceGroup.put("MpsUnAutoReserve", 1402139266611416064L);
        reserveServiceGroup.put("UnReleaseReserved", 1402139574834039808L);
        reserveServiceGroup.put("ReserveReplace", 1402856110217534464L);
    }
}

