/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.reserve.form.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.LinkEntityPolicy;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.reserve.business.ConvRateContext;
import kd.mpscmm.msbd.reserve.business.ReserveHelper;
import kd.mpscmm.msbd.reserve.business.datasource.ColsMap;
import kd.mpscmm.msbd.reserve.business.helper.ColsMapHelper;
import kd.mpscmm.msbd.reserve.business.record.RecordSpiltModel;
import kd.mpscmm.mscommon.reserve.form.botp.ReserveSpiltBotpPlugin;
import org.apache.commons.lang3.StringUtils;

public class ReserveSplitBotpRecordIdPlugin
extends AbstractConvertPlugIn {
    private static final Log log = LogFactory.getLog(ReserveSpiltBotpPlugin.class);
    private static final String algoKey = ReserveSpiltBotpPlugin.class.getName();
    private static final String SRC_ENTRY_ID_KEY = "f2";
    private static final String ENTRY_KEY = "entryKey";
    private ConvRateContext convRate = new ConvRateContext();

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().getName();
        String srcMainType = this.getSrcMainType().getName();
        ColsMap releaseBillCols = ColsMapHelper.findBillColMaps(tgtMainType, "msmod_releasebill");
        Map<String, String> billColMap = releaseBillCols.getBalColMap();
        LinkEntityPolicy entityPolicy = this.getRule().getLinkEntityPolicy();
        String srcEntryKey = entityPolicy.getSourceEntryKey();
        String entryKey = entityPolicy.getTargetEntryKey();
        String f2 = ((DynamicProperty)e.getFldProperties().get(srcEntryKey + ".id")).getName();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(entryKey);
        ArrayList<Long> entryIds = new ArrayList<Long>(16);
        HashSet<Long> ids = new HashSet<Long>(16);
        for (ExtendedDataEntity entity : entitys) {
            List srcRows = (List)entity.getValue("ConvertSource");
            for (DynamicObject row : srcRows) {
                ids.add(row.getLong("id"));
                entryIds.add(row.getLong(f2));
            }
        }
        Long[] pkIds = ids.toArray(new Long[ids.size()]);
        Set<Object> srcIds = ReserveHelper.getBotpLinkBillIds(srcMainType, pkIds);
        Map<Object, List<Object>> srcEntryIdMap = this.getSrcEntryIdMap(srcMainType, srcEntryKey, entryIds);
        QFilter recordFilter = new QFilter("bill_id", "in", srcIds);
        recordFilter.and(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
        recordFilter.and(new QFilter("ispredict", "=", (Object)false));
        recordFilter.and("bal_id", "!=", (Object)0L);
        StringBuilder selectCols = new StringBuilder();
        selectCols.append("billentry_id,base_qty-splitbaseqty as base_qty,qty-splitqty as qty,qty2nd-split2ndqty as qty2nd,bal_obj,bal_id,aggregateid,id as reserveid");
        DataSet recordDatas = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + ":afterConvert"), (String)"msmod_reserve_record", (String)selectCols.toString(), (QFilter[])recordFilter.toArray(), null);
        ColsMap releaseCols = ColsMapHelper.findBillColMaps("msmod_releasebill", "msmod_std_inv_field");
        Map<String, String> relBalColMaps = releaseCols.getBalColMap();
        HashMap<String, String> relBalColMapHash = new HashMap<String, String>(relBalColMaps.size());
        relBalColMapHash.putAll(relBalColMaps);
        relBalColMapHash.remove("billentry");
        DataSet supDataSet = this.getSupDataSet(recordDatas, relBalColMapHash);
        if (supDataSet == null) {
            log.info("\u4f9b\u5e94\u65b9\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a...");
            return;
        }
        recordDatas = recordDatas.join(supDataSet.copy(), JoinType.INNER).on("bal_obj", "source_bal_obj").on("bal_id", "id").select(recordDatas.getRowMeta().getFieldNames(), supDataSet.getRowMeta().getFieldNames()).finish();
        Map<Long, List<RecordSpiltModel>> spiltModels = this.getSpiltModels(recordDatas, relBalColMapHash);
        Map<String, String> subRelColsMap = this.getSubColsMap(relBalColMapHash);
        Map<String, String> subBillColsMap = this.getSubColsMap(billColMap);
        HashMap<String, String> keyMap = new HashMap<String, String>(16);
        keyMap.put(ENTRY_KEY, entryKey);
        keyMap.put(SRC_ENTRY_ID_KEY, f2);
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        params.put("subRelCols", subRelColsMap);
        params.put("subBillCols", subBillColsMap);
        params.put("keyMap", keyMap);
        for (ExtendedDataEntity entity : entitys) {
            this.entrySlipt(entity, srcEntryIdMap, spiltModels, params);
        }
    }

    private void entrySlipt(ExtendedDataEntity entity, Map<Object, List<Object>> srcEntryIdMap, Map<Long, List<RecordSpiltModel>> spiltModels, Map<String, Map<String, String>> paramsMap) {
        Map<String, String> balColMap = paramsMap.get("subRelCols");
        Map<String, String> billColMap = paramsMap.get("subBillCols");
        Map<String, String> keyMap = paramsMap.get("keyMap");
        String entryKey = keyMap.get(ENTRY_KEY);
        String f2 = keyMap.get(SRC_ENTRY_ID_KEY);
        DynamicObject entry = entity.getDataEntity();
        DynamicObject parent = (DynamicObject)entry.getParent();
        if (parent == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7559\u8bb0\u5f55\u62c6\u5206\u5931\u8d25\uff0c\u76ee\u6807\u5355\u5173\u8054\u5b9e\u4f53\u4e0d\u662f\u5355\u636e\u4f53\u7c7b\u578b\u3002", (String)"ReserveSplitBotpPlugin_1", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]));
        }
        DynamicObjectCollection entrys = parent.getDynamicObjectCollection(entryKey);
        HashMap<String, String> checKeyMap = new HashMap<String, String>(8);
        String baseQtyKey = billColMap.get("baseqty");
        checKeyMap.put("baseqty", baseQtyKey);
        String qtyKey = billColMap.get("qty");
        checKeyMap.put("qty", qtyKey);
        String qty2ndKey = billColMap.get("qty2nd");
        checKeyMap.put("qty2nd", qty2ndKey);
        String baseUnitKey = billColMap.get("baseunit");
        checKeyMap.put("baseunit", baseUnitKey);
        String unitKey = billColMap.get("unit");
        checKeyMap.put("unit", unitKey);
        String materialKey = billColMap.get("material");
        checKeyMap.put("material", materialKey);
        this.checkNull(checKeyMap);
        BigDecimal baseQty = entry.getBigDecimal(baseQtyKey);
        BigDecimal qty2nd = entry.getBigDecimal(qty2ndKey);
        DynamicObject baseUnit = entry.getDynamicObject(baseUnitKey);
        DynamicObject unit = entry.getDynamicObject(unitKey);
        DynamicObject material = entry.getDynamicObject(materialKey);
        Long materialId = (Long)material.getPkValue();
        List srcRows = (List)entity.getValue("ConvertSource");
        for (DynamicObject row : srcRows) {
            long entryId = row.getLong(f2);
            List<Object> srcEntryIds = srcEntryIdMap.get(entryId);
            for (Object srcEntryId : srcEntryIds) {
                List<RecordSpiltModel> spiltModelList = spiltModels.get(srcEntryId);
                if (spiltModelList == null) continue;
                for (RecordSpiltModel spiltModel : spiltModelList) {
                    BigDecimal subQty;
                    if (spiltModel.getBaseQty().compareTo(BigDecimal.ZERO) == 0) continue;
                    Map<String, Object> params = spiltModel.getParams();
                    DynamicObject add = (DynamicObject)OrmUtils.clone((IDataEntityBase)entry, (boolean)true, (boolean)true);
                    entrys.add((Object)add);
                    this.addBalFields(add, params, balColMap, billColMap);
                    BigDecimal reBaseQty = spiltModel.getBaseQty();
                    BigDecimal reQty2nd = spiltModel.getQty2nd();
                    BigDecimal subBaseQty = baseQty.min(reBaseQty);
                    materialId = (Long)params.get("materiel");
                    add.set(baseQtyKey, (Object)subBaseQty);
                    spiltModel.setBaseQty(reBaseQty.subtract(subBaseQty));
                    add.set("reserveid", spiltModel.getParams().get("reserveid"));
                    if (baseQty.compareTo(subBaseQty) > 0) {
                        baseQty = baseQty.subtract(subBaseQty);
                        qty2nd = qty2nd.subtract(reQty2nd).max(BigDecimal.ZERO);
                        subQty = this.convRate.getSrcQty(subBaseQty, (Long)params.get("materiel"), (Long)params.get("unit"), (Long)baseUnit.getPkValue());
                        add.set(qtyKey, (Object)subQty);
                        add.set(qty2ndKey, (Object)reQty2nd);
                        entry.set(qty2ndKey, (Object)qty2nd);
                        spiltModel.setQty2nd(BigDecimal.ZERO);
                        spiltModel.setQty(BigDecimal.ZERO);
                        continue;
                    }
                    subQty = this.convRate.getSrcQty(subBaseQty, (Long)params.get("materiel"), (Long)params.get("unit"), (Long)baseUnit.getPkValue());
                    add.set(qtyKey, (Object)subQty);
                    add.set(qty2ndKey, (Object)reQty2nd.min(qty2nd));
                    if (add.getBigDecimal("baseqty").compareTo(entry.getBigDecimal("baseqty")) == 0) {
                        entrys.remove((Object)add);
                        this.addBalFields(entry, params, balColMap, billColMap);
                        entry.set(qtyKey, (Object)subQty);
                        entry.set(qty2ndKey, (Object)reQty2nd.min(qty2nd));
                        entry.set("reserveid", spiltModel.getParams().get("reserveid"));
                    } else {
                        entrys.remove((Object)entry);
                    }
                    spiltModel.setQty2nd(qty2nd.subtract(reQty2nd).max(BigDecimal.ZERO));
                    spiltModel.setQty(spiltModel.getQty().subtract(subQty).max(BigDecimal.ZERO));
                    return;
                }
            }
        }
        entry.set(baseQtyKey, (Object)baseQty);
        BigDecimal srcQty = this.convRate.getSrcQty(baseQty, materialId, (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
        entry.set(qtyKey, (Object)srcQty);
    }

    private void checkNull(Map<String, String> keys) {
        for (Map.Entry<String, String> entry : keys.entrySet()) {
            if (!StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u76ee\u6807\u5355\u636e\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff08\u9884\u7559\u91ca\u653e\u6a21\u578b\uff09\uff1a%1$s\u6ca1\u6709\u914d\u7f6e\u3002", (String)"ReserveSplitBotpPlugin_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), entry.getKey()));
        }
    }

    private void addBalFields(DynamicObject entry, Map<String, Object> params, Map<String, String> balColMap, Map<String, String> billColMap) {
        EntryType entryEntity = (EntryType)entry.getDataEntityType();
        for (Map.Entry<String, String> col : balColMap.entrySet()) {
            String balKey = col.getKey();
            String billKey = col.getValue();
            Object val = params.get(balKey);
            String findKey = billColMap.get(billKey);
            IDataEntityProperty prop = entryEntity.findProperty(findKey);
            if (prop == null) continue;
            if (prop instanceof FlexProp) {
                DynamicObject flex = (DynamicObject)((FlexProp)prop).getComplexType().createInstance();
                flex.set("id", val);
                val = flex;
            } else if (prop instanceof BasedataProp) {
                if ("material".equals(findKey)) {
                    String baseEntityId = ((BasedataProp)prop).getBaseEntityId();
                    long orgId = Long.parseLong(params.get("org").toString());
                    QFilter qFilter = new QFilter("masterid.id", "=", (Object)Long.parseLong(val.toString()));
                    qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)baseEntityId, (Long)orgId));
                    DynamicObject material = BusinessDataServiceHelper.loadSingleFromCache((String)baseEntityId, (QFilter[])new QFilter[]{qFilter});
                    if (material != null) {
                        val = material;
                    }
                } else {
                    DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)((BasedataProp)prop).getBaseEntityId());
                    obj.set("id", val);
                    val = obj;
                }
            }
            entry.set(findKey, val);
        }
    }

    private boolean objectUtil(Object val) {
        if (val.equals(0L)) {
            return false;
        }
        return !val.equals("");
    }

    private Map<Object, List<Object>> getSrcEntryIdMap(String tgtMainType, String entryKey, List<Long> entryIds) {
        Map<Object, List<Object>> srcEntryIdMap = ReserveHelper.getBotpUpPath4EntryId(tgtMainType, entryKey, entryIds.toArray(new Long[entryIds.size()]));
        for (Long entryId : entryIds) {
            List<Object> srcEntryIds = srcEntryIdMap.get(entryId);
            if (srcEntryIds == null) {
                srcEntryIds = new ArrayList<Object>(16);
                srcEntryIdMap.put(entryId, srcEntryIds);
            }
            srcEntryIds.add(entryId);
        }
        return srcEntryIdMap;
    }

    private Map<Long, List<RecordSpiltModel>> getSpiltModels(DataSet recordDatas, Map<String, String> balColMap) {
        HashMap<Long, List<RecordSpiltModel>> spiltModelMap = new HashMap<Long, List<RecordSpiltModel>>(16);
        Set<String> balKeys = balColMap.keySet();
        while (recordDatas.hasNext()) {
            Row row = recordDatas.next();
            Long entryId = row.getLong("billentry_id");
            RecordSpiltModel spiltModel = this.getRecordSpiltModel(row, balKeys);
            ArrayList<RecordSpiltModel> spiltModelList = (ArrayList<RecordSpiltModel>)spiltModelMap.get(entryId);
            if (spiltModelList == null) {
                spiltModelList = new ArrayList<RecordSpiltModel>(16);
                spiltModelMap.put(entryId, spiltModelList);
            }
            spiltModelList.add(spiltModel);
        }
        return spiltModelMap;
    }

    private RecordSpiltModel getRecordSpiltModel(Row row, Set<String> balKeys) {
        RecordSpiltModel spiltModel = new RecordSpiltModel();
        spiltModel.setBaseQty(row.getBigDecimal("base_qty"));
        spiltModel.setQty(row.getBigDecimal("qty"));
        spiltModel.setQty2nd(row.getBigDecimal("qty2nd"));
        Map<String, Object> params = spiltModel.getParams();
        for (String balKey : balKeys) {
            params.put(balKey, row.get(balKey));
        }
        params.put("bal_id", row.get("bal_id"));
        params.put("reserveid", row.get("reserveid"));
        return spiltModel;
    }

    private DataSet getSupDataSet(DataSet recordDatas, Map<String, String> balColMap) {
        DataSet copy = recordDatas.copy();
        HashMap<String, Set> supIdMap = new HashMap<String, Set>(16);
        while (copy.hasNext()) {
            Set supIds;
            Row row = copy.next();
            String supFormId = row.getString("bal_obj");
            if (row.getLong("bal_id") == 0L) {
                supFormId = "msmod_reserveaggre";
                supIds = supIdMap.computeIfAbsent(supFormId, k -> new HashSet(16));
                supIds.add(row.getLong("aggregateid"));
                continue;
            }
            supIds = supIdMap.computeIfAbsent(supFormId, k -> new HashSet(16));
            supIds.add(row.getLong("bal_id"));
        }
        Map<String, ColsMap> colMaps = ColsMapHelper.findBillColMaps(supIdMap.keySet(), "msmod_std_inv_field");
        if (colMaps.isEmpty()) {
            log.info("\u4f9b\u5e94\u65b9\u5355\u636e\u65e0\u53ef\u7528\u7684\u6620\u5c04\u914d\u7f6e");
            return null;
        }
        Algo algo = Algo.create((String)algoKey);
        OrmInput[] ormInPuts = new OrmInput[colMaps.size()];
        int i = 0;
        for (Map.Entry<String, ColsMap> colEntry : colMaps.entrySet()) {
            ColsMap colsMap = colEntry.getValue();
            String formId = colEntry.getKey();
            String colAsSel = this.colAsSelect(formId, new HashSet<String>(balColMap.keySet()), colsMap.getBalColMap());
            Set supIds = (Set)supIdMap.get(formId);
            ormInPuts[i] = new OrmInput(algoKey, formId, colAsSel, new QFilter("id", "in", (Object)supIds).toArray());
            RowMeta rowMeta = ormInPuts[i].getRowMeta();
            rowMeta.getField("source_bal_obj").setDataType((DataType)DataType.StringType);
            ++i;
        }
        return algo.createDataSet((Input[])ormInPuts);
    }

    private String colAsSelect(String formId, Set<String> selKeySet, Map<String, String> balColMap) {
        selKeySet.add("baseunit");
        selKeySet.add("unit");
        selKeySet.add("unit2nd");
        StringBuilder sb = new StringBuilder();
        sb.append("id ");
        for (String key : selKeySet) {
            String val = balColMap.get(key);
            if (StringUtils.isBlank((CharSequence)val)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9884\u7559\u4f9b\u5e94\u5bf9\u8c61\u7684\u9884\u7559\u6620\u5c04\u914d\u7f6e\uff08\u9884\u7559\u4f9b\u5e94\u6a21\u578b\uff09\uff1a%1$s\u6ca1\u6709\u914d\u7f6e\u3002", (String)"DefaultDataReader_0", (String)"mpscmm-mscommon-reserve", (Object[])new Object[0]), key));
            }
            sb.append(',');
            sb.append(val).append(" AS ").append(key);
        }
        sb.append(',');
        sb.append("'");
        sb.append(formId).append("'").append(" AS ").append("source_bal_obj");
        return sb.toString();
    }

    private Map<String, String> getSubColsMap(Map<String, String> colsMap) {
        HashMap<String, String> subColsMap = new HashMap<String, String>(colsMap.size());
        for (Map.Entry<String, String> entryCols : colsMap.entrySet()) {
            String tarKey = entryCols.getKey();
            String srcKey = entryCols.getValue();
            String[] tarSpilt = tarKey.split("\\.");
            String[] srcSpilt = srcKey.split("\\.");
            if (tarSpilt.length == 2) {
                tarKey = tarSpilt[1];
            }
            if (srcSpilt.length == 2 || srcSpilt.length == 3) {
                srcKey = srcSpilt[1];
            }
            subColsMap.put(tarKey, srcKey);
        }
        return subColsMap;
    }
}

