/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.function.algoxoutput;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.CustomizedOutput;
import kd.bos.algo.RowMeta;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public class InspectCustomizedOutput
implements CustomizedOutput,
Serializable {
    private static final long serialVersionUID = 2281672671194424593L;
    private RowMeta rowMeta;
    private String sql;
    private String route;
    private List<Object[]> batchData = null;
    private int batchSize = 2000;
    private int count;

    public InspectCustomizedOutput(RowMeta rowMeta, String sql, String route) {
        this.rowMeta = rowMeta;
        this.sql = sql;
        this.route = route;
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public boolean isSingleParallel() {
        return false;
    }

    public void open() {
        this.batchData = new ArrayList<Object[]>();
    }

    public void write(Object[] row) {
        ++this.count;
        this.batchData.add(row);
        if (this.count == this.batchSize) {
            DB.executeBatch((DBRoute)DBRoute.of((String)this.route), (String)this.sql, this.batchData);
            this.count = 0;
            this.batchData.clear();
        }
    }

    public void close() {
        if (this.count > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)this.route), (String)this.sql, this.batchData);
        }
    }
}

