/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.function.algoxreduce;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.util.ReflectUtils;

public class IuPluginCalculateFunction
extends GroupReduceFunction {
    private AbstractDmfPlugin extPluginSerivce;
    private String inspectEntity;
    private String queryFieldKeys;
    private Long entryId;
    private long defaultBatchMaxNum;

    public IuPluginCalculateFunction(AbstractDmfPlugin extPluginSerivce, String inspectEntity, String queryFieldKeys, Long entryId, long defaultBatchMaxNum) {
        this.extPluginSerivce = extPluginSerivce;
        this.inspectEntity = inspectEntity;
        this.queryFieldKeys = queryFieldKeys;
        this.entryId = entryId;
        this.defaultBatchMaxNum = defaultBatchMaxNum;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        HashSet<Long> idSet = new HashSet<Long>(16);
        Iterator<RowX> iterator = iterable.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            RowX next = iterator.next();
            Long id = (Long)next.get(0);
            idSet.add(id);
            if ((long)(++count) < this.defaultBatchMaxNum) continue;
            this.calculateExtLogic(idSet, collector);
            idSet.clear();
            count = 0;
        }
        if (idSet.size() > 0) {
            this.calculateExtLogic(idSet, collector);
            idSet.clear();
        }
    }

    private void calculateExtLogic(Set<Long> idSet, Collector collector) {
        QFilter[] filterIdArray = new QFilter("id", "in", idSet).toArray();
        DataSet partitionDataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)this.inspectEntity, (String)this.queryFieldKeys, (QFilter[])filterIdArray, null);
        List<OperateErrorInfo> operateErrorInfoList = this.extPluginSerivce.exeInspectUnitExtPlugin(partitionDataset);
        operateErrorInfoList.stream().sorted(Comparator.comparing(OperateInfo::getTitle));
        int subEntrySize = operateErrorInfoList.size();
        int indexSeq = 1;
        long[] detailPkIdList = DBServiceHelper.genLongIds((String)"t_msbd_inspectlogentry_e", (int)subEntrySize);
        for (int i = 0; i < subEntrySize; ++i) {
            OperateErrorInfo result = operateErrorInfoList.get(i);
            Object[] subEntry = new Object[8];
            subEntry[0] = detailPkIdList[i];
            subEntry[1] = this.entryId;
            subEntry[2] = indexSeq;
            subEntry[3] = result.getPkValue();
            Object[] reflectFieldsValue = ReflectUtils.reflectFieldsValue(result, "entryId");
            subEntry[4] = reflectFieldsValue[0] instanceof Long ? reflectFieldsValue[0] : Long.valueOf(0L);
            subEntry[5] = result.getEntityKey();
            String msg = "";
            msg = result.getMessage().length() > 512 ? result.getMessage().substring(0, 480) : result.getMessage();
            subEntry[6] = msg;
            String title = result.getTitle();
            if (title == null) {
                title = "";
            }
            subEntry[7] = title;
            collector.collect(new RowX(subEntry));
            ++indexSeq;
        }
    }

    public RowMeta getResultRowMeta() {
        Field fdetailid = new Field("fdetailid", (DataType)DataType.LongType);
        Field fentryid = new Field("fentryid", (DataType)DataType.LongType);
        Field fseq = new Field("fseq", (DataType)DataType.IntegerType);
        Field fobjid = new Field("fobjid", (DataType)DataType.LongType);
        Field fobjentryid = new Field("fobjentryid", (DataType)DataType.LongType);
        Field fobjtypeid = new Field("fobjtypeid", (DataType)DataType.StringType);
        Field fobjdes = new Field("fobjdes", (DataType)DataType.StringType);
        Field fbizuniquesympol = new Field("fbizuniquesympol", (DataType)DataType.StringType);
        RowMeta rowMeta = new RowMeta(new Field[]{fdetailid, fentryid, fseq, fobjid, fobjentryid, fobjtypeid, fobjdes, fbizuniquesympol});
        return rowMeta;
    }

    private IuPluginCalculateFunction() {
    }
}

