/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.helper.im;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.DmfExpMsgInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillEntryModel;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillModel;

public class LogisticsBillMatch {
    private DynamicObject cfg;
    private InvBillModel bill;
    private String formId;
    List<InvBillEntryModel> entrys;
    private Integer priority;

    private LogisticsBillMatch(DynamicObject cfg, InvBillModel bill) {
        this.bill = bill;
        this.cfg = cfg;
        this.formId = cfg.getString("bill.id");
        this.priority = cfg.getInt("priority");
        this.entrys = bill.getBillEntrys();
    }

    public static LogisticsBillMatch getInstance(DynamicObject cfg, InvBillModel bill) {
        return new LogisticsBillMatch(cfg, bill);
    }

    public boolean isLogistcsBill() {
        String filterstr = this.cfg.getString("billfilterstr_tag");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.formId);
        if (StringUtils.isEmpty((CharSequence)filterstr)) {
            return true;
        }
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterstr, FilterCondition.class);
        this.updateFilterCondition(condition);
        FilterBuilder fb = new FilterBuilder(entityType, condition);
        String[] script = fb.buildFilterScript();
        BOSExpression expr = new BOSExpression(script[0]);
        HashMap<String, Object> ctx = new HashMap<String, Object>(16);
        Set vars = expr.getVars();
        if (vars.isEmpty()) {
            return true;
        }
        for (String var : vars) {
            String[] sp = var.split("\\.");
            IDataEntityProperty property = entityType.findProperty(sp[0]);
            if (property == null || property instanceof EntryProp || property instanceof BillStatusProp) continue;
            ctx.put(var, this.bill.getOtherPropMaps().get(var));
        }
        boolean exec = (Boolean)FormulaEngine.execExcelFormula((Expr)expr.getExpr(), ctx, null);
        return exec;
    }

    public List<DmfExpMsgInfo> execute() {
        ArrayList<DmfExpMsgInfo> dmfExpMsgInfos = new ArrayList<DmfExpMsgInfo>(16);
        String msg = ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u7269\u6d41\u6807\u8bc6\u201d\u9519\u8bef\u3002", (String)"LogisticsBillMatch_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
        for (InvBillEntryModel entry : this.entrys) {
            boolean isLogisticsBill;
            Map<String, Object> entryOtherMap = entry.getOtherPropMaps();
            Long balance = (Long)entryOtherMap.get(this.cfg.getString("balanceorg"));
            Long owner = (Long)entryOtherMap.get(this.cfg.getString("ownerorg"));
            boolean bl = isLogisticsBill = balance != null && owner != null && !balance.equals(owner);
            if (entry.isIslogisticsBill() == isLogisticsBill) continue;
            dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(msg, entry.getSeq()), this.bill.getPkValue(), entry.getEntryId(), this.bill.getBillNo()));
        }
        return dmfExpMsgInfos;
    }

    public Integer getPriority() {
        return this.priority;
    }

    private void updateFilterCondition(FilterCondition condition) {
        List filterRow = condition.getFilterRow();
        Iterator it = filterRow.iterator();
        while (it.hasNext()) {
            SimpleFilterRow next = (SimpleFilterRow)it.next();
            String fieldName = next.getFieldName();
            if (StringUtils.isBlank((CharSequence)fieldName) || !fieldName.contains("billentry") && !fieldName.contains("billstatus")) continue;
            it.remove();
        }
    }
}

