/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.logicsexecutor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algox.AlgoX;
import kd.bos.algox.AlgoXCallBack;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.function.algoxcallback.InspectSuccessCallBack;
import kd.mpscmm.msbd.datamanage.business.function.algoxinput.InspectCustomizedInput;
import kd.mpscmm.msbd.datamanage.business.function.algoxoutput.InspectCustomizedOutput;
import kd.mpscmm.msbd.datamanage.business.function.algoxreduce.IuPluginCalculateFunction;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.business.logicsexecutor.AbstractInspectUnitExecutor;
import kd.mpscmm.msbd.datamanage.common.pojo.ExeDmfUnitInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.common.util.DateUtils;
import kd.mpscmm.msbd.datamanage.common.util.InspectUnitContext;

public class IuPluginExecutor
extends AbstractInspectUnitExecutor {
    private static final Log logger = LogFactory.getLog(IuPluginExecutor.class);

    public IuPluginExecutor(InspectUnitContext inspectUnitContext) {
        super(inspectUnitContext);
    }

    @Override
    public List<OperateErrorInfo> executeUnitLogic(DynamicObject inspectUnit, List<QFilter> inspectUnitQFilter) {
        String inspectEntity = (String)inspectUnit.getDynamicObject("entity").getPkValue();
        List<QFilter> inspectPlanQFilter = this.inspectUnitContext.getInspectPlanQFilter();
        Long inspectUnitId = (Long)inspectUnit.getPkValue();
        DynamicObjectCollection extPluginEntryList = inspectUnit.getDynamicObjectCollection("pluginentry");
        List<Object> operateErrorInfoList = new ArrayList<OperateErrorInfo>(16);
        for (DynamicObject row : extPluginEntryList) {
            Object pluginClassObj;
            String pluginClassUrl;
            boolean mulTermination = DmfSchemeExecuteHelper.getMulTermination((Long)inspectUnit.getPkValue());
            if (mulTermination) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5de1\u68c0\u6a21\u578b\u5df2\u7ecf\u88ab\u7ec8\u6b62\uff0c\u7ec8\u6b62\u671f\u95f4\u5185\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u88ab\u6267\u884c\u3002", (String)"IuPluginExecutor_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            }
            boolean pluginEnable = row.getBoolean("pluginenable");
            if (!pluginEnable || StringUtils.isBlank((CharSequence)(pluginClassUrl = row.getString("pluginclassurl"))) || !((pluginClassObj = TypesContainer.createInstance((String)pluginClassUrl)) instanceof AbstractDmfPlugin)) continue;
            AbstractDmfPlugin pluginService = (AbstractDmfPlugin)pluginClassObj;
            InspectOptionInfo option = InspectOptionInfo.getInstance();
            pluginService.setInspectOptionInfo(option);
            pluginService.beginInspectOperation(option);
            int methodSelect = option.getMethodSelect();
            String customParameter = row.getString("customparameter_tag");
            ExeDmfUnitInfo exeDmfUnitInfo = new ExeDmfUnitInfo(inspectPlanQFilter, inspectUnitId, inspectUnitQFilter, customParameter, inspectEntity);
            exeDmfUnitInfo.setTimeOut(this.inspectUnitContext.getTimeOut());
            pluginService.setExeDmfUnitInfo(exeDmfUnitInfo);
            if (methodSelect == 0) {
                pluginService.onPrepareInspectPlanQFilter(inspectPlanQFilter);
                PreparePropertysEventArgs preparePropertysEventArgs = new PreparePropertysEventArgs();
                ArrayList fieldKeys = new ArrayList(16);
                preparePropertysEventArgs.setFieldKeys(fieldKeys);
                pluginService.onPreparePropertys(preparePropertysEventArgs);
                String queryFieldKeys = String.join((CharSequence)",", fieldKeys);
                if (inspectPlanQFilter != null) {
                    inspectUnitQFilter.addAll(inspectPlanQFilter);
                }
                String pluginName = pluginService.getClass().getName();
                logger.info("\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u5f00\u59cb\u6267\u884c\u3002", (Object)pluginName, (Object)DateUtils.getCurrentDateStr());
                List<OperateErrorInfo> operateErrorInfo = this.executeUnitLogic(inspectUnitId, inspectEntity, queryFieldKeys, inspectUnitQFilter, pluginService);
                logger.info("\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u7ed3\u675f\u6267\u884c\u3002", (Object)pluginName, (Object)DateUtils.getCurrentDateStr());
                option = null;
                exeDmfUnitInfo = null;
                pluginService = null;
                if (operateErrorInfo.size() > 10000) {
                    operateErrorInfo = operateErrorInfo.subList(0, 10000);
                    operateErrorInfoList.addAll(operateErrorInfo);
                    break;
                }
                operateErrorInfoList.addAll(operateErrorInfo);
                continue;
            }
            List<OperateErrorInfo> operateErrorList = pluginService.exeInspectUnitExtPlugin();
            if (operateErrorList.size() > 10000) {
                operateErrorList = operateErrorList.subList(0, 10000);
                operateErrorInfoList.addAll(operateErrorList);
                break;
            }
            option = null;
            exeDmfUnitInfo = null;
            pluginService = null;
            operateErrorInfoList.addAll(operateErrorList);
        }
        if (operateErrorInfoList.size() > 10000) {
            operateErrorInfoList = operateErrorInfoList.subList(0, 10000);
        }
        return operateErrorInfoList;
    }

    private List<OperateErrorInfo> executeUnitLogic(Long inspectUnitId, String inspectEntity, String queryFieldKeys, List<QFilter> planUnitQFilter, AbstractDmfPlugin pluginService) {
        QFilter[] qFilter = planUnitQFilter.toArray(new QFilter[0]);
        int countBizBillNum = ORM.create().count(this.getClass().getName(), inspectEntity, "id", qFilter, (Distinctable)WithDistinctable.get());
        this.inspectUnitContext.getInspectUnitCountNum().put(inspectUnitId, Long.valueOf(countBizBillNum));
        long maxInspectNum = this.inspectUnitContext.getMaxInspectNum();
        if (countBizBillNum == 0) {
            return new ArrayList<OperateErrorInfo>(16);
        }
        if ((long)countBizBillNum > maxInspectNum && maxInspectNum != 0L) {
            String expMsg = String.format(ResManager.loadKDString((String)"\u5f85\u5de1\u68c0\u6570\u91cf\uff08%1$d\uff09\u8d85\u8fc7\u5de1\u68c0\u4efb\u52a1\u4e0a\u5b9a\u4e49\u7684\u6700\u5927\u5de1\u68c0\u6570\u91cf\uff08%2$d\uff09\u3002", (String)"IuPluginExecutor_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), countBizBillNum, maxInspectNum);
            throw new KDBizException(expMsg);
        }
        ShardingUtil.BroadcastVO broadcast = this.inspectUnitContext.getBroadcast();
        List<OperateErrorInfo> operateErrorInfoList = null;
        operateErrorInfoList = broadcast != null ? this.executeBroadCastUnitLogic(broadcast, pluginService, inspectEntity, queryFieldKeys, qFilter, countBizBillNum, inspectUnitId) : this.executeSingleUnitLogic(pluginService, inspectEntity, queryFieldKeys, qFilter, countBizBillNum, inspectUnitId);
        return operateErrorInfoList;
    }

    private List<OperateErrorInfo> executeBroadCastUnitLogic(ShardingUtil.BroadcastVO broadcast, AbstractDmfPlugin pluginService, String inspectEntity, String queryFieldKeys, QFilter[] unitQFilter, int countBizBillNum, Long inspectUnitId) {
        int index = broadcast.getIndex();
        int total = broadcast.getTotal();
        List objectList = QueryServiceHelper.queryPrimaryKeys((String)inspectEntity, (QFilter[])unitQFilter, null, (int)countBizBillNum);
        ArrayList entityDataIdList = new ArrayList(16);
        for (int i = 0; i < objectList.size(); ++i) {
            if (i % total != index) continue;
            entityDataIdList.add(objectList.get(i));
        }
        int size = entityDataIdList.size();
        logger.info("\u5e7f\u64ad\u4e8b\u52a1\u5904\u7406MyTaskBroadcast,\u5206\u7247\u53c2\u6570: \u603b\u6570\uff1a{} \u5f53\u524d\u6267\u884c\u5668\u5e8f\u53f7\uff1a {}\u3002\u4e8e\u65f6\u95f4\uff1a{}\u5f00\u59cb\u5904\u7406{}\u6761\u6570\u636e\u3002", new Object[]{total, index, DateUtils.getCurrentDateStr(), size});
        int countBizBillNumSlice = entityDataIdList.size();
        QFilter[] unitQFilterSlice = new QFilter("id", "in", entityDataIdList).toArray();
        List<OperateErrorInfo> operateErrorInfo = this.executeSingleUnitLogic(pluginService, inspectEntity, queryFieldKeys, unitQFilterSlice, countBizBillNumSlice, inspectUnitId);
        logger.info("\u5e7f\u64ad\u4e8b\u52a1\u5904\u7406MyTaskBroadcast,\u5206\u7247\u53c2\u6570: \u603b\u6570\uff1a{} \u5f53\u524d\u6267\u884c\u5668\u5e8f\u53f7\uff1a {}\u3002\u4e8e\u65f6\u95f4\uff1a{}\u5904\u7406\u4e86{}\u6761\u6570\u636e\u7ed3\u675f\u3002", new Object[]{total, index, DateUtils.getCurrentDateStr(), size});
        return operateErrorInfo;
    }

    private List<OperateErrorInfo> executeSingleUnitLogic(AbstractDmfPlugin pluginService, String inspectEntity, String queryFieldKeys, QFilter[] unitQFilter, int factCountBizBillNum, Long inspectUnitId) {
        long defaultBatchMaxNum;
        long batchMaxNum = this.inspectUnitContext.getBatchMaxNum();
        long l = defaultBatchMaxNum = batchMaxNum == 0L ? 2000L : batchMaxNum;
        if ((long)factCountBizBillNum > defaultBatchMaxNum) {
            if (factCountBizBillNum > 100000) {
                JobSession jobSession = AlgoX.createSession((String)pluginService.getClass().getName());
                InspectCustomizedInput inspectCustomizedInput = new InspectCustomizedInput(inspectEntity, unitQFilter, factCountBizBillNum);
                DataSetX inputDataSetX = jobSession.fromInput(inspectCustomizedInput.createBizDataInput());
                Long entryId = this.inspectUnitContext.getLogEntryIdInspectId().get(inspectUnitId);
                DataSetX transFormDataSetX = inputDataSetX.groupBy(new String[0]).reduceGroup((GroupReduceFunction)new IuPluginCalculateFunction(pluginService, inspectEntity, queryFieldKeys, entryId, defaultBatchMaxNum));
                String insertSql = "insert into t_msbd_inspectlogentry_e(fdetailid,fentryid,fseq,fobjid,fobjentryid,fobjtypeid,fobjdes,fbizuniquesympol) values(?,?,?,?,?,?,?,?)";
                InspectCustomizedOutput inspectCustomizedOutput = new InspectCustomizedOutput(transFormDataSetX.getRowMeta(), insertSql, "scm");
                transFormDataSetX.output((Output)inspectCustomizedOutput);
                jobSession.asyncCommit(60, 57, TimeUnit.SECONDS, (AlgoXCallBack)new InspectSuccessCallBack(entryId));
                return Collections.emptyList();
            }
            List entityDataIdList = QueryServiceHelper.queryPrimaryKeys((String)inspectEntity, (QFilter[])unitQFilter, null, (int)factCountBizBillNum);
            List<OperateErrorInfo> operateErrorInfoList = this.batchExeData(inspectEntity, queryFieldKeys, entityDataIdList, factCountBizBillNum, pluginService);
            return operateErrorInfoList;
        }
        return this.singleExeData(pluginService, inspectEntity, queryFieldKeys, unitQFilter);
    }

    private List<OperateErrorInfo> singleExeData(AbstractDmfPlugin pluginService, String inspectEntity, String queryFieldKeys, QFilter[] unitQFilter) {
        int bizDataType = pluginService.getInspectOptionInfo().getBizDataType();
        String pluginName = pluginService.getClass().getSimpleName();
        List<OperateErrorInfo> operateErrorInfoList = null;
        String billEntrySympol = pluginService.getInspectOptionInfo().getBillEntrySympol();
        if (bizDataType == 0) {
            if (billEntrySympol == null || "".equals(billEntrySympol)) {
                DynamicObject[] bizDataArray = this.queryBizDataArray(inspectEntity, queryFieldKeys, unitQFilter);
                operateErrorInfoList = pluginService.exeInspectUnitExtPlugin(bizDataArray);
                logger.info("singleExeData->\u4e0d\u5305\u542b\u5206\u5f55,\u5de1\u68c0\u7c7b\u578b\u662fDynamicObject\u7684\u5de1\u68c0\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u6267\u884c\u5b8c\u6210\u3002", (Object)pluginName, (Object)DateUtils.getCurrentDateStr());
            } else {
                String selectFields = "id,".concat(billEntrySympol.concat(".").concat("id").concat(" entryid"));
                try (DataSet filterDataSet = this.queryBizDataSet(inspectEntity, selectFields, unitQFilter);){
                    DataSet entryIdDataSet = filterDataSet.groupBy(new String[]{"id"}).count("entryid").finish();
                    DataSet totalEntryIdDataSet = entryIdDataSet.copy();
                    Long totalEntryIdNum = this.getTotalEntryIdNum(totalEntryIdDataSet);
                    if (totalEntryIdNum < 10000L) {
                        DynamicObject[] bizDataArray = this.queryBizDataArray(inspectEntity, queryFieldKeys, unitQFilter);
                        operateErrorInfoList = pluginService.exeInspectUnitExtPlugin(bizDataArray);
                        bizDataArray = null;
                        logger.info("singleExeData->\u542b\u5206\u5f55\u4f46\u4e0d\u5206\u6279\u6b21,\u5de1\u68c0\u7c7b\u578b\u662fDynamicObject\u7684\u5de1\u68c0\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u6267\u884c\u5b8c\u6210\u3002", (Object)pluginName, (Object)DateUtils.getCurrentDateStr());
                    }
                    operateErrorInfoList = new ArrayList<OperateErrorInfo>(16);
                    List<Set<Object>> batchIdList = this.getBatchIdList(entryIdDataSet);
                    for (Set<Object> singleBatch : batchIdList) {
                        DynamicObject[] bizDataArray = this.queryBizDataArray(inspectEntity, queryFieldKeys, new QFilter("id", "in", singleBatch).toArray());
                        List<OperateErrorInfo> operateErrorInfo = pluginService.exeInspectUnitExtPlugin(bizDataArray);
                        if (operateErrorInfo != null && operateErrorInfo.size() > 0) {
                            operateErrorInfoList.addAll(operateErrorInfo);
                        } else {
                            operateErrorInfo = null;
                        }
                        bizDataArray = null;
                        if (operateErrorInfoList.size() < 10000) continue;
                        break;
                    }
                    logger.info("singleExeData->\u5206\u5f55\u5206\u6279\u6570\u636e\u91cf:{}\uff0c\u5de1\u68c0\u7c7b\u578b\u662fDynamicObject\u7684\u5de1\u68c0\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u6267\u884c\u5b8c\u6210\u3002", new Object[]{batchIdList.size(), pluginName, DateUtils.getCurrentDateStr()});
                    batchIdList.clear();
                    batchIdList = null;
                }
            }
        } else if (billEntrySympol == null || "".equals(billEntrySympol)) {
            DataSet bizDataSet = this.queryBizDataSet(inspectEntity, queryFieldKeys, unitQFilter);
            operateErrorInfoList = pluginService.exeInspectUnitExtPlugin(bizDataSet);
            if (bizDataSet != null) {
                bizDataSet.close();
            }
            logger.info("singleExeData->\u4e0d\u5305\u542b\u5206\u5f55,\u5de1\u68c0\u7c7b\u578b\u662fDataSet\u7684\u5de1\u68c0\u63d2\u4ef6\u540d\u79f0\uff1a{},\u4e8e\u65f6\u95f4\uff1a{}\u6267\u884c\u5b8c\u6210\u3002", (Object)pluginName, (Object)DateUtils.getCurrentDateStr());
        } else {
            String selectFields = "id,".concat(billEntrySympol.concat(".").concat("id").concat(" entryid"));
            try (DataSet filterDataSet = this.queryBizDataSet(inspectEntity, selectFields, unitQFilter);){
                DataSet entryIdDataSet = filterDataSet.groupBy(new String[]{"id"}).count("entryid").finish();
                DataSet totalEntryIdDataSet = entryIdDataSet.copy();
                Long totalEntryIdNum = this.getTotalEntryIdNum(totalEntryIdDataSet);
                if (totalEntryIdNum < 10000L) {
                    DataSet bizDataSet = this.queryBizDataSet(inspectEntity, queryFieldKeys, unitQFilter);
                    operateErrorInfoList = pluginService.exeInspectUnitExtPlugin(bizDataSet);
                    if (bizDataSet != null) {
                        bizDataSet.close();
                    }
                    logger.info("singleExeData->\u5305\u542b\u5206\u5f55\u4f46\u662f\u4e0d\u5206\u6279\u6b21,\u5de1\u68c0\u7c7b\u578b\u662fDataSet\u7684\u5de1\u68c0\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u6267\u884c\u5b8c\u6210\u3002", (Object)pluginName, (Object)DateUtils.getCurrentDateStr());
                } else {
                    operateErrorInfoList = new ArrayList<OperateErrorInfo>(16);
                    List<Set<Object>> batchIdList = this.getBatchIdList(entryIdDataSet);
                    Iterator<Set<Object>> batchIdIterator = batchIdList.iterator();
                    while (batchIdIterator.hasNext()) {
                        Set<Object> singleBatch = batchIdIterator.next();
                        DataSet bizDataSet = this.queryBizDataSet(inspectEntity, queryFieldKeys, new QFilter("id", "in", singleBatch).toArray());
                        List<OperateErrorInfo> operateErrorInfo = pluginService.exeInspectUnitExtPlugin(bizDataSet);
                        if (operateErrorInfo != null && operateErrorInfo.size() > 0) {
                            operateErrorInfoList.addAll(operateErrorInfo);
                        } else {
                            operateErrorInfo = null;
                        }
                        if (bizDataSet != null) {
                            bizDataSet.close();
                        }
                        if (operateErrorInfoList.size() >= 10000) break;
                        batchIdIterator.remove();
                    }
                    logger.info("singleExeData->\u5206\u5f55\u5206\u6279\u6b21\u6570\u91cf\uff1a{},\u5de1\u68c0\u7c7b\u578b\u662fDataSet\u7684\u5de1\u68c0\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u6267\u884c\u5b8c\u6210\u3002", new Object[]{batchIdList.size(), pluginName, DateUtils.getCurrentDateStr()});
                    batchIdList = null;
                }
            }
        }
        return operateErrorInfoList;
    }

    private List<OperateErrorInfo> batchExeData(String inspectEntity, String queryFieldKeys, List<Object> objectList, long factBatchMaxNum, AbstractDmfPlugin pluginService) {
        ArrayList<OperateErrorInfo> operateErrorInfoList = new ArrayList<OperateErrorInfo>(16);
        int objectSize = objectList.size();
        List<List<Object>> partitionList = DmfSchemeExecuteHelper.partition(objectList, (int)factBatchMaxNum);
        int bizDataType = pluginService.getInspectOptionInfo().getBizDataType();
        String pluginName = pluginService.getClass().getName();
        logger.info("batchExeData->\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u5f00\u59cb\u6279\u91cf\u6267\u884c\u6570\u636e\u91cf\u4e3a{}\u7684\u6570\u636e\u3002", new Object[]{pluginName, DateUtils.getCurrentDateStr(), objectSize});
        int i = 1;
        try {
            Iterator<List<Object>> batchBillNoIterator = partitionList.iterator();
            while (batchBillNoIterator.hasNext()) {
                List<OperateErrorInfo> operateErrorInfo;
                List<Set<Object>> batchIdList;
                Long totalEntryIdNum;
                DataSet totalEntryIdDataSet;
                DataSet entryIdDataSet2;
                Throwable throwable;
                DataSet filterDataSet;
                String selectFields;
                List<Object> batchBillNo = batchBillNoIterator.next();
                this.getMulTermination();
                String billEntrySympol = pluginService.getInspectOptionInfo().getBillEntrySympol();
                QFilter[] qFilterIdArray = new QFilter("id", "in", batchBillNo).toArray();
                if (bizDataType == 0) {
                    if (billEntrySympol == null || "".equals(billEntrySympol)) {
                        DynamicObject[] bizDataArray = this.queryBizDataArray(inspectEntity, queryFieldKeys, qFilterIdArray);
                        operateErrorInfoList.addAll(pluginService.exeInspectUnitExtPlugin(bizDataArray));
                        bizDataArray = null;
                    } else {
                        selectFields = "id,".concat(billEntrySympol.concat(".").concat("id").concat(" entryid"));
                        filterDataSet = this.queryBizDataSet(inspectEntity, selectFields, qFilterIdArray);
                        throwable = null;
                        try {
                            entryIdDataSet2 = filterDataSet.groupBy(new String[]{"id"}).count("entryid").finish();
                            totalEntryIdDataSet = entryIdDataSet2.copy();
                            totalEntryIdNum = this.getTotalEntryIdNum(totalEntryIdDataSet);
                            if (totalEntryIdNum < 10000L) {
                                DynamicObject[] bizDataArray = this.queryBizDataArray(inspectEntity, queryFieldKeys, qFilterIdArray);
                                operateErrorInfoList.addAll(pluginService.exeInspectUnitExtPlugin(bizDataArray));
                                bizDataArray = null;
                            }
                            batchIdList = this.getBatchIdList(entryIdDataSet2);
                            for (Set<Object> singleBatch : batchIdList) {
                                DynamicObject[] bizDataArray = this.queryBizDataArray(inspectEntity, queryFieldKeys, new QFilter("id", "in", singleBatch).toArray());
                                operateErrorInfo = pluginService.exeInspectUnitExtPlugin(bizDataArray);
                                if (operateErrorInfo.size() <= 0) {
                                    operateErrorInfo = null;
                                } else {
                                    operateErrorInfoList.addAll(operateErrorInfo);
                                }
                                if (operateErrorInfoList.size() >= 10000) {
                                }
                                bizDataArray = null;
                            }
                        }
                        catch (Throwable entryIdDataSet2) {
                            throwable = entryIdDataSet2;
                            throw entryIdDataSet2;
                        }
                        finally {
                            if (filterDataSet != null) {
                                if (throwable != null) {
                                    try {
                                        filterDataSet.close();
                                    }
                                    catch (Throwable entryIdDataSet2) {
                                        throwable.addSuppressed(entryIdDataSet2);
                                    }
                                } else {
                                    filterDataSet.close();
                                }
                            }
                        }
                    }
                } else if (billEntrySympol == null || "".equals(billEntrySympol)) {
                    DataSet bizDataSet = this.queryBizDataSet(inspectEntity, queryFieldKeys, qFilterIdArray);
                    List<OperateErrorInfo> operateErrorInfo2 = pluginService.exeInspectUnitExtPlugin(bizDataSet);
                    if (operateErrorInfo2 != null && operateErrorInfo2.size() > 0) {
                        operateErrorInfoList.addAll(operateErrorInfo2);
                    } else {
                        operateErrorInfo2 = null;
                    }
                    if (bizDataSet != null) {
                        bizDataSet.close();
                    }
                } else {
                    selectFields = "id,".concat(billEntrySympol.concat(".").concat("id").concat(" entryid"));
                    filterDataSet = this.queryBizDataSet(inspectEntity, selectFields, qFilterIdArray);
                    throwable = null;
                    try {
                        entryIdDataSet2 = filterDataSet.groupBy(new String[]{"id"}).count("entryid").finish();
                        totalEntryIdDataSet = entryIdDataSet2.copy();
                        totalEntryIdNum = this.getTotalEntryIdNum(totalEntryIdDataSet);
                        if (totalEntryIdNum < 10000L) {
                            DataSet bizDataSet = this.queryBizDataSet(inspectEntity, queryFieldKeys, qFilterIdArray);
                            List<OperateErrorInfo> operateErrorInfo3 = pluginService.exeInspectUnitExtPlugin(bizDataSet);
                            if (operateErrorInfo3 != null && operateErrorInfo3.size() > 0) {
                                operateErrorInfoList.addAll(operateErrorInfo3);
                            } else {
                                operateErrorInfo3 = null;
                            }
                            if (bizDataSet != null) {
                                bizDataSet.close();
                            }
                        } else {
                            batchIdList = this.getBatchIdList(entryIdDataSet2);
                            logger.error("batchExeData->\u6309\u5355\u5206\u6279\uff0c\u7b2c{}\u6279\u7684\u6570\u636e\uff0c\u6309\u7167\u5206\u5f55\u5206\u6279\u4e4b\u540e\uff0c\u6279\u6b21\u6570\u662f->{}\u3002", (Object)i, (Object)batchIdList.size());
                            Iterator<Set<Object>> batchIdIterator = batchIdList.iterator();
                            while (batchIdIterator.hasNext()) {
                                Set<Object> singleBatch;
                                singleBatch = batchIdIterator.next();
                                DataSet bizDataSet = this.queryBizDataSet(inspectEntity, queryFieldKeys, new QFilter("id", "in", singleBatch).toArray());
                                operateErrorInfo = pluginService.exeInspectUnitExtPlugin(bizDataSet);
                                if (operateErrorInfo.size() <= 0) {
                                    operateErrorInfo = null;
                                } else {
                                    operateErrorInfoList.addAll(operateErrorInfo);
                                }
                                if (bizDataSet != null) {
                                    bizDataSet.close();
                                }
                                if (operateErrorInfoList.size() >= 10000) break;
                                batchIdIterator.remove();
                            }
                            batchIdList = null;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (filterDataSet != null) {
                            if (throwable != null) {
                                try {
                                    filterDataSet.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                filterDataSet.close();
                            }
                        }
                    }
                }
                logger.error("batchExeData->\u6309\u5355\u5206\u6279\uff0c\u7b2c{}\u6279\u7684\u6570\u636e\u6267\u884c\u5b8c\u6bd5\u3002", (Object)i);
                this.waitTime(500L);
                ++i;
                batchBillNoIterator.remove();
                if (operateErrorInfoList.size() < 10000) continue;
                break;
            }
            partitionList = null;
            pluginService = null;
            objectList.clear();
            objectList = null;
        }
        catch (Exception e) {
            try {
                String expMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
                logger.error("batchExeData->\u6309\u5355\u5206\u6279\uff0c\u7b2c{}\u6279\u7684\u6570\u636e\u6267\u884c\u65f6\uff0c\u53d1\u751f\u5982\u4e0b\u5f02\u5e38\uff1a{}", (Object)i, (Object)expMsg);
                throw new KDBizException(expMsg);
            }
            catch (Throwable throwable) {
                partitionList = null;
                pluginService = null;
                objectList.clear();
                objectList = null;
                logger.info("batchExeData->\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u6279\u91cf\u6267\u884c\u6570\u636e\u91cf\u4e3a{}\u7684\u6570\u636e\u6267\u884c\u7ed3\u675f\u3002", new Object[]{pluginName, DateUtils.getCurrentDateStr(), objectSize});
                throw throwable;
            }
        }
        logger.info("batchExeData->\u63d2\u4ef6\u540d\u79f0\uff1a{}\uff0c\u4e8e\u65f6\u95f4\uff1a{}\u6279\u91cf\u6267\u884c\u6570\u636e\u91cf\u4e3a{}\u7684\u6570\u636e\u6267\u884c\u7ed3\u675f\u3002", new Object[]{pluginName, DateUtils.getCurrentDateStr(), objectSize});
        return operateErrorInfoList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getTotalEntryIdNum(DataSet totalEntryIdDataSet) {
        try (DataSet totalEntryId = totalEntryIdDataSet.groupBy().sum("entryid").finish();){
            Long totalEntryIdNum = totalEntryId.next().getLong("entryid");
            totalEntryIdDataSet.close();
            Long l = totalEntryIdNum;
            return l;
        }
        catch (Exception e) {
            String expMsg = e.toString().concat(Arrays.toString(e.getStackTrace()));
            logger.error("\u5bf9\u5206\u5f55\u5206\u7ec4\u8ba1\u6570\u4e4b\u540e\u7684\u6c42\u548c\u5b58\u5728\u5f02\u5e38:{}\uff0c\u8bf7\u68c0\u67e5\u3002", (Object)e.toString().concat(Arrays.toString(e.getStackTrace())));
            throw new KDBizException(expMsg);
        }
    }

    private List<Set<Object>> getBatchIdList(DataSet entryIdDataSet) {
        ArrayList<Set<Object>> partition = new ArrayList<Set<Object>>(16);
        HashSet<Long> maxNum = new HashSet<Long>(16);
        try (DataSet maxNumDataSet = entryIdDataSet.copy();){
            for (Row row : maxNumDataSet) {
                int entryIdCount = row.getInteger("entryid");
                Long id = row.getLong("id");
                if (entryIdCount < 10000) continue;
                maxNum.add(id);
                HashSet<Long> maxBillIdSet = new HashSet<Long>(16);
                maxBillIdSet.add(id);
                partition.add(maxBillIdSet);
            }
        }
        int m = 0;
        HashSet<Long> addUpIdSet = new HashSet<Long>(16);
        for (Row row : entryIdDataSet) {
            Long id = row.getLong("id");
            if (maxNum.contains(id)) continue;
            int entryIdCount = row.getInteger("entryid");
            if ((m += entryIdCount) < 10000) {
                addUpIdSet.add(id);
                continue;
            }
            partition.add(addUpIdSet);
            addUpIdSet = new HashSet(16);
            addUpIdSet.add(id);
            m = entryIdCount;
        }
        partition.add(addUpIdSet);
        return partition;
    }

    private boolean getMulTermination() {
        Set<Long> inspectUnitSet = this.inspectUnitContext.getInspectUnitCountNum().keySet();
        Long inspectUnitId = (Long)inspectUnitSet.stream().iterator().next();
        boolean mulTermination = DmfSchemeExecuteHelper.getMulTermination(inspectUnitId);
        if (mulTermination) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5de1\u68c0\u6a21\u578b\u5df2\u7ecf\u88ab\u7ec8\u6b62\uff0c\u7ec8\u6b62\u671f\u95f4\u5185\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u88ab\u6267\u884c\u3002", (String)"IuPluginExecutor_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        }
        return false;
    }
}

