/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.threads.ThreadPool;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.business.helper.DmfThreadPoolsHelper;
import kd.mpscmm.msbd.datamanage.business.service.AbstractInspectPlanService;
import kd.mpscmm.msbd.datamanage.business.service.DmfUnitService;
import kd.mpscmm.msbd.datamanage.common.pojo.DmfUnitResultInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectLogToolsInfo;
import kd.mpscmm.msbd.datamanage.common.util.DataInspectContext;
import kd.mpscmm.msbd.datamanage.common.util.InspectUnitContext;

public class ParallelInspectPlanService
extends AbstractInspectPlanService {
    private static final Log logger = LogFactory.getLog(ParallelInspectPlanService.class);

    @Override
    public List<DmfUnitResultInfo> executeInspectUnits(DynamicObject[] inspectUnitList, List<QFilter> inspectPlanQFilter, long timeOut, long batchMaxNum, ShardingUtil.BroadcastVO broadcast) {
        logger.info("ParallelInspectPlanService\u5f00\u59cb\u5e76\u884c\u6267\u884c{}\u4e2a\u5de1\u68c0\u6a21\u578b\uff0c\u8d85\u65f6\u65f6\u95f4\u662f\uff1a{}", (Object)inspectUnitList.length, (Object)timeOut);
        DataInspectContext dataInspectContext = DataInspectContext.get();
        InspectLogToolsInfo inspectLogToolsInfo = dataInspectContext.getInspectLogToolsInfo();
        long maxInspectNum = dataInspectContext.getMaxInspectNum();
        InspectUnitContext inspectUnitContext = new InspectUnitContext(inspectPlanQFilter, maxInspectNum, batchMaxNum, timeOut, broadcast, new HashMap(16));
        this.initLogToolsEntry(inspectLogToolsInfo, inspectUnitContext);
        DmfUnitService inspectUnitService = new DmfUnitService(inspectUnitContext);
        ThreadPool threadPoolExecutor = DmfThreadPoolsHelper.getInspectThreadPool();
        long maxParallelNum = dataInspectContext.getMaxParallelNum();
        List<List<DynamicObject>> partition = DmfSchemeExecuteHelper.partition(Arrays.asList(inspectUnitList), (int)maxParallelNum);
        boolean isLastBatchFlag = false;
        for (int m = 0; m < partition.size(); ++m) {
            if (m == partition.size() - 1) {
                isLastBatchFlag = true;
            }
            List<DynamicObject> partitionInspectUnitList = partition.get(m);
            LinkedHashMap<Long, Future> inspectUnitResultCollect = new LinkedHashMap<Long, Future>(16);
            for (DynamicObject inspectUnit : partitionInspectUnitList) {
                Long inspectUnitId = (Long)inspectUnit.getPkValue();
                inspectLogToolsInfo.beginRun(inspectUnitId);
                Future result = threadPoolExecutor.submit((Callable)new AbstractInspectPlanService.InspectUnitCallable(inspectUnitService, inspectUnit));
                inspectUnitResultCollect.put(inspectUnitId, result);
            }
            long timeOutSeconds = timeOut == 0L ? 1800L : timeOut * 60L;
            int i = 0;
            boolean isLastInspectUnitFlag = false;
            for (Map.Entry entry : inspectUnitResultCollect.entrySet()) {
                Future inspectUnitResult = (Future)entry.getValue();
                Long inspectUnitId = (Long)entry.getKey();
                if (i == inspectUnitResultCollect.size() - 1 && isLastBatchFlag) {
                    isLastInspectUnitFlag = true;
                }
                try {
                    DmfUnitResultInfo dmfUnitResultInfo = (DmfUnitResultInfo)inspectUnitResult.get(timeOutSeconds, TimeUnit.SECONDS);
                    String exceptionStackTrace = dmfUnitResultInfo.getExceptionStackTrace();
                    if (exceptionStackTrace != null) {
                        inspectLogToolsInfo.collectExtExcpMsg(inspectUnitId, exceptionStackTrace, isLastInspectUnitFlag);
                    } else {
                        inspectLogToolsInfo.endRun(inspectUnitId, inspectUnitContext.getInspectUnitCountNum().get(inspectUnitId), dmfUnitResultInfo.getAuditResult(), isLastInspectUnitFlag);
                    }
                    inspectUnitResult = null;
                    inspectUnitId = null;
                    dmfUnitResultInfo = null;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    inspectUnitResult.cancel(true);
                    String expMsg = String.format(ResManager.loadKDString((String)"\u5b50\u7ebf\u7a0b\u6267\u884c\u8d85\u65f6%s", (String)"ParallelInspectPlanService_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), e.toString().concat(Arrays.toString(e.getStackTrace())));
                    inspectLogToolsInfo.collectExtExcpMsg(inspectUnitId, expMsg, isLastInspectUnitFlag);
                    logger.error("exists  TimeoutException:{}", (Object)e.toString().concat(Arrays.toString(e.getStackTrace())));
                    inspectUnitResult = null;
                    inspectUnitId = null;
                }
                ++i;
            }
        }
        inspectUnitContext = null;
        inspectUnitService = null;
        inspectUnitList = null;
        partition = null;
        inspectPlanQFilter = null;
        return Collections.emptyList();
    }
}

