/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.business.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.threads.ThreadPool;
import kd.mpscmm.msbd.datamanage.business.helper.DmfThreadPoolsHelper;
import kd.mpscmm.msbd.datamanage.business.service.AbstractInspectPlanService;
import kd.mpscmm.msbd.datamanage.business.service.DmfUnitService;
import kd.mpscmm.msbd.datamanage.common.pojo.DmfUnitResultInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectLogToolsInfo;
import kd.mpscmm.msbd.datamanage.common.util.DataInspectContext;
import kd.mpscmm.msbd.datamanage.common.util.InspectUnitContext;

public class SerialInspectPlanService
extends AbstractInspectPlanService {
    private static final Log logger = LogFactory.getLog(SerialInspectPlanService.class);

    @Override
    public List<DmfUnitResultInfo> executeInspectUnits(DynamicObject[] enableInspectUnitList, List<QFilter> inspectPlanQFilter, long timeOut, long batchMaxNum, ShardingUtil.BroadcastVO broadcast) {
        logger.info("SerialInspectPlanService\u5f00\u59cb\u4e32\u884c\u6267\u884c{}\u4e2a\u5de1\u68c0\u6a21\u578b\uff0c\u8d85\u65f6\u65f6\u95f4\u662f\uff1a{}", (Object)enableInspectUnitList.length, (Object)timeOut);
        DataInspectContext dataInspectContext = DataInspectContext.get();
        InspectLogToolsInfo inspectLogToolsInfo = dataInspectContext.getInspectLogToolsInfo();
        long maxInspectNum = dataInspectContext.getMaxInspectNum();
        InspectUnitContext inspectUnitContext = new InspectUnitContext(inspectPlanQFilter, maxInspectNum, batchMaxNum, timeOut, broadcast, new HashMap(16));
        this.initLogToolsEntry(inspectLogToolsInfo, inspectUnitContext);
        DmfUnitService inspectUnitService = new DmfUnitService(inspectUnitContext);
        long timeOutSeconds = timeOut == 0L ? 1800L : timeOut * 60L;
        ThreadPool threadPool = DmfThreadPoolsHelper.getInspectThreadPool();
        boolean isLastInspectUnitFlag = false;
        for (int i = 0; i < enableInspectUnitList.length; ++i) {
            DynamicObject inspectUnit = enableInspectUnitList[i];
            Long inspectUnitId = (Long)inspectUnit.getPkValue();
            inspectLogToolsInfo.beginRun(inspectUnitId);
            Future unitResult = threadPool.submit((Callable)new AbstractInspectPlanService.InspectUnitCallable(inspectUnitService, inspectUnit));
            DmfUnitResultInfo dmfUnitResultInfo = null;
            if (i == enableInspectUnitList.length - 1) {
                isLastInspectUnitFlag = true;
            }
            try {
                dmfUnitResultInfo = (DmfUnitResultInfo)unitResult.get(timeOutSeconds, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                unitResult.cancel(true);
                logger.error("exists  TimeoutException:{}", (Object)e.toString().concat(Arrays.toString(e.getStackTrace())));
                String expMsg = String.format(ResManager.loadKDString((String)"\u5b50\u7ebf\u7a0b\u6267\u884c\u8d85\u65f6%s", (String)"SerialInspectPlanService_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), e.toString().concat(Arrays.toString(e.getStackTrace())));
                dmfUnitResultInfo = DmfUnitResultInfo.acceptExceptionStackTrace(expMsg, inspectUnitId, inspectUnit.getString("number"));
            }
            String exceptionStackTrace = dmfUnitResultInfo.getExceptionStackTrace();
            List<OperateErrorInfo> inspectUnitResult = dmfUnitResultInfo.getAuditResult();
            if (exceptionStackTrace != null) {
                inspectLogToolsInfo.collectExtExcpMsg(inspectUnitId, exceptionStackTrace, isLastInspectUnitFlag);
                continue;
            }
            inspectLogToolsInfo.endRun(inspectUnitId, inspectUnitContext.getInspectUnitCountNum().get(inspectUnitId), inspectUnitResult, isLastInspectUnitFlag);
        }
        enableInspectUnitList = null;
        inspectUnitContext = null;
        inspectUnitService = null;
        inspectPlanQFilter = null;
        return Collections.emptyList();
    }
}

