/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DateUtils {
    private static final Log logger = LogFactory.getLog(DateUtils.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
    private static final DateTimeFormatter FORMATTER_SMALL = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public static Date parse(String dateStr) {
        SimpleDateFormat lengthFomate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date bizTime = null;
        try {
            bizTime = lengthFomate.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error("exist exception:" + e.getLocalizedMessage());
        }
        return bizTime;
    }

    public static String getCurrentDateStr() {
        return FORMATTER.format(LocalDateTime.now());
    }

    public static String getCurrentDateStr1() {
        return FORMATTER_SMALL.format(LocalDateTime.now());
    }

    public static String dateFormat(Date d, String pattern) {
        Date date = null;
        date = d != null ? d : Calendar.getInstance().getTime();
        if (pattern == null || pattern.equals("")) {
            pattern = ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss", (String)"DateUtils_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String getCurrentDateStr(int i) {
        LocalDate now = LocalDate.now().minusDays(6L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"DateUtils_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        if (i == 0) {
            return formatter.format(now);
        }
        return formatter.format(now.plusDays(i));
    }

    public static String getCurrentDayStr(int i) {
        LocalDate now = LocalDate.now().minusDays(13L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (i == 0) {
            return formatter.format(now);
        }
        return formatter.format(now.plusDays(i));
    }
}

