/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DmfInspectPlanMsgPlugin
extends AbstractFormPlugin {
    private static final String MSG_CONTENT = "sch_msg_content";
    private static final String TEMPLATECALLBACK = "templateCallBack";
    private static final String MSGCONTENT = "smsgcontent";
    private static final String NOTIFYTYPE = "snotifytype";
    private static final String MSGTEMPLATE = "msg_template";
    private static final String MSGCHANNEL = "msg_channel";
    private static final String CUSTOM_SUBJECT = "customSubject";
    private Set<String> enableTypes = new HashSet<String>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MSGCONTENT});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setMsgChannelItem();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String notifyType = (String)this.getModel().getValue(NOTIFYTYPE);
        if (StringUtils.isNotBlank((CharSequence)notifyType)) {
            String[] types = notifyType.split(",");
            ArrayList effectTypes = new ArrayList();
            Arrays.stream(types).forEach(type -> {
                if (StringUtils.isNotBlank((CharSequence)type) && this.enableTypes.contains(type)) {
                    effectTypes.add(type);
                }
            });
            this.getModel().setValue(NOTIFYTYPE, (Object)effectTypes.stream().collect(Collectors.joining(",")));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setMsgChannelItem();
        HashMap<String, String> msgTemplateMap = new HashMap<String, String>(16);
        QFilter[] filters = new QFilter[]{new QFilter("msgentity", "=", (Object)"sch_schedule")};
        DynamicObject[] templatelArray = BusinessDataServiceHelper.load((String)MSGTEMPLATE, (String)"msgtype,msgchannel,msgtemplate", (QFilter[])filters, (String)"createdate asc");
        if (templatelArray != null && templatelArray.length > 0) {
            HashSet notifyTypeSets = new HashSet(10);
            Arrays.stream(templatelArray).forEach(bill -> {
                String msgchannel = bill.getString("msgchannel");
                String msgtemplate = bill.getLocaleString("msgtemplate").getLocaleValue();
                notifyTypeSets.add(msgchannel);
                msgTemplateMap.put(MSGCONTENT, msgtemplate);
            });
            msgTemplateMap.put(NOTIFYTYPE, notifyTypeSets.stream().collect(Collectors.joining(",")));
        }
        String msgcontent = (String)msgTemplateMap.get(MSGCONTENT);
        this.getModel().setValue(NOTIFYTYPE, msgTemplateMap.get(NOTIFYTYPE));
        this.getModel().setValue(MSGCONTENT, (Object)(msgcontent == null ? "" : msgcontent));
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        String entityName = this.getModel().getDataEntityType().getName();
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if (MSGCONTENT.equals(key)) {
            String msgcontent = (String)this.getView().getModel().getValue(MSGCONTENT);
            parameter.setFormId(MSG_CONTENT);
            parameter.setCaption(ResManager.loadKDString((String)"\u6d88\u606f\u5185\u5bb9\u7f16\u8f91", (String)"DmfInspectPlanMsgPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            parameter.setCustomParam("entityNumber", (Object)entityName);
            parameter.setCustomParam("FROM", (Object)"task");
            parameter.setCustomParam("value", (Object)msgcontent);
            parameter.setCustomParam("isInclude", (Object)"true");
            parameter.setCustomParam("includeFields", (Object)SerializationUtils.toJsonString(Arrays.asList("number", "name", "starttime", "endtime", "schprincipal")));
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, TEMPLATECALLBACK));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData != null && TEMPLATECALLBACK.equals(actionId)) {
            String content = null;
            Map dataMap = (Map)returnData;
            if (StringUtils.isNotBlank((CharSequence)((String)dataMap.get(CUSTOM_SUBJECT)))) {
                content = (String)dataMap.get(CUSTOM_SUBJECT);
            } else if (StringUtils.isBlank((CharSequence)((String)dataMap.get(CUSTOM_SUBJECT)))) {
                dataMap.remove(CUSTOM_SUBJECT);
                content = "";
            }
            this.getModel().setValue(MSGCONTENT, (Object)content);
        }
    }

    private void setMsgChannelItem() {
        DynamicObject[] channelArray = BusinessDataServiceHelper.load((String)MSGCHANNEL, (String)"id, number, name, enable", null);
        ArrayList comboItemList = new ArrayList(16);
        if (channelArray == null || channelArray.length <= 0) {
            return;
        }
        Arrays.stream(channelArray).forEach(channel -> {
            OrmLocaleValue name = (OrmLocaleValue)channel.get("name");
            String number = channel.getString("number");
            Boolean enable = channel.getBoolean("enable");
            if (enable.booleanValue() && !"sysnotice".equalsIgnoreCase(number)) {
                this.enableTypes.add(number);
                ComboItem comboItem = new ComboItem();
                comboItem.setValue(number);
                comboItem.setCaption(new LocaleString(name != null ? name.getLocaleValue() : ""));
                comboItemList.add(comboItem);
            }
        });
        ComboEdit combo = (ComboEdit)this.getView().getControl(NOTIFYTYPE);
        combo.setComboItems(comboItemList);
    }
}

