/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.CultureInfoUtils;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang.StringUtils;

public class DmfInspectUnitPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbmain", "tbar_cancleplugin", "tbar_validcondition", "tbar_cancleplugin1"});
        this.addClickListeners(new String[]{"validdescription"});
        EntryGrid validEntryGrid = (EntryGrid)this.getView().getControl("validentity");
        if (validEntryGrid != null) {
            validEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateAreaFilter(null);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("validdescription".equals(key)) {
            this.doModifyBizValid();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initEntityFilterGrid();
        String unitQFilterStr = this.getModel().getDataEntity().getString("areajson_tag");
        FilterGrid filterFilter = (FilterGrid)this.getControl("areafilter");
        if (StringUtils.isBlank((String)unitQFilterStr)) {
            filterFilter.SetValue(new FilterCondition());
        } else {
            FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)unitQFilterStr, FilterCondition.class);
            filterFilter.SetValue(condition);
        }
    }

    private void initEntityFilterGrid() {
        String billName = "entity";
        String filterGridField = "areafilter";
        DynamicObject bill = (DynamicObject)this.getModel().getValue(billName);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(filterGridField);
        if (bill == null) {
            filterGrid.setFilterColumns(Collections.emptyList());
        } else {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)bill.getString("number"));
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)dataEntityType);
            filterGrid.setEntityNumber(dataEntityType.getName());
            filterGrid.setFilterColumns(cols);
        }
        this.getView().updateView(filterGridField);
    }

    private void updateAreaFilter(DynamicObject srcBill) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("areafilter");
        if (srcBill == null) {
            filterGrid.setFilterColumns(Collections.emptyList());
        } else {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setEntityNumber(srcBill.getString("number"));
            this.initEntityFilterGrid();
        }
        this.getView().updateView("areafilter");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if ("entity".equals(name)) {
            DynamicObjectCollection validEntityList;
            int size;
            DynamicObject srcBill = (DynamicObject)newValue;
            this.updateAreaFilter(srcBill);
            if ((srcBill == null || newValue != oldValue) && (size = (validEntityList = this.getModel().getDataEntity(true).getDynamicObjectCollection("validentity")).size()) > 0) {
                for (int i = size - 1; i >= 0; --i) {
                    validEntityList.remove(i);
                }
                this.getView().updateView("validentity");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        IDataModel model = this.getModel();
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key)) {
            String sourceFs = this.getFilterGridCondition("areafilter");
            model.setValue("areajson_tag", (Object)sourceFs);
        }
        if ("cusparm".equals(key)) {
            int index = model.getEntryCurrentRowIndex("pluginentry");
            DynamicObject result = model.getDataEntity(true);
            DynamicObject resultEntry = (DynamicObject)result.getDynamicObjectCollection("pluginentry").get(index);
            FormShowParameter customParameter = new FormShowParameter();
            customParameter.getOpenStyle().setShowType(ShowType.Modal);
            customParameter.setFormId("msbd_customparameter");
            String customParameterStr = resultEntry.getString("customparameter_tag");
            if (!"".equals(customParameterStr)) {
                List customParameterList = SerializationUtils.fromJsonStringToList((String)customParameterStr, Map.class);
                customParameter.setCustomParam("customparameter", (Object)customParameterList);
            }
            customParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "customparameter"));
            this.getView().showForm(customParameter);
            e.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Object entity;
        super.itemClick(evt);
        IFormView view = this.getView();
        String barItemKey = evt.getItemKey();
        if (barItemKey.equalsIgnoreCase("baraddplugin")) {
            this.showAddPlugForm(view, this);
        }
        if (barItemKey.equalsIgnoreCase("barmodifyplugin")) {
            this.showModifyPlugForm(view, this);
        }
        if (barItemKey.equalsIgnoreCase("btnaddvalid")) {
            entity = this.getModel().getValue("entity");
            if (entity == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4f18\u5148\u9009\u62e9\u5bf9\u5e94\u5355\u636e\u3002", (String)"DmfInspectUnitPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                return;
            }
            this.doNewBizValid();
        }
        if (barItemKey.equalsIgnoreCase("barmodifyvalid") || "validdescription".equals(barItemKey)) {
            entity = this.getModel().getValue("entity");
            if (entity == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4f18\u5148\u9009\u62e9\u5bf9\u5e94\u5355\u636e\u3002", (String)"DmfInspectUnitPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                return;
            }
            this.doModifyBizValid();
        }
        if (barItemKey.equalsIgnoreCase("baraddms")) {
            this.doNewBizMicroService();
        }
        if (barItemKey.equalsIgnoreCase("barmodifyms")) {
            this.doModifyBizMicroService();
        }
    }

    public void entryRowDoubleClick(RowClickEvent e) {
        super.entryRowDoubleClick(e);
        EntryGrid entry = (EntryGrid)e.getSource();
        String entryKey = entry.getEntryKey();
        if ("validentity".equals(entryKey)) {
            this.doModifyBizValid();
        }
    }

    private void doModifyBizValid() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("validentity");
        int rowKey = grid.getEntryState().getFocusRow();
        boolean validEntity = this.showUpdateEntryTips(rowKey);
        if (!validEntity) {
            return;
        }
        FormShowParameter editValidRulePara = new FormShowParameter();
        editValidRulePara.getOpenStyle().setShowType(ShowType.Modal);
        editValidRulePara.setFormId("msbd_validationcondition");
        editValidRulePara.setCustomParam("Rule", this.getModel().getValue("validjson_tag", rowKey));
        ArrayList<List<Map<String, Object>>> editFormContext = new ArrayList<List<Map<String, Object>>>();
        editFormContext.add(this.buildDesignContext((DynamicObject)this.getModel().getValue("entity")));
        editValidRulePara.setCustomParam("MetaContext", editFormContext);
        editValidRulePara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "barmodifyvalid"));
        this.getView().showForm(editValidRulePara);
    }

    private boolean showUpdateEntryTips(int rowKey) {
        if (rowKey <= -1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u3002", (String)"DmfInspectUnitPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.closedCallBack(closedCallBackEvent.getActionId(), closedCallBackEvent.getReturnData());
    }

    private void closedCallBack(String sourceFldKey, Object returnData) {
        IFormView view = this.getView();
        if ("btnaddplug".equals(sourceFldKey)) {
            this.receiveNewPlug(view, returnData);
        } else if ("barmodifyplugin".equals(sourceFldKey)) {
            this.receiveModifyPlug(view, returnData);
        } else if ("btnaddvalid".equals(sourceFldKey)) {
            this.receiveNewBizVaild(returnData);
        } else if ("barmodifyvalid".equals(sourceFldKey)) {
            this.receiveModifyBizVaild(returnData);
        } else if ("baraddms".equals(sourceFldKey)) {
            this.receiveNewMs(returnData);
        } else if ("barmodifyms".equals(sourceFldKey)) {
            this.receiveModifyMs(returnData);
        } else if ("customparameter".equals(sourceFldKey)) {
            List methodParameterList = (List)returnData;
            if (returnData != null && methodParameterList.size() > 0) {
                String methodParameterListStr = SerializationUtils.toJsonString((Object)methodParameterList);
                int row = view.getModel().getEntryCurrentRowIndex("pluginentry");
                this.getModel().setValue("customparameter_tag", (Object)SerializationUtils.toJsonString((Object)methodParameterList), row);
                if (methodParameterListStr.length() > 255) {
                    methodParameterListStr = methodParameterListStr.substring(0, 252).concat("...");
                }
                this.getModel().setValue("customparameter", (Object)methodParameterListStr, row);
            } else if (methodParameterList != null && methodParameterList.size() == 0) {
                int row = view.getModel().getEntryCurrentRowIndex("pluginentry");
                this.getModel().setValue("customparameter_tag", null, row);
                this.getModel().setValue("customparameter", null, row);
            }
        }
    }

    private void receiveNewBizVaild(Object returnData) {
        if (returnData instanceof ConditionValidation) {
            ConditionValidation validnew = (ConditionValidation)returnData;
            validnew.setEnabled(true);
            int rowKey = this.getModel().createNewEntryRow("validentity");
            if (rowKey >= 0) {
                this.getModel().setValue("validdescription", validnew.getDescription().getItem(CultureInfoUtils.getDefaultLCId()), rowKey);
                this.getModel().setValue("validjson_tag", (Object)new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, new ArrayList())).serializeToString((Object)validnew, null), rowKey);
            }
        }
    }

    private void receiveModifyBizVaild(Object returnData) {
        if (returnData instanceof ConditionValidation) {
            ConditionValidation validedit = (ConditionValidation)returnData;
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("validentity");
            int selrowkey = grid.getEntryState().getFocusRow();
            if (selrowkey >= 0) {
                validedit.setEnabled(((Boolean)this.getModel().getValue("validenable")).booleanValue());
                this.getModel().setValue("validdescription", validedit.getDescription().getItem(CultureInfoUtils.getDefaultLCId()), selrowkey);
                this.getModel().setValue("validjson_tag", (Object)new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, new ArrayList())).serializeToString((Object)validedit, null), selrowkey);
            }
        }
    }

    private void doNewBizValid() {
        FormShowParameter addValidRulePara = new FormShowParameter();
        addValidRulePara.getOpenStyle().setShowType(ShowType.Modal);
        addValidRulePara.setFormId("msbd_validationcondition");
        ArrayList<List<Map<String, Object>>> formContext = new ArrayList<List<Map<String, Object>>>();
        formContext.add(this.buildDesignContext((DynamicObject)this.getModel().getValue("entity")));
        addValidRulePara.setCustomParam("MetaContext", formContext);
        addValidRulePara.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnaddvalid"));
        this.getView().showForm(addValidRulePara);
    }

    private void doNewBizMicroService() {
        FormShowParameter microservice = new FormShowParameter();
        microservice.getOpenStyle().setShowType(ShowType.Modal);
        microservice.setFormId("msbd_microservice");
        microservice.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "baraddms"));
        this.getView().showForm(microservice);
    }

    private void doModifyBizMicroService() {
        IDataModel model = this.getModel();
        FormShowParameter microservice = new FormShowParameter();
        microservice.getOpenStyle().setShowType(ShowType.Modal);
        microservice.setFormId("msbd_microservice");
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("msentry");
        int row = grid.getEntryState().getFocusRow();
        boolean msEntry = this.showUpdateEntryTips(row);
        if (!msEntry) {
            return;
        }
        HashMap<String, Object> msObj = new HashMap<String, Object>();
        msObj.put("bizapp", ((DynamicObject)model.getValue("bizappid", row)).getPkValue());
        msObj.put("msname", model.getValue("msimplclass", row));
        msObj.put("msmethodname", model.getValue("msmethodname", row));
        msObj.put("msparameterarray", model.getValue("msparameterarray", row));
        microservice.setCustomParam("ms", msObj);
        microservice.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "barmodifyms"));
        this.getView().showForm(microservice);
    }

    private String getFilterGridCondition(String gridName) {
        FilterGrid grid = (FilterGrid)this.getControl(gridName);
        if (grid == null) {
            return "";
        }
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        return SerializationUtils.toJsonString((Object)condition);
    }

    private void showAddPlugForm(IFormView view, AbstractFormPlugin plugin) {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "msbd_registerplugin");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "btnaddplug"));
        view.showForm(showParameter);
    }

    private void receiveNewMs(Object returnData) {
        IDataModel model = this.getModel();
        if (returnData != null) {
            Map msParams = (Map)returnData;
            model.createNewEntryRow("msentry");
            int row = model.getEntryRowCount("msentry");
            int index = row - 1;
            model.setValue("msenable", (Object)Boolean.TRUE, index);
            model.setValue("bizappid", msParams.get("bizappid"), index);
            model.setValue("bizcloud", msParams.get("bizcloud"), index);
            model.setValue("msname", msParams.get("msname"), index);
            model.setValue("msimplclass", msParams.get("msimplclass"), index);
            model.setValue("msmethodname", msParams.get("msmethodname"), index);
            model.setValue("msparameterarray", msParams.get("msparameterarray"), index);
        }
    }

    private void receiveModifyMs(Object returnData) {
        IDataModel model = this.getModel();
        if (returnData != null) {
            Map msParams = (Map)returnData;
            int row = model.getEntryCurrentRowIndex("msentry");
            model.setValue("msenable", (Object)Boolean.TRUE, row);
            model.setValue("bizappid", msParams.get("bizappid"), row);
            model.setValue("bizcloud", msParams.get("bizcloud"), row);
            model.setValue("msname", msParams.get("msname"), row);
            model.setValue("msimplclass", msParams.get("msimplclass"), row);
            model.setValue("msmethodname", msParams.get("msmethodname"), row);
            model.setValue("msparameterarray", msParams.get("msparameterarray"), row);
        }
    }

    private void receiveNewPlug(IFormView view, Object returnData) {
        if (returnData != null) {
            Map plugParams = (Map)returnData;
            Plugin crPlugin = DmfInspectUnitPlugin.convertToPlugin(plugParams);
            String json = SerializationUtils.toJsonString((Object)crPlugin);
            view.getModel().createNewEntryRow("pluginentry");
            int row = view.getModel().getEntryRowCount("pluginentry");
            int index = row - 1;
            view.getModel().setValue("pluginenable", (Object)crPlugin.isEnabled(), index);
            view.getModel().setValue("pluginclassurl", (Object)crPlugin.getClassName(), index);
            view.getModel().setValue("plugindescription", (Object)crPlugin.getDescription(), index);
            view.getModel().setValue("pluginclassname", (Object)crPlugin.getScriptNumber(), index);
            view.getModel().setValue("pluginjson", (Object)json, index);
        }
    }

    private static Plugin convertToPlugin(Map<String, Object> plugParams) {
        Plugin crPlugin = new Plugin();
        crPlugin.setClassName((String)plugParams.get("classname"));
        crPlugin.setEnabled(((Boolean)plugParams.get("enabled")).booleanValue());
        crPlugin.setDescription((String)plugParams.get("description"));
        crPlugin.setScriptNumber((String)plugParams.get("displayname"));
        crPlugin.setType(0);
        return crPlugin;
    }

    private void showModifyPlugForm(IFormView view, AbstractFormPlugin plugin) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("pluginentry");
        int row = grid.getEntryState().getFocusRow();
        boolean pluginEntry = this.showUpdateEntryTips(row);
        if (!pluginEntry) {
            return;
        }
        String json = (String)view.getModel().getValue("pluginjson", row);
        if (!StringUtils.isBlank((String)json)) {
            Plugin crPlugin = (Plugin)SerializationUtils.fromJsonString((String)json, Plugin.class);
            boolean enabled = (Boolean)view.getModel().getValue("pluginenable", row);
            crPlugin.setEnabled(enabled);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("msbd_registerplugin");
            Map<String, Object> currentPlugin = this.convertToParams(crPlugin);
            parameter.setCustomParam("rowkey", (Object)row);
            parameter.setCustomParam("plugin", currentPlugin);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "barmodifyplugin"));
            view.showForm(parameter);
        }
    }

    private void receiveModifyPlug(IFormView view, Object returnData) {
        if (returnData != null) {
            Map plugParams = (Map)returnData;
            int row = view.getModel().getEntryCurrentRowIndex("pluginentry");
            Plugin oldPlugin = DmfInspectUnitPlugin.convertToPlugin(plugParams);
            String json = SerializationUtils.toJsonString((Object)oldPlugin);
            view.getModel().setValue("pluginenable", (Object)oldPlugin.isEnabled(), row);
            view.getModel().setValue("pluginclassurl", (Object)oldPlugin.getClassName(), row);
            view.getModel().setValue("plugindescription", (Object)oldPlugin.getDescription(), row);
            view.getModel().setValue("pluginclassname", (Object)oldPlugin.getScriptNumber(), row);
            view.getModel().setValue("pluginjson", (Object)json, row);
        }
    }

    private Map<String, Object> convertToParams(Plugin crPlugin) {
        HashMap<String, Object> plugParams = new HashMap<String, Object>();
        plugParams.put("description", crPlugin.getDescription());
        plugParams.put("classname", crPlugin.getClassName());
        plugParams.put("enabled", crPlugin.isEnabled());
        plugParams.put("displayname", crPlugin.getScriptNumber());
        return plugParams;
    }

    private List<Map<String, Object>> buildDesignContext(DynamicObject entityBill) {
        ArrayList<Map<String, Object>> metaItems = new ArrayList<Map<String, Object>>(10);
        String entityBillId = MetadataDao.getIdByNumber((String)entityBill.getPkValue().toString(), (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityBillId, (MetaCategory)MetaCategory.Entity);
        for (EntityItem item : entityMetadata.getItems()) {
            HashMap<String, String> entityItem = new HashMap<String, String>(16);
            entityItem.put("_Type_", item.getClass().getSimpleName());
            entityItem.put("Id", item.getId());
            entityItem.put("ParentId", item.getParentId());
            entityItem.put("Key", item.getKey());
            entityItem.put("Name", item.getName().toString());
            metaItems.add(entityItem);
        }
        return metaItems;
    }
}

