/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin.echart;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.formplugin.echart.InspectCommonChartPlugin;

public class InspectPieAnalysisPlugin
extends InspectCommonChartPlugin {
    public void afterCreateNewData(EventObject e) {
        this.initMainInfo();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.initMainInfo();
        }
    }

    private void initMainInfo() {
        QFilter logQFilter = this.getQFilter();
        logQFilter.and(new QFilter("entryentity.entrystatus", "=", (Object)"C"));
        try (DataSet logList = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectlog", (String)"entryentity.inspectunit.warnlevel warnlevel,entryentity.inspectdetail inspectdetail", (QFilter[])logQFilter.toArray(), null);){
            BigDecimal A_totoalNum = new BigDecimal("0");
            BigDecimal B_totoalNum = new BigDecimal("0");
            BigDecimal C_totoalNum = new BigDecimal("0");
            for (Row row : logList) {
                Map inspectDetailMap;
                Integer exp;
                String entryStatus = row.getString("warnlevel");
                String inspectDetail = row.getString("inspectdetail");
                if (inspectDetail == null || "".equals(inspectDetail) || (exp = (Integer)(inspectDetailMap = (Map)SerializationUtils.fromJsonString((String)inspectDetail, Map.class)).get("inspect_unit_expnum")) == null) continue;
                BigDecimal normalNumTemp = new BigDecimal(exp);
                if ("A".equals(entryStatus)) {
                    A_totoalNum = A_totoalNum.add(normalNumTemp);
                    continue;
                }
                if ("B".equals(entryStatus)) {
                    B_totoalNum = B_totoalNum.add(normalNumTemp);
                    continue;
                }
                if (!"C".equals(entryStatus)) continue;
                C_totoalNum = C_totoalNum.add(normalNumTemp);
            }
            this.initPie(A_totoalNum, B_totoalNum, C_totoalNum);
            BigDecimal total = A_totoalNum.add(B_totoalNum).add(C_totoalNum);
            if (total.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal A_percent = A_totoalNum.divide(total, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                BigDecimal B_percent = B_totoalNum.divide(total, 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
                BigDecimal C_percent = new BigDecimal("100").subtract(A_percent).subtract(B_percent);
                this.setLabelApText("serexpper", ResManager.loadKDString((String)"\u4e25\u91cd\uff1a", (String)"InspectPieAnalysisPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]).concat(String.valueOf(C_percent.doubleValue())).concat("%"));
                this.setLabelApText("warnexpper", ResManager.loadKDString((String)"\u8b66\u544a\uff1a", (String)"InspectPieAnalysisPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]).concat(String.valueOf(B_percent.doubleValue())).concat("%"));
                this.setLabelApText("comexpper", ResManager.loadKDString((String)"\u4e00\u822c\uff1a", (String)"InspectPieAnalysisPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]).concat(String.valueOf(A_percent.doubleValue())).concat("%"));
            } else {
                this.setLabelApText("serexpper", ResManager.loadKDString((String)"\u4e25\u91cd\uff1a", (String)"InspectPieAnalysisPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]).concat("0%"));
                this.setLabelApText("warnexpper", ResManager.loadKDString((String)"\u8b66\u544a\uff1a", (String)"InspectPieAnalysisPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]).concat("0%"));
                this.setLabelApText("comexpper", ResManager.loadKDString((String)"\u4e00\u822c\uff1a", (String)"InspectPieAnalysisPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]).concat("0%"));
            }
            this.setLabelApText("comexpnum", String.valueOf(A_totoalNum.intValue()).concat(ResManager.loadKDString((String)"\u6761", (String)"InspectPieAnalysisPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])));
            this.setLabelApText("warnexpnum", String.valueOf(B_totoalNum.intValue()).concat(ResManager.loadKDString((String)"\u6761", (String)"InspectPieAnalysisPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])));
            this.setLabelApText("serexpnum", String.valueOf(C_totoalNum.intValue()).concat(ResManager.loadKDString((String)"\u6761", (String)"InspectPieAnalysisPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])));
        }
    }

    private void initPie(BigDecimal A_totoalNum, BigDecimal B_totoalNum, BigDecimal C_totoalNum) {
        ItemValue item3;
        ItemValue item2;
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        PieSeries series = pieChart.createPieSeries("");
        ItemValue item1 = new ItemValue(ResManager.loadKDString((String)"\u4e00\u822c", (String)"InspectPieAnalysisPlugin_6", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), (Number)A_totoalNum.intValue(), "#45DAD1");
        ItemValue[] items = new ItemValue[]{item1, item2 = new ItemValue(ResManager.loadKDString((String)"\u8b66\u544a", (String)"InspectPieAnalysisPlugin_5", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), (Number)B_totoalNum.intValue(), "#FFA600"), item3 = new ItemValue(ResManager.loadKDString((String)"\u4e25\u91cd", (String)"InspectPieAnalysisPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), (Number)C_totoalNum.intValue(), "#F57582")};
        series.setData(items);
        BigDecimal total = A_totoalNum.add(B_totoalNum).add(C_totoalNum);
        String seriesName = String.format(ResManager.loadKDString((String)"\u603b\u8ba1%s\u6761", (String)"InspectPieAnalysisPlugin_7", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), total.toString());
        pieChart.setName(new LocaleString(seriesName));
        series.setRadius("50%", "69%");
        pieChart.setTitlePropValue("x", (Object)0);
        pieChart.setTitlePropValue("y", (Object)0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("color", "#7F93BC");
        map.put("fontSize", 14);
        map.put("fontWeight", "lighter");
        pieChart.setTitlePropValue("textStyle", map);
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.top);
        label.setFormatter("{b}:{d}%");
        series.setLabel(label);
        pieChart.setShowTitle(true);
        pieChart.setShowTooltip(true);
        pieChart.refresh();
    }
}

