/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin.echart;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.GaugeChart;
import kd.bos.form.chart.GaugeSeries;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.radar.RadarAxis;
import kd.bos.form.chart.radar.RadarChart;
import kd.bos.form.chart.radar.RadarData;
import kd.bos.form.chart.radar.RadarIndicator;
import kd.bos.form.chart.radar.RadarSeries;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectDetailInfo;
import kd.mpscmm.msbd.datamanage.formplugin.echart.InspectCommonChartPlugin;

public class InspectRadarAnalysisPlugin
extends InspectCommonChartPlugin {
    public void afterCreateNewData(EventObject e) {
        Double[] valueData = this.getCurrentValue();
        this.initRadar(valueData);
        double average = Arrays.stream(valueData).mapToDouble(x -> x).average().getAsDouble();
        double averageValue = BigDecimal.valueOf(average).setScale(2, RoundingMode.HALF_UP).doubleValue();
        this.initGauge(averageValue);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            Double[] valueData = this.getCurrentValue();
            this.initRadar(valueData);
            double average = Arrays.stream(valueData).mapToDouble(x -> x).average().getAsDouble();
            double averageValue = BigDecimal.valueOf(average).setScale(2, RoundingMode.HALF_UP).doubleValue();
            this.initGauge(averageValue);
        }
    }

    private void initRadar(Double[] valueData) {
        RadarChart radarChart = (RadarChart)this.getControl("radarchartap");
        RadarAxis axis = new RadarAxis();
        HashMap<String, Object> textStyle = new HashMap<String, Object>(16);
        textStyle.put("color", "#8A8B99");
        textStyle.put("backgroundColor", "#1890FF");
        textStyle.put("borderRadius", 3);
        textStyle.put("padding", new Integer[]{0, 0, 10, 15});
        axis.setName(textStyle);
        HashMap splitArea = new HashMap(16);
        HashMap<String, String[]> color = new HashMap<String, String[]>(16);
        color.put("color", new String[]{"#161834"});
        splitArea.put("areaStyle", color);
        axis.setSplitArea(splitArea);
        ArrayList<RadarIndicator> indicator = new ArrayList<RadarIndicator>(16);
        int[] max = new int[]{100, 100, 100, 100, 100, 100};
        String[] initValue = InspectRadarAnalysisPlugin.getInitValue();
        for (int i = 0; i < initValue.length; ++i) {
            RadarIndicator radardata = new RadarIndicator(initValue[i]);
            radardata.setMax((Number)max[i]);
            indicator.add(radardata);
        }
        axis.setIndicator(indicator);
        HashMap<String, Object> axisline = new HashMap<String, Object>();
        axisline.put("backgroundColor", "#161834");
        axisline.put("fontSize", 12);
        axisline.put("color", "\t#8A8B99");
        axis.setName(axisline);
        radarChart.addRadarAxis(axis);
        radarChart.setShowTooltip(true);
        HashMap<String, Object> legendtextstyle = new HashMap<String, Object>();
        legendtextstyle.put("fontSize", 12);
        legendtextstyle.put("color", "#205AA7");
        radarChart.setLegendPropValue("textStyle", legendtextstyle);
        radarChart.setLegendPropValue("center", (Object)50);
        radarChart.setLegendPropValue("top", (Object)5);
        RadarSeries series = new RadarSeries();
        series.setType(ChartType.radar);
        RadarData radarData = new RadarData();
        radarData.setValue((Number[])valueData);
        radarData.setName("");
        series.addData(radarData);
        series.setItemColor("#1890FF");
        Label label = new Label();
        label.setShow(true);
        series.setLabel(label);
        radarChart.addRadarSeries(series);
        radarChart.bindData(null);
    }

    private void initGauge(Number number) {
        GaugeChart gauge = (GaugeChart)this.getControl("gaugechartap");
        GaugeSeries series = gauge.createSeries(ResManager.loadKDString((String)"\u4eea\u8868\u76d8", (String)"InspectRadarAnalysisPlugin_6", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        series.addData(new ItemValue(ResManager.loadKDString((String)"\u603b\u4f53\u8bc4\u5206", (String)"InspectRadarAnalysisPlugin_7", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), number));
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(0);
        list.add("45%");
        map.put("offsetCenter", list);
        map.put("fontSize", 16);
        map.put("color", "#1890FF");
        map.put("formatter", number);
        series.setDetail(map);
        HashMap<String, Object> titleMap = new HashMap<String, Object>();
        list = new ArrayList();
        list.add(0);
        list.add("70%");
        titleMap.put("offsetCenter", list);
        titleMap.put("fontSize", "16");
        titleMap.put("color", "#8A8B99");
        series.setPropValue("title", titleMap);
        HashMap axisLine = new HashMap();
        HashMap<String, Serializable> lineStyle = new HashMap<String, Serializable>();
        lineStyle.put("width", Integer.valueOf(16));
        ArrayList<List<Serializable>> colorlist = new ArrayList<List<Serializable>>();
        colorlist.add(Arrays.asList(0.3, "#F57582"));
        colorlist.add(Arrays.asList(0.7, "#FFA940"));
        colorlist.add(Arrays.asList(1, "#45DAD1"));
        lineStyle.put("color", colorlist);
        axisLine.put("lineStyle", lineStyle);
        series.setPropValue("axisLine", axisLine);
        HashMap<String, Integer> axisTick = new HashMap<String, Integer>();
        axisTick.put("length", 15);
        series.setPropValue("axisTick", axisTick);
        HashMap<String, Serializable> splitLine = new HashMap<String, Serializable>();
        splitLine.put("length", Integer.valueOf(10));
        HashMap<String, Object> splitLineStyle = new HashMap<String, Object>();
        splitLineStyle.put("color", "auto");
        splitLineStyle.put("width", 5);
        splitLine.put("lineStyle", splitLineStyle);
        series.setPropValue("splitLine", splitLine);
        HashMap<String, Object> pointer = new HashMap<String, Object>();
        pointer.put("length", "60%");
        pointer.put("width", 5);
        pointer.put("color", "#1890FF");
        HashMap<String, String> itemStyle = new HashMap<String, String>();
        itemStyle.put("color", "#1890FF");
        pointer.put("itemStyle", itemStyle);
        series.setPropValue("pointer", pointer);
        HashMap<String, Comparable<Boolean>> axisLabel = new HashMap<String, Comparable<Boolean>>();
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("distance", Integer.valueOf(10));
        series.setPropValue("axisLabel", axisLabel);
        gauge.refresh();
    }

    private Double[] getCurrentValue() {
        QFilter logQFilter = this.getQFilter();
        DataSet inspectLogList = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectlog", (String)"entryentity.inspectunit.dataqualitystandard dataqualitystandard ,entryentity.entrystatus entrystatus,entryentity.id id", (QFilter[])logQFilter.toArray(), null);
        DataSet logList = inspectLogList.groupBy(new String[]{"dataqualitystandard", "entrystatus"}).count("id").finish();
        ArrayList<InspectDetailInfo> dataList = new ArrayList<InspectDetailInfo>(16);
        for (Row row : logList) {
            String dataQualityStandard = row.getString("dataqualitystandard");
            String entryStatus = row.getString("entrystatus");
            Long id = row.getLong("id");
            dataList.add(new InspectDetailInfo(dataQualityStandard, entryStatus, id));
        }
        Map<String, Long> totalNumMap = dataList.stream().collect(Collectors.groupingBy(InspectDetailInfo::getDataQualityStandard, Collectors.summingLong(InspectDetailInfo::getExeNum)));
        HashMap<String, Long> normalNumMap = new HashMap<String, Long>(16);
        for (InspectDetailInfo inspectDetailInfo : dataList) {
            String checkStatus = inspectDetailInfo.getCheckStatus();
            if (!"D".equals(checkStatus)) continue;
            Long exeNum = inspectDetailInfo.getExeNum();
            normalNumMap.put(inspectDetailInfo.getDataQualityStandard(), exeNum);
        }
        Double[] valueData = new Double[6];
        List<String> dataStandardList = Arrays.asList("C", "B", "A", "D", "E", "F");
        for (int i = 0; i < dataStandardList.size(); ++i) {
            String standValue = dataStandardList.get(i);
            Long totalNum = totalNumMap.get(standValue);
            if (totalNum == null || totalNum == 0L) {
                valueData[i] = 100.0;
                continue;
            }
            Long normalNum = (Long)normalNumMap.get(standValue);
            if (normalNum == null || normalNum == 0L) {
                valueData[i] = 0.0;
                continue;
            }
            BigDecimal total = new BigDecimal(totalNum);
            BigDecimal normal = new BigDecimal(normalNum);
            BigDecimal percent = normal.divide(total, 2, RoundingMode.HALF_UP).multiply(new BigDecimal("100"));
            valueData[i] = percent.doubleValue();
        }
        return valueData;
    }

    private static String[] getInitValue() {
        return new String[]{ResManager.loadKDString((String)"\u51c6\u786e\u6027", (String)"InspectRadarAnalysisPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5b8c\u6574\u6027", (String)"InspectRadarAnalysisPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ResManager.loadKDString((String)"\u552f\u4e00\u6027", (String)"InspectRadarAnalysisPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5173\u8054\u6027", (String)"InspectRadarAnalysisPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00\u81f4\u6027", (String)"InspectRadarAnalysisPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53ca\u65f6\u6027", (String)"InspectRadarAnalysisPlugin_5", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0])};
    }
}

