/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.formplugin.home;

import java.lang.constant.Constable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectAnalysisInfo;
import kd.mpscmm.msbd.datamanage.common.util.DateUtils;
import kd.mpscmm.msbd.datamanage.formplugin.echart.InspectCommonChartPlugin;

public class InspectHistogramAnalysisPlugin
extends InspectCommonChartPlugin {
    public void afterCreateNewData(EventObject e) {
        CustomChart customchart = (CustomChart)this.getControl("customchartap");
        this.setHandlechartXaxisTick(customchart);
        this.setHandleChartData(customchart);
        customchart.setMargin(Position.right, "10px");
        customchart.setMargin(Position.top, "20px");
        customchart.setLegendPropValue("itemWidth", (Object)10);
        customchart.setLegendPropValue("itemHeight", (Object)10);
    }

    private Axis setHandlechartXaxisTick(CustomChart customchart) {
        Axis xaxis = customchart.createXAxis("", AxisType.category);
        ArrayList<String> xDimensions = new ArrayList<String>(16);
        for (int i = 0; i < 7; ++i) {
            xDimensions.add(DateUtils.getCurrentDateStr(i));
        }
        xaxis.setCategorys(xDimensions);
        xaxis.setPosition(Position.bottom);
        xaxis.setPropValue("nameGap", (Object)"10");
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        xaxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xaxis, "#999999");
        return xaxis;
    }

    private void setHandleChartData(CustomChart customchart) {
        Axis taskNumberAxis = customchart.createYAxis("", AxisType.value);
        taskNumberAxis.setPropValue("nameGap", (Object)"7");
        taskNumberAxis.setName(ResManager.loadKDString((String)"\u5355\u4f4d(\u6761)", (String)"InspectHistogramAnalysisPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
        customchart.setMargin(Position.left, "40");
        Map<String, Long[]> handleTaskData = this.getHandleChartData();
        List<String> colorList = this.getColorList();
        int colorIndex = 0;
        for (Map.Entry<String, Long[]> entry : handleTaskData.entrySet()) {
            String materialTypeName = entry.getKey();
            BarSeries expireSeries = customchart.createBarSeries(materialTypeName);
            expireSeries.setBarWidth("50px");
            expireSeries.setAnimationDuration(2000);
            Number[] data = entry.getValue();
            expireSeries.setColor(colorList.get(colorIndex));
            expireSeries.setData(data);
            Label label = new Label();
            label.setShow(false);
            expireSeries.setLabel(label);
            ++colorIndex;
        }
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        taskNumberAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        taskNumberAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(taskNumberAxis, "#999999");
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setLegendVertical(false);
        customchart.setShowTitle(true);
        customchart.setShowTooltip(true);
    }

    private List<String> getColorList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#67BF7F");
        list.add("#DF0029");
        return list;
    }

    private Map<String, Long[]> getHandleChartData() {
        HashMap<String, Long[]> map = new HashMap<String, Long[]>(16);
        Long[] normal = new Long[7];
        Long[] exp = new Long[7];
        LocalDateTime todayStart = LocalDateTime.of(LocalDate.now().minusDays(6L), LocalTime.MIN);
        LocalDateTime todayEnd = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
        QFilter qFilter = new QFilter("exetime", ">=", (Object)todayStart);
        qFilter.and(new QFilter("exetime", "<=", (Object)todayEnd));
        DataSet inspectLog = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msbd_inspectlog", (String)"exetime,entryentity.inspectdetail", (QFilter[])qFilter.toArray(), null);
        ArrayList<InspectAnalysisInfo> analysisInfoList = new ArrayList<InspectAnalysisInfo>(16);
        for (Row row : inspectLog) {
            Date exeTime = row.getDate("exetime");
            String inspectDetailStr = row.getString("entryentity.inspectdetail");
            if (inspectDetailStr == null || "".equals(inspectDetailStr)) continue;
            Map inspectDetail = (Map)SerializationUtils.fromJsonString((String)inspectDetailStr, Map.class);
            String bizDate = DateUtils.dateFormat(exeTime, ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"InspectHistogramAnalysisPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            Integer unitTotalNum = (Integer)inspectDetail.get("inspect_unit_totalnum");
            if (unitTotalNum == null) continue;
            Long totalNum = (long)unitTotalNum;
            Long expNum = (long)((Integer)inspectDetail.get("inspect_unit_expnum"));
            long normalNum = totalNum - expNum;
            analysisInfoList.add(new InspectAnalysisInfo(bizDate, totalNum, expNum, normalNum));
        }
        Map<String, Long> normalMap = analysisInfoList.stream().collect(Collectors.groupingBy(InspectAnalysisInfo::getInspectDate, Collectors.summingLong(InspectAnalysisInfo::getNormalNum)));
        for (int i = 0; i < 7; ++i) {
            String currentDateStr = DateUtils.getCurrentDateStr(i);
            Long num = normalMap.get(currentDateStr);
            normal[i] = num == null ? Long.valueOf(0L) : num;
        }
        map.put(ResManager.loadKDString((String)"\u6b63\u5e38", (String)"InspectHistogramAnalysisPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), normal);
        Map<String, Long> expMap = analysisInfoList.stream().collect(Collectors.groupingBy(m -> m.getInspectDate(), Collectors.summingLong(m -> m.getExpNum())));
        for (int i = 0; i < 7; ++i) {
            String currentDateStr = DateUtils.getCurrentDateStr(i);
            Long num = expMap.get(currentDateStr);
            exp[i] = num == null ? Long.valueOf(0L) : num;
        }
        map.put(ResManager.loadKDString((String)"\u5f02\u5e38", (String)"InspectHistogramAnalysisPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), exp);
        return map;
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

