/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.ap;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class FinApLockAndSettleFieldCheckPlugin
extends AbstractDmfPlugin {
    private static final Log logger = LogFactory.getLog(FinApLockAndSettleFieldCheckPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("id");
        fieldKeys.add("billno");
        fieldKeys.add("org");
        fieldKeys.add("pricetaxtotal");
        fieldKeys.add("unsettleamount");
        fieldKeys.add("settleamount");
        fieldKeys.add("settlestatus");
        fieldKeys.add("detailentry.e_pricetaxtotal");
        fieldKeys.add("detailentry.lockedamt");
        fieldKeys.add("detailentry.unlockamt");
        fieldKeys.add("detailentry.settledamt");
        fieldKeys.add("detailentry.unsettleamt");
        fieldKeys.add("planentity.planpricetax");
        fieldKeys.add("planentity.planlockedamt");
        fieldKeys.add("planentity.unplanlockamt");
        fieldKeys.add("planentity.plansettledamt");
        fieldKeys.add("planentity.unplansettleamt");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        inspectOptionInfo.setBizDataType(0);
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DynamicObject[] args) {
        Long orgId;
        logger.info("FinApLockAndSettleFieldCheckPlugin:\u63d2\u4ef6\u5de1\u68c0\u6267\u884c\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)FORMATTER.format(LocalDateTime.now()));
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(10);
        Map<Object, Object> apSettleParamMap = new HashMap(8);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        for (DynamicObject bill : args) {
            orgId = bill.getLong("org.id");
            orgIds.add(orgId);
        }
        apSettleParamMap = this.getApSettleParam(orgIds);
        for (DynamicObject bill : args) {
            orgId = bill.getLong("org.id");
            int apSettleParam = ObjectUtils.isEmpty((Object)apSettleParamMap.get(orgId)) ? 1 : (Integer)apSettleParamMap.get(orgId);
            this.checkLockAndSettleField(bill, apSettleParam, errorInfo);
        }
        logger.info("FinApLockAndSettleFieldCheckPlugin\uff1a\u672c\u6279\u6b21\u5de1\u68c0\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{}\uff0c\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfo.size());
        return errorInfo;
    }

    private Map<Long, Integer> getApSettleParam(List<Long> orgPks) {
        HashMap<Long, Integer> resultMap = new HashMap<Long, Integer>();
        AppParam appParam = new AppParam();
        appParam.setAppId("+HKZHSKFXOX");
        appParam.setViewType(OrgViewTypeEnum.IS_ACCOUNTING.getViewType());
        Map sysParamMap = SystemParamServiceHelper.loadBatchAppParameterByOrg((AppParam)appParam, orgPks);
        sysParamMap.forEach((id, value) -> {
            int result = Integer.parseInt(value.get("ap_003").toString());
            resultMap.put(Long.valueOf(id), result);
        });
        return resultMap;
    }

    private void checkLockAndSettleField(DynamicObject bill, int apSettleParam, List<OperateErrorInfo> errorInfo) {
        String billno = bill.getString("billno");
        Long billId = bill.getLong("id");
        String settleStatus = bill.getString("settlestatus");
        if ("unsettle".equals(settleStatus) || "settled".equals(settleStatus)) {
            this.compare(billno, bill, "pricetaxtotal", "unsettleamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, 0L);
            this.compare(billno, bill, "pricetaxtotal", "settleamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, 0L);
        }
        DynamicObjectCollection detailEntrys = bill.getDynamicObjectCollection("detailentry");
        BigDecimal detailEntryUnLockSum = BigDecimal.ZERO;
        BigDecimal detailEntryUnSettleSum = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntrys) {
            Long entryId = detailEntry.getLong("id");
            if (1 == apSettleParam) {
                this.compare(billno, detailEntry, "e_pricetaxtotal", "unsettleamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, detailEntry, "e_pricetaxtotal", "settledamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, detailEntry, "e_pricetaxtotal", "unsettleamt", "settledamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55(\u672a\u7ed3\u7b97\u91d1\u989d+\u5df2\u7ed3\u7b97\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, detailEntry, "e_pricetaxtotal", "unlockamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_5", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, detailEntry, "e_pricetaxtotal", "lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_6", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, detailEntry, "e_pricetaxtotal", "unlockamt", "lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55(\u672a\u9501\u5b9a\u91d1\u989d+\u5df2\u9501\u5b9a\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_7", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
            }
            detailEntryUnLockSum = detailEntryUnLockSum.add(detailEntry.getBigDecimal("unlockamt"));
            detailEntryUnSettleSum = detailEntryUnSettleSum.add(detailEntry.getBigDecimal("unsettleamt"));
        }
        DynamicObjectCollection planEntrys = bill.getDynamicObjectCollection("planentity");
        BigDecimal planEntryUnLockSum = BigDecimal.ZERO;
        BigDecimal planEntryUnSettleSum = BigDecimal.ZERO;
        for (DynamicObject planEntry : planEntrys) {
            Long entryId = planEntry.getLong("id");
            if (2 == apSettleParam) {
                this.compare(billno, planEntry, "planpricetax", "unplansettleamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_8", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, planEntry, "planpricetax", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_9", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, planEntry, "planpricetax", "unplansettleamt", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55(\u672a\u7ed3\u7b97\u91d1\u989d+\u5df2\u7ed3\u7b97\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_10", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, planEntry, "planpricetax", "unplanlockamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_11", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, planEntry, "planpricetax", "planlockedamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_12", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, planEntry, "planpricetax", "unplanlockamt", "planlockedamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55(\u672a\u9501\u5b9a\u91d1\u989d+\u5df2\u9501\u5b9a\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_13", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, planEntry, "planlockedamt", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5df2\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5df2\u9501\u5b9a\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_14", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
                this.compare(billno, planEntry, "unplansettleamt", "unplanlockamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u672a\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5c0f\u4e8e\u672a\u9501\u5b9a\u91d1\u989d\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_15", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, entryId);
            }
            planEntryUnLockSum = planEntryUnLockSum.add(planEntry.getBigDecimal("unplanlockamt"));
            planEntryUnSettleSum = planEntryUnSettleSum.add(planEntry.getBigDecimal("unplansettleamt"));
        }
        if ("unsettle".equals(settleStatus) || "settled".equals(settleStatus)) {
            this.compare(billno, detailEntryUnLockSum, planEntryUnLockSum, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u672a\u9501\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0e\u8ba1\u5212\u884c\u672a\u9501\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_16", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, 0L);
            this.compare(billno, detailEntryUnSettleSum, planEntryUnSettleSum, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0e\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"FinApLockAndSettleFieldCheckPlugin_17", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), errorInfo, billId, 0L);
        }
    }

    private void compare(String billNo, DynamicObject bill, String amountKey1, String amountKey2, String msg, List<OperateErrorInfo> errorInfo, Long billId, Long entryId) {
        BigDecimal amount2;
        BigDecimal amount1 = bill.getBigDecimal(amountKey1);
        if (amount1.multiply(amount2 = bill.getBigDecimal(amountKey2)).compareTo(BigDecimal.ZERO) >= 0) {
            if (amount1.abs().compareTo(amount2.abs()) < 0 && amount2.abs().subtract(amount1.abs()).abs().compareTo(BigDecimal.valueOf(0.1)) >= 0) {
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, billId, entryId, billNo));
            }
        } else if (amount2.abs().compareTo(BigDecimal.valueOf(0.1)) > 0) {
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, billId, entryId, billNo));
        }
    }

    private void compare(String billNo, DynamicObject bill, String amountKey1, String amountKey2, String amountKey3, String msg, List<OperateErrorInfo> errorInfo, Long billId, Long entryId) {
        BigDecimal amount3;
        BigDecimal amount1 = bill.getBigDecimal(amountKey1);
        BigDecimal amount2 = bill.getBigDecimal(amountKey2);
        if (amount2.add(amount3 = bill.getBigDecimal(amountKey3)).subtract(amount1).compareTo(BigDecimal.ZERO) != 0) {
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, billId, entryId, billNo));
        }
    }

    private void compare(String billNo, BigDecimal amount1, BigDecimal amount2, String msg, List<OperateErrorInfo> errorInfo, Long billId, Long entryId) {
        BigDecimal subtract = amount1.abs().subtract(amount2.abs());
        if (amount1.multiply(amount2).compareTo(BigDecimal.ZERO) < 0 || subtract.abs().subtract(new BigDecimal("0.1")).compareTo(BigDecimal.ZERO) > 0) {
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, billId, entryId, billNo));
        }
    }
}

