/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;

public class ApWriteBackScmcHelper {
    private static final Log logger = LogFactory.getLog(ApWriteBackScmcHelper.class);
    private static int count = 0;

    public static List<Map<String, Object>> writeBackHeadPaidAmt(List<Map<String, Object>> params) {
        if (params == null || params.isEmpty()) {
            return new ArrayList<Map<String, Object>>(2);
        }
        Object accessType = params.get(0).get("accessType");
        logger.info("writeBackHeadPaidAmt - params : " + params + " accessType:" + accessType);
        Map<Long, Map<String, BigDecimal>> corePrePayMap = ApWriteBackScmcHelper.processCasPayBill(params);
        logger.info("writeBackHeadPaidAmt - corePrePayMap : " + corePrePayMap);
        Map<String, Map<String, Object>> settleAmountMap = ApWriteBackScmcHelper.processSettleRecord(params);
        logger.info("writeBackHeadPaidAmt - settleAmountMap : " + settleAmountMap);
        return ApWriteBackScmcHelper.writeBackHeadPaidAmtMergeParam(corePrePayMap, settleAmountMap);
    }

    public static List<Map<String, Object>> writeBackPayPlanAmt(List<Map<String, Object>> params) {
        if (params == null || params.isEmpty()) {
            return new ArrayList<Map<String, Object>>(2);
        }
        logger.info("writeBackPayPlanAmt - params : " + params);
        Map<String, Map<String, Object>> result = ApWriteBackScmcHelper.getInitResult(params);
        HashSet<Long> mainBillIds = new HashSet<Long>(64);
        HashSet<Long> mainBillEntryIds = new HashSet<Long>(64);
        for (Map<String, Object> param : params) {
            mainBillIds.add((Long)param.get("mainbillid"));
            mainBillEntryIds.add((Long)param.get("mainbillentryid"));
        }
        QFilter qFilter = new QFilter("entry.e_corebillid", "in", mainBillIds);
        qFilter.and("entry.e_corebillentryid", "in", mainBillEntryIds);
        logger.info("writeBackPayPlanAmt - result.values()_0 : " + result.values());
        ApWriteBackScmcHelper.processOrderPayPlan4PayBill(qFilter, result);
        logger.info("writeBackPayPlanAmt - result.values()_2 : " + result.values());
        return new ArrayList<Map<String, Object>>(result.values());
    }

    public static List<Map<String, Object>> constructWriteBackScmcParam(List<Map<String, Object>> param) {
        if (param == null || param.isEmpty()) {
            return new ArrayList<Map<String, Object>>(2);
        }
        logger.info("constructWriteBackPurParam \uff1a " + param);
        HashMap<String, Map<String, Object>> writeBackParamMap = new HashMap<String, Map<String, Object>>(64);
        for (Map<String, Object> inParam : param) {
            HashMap<String, Object> writeBackParam = new HashMap<String, Object>(8);
            Object mainBillId = inParam.get("mainbillid");
            Object mainBillEntryId = inParam.get("mainbillentryid");
            writeBackParam.put("mainbillid", mainBillId);
            writeBackParam.put("mainbillentryid", mainBillEntryId);
            writeBackParam.put("baseqty", BigDecimal.ZERO);
            writeBackParam.put("amount", BigDecimal.ZERO);
            writeBackParam.put("qty", BigDecimal.ZERO);
            writeBackParamMap.put(String.valueOf(mainBillId).concat("_").concat(String.valueOf(mainBillEntryId)), writeBackParam);
        }
        Map<Long, List<Row>> blueBillMap = ApWriteBackScmcHelper.processFinApBill(param, writeBackParamMap);
        logger.info("writeBackParamMap_1" + writeBackParamMap);
        ApWriteBackScmcHelper.processApSelfBill(writeBackParamMap, blueBillMap);
        logger.info("writeBackParamMap_2" + writeBackParamMap);
        return new ArrayList<Map<String, Object>>(writeBackParamMap.values());
    }

    private static Map<String, Map<String, Object>> processSettleRecord(List<Map<String, Object>> params) {
        Map<String, Map<String, Object>> result = ApWriteBackScmcHelper.getInitResult(params);
        Object accessType = params.get(0).get("accessType");
        if ("conm".equals(accessType)) {
            return result;
        }
        HashSet<Long> mainBillIds = new HashSet<Long>(64);
        HashSet<Long> orgIds = new HashSet<Long>(64);
        for (Map<String, Object> param : params) {
            orgIds.add((Long)param.get("settleorgid"));
            mainBillIds.add((Long)param.get("mainbillid"));
        }
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("detailentry.corebillid", "in", mainBillIds);
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"queryFinApBill", (String)"ap_finapbill", (String)"id,org,asstacttype,asstact,detailentry.corebillid corebillid,detailentry.corebillentryid corebillentryid,currency,pricetaxtotal,detailentry.e_pricetaxtotal e_pricetaxtotal,detailentry.id detailentryId,detailentry.corebilltype corebilltype", (QFilter[])new QFilter[]{filter}, (String)"bizdate");
        HashMap<Long, List<Row>> finApMap = new HashMap<Long, List<Row>>(64);
        HashMap<Long, Row> finApEntryMap = new HashMap<Long, Row>(64);
        HashSet<Long> currencyIds = new HashSet<Long>(32);
        for (Row finApRow : finApDataSet.copy()) {
            Boolean internalCompany;
            String key = String.valueOf(finApRow.getLong("corebillid")).concat("_").concat(String.valueOf(finApRow.getLong("corebillentryid")));
            Map<String, Object> writeParam = result.get(key);
            if (writeParam == null || Boolean.TRUE.equals(internalCompany = (Boolean)writeParam.get("internal_company")) && finApRow.getLong("asstact").compareTo((Long)writeParam.get("asstid")) != 0) continue;
            Long billId = finApRow.getLong("id");
            List details = finApMap.getOrDefault(billId, new ArrayList(2));
            details.add(finApRow);
            finApMap.put(billId, details);
            finApEntryMap.put(finApRow.getLong("detailentryId"), finApRow);
            currencyIds.add(finApRow.getLong("currency"));
        }
        if (finApMap.isEmpty()) {
            return result;
        }
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((Object[])currencyIds.toArray(new Long[0]), (String)"bd_currency");
        if (currencyMap == null || currencyMap.isEmpty()) {
            return result;
        }
        ApWriteBackScmcHelper.processRecordByFinMain(finApMap, finApEntryMap, result, currencyMap);
        ApWriteBackScmcHelper.processRecordByFinAsst(finApMap, finApEntryMap, result, currencyMap);
        return result;
    }

    private static Map<Long, Map<String, BigDecimal>> processCasPayBill(List<Map<String, Object>> params) {
        Object accessType = params.get(0).get("accessType");
        HashMap<Long, Map<String, BigDecimal>> result = new HashMap<Long, Map<String, BigDecimal>>(32);
        HashSet<Long> mainBillIds = new HashSet<Long>(64);
        for (Map<String, Object> param : params) {
            mainBillIds.add((Long)param.get("mainbillid"));
        }
        QFilter filter = new QFilter("entry.e_corebillid", "in", mainBillIds);
        DataSet payBillDataSet = QueryServiceHelper.queryDataSet((String)"processCasPayBill", (String)"cas_paybill", (String)"id,entry.e_payableamt e_payableamt,entry.e_corebillid e_corebillid,paymenttype.biztype biztype,entry.e_corebillentryid e_corebillentryid,entry.id entryId,billstatus,entry.e_unsettledamt e_unsettledamt", (QFilter[])new QFilter[]{filter}, (String)"bizdate");
        if (!payBillDataSet.hasNext()) {
            return result;
        }
        HashSet<Long> casPayBillIds = new HashSet<Long>(64);
        HashMap<Long, Row> casPayRowMap = new HashMap<Long, Row>(64);
        for (Row payRow : payBillDataSet.copy()) {
            String bizType = payRow.getString("biztype");
            casPayBillIds.add(payRow.getLong("id"));
            Long eCoreBillId = payRow.getLong("e_corebillid");
            HashMap<String, BigDecimal> amountMap = (HashMap<String, BigDecimal>)result.get(eCoreBillId);
            if (amountMap == null) {
                amountMap = new HashMap<String, BigDecimal>(2);
                amountMap.put("paidpreallamount", BigDecimal.ZERO);
                amountMap.put("paidallamount", BigDecimal.ZERO);
            }
            BigDecimal paidPreAllAmount = (BigDecimal)amountMap.get("paidpreallamount");
            BigDecimal paidAllAmount = (BigDecimal)amountMap.get("paidallamount");
            if ("conm".equals(accessType) && "D".equals(payRow.getString("billstatus"))) {
                BigDecimal unSettleAmt = payRow.getBigDecimal("e_unsettledamt");
                amountMap.put("paidallamount", paidAllAmount.add(unSettleAmt));
                amountMap.put("paidpreallamount", paidPreAllAmount.add(unSettleAmt));
            }
            if (!"conm".equals(accessType) && Arrays.asList("D", "F", "I").contains(payRow.getString("billstatus"))) {
                BigDecimal ePayableAmt = payRow.getBigDecimal("e_payableamt");
                if ("202".equals(bizType)) {
                    amountMap.put("paidpreallamount", paidPreAllAmount.add(ePayableAmt));
                }
                amountMap.put("paidallamount", paidAllAmount.add(ePayableAmt));
            }
            result.put(eCoreBillId, amountMap);
            casPayRowMap.put(payRow.getLong("entryId"), payRow);
        }
        if ("conm".equals(accessType)) {
            return result;
        }
        DataSet settleRecords = QueryServiceHelper.queryDataSet((String)"queryCasRecord", (String)"ap_settlerecord", (String)"totalsettleamt,mainbillid,mainbillentryid,settlerelation", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", casPayBillIds), new QFilter("settlerelation", "in", Arrays.asList("payself", "payrecsettle"))}, (String)"mainbizdate");
        if (!settleRecords.hasNext()) {
            return result;
        }
        for (Row settleRecord : settleRecords) {
            Row payRow = (Row)casPayRowMap.get(settleRecord.getLong("mainbillentryid"));
            BigDecimal totalSettleAmt = settleRecord.getBigDecimal("totalsettleamt");
            if (payRow == null) continue;
            Long eCoreBillId = payRow.getLong("e_corebillid");
            HashMap<String, BigDecimal> amountMap = (HashMap<String, BigDecimal>)result.get(eCoreBillId);
            if (amountMap == null) {
                amountMap = new HashMap<String, BigDecimal>(2);
                amountMap.put("paidpreallamount", BigDecimal.ZERO);
                amountMap.put("paidallamount", BigDecimal.ZERO);
            }
            BigDecimal paidAllAmount = (BigDecimal)amountMap.get("paidallamount");
            BigDecimal paidPreAllAmount = (BigDecimal)amountMap.get("paidpreallamount");
            if ("202".equals(payRow.getString("biztype"))) {
                amountMap.put("paidpreallamount", paidPreAllAmount.add(totalSettleAmt.negate()));
            }
            amountMap.put("paidallamount", paidAllAmount.add(totalSettleAmt.negate()));
        }
        return result;
    }

    private static void processRecordByFinMain(Map<Long, List<Row>> finApMap, Map<Long, Row> finApEntryMap, Map<String, Map<String, Object>> result, Map<Object, DynamicObject> currencyMap) {
        List recordRows;
        QFilter filter = new QFilter("mainbillid", "in", finApMap.keySet());
        filter.and("settlerelation", "in", Arrays.asList("appaysettle", "aparsettle", "paytrans", "aprecsettle", "liqsettle"));
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)"queryApSettleRecord", (String)"ap_settlerecord", (String)"totalsettleamt,settlerelation,settleentry,entry.settleamt settleamt,entry.billid billid,mainbillid,entry.billentryid billentryid,mainbillentryid,entry.e_billentity e_billentity,id,entry.id entryId", (QFilter[])new QFilter[]{filter}, (String)"mainbizdate");
        if (!recordDataSet.hasNext()) {
            return;
        }
        HashSet<Long> asstBillIds = new HashSet<Long>(64);
        HashMap<Object, List> recordMap = new HashMap<Object, List>(64);
        for (Row recordRow : recordDataSet.copy()) {
            if ("appaysettle".equals(recordRow.getString("settlerelation")) || "aprecsettle".equals(recordRow.getString("settlerelation"))) {
                asstBillIds.add(recordRow.getLong("billid"));
            }
            Long recordId = recordRow.getLong("id");
            recordRows = recordMap.getOrDefault(recordId, new ArrayList(2));
            recordRows.add(recordRow);
            recordMap.put(recordId, recordRows);
        }
        HashMap<Long, Row> asstRowMap = new HashMap<Long, Row>(64);
        if (!asstBillIds.isEmpty()) {
            DataSet casPayDataSet = QueryServiceHelper.queryDataSet((String)"queryCasPayBill", (String)"cas_paybill", (String)"id,paymenttype.biztype biztype,entry.e_corebillid e_corebillid,entry.id entryId,sourcebilltype,sourcebillid,entry.e_corebilltype e_corebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIds)}, (String)"bizdate");
            for (Object casPayRow : casPayDataSet.copy()) {
                asstRowMap.put(casPayRow.getLong("entryId"), (Row)casPayRow);
            }
            DataSet paidBillDataSet = QueryServiceHelper.queryDataSet((String)"queryPaidBill", (String)"ap_paidbill", (String)"id,paymenttype.biztype biztype,entry.id entryId", (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIds)}, (String)"bizdate");
            for (Object paidBillRow : paidBillDataSet.copy()) {
                asstRowMap.put(paidBillRow.getLong("entryId"), (Row)paidBillRow);
            }
            DataSet casRecDataSet = QueryServiceHelper.queryDataSet((String)"queryCasRecBill", (String)"cas_recbill", (String)"id,receivingtype.biztype biztype,entry.id entryId", (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIds)}, (String)"bizdate");
            for (Row recBillRow : casRecDataSet.copy()) {
                asstRowMap.put(recBillRow.getLong("entryId"), recBillRow);
            }
        }
        for (Map.Entry longListEntry : recordMap.entrySet()) {
            String key;
            Map<String, Object> writeBackParam;
            Long currencyId;
            DynamicObject currency;
            recordRows = (List)longListEntry.getValue();
            if (recordRows == null || recordRows.size() == 0) continue;
            Row record = (Row)recordRows.get(0);
            String settleRelation = record.getString("settlerelation");
            long mainBillId = record.getLong("mainbillid");
            List<Row> finApBill = finApMap.get(mainBillId);
            if (finApBill == null || finApBill.isEmpty() || (currency = currencyMap.get(currencyId = finApBill.get(0).getLong("currency"))) == null) continue;
            BigDecimal totalSettleAmt = record.getBigDecimal("totalsettleamt");
            BigDecimal entrySettleTotal = BigDecimal.ZERO;
            for (Object recordRow : recordRows) {
                entrySettleTotal = entrySettleTotal.add(recordRow.getBigDecimal("settleamt"));
            }
            boolean isPlan = "2".equals(record.getString("settleentry"));
            if (isPlan) {
                Object recordRow;
                count = 0;
                recordRow = finApBill.iterator();
                while (recordRow.hasNext()) {
                    Row detailEntry = (Row)recordRow.next();
                    if (BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("e_pricetaxtotal")) == 0) continue;
                    ++count;
                }
                BigDecimal remainDisDetailAmt = totalSettleAmt;
                HashMap<Long, BigDecimal> recordEntryUseAmtMap = new HashMap<Long, BigDecimal>(8);
                for (Row detailEntry : finApBill) {
                    String coreBillType = detailEntry.getString("corebilltype");
                    BigDecimal detailSettleAmt = ApWriteBackScmcHelper.allocationAmtByPlan(detailEntry, currencyMap, remainDisDetailAmt, totalSettleAmt);
                    remainDisDetailAmt = remainDisDetailAmt.subtract(detailSettleAmt);
                    String key2 = String.valueOf(detailEntry.getLong("corebillid")).concat("_").concat(String.valueOf(detailEntry.getLong("corebillentryid")));
                    Map<String, Object> writeBackParam2 = result.get(key2);
                    if (writeBackParam2 == null || !detailEntry.getLong("org").equals((Long)writeBackParam2.get("settleorgid"))) continue;
                    BigDecimal remainSettleEntryAmt = detailSettleAmt;
                    for (int i = 0; i < recordRows.size(); ++i) {
                        Row recordRow2 = (Row)recordRows.get(i);
                        BigDecimal disposeAmt = detailSettleAmt;
                        BigDecimal entrySettleAmt = recordRow2.getBigDecimal("settleamt");
                        long asstBillEntryId = recordRow2.getLong("billentryid");
                        long settleEntryId = recordRow2.getLong("entryId");
                        BigDecimal recordEntryUseAmt = recordEntryUseAmtMap.getOrDefault(settleEntryId, BigDecimal.ZERO);
                        disposeAmt = count == 0 ? (entrySettleAmt.signum() != totalSettleAmt.signum() ? entrySettleAmt.negate().subtract(recordEntryUseAmt) : entrySettleAmt.subtract(recordEntryUseAmt)) : (i == recordRows.size() - 1 ? remainSettleEntryAmt : detailSettleAmt.multiply(entrySettleAmt).divide(entrySettleTotal, currency.getInt("amtprecision"), RoundingMode.HALF_UP));
                        if (disposeAmt.abs().add(recordEntryUseAmt.abs()).compareTo(entrySettleAmt.abs()) > 0) {
                            disposeAmt = totalSettleAmt.signum() != entrySettleAmt.signum() ? entrySettleAmt.abs().subtract(recordEntryUseAmt.abs()).negate() : entrySettleAmt.subtract(recordEntryUseAmt);
                        }
                        remainSettleEntryAmt = remainSettleEntryAmt.subtract(disposeAmt);
                        recordEntryUseAmtMap.put(settleEntryId, disposeAmt.add(recordEntryUseAmt));
                        BigDecimal paidAllAmount = (BigDecimal)writeBackParam2.get("paidallamount");
                        BigDecimal paidPreAllAmount = (BigDecimal)writeBackParam2.get("paidpreallamount");
                        Row asstRow = (Row)asstRowMap.get(asstBillEntryId);
                        if (asstRow != null && "appaysettle".equals(settleRelation)) {
                            String asstEntity = recordRow2.getString("e_billentity");
                            if ("cas_paybill".equals(asstEntity)) {
                                String eCoreBillType = asstRow.getString("e_corebilltype");
                                Long coreBillId = asstRow.getLong("e_corebillid");
                                if (coreBillId == 0L || !ApWriteBackScmcHelper.equals(eCoreBillType, coreBillType)) {
                                    if ("202".equals(asstRow.getString("biztype"))) {
                                        writeBackParam2.put("paidpreallamount", paidPreAllAmount.add(disposeAmt));
                                    }
                                    writeBackParam2.put("paidallamount", paidAllAmount.add(disposeAmt));
                                }
                            } else {
                                if ("202".equals(asstRow.getString("biztype"))) {
                                    writeBackParam2.put("paidpreallamount", paidPreAllAmount.add(disposeAmt));
                                }
                                writeBackParam2.put("paidallamount", paidAllAmount.add(disposeAmt));
                            }
                        }
                        if (asstRow != null && "aprecsettle".equals(settleRelation) && "103".equals(asstRow.getString("biztype"))) {
                            writeBackParam2.put("paidpreallamount", paidPreAllAmount.add(disposeAmt));
                        }
                        if (!"aparsettle".equals(settleRelation) && !"paytrans".equals(settleRelation) && !"aprecsettle".equals(settleRelation) && !"liqsettle".equals(settleRelation)) continue;
                        writeBackParam2.put("paidallamount", paidAllAmount.add(disposeAmt));
                    }
                }
                continue;
            }
            long mainBillEntryId = record.getLong("mainbillentryid");
            Row finEntry = finApEntryMap.get(mainBillEntryId);
            if (finEntry == null || (writeBackParam = result.get(key = String.valueOf(finEntry.getLong("corebillid")).concat("_").concat(String.valueOf(finEntry.getLong("corebillentryid"))))) == null || !finEntry.getLong("org").equals((Long)writeBackParam.get("settleorgid"))) continue;
            String coreBillType = finEntry.getString("corebilltype");
            BigDecimal remainingAmt = totalSettleAmt;
            for (int i = 0; i < recordRows.size(); ++i) {
                Row recordRow = (Row)recordRows.get(i);
                BigDecimal recordEntrySettleAmt = totalSettleAmt;
                if (i == recordRows.size() - 1) {
                    recordEntrySettleAmt = remainingAmt;
                } else {
                    recordEntrySettleAmt = totalSettleAmt.multiply(recordRow.getBigDecimal("settleamt")).divide(entrySettleTotal, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    remainingAmt = remainingAmt.subtract(recordEntrySettleAmt);
                }
                long asstBillEntryId = recordRow.getLong("billentryid");
                BigDecimal paidAllAmount = (BigDecimal)writeBackParam.get("paidallamount");
                BigDecimal paidPreAllAmount = (BigDecimal)writeBackParam.get("paidpreallamount");
                Row asstRow = (Row)asstRowMap.get(asstBillEntryId);
                if (asstRow != null && "appaysettle".equals(settleRelation)) {
                    String asstEntity = recordRow.getString("e_billentity");
                    if ("cas_paybill".equals(asstEntity)) {
                        String eCoreBillType = asstRow.getString("e_corebilltype");
                        Long coreBillId = asstRow.getLong("e_corebillid");
                        if (coreBillId == 0L || !ApWriteBackScmcHelper.equals(eCoreBillType, coreBillType)) {
                            if ("202".equals(asstRow.getString("biztype"))) {
                                writeBackParam.put("paidpreallamount", paidPreAllAmount.add(recordEntrySettleAmt));
                            }
                            writeBackParam.put("paidallamount", paidAllAmount.add(recordEntrySettleAmt));
                        }
                    } else {
                        if ("202".equals(asstRow.getString("biztype"))) {
                            writeBackParam.put("paidpreallamount", paidPreAllAmount.add(recordEntrySettleAmt));
                        }
                        writeBackParam.put("paidallamount", paidAllAmount.add(recordEntrySettleAmt));
                    }
                }
                if (asstRow != null && "aprecsettle".equals(settleRelation) && "103".equals(asstRow.getString("biztype"))) {
                    writeBackParam.put("paidpreallamount", paidPreAllAmount.add(recordEntrySettleAmt));
                }
                if (!"aparsettle".equals(settleRelation) && !"paytrans".equals(settleRelation) && !"aprecsettle".equals(settleRelation) && !"liqsettle".equals(settleRelation)) continue;
                writeBackParam.put("paidallamount", paidAllAmount.add(recordEntrySettleAmt));
            }
        }
    }

    private static List<Map<String, Object>> writeBackHeadPaidAmtMergeParam(Map<Long, Map<String, BigDecimal>> corePrePayMap, Map<String, Map<String, Object>> settleAmountMap) {
        HashMap<Long, Map> result = new HashMap<Long, Map>(64);
        for (Map.Entry<String, Map<String, Object>> recordEntry : settleAmountMap.entrySet()) {
            Map<String, Object> recordValue = recordEntry.getValue();
            Long mainBillId = (Long)recordValue.get("mainbillid");
            Map<String, BigDecimal> prePayMap = corePrePayMap.get(mainBillId);
            Map writeBackParam = result.getOrDefault(mainBillId, new HashMap(2));
            BigDecimal paidPreAllAmount = writeBackParam.getOrDefault("paidpreallamount", BigDecimal.ZERO);
            BigDecimal paidAllAmount = writeBackParam.getOrDefault("paidallamount", BigDecimal.ZERO);
            paidPreAllAmount = paidPreAllAmount.add((BigDecimal)recordValue.getOrDefault("paidpreallamount", BigDecimal.ZERO));
            paidAllAmount = paidAllAmount.add((BigDecimal)recordValue.getOrDefault("paidallamount", BigDecimal.ZERO));
            writeBackParam.put("paidpreallamount", paidPreAllAmount);
            writeBackParam.put("paidallamount", paidAllAmount);
            if (prePayMap != null) {
                writeBackParam.put("paidpreallamount", paidPreAllAmount.add(prePayMap.getOrDefault("paidpreallamount", BigDecimal.ZERO)));
                writeBackParam.put("paidallamount", paidAllAmount.add(prePayMap.getOrDefault("paidallamount", BigDecimal.ZERO)));
            }
            writeBackParam.put("mainbillid", mainBillId);
            result.put(mainBillId, writeBackParam);
            corePrePayMap.remove(mainBillId);
        }
        logger.info("writeBackHeadPaidAmtMergeParam - finalparam : " + result.values());
        return new ArrayList<Map<String, Object>>(result.values());
    }

    private static void processRecordByFinAsst(Map<Long, List<Row>> finApMap, Map<Long, Row> finApEntryMap, Map<String, Map<String, Object>> result, Map<Object, DynamicObject> currencyMap) {
        QFilter filter = new QFilter("entry.billid", "in", finApMap.keySet());
        filter.and("settlerelation", "=", (Object)"arapsettle");
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)"queryApSettleRecord", (String)"ap_settlerecord", (String)"totalsettleamt,settlerelation,settleentry,entry.settleamt settleamt,entry.billid billid,mainbillid,entry.billentryid billentryid,mainbillentryid,id", (QFilter[])new QFilter[]{filter}, (String)"mainbizdate");
        if (!recordDataSet.hasNext()) {
            return;
        }
        HashMap<Long, List> recordMap = new HashMap<Long, List>(64);
        for (Row recordRow : recordDataSet.copy()) {
            Long recordId = recordRow.getLong("id");
            List recordRows = recordMap.getOrDefault(recordId, new ArrayList(2));
            recordRows.add(recordRow);
            recordMap.put(recordId, recordRows);
        }
        for (Map.Entry longListEntry : recordMap.entrySet()) {
            List recordRows = (List)longListEntry.getValue();
            if (recordRows == null || recordRows.size() == 0) continue;
            Row record = (Row)recordRows.get(0);
            BigDecimal entrySettleTotal = BigDecimal.ZERO;
            for (Row recordRow : recordRows) {
                entrySettleTotal = entrySettleTotal.add(recordRow.getBigDecimal("settleamt"));
            }
            boolean isPlan = "2".equals(record.getString("settleentry"));
            for (Row recordRow : recordRows) {
                String key;
                Map<String, Object> writeBackParam;
                BigDecimal recordEntrySettleAmt = recordRow.getBigDecimal("settleamt");
                long asstBillId = recordRow.getLong("billid");
                List<Row> finApBill = finApMap.get(asstBillId);
                if (finApBill == null) continue;
                if (isPlan) {
                    count = 0;
                    for (Row detailEntry : finApBill) {
                        if (BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("e_pricetaxtotal")) == 0) continue;
                        ++count;
                    }
                    BigDecimal remainDisposeAmount = recordEntrySettleAmt;
                    for (Row detailEntry : finApBill) {
                        BigDecimal disposeAmt = ApWriteBackScmcHelper.allocationAmtByPlan(detailEntry, currencyMap, remainDisposeAmount, recordEntrySettleAmt);
                        remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                        String key2 = String.valueOf(detailEntry.getLong("corebillid")).concat("_").concat(String.valueOf(detailEntry.getLong("corebillentryid")));
                        Map<String, Object> writeBackParam2 = result.get(key2);
                        if (writeBackParam2 == null || !detailEntry.getLong("org").equals((Long)writeBackParam2.get("settleorgid"))) continue;
                        BigDecimal paidAllAmount = (BigDecimal)writeBackParam2.get("paidallamount");
                        writeBackParam2.put("paidallamount", paidAllAmount.add(disposeAmt));
                    }
                    continue;
                }
                long asstBillEntryId = recordRow.getLong("billentryid");
                Row finEntry = finApEntryMap.get(asstBillEntryId);
                if (finEntry == null || (writeBackParam = result.get(key = String.valueOf(finEntry.getLong("corebillid")).concat("_").concat(String.valueOf(finEntry.getLong("corebillentryid"))))) == null || !finEntry.getLong("org").equals((Long)writeBackParam.get("settleorgid"))) continue;
                BigDecimal paidAllAmount = (BigDecimal)writeBackParam.get("paidallamount");
                writeBackParam.put("paidallamount", paidAllAmount.add(recordEntrySettleAmt));
            }
        }
    }

    private static BigDecimal allocationAmtByPlan(Row detailEntry, Map<Object, DynamicObject> currencyMap, BigDecimal remainDisposeAmount, BigDecimal allocationAllAmt) {
        BigDecimal disposeAmt = BigDecimal.ZERO;
        if (detailEntry == null || currencyMap == null) {
            return disposeAmt;
        }
        DynamicObject currency = currencyMap.get(detailEntry.getLong("currency"));
        BigDecimal headAmt = detailEntry.getBigDecimal("pricetaxtotal");
        BigDecimal entryAmt = detailEntry.getBigDecimal("e_pricetaxtotal");
        if (entryAmt.compareTo(BigDecimal.ZERO) == 0) {
            return disposeAmt;
        }
        disposeAmt = --count == 0 ? remainDisposeAmount : allocationAllAmt.multiply(entryAmt).divide(headAmt, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
        return disposeAmt;
    }

    private static Map<String, Map<String, Object>> getInitResult(List<Map<String, Object>> params) {
        if (params == null || params.isEmpty()) {
            return new HashMap<String, Map<String, Object>>(2);
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(64);
        for (Map<String, Object> param : params) {
            HashMap<String, Object> initMap = new HashMap<String, Object>(8);
            initMap.put("mainbillid", param.get("mainbillid"));
            initMap.put("mainbillentryid", param.get("mainbillentryid"));
            initMap.put("settleorgid", param.get("settleorgid"));
            initMap.put("asstid", param.get("asstid"));
            initMap.put("internal_company", param.get("internal_company"));
            initMap.put("paidpreallamount", BigDecimal.ZERO);
            initMap.put("paidallamount", BigDecimal.ZERO);
            initMap.put("joinpayamount", BigDecimal.ZERO);
            initMap.put("paidamount", BigDecimal.ZERO);
            result.put(String.valueOf(param.get("mainbillid")).concat("_").concat(String.valueOf(param.get("mainbillentryid"))), initMap);
        }
        return result;
    }

    private static Map<Long, List<Row>> processFinApBill(List<Map<String, Object>> param, Map<String, Map<String, Object>> writeBackParamMap) {
        HashMap<Long, List<Row>> blueBillMap = new HashMap<Long, List<Row>>(64);
        if (param == null || param.isEmpty()) {
            return blueBillMap;
        }
        HashSet<Long> coreBillIds = new HashSet<Long>(param.size());
        HashSet<Long> coreBillEntryIds = new HashSet<Long>(param.size());
        HashSet<Long> unitIds = new HashSet<Long>(param.size());
        ArrayList<Long> orgIds = new ArrayList<Long>(param.size());
        for (Map<String, Object> map : param) {
            Object mainBillId = map.get("mainbillid");
            Object mainBillEntryId = map.get("mainbillentryid");
            Object settleOrgId = map.get("settleorgid");
            if (mainBillId == null || mainBillEntryId == null || settleOrgId == null) continue;
            coreBillIds.add((Long)mainBillId);
            coreBillEntryIds.add((Long)mainBillEntryId);
            orgIds.add((Long)settleOrgId);
            unitIds.add((Long)map.get("unit"));
        }
        Map unitMap = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(), (String)"bd_measureunits");
        String selector = "id,org,asstacttype,asstact,detailentry.id entryid,detailentry.e_pricetaxtotal e_pricetaxtotal,detailentry.quantity quantity,detailentry.corebillentryid corebillentryid,detailentry.corebillid corebillid,pricetaxtotal,currency,detailentry.material material,detailentry.e_baseunit e_baseunit,detailentry.e_baseunitqty e_baseunitqty";
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"queryfinapbill", (String)"ap_finapbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("detailentry.corebillentryid", "in", coreBillEntryIds), new QFilter("detailentry.corebillid", "in", coreBillIds), new QFilter("billstatus", "=", (Object)"C")}, (String)"bizdate");
        for (Row finApRow : finApDataSet.copy()) {
            Boolean internalCompany;
            Map<String, Object> inCoreParam;
            String coreKey = finApRow.getLong("corebillid") + "_" + finApRow.getLong("corebillentryid");
            Map<String, Object> writeBackParam = writeBackParamMap.get(coreKey);
            if (writeBackParam == null) {
                writeBackParam = new HashMap<String, Object>(8);
                writeBackParam.put("mainbillid", finApRow.getLong("corebillid"));
                writeBackParam.put("mainbillentryid", finApRow.getLong("corebillentryid"));
                writeBackParam.put("baseqty", BigDecimal.ZERO);
                writeBackParam.put("amount", BigDecimal.ZERO);
                writeBackParam.put("qty", BigDecimal.ZERO);
            }
            if ((inCoreParam = ApWriteBackScmcHelper.getCoreBillParam(param, coreKey)).isEmpty() || Boolean.TRUE.equals(internalCompany = (Boolean)inCoreParam.get("internal_company")) && finApRow.getLong("asstact").compareTo((Long)inCoreParam.get("asstid")) != 0 || finApRow.getLong("org").compareTo((Long)inCoreParam.get("settleorgid")) != 0) continue;
            if (BigDecimal.ZERO.compareTo(finApRow.getBigDecimal("e_pricetaxtotal")) < 0) {
                Long billId = finApRow.getLong("id");
                List rowList = blueBillMap.getOrDefault(billId, new ArrayList(32));
                rowList.add(finApRow);
                blueBillMap.put(billId, rowList);
            }
            Long measureUnitId = finApRow.getLong("e_baseunit");
            DynamicObject srcUnit = (DynamicObject)unitMap.get(inCoreParam.get("unit"));
            DynamicObject desUnit = (DynamicObject)unitMap.get(measureUnitId);
            if (desUnit == null) {
                desUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)measureUnitId, (String)"bd_measureunits");
                unitMap.put(measureUnitId, desUnit);
            }
            BigDecimal qtyConv = MaterialHelper.getDesQtyConv((Long)finApRow.getLong("material"), (DynamicObject)desUnit, (BigDecimal)finApRow.getBigDecimal("e_baseunitqty"), (DynamicObject)srcUnit, (boolean)true);
            BigDecimal qty = (BigDecimal)writeBackParam.get("qty");
            writeBackParam.put("qty", qtyConv.add(qty));
            BigDecimal baseQty = (BigDecimal)writeBackParam.get("baseqty");
            writeBackParam.put("baseqty", baseQty.add(finApRow.getBigDecimal("e_baseunitqty")));
            BigDecimal amount = (BigDecimal)writeBackParam.get("amount");
            writeBackParam.put("amount", finApRow.getBigDecimal("e_pricetaxtotal").add(amount));
            writeBackParamMap.put(coreKey, writeBackParam);
        }
        return blueBillMap;
    }

    private static void processApSelfBill(Map<String, Map<String, Object>> writeBackParamMap, Map<Long, List<Row>> blueBillMap) {
        if (writeBackParamMap == null || blueBillMap == null || writeBackParamMap.isEmpty() || blueBillMap.isEmpty()) {
            return;
        }
        String recordSelector = "mainbillid,mainbillentryid,totalsettleamt,entry.billid asstid,entry.billentryid asstentryid,settleentry,corebillentryid,corebillid,maincurrency";
        QFilter recordFilter = new QFilter("settlerelation", "=", (Object)"apself");
        recordFilter.and(new QFilter("mainbillid", "in", blueBillMap.keySet()));
        recordFilter.and(new QFilter("settleentry", "not in", Arrays.asList("", " ")));
        DataSet settleRecordDataSet = QueryServiceHelper.queryDataSet((String)"querysettlerocord", (String)"ap_settlerecord", (String)recordSelector, (QFilter[])new QFilter[]{recordFilter}, (String)"mainbizdate");
        HashMap<Long, List> settleRecordMap = new HashMap<Long, List>(64);
        HashSet<Long> currencyIds = new HashSet<Long>(64);
        for (Row settleRecord : settleRecordDataSet.copy()) {
            currencyIds.add(settleRecord.getLong("maincurrency"));
            Long asstId = settleRecord.getLong("asstid");
            List recordList = settleRecordMap.getOrDefault(asstId, new ArrayList(8));
            recordList.add(settleRecord);
            settleRecordMap.put(asstId, recordList);
        }
        QFilter filter = new QFilter("id", "in", settleRecordMap.keySet());
        filter.and(new QFilter("detailentry.corebillid", "!=", (Object)0L));
        filter.and(new QFilter("detailentry.corebillentryid", "!=", (Object)0L));
        DataSet asstApBillDataSet = QueryServiceHelper.queryDataSet((String)"querycorenotnull", (String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"bizdate");
        HashSet<Long> noCorrectAsst = new HashSet<Long>(64);
        for (Row asstRow : asstApBillDataSet) {
            noCorrectAsst.add(asstRow.getLong("id"));
        }
        if (noCorrectAsst.size() == settleRecordMap.size()) {
            return;
        }
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)});
        for (Map.Entry entrySet : settleRecordMap.entrySet()) {
            Long asstId = (Long)entrySet.getKey();
            List recordRows = (List)entrySet.getValue();
            if (noCorrectAsst.contains(asstId) || recordRows == null || recordRows.isEmpty()) continue;
            for (Row recordRow : recordRows) {
                BigDecimal totalSettleAmt = recordRow.getBigDecimal("totalsettleamt");
                boolean isPlanSettle = "2".equals(recordRow.getString("settleentry"));
                if (isPlanSettle) {
                    List<Row> mainBillRows = blueBillMap.get(recordRow.getLong("mainbillid"));
                    if (mainBillRows == null || mainBillRows.isEmpty()) continue;
                    BigDecimal remainDisposeAmount = totalSettleAmt;
                    BigDecimal disposeAmt = BigDecimal.ZERO;
                    for (int i = 0; i < mainBillRows.size(); ++i) {
                        int precision;
                        Row mainBillRow = mainBillRows.get(i);
                        BigDecimal headAmt = mainBillRow.getBigDecimal("pricetaxtotal");
                        DynamicObject currency = (DynamicObject)currencyMap.get(mainBillRow.getLong("currency"));
                        int n = precision = currency == null ? 2 : currency.getInt("amtprecision");
                        if (i != mainBillRows.size() - 1) {
                            BigDecimal entryAmt = mainBillRow.getBigDecimal("e_pricetaxtotal");
                            BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
                            disposeAmt = totalSettleAmt.multiply(proportion).setScale(precision, RoundingMode.HALF_UP);
                            remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                        } else {
                            disposeAmt = remainDisposeAmount;
                        }
                        ApWriteBackScmcHelper.processApSelfParam(mainBillRow, writeBackParamMap, disposeAmt);
                    }
                    continue;
                }
                ApWriteBackScmcHelper.processApSelfParam(recordRow, writeBackParamMap, totalSettleAmt);
            }
        }
        settleRecordDataSet.close();
    }

    @Deprecated
    private static void processOrderPayPlan4PayApply(QFilter qFilter, Map<String, Map<String, Object>> result) {
        DataSet payApplyDataSet = QueryServiceHelper.queryDataSet((String)"queryPayApply", (String)"ap_payapply", (String)"entry.e_corebillid e_corebillid,entry.e_corebillentryid e_corebillentryid,entry.e_approvedseleamt e_approvedseleamt,billstatus,entry.lockedamt lockedamt", (QFilter[])new QFilter[]{qFilter, new QFilter("sourcebilltype", "in", Arrays.asList("conm_purcontract", "pm_purorderbill"))}, (String)"applydate");
        for (Row payApplyRow : payApplyDataSet) {
            String key = String.valueOf(payApplyRow.getLong("e_corebillid")).concat("_").concat(String.valueOf(payApplyRow.getLong("e_corebillentryid")));
            Map<String, Object> writeBackParam = result.get(key);
            if (writeBackParam == null) continue;
            BigDecimal joinPayAmount = (BigDecimal)writeBackParam.get("joinpayamount");
            joinPayAmount = joinPayAmount.add(payApplyRow.getBigDecimal("e_approvedseleamt"));
            writeBackParam.put("joinpayamount", joinPayAmount);
            if (!"D".equals(payApplyRow.getString("billstatus"))) continue;
            BigDecimal closePayApply = payApplyRow.getBigDecimal("e_approvedseleamt").subtract(payApplyRow.getBigDecimal("lockedamt"));
            writeBackParam.put("joinpayamount", joinPayAmount.add(closePayApply.negate()));
        }
    }

    private static void processOrderPayPlan4PayBill(QFilter qFilter, Map<String, Map<String, Object>> result) {
        BigDecimal paidAmount;
        DataSet casPayDataSet = QueryServiceHelper.queryDataSet((String)"queryCasPayBill", (String)"cas_paybill", (String)"id,paymenttype.biztype biztype,billstatus,entry.e_corebillid e_corebillid,sourcebilltype,entry.e_corebillentryid e_corebillentryid,entry.e_payableamt e_payableamt,entry.id entryId", (QFilter[])new QFilter[]{qFilter}, (String)"bizdate");
        if (!casPayDataSet.hasNext()) {
            return;
        }
        HashSet<Long> casPayIds = new HashSet<Long>(64);
        HashMap<Long, Row> casPayRowMap = new HashMap<Long, Row>(64);
        for (Row casPayRow : casPayDataSet.copy()) {
            if ("202".equals(casPayRow.getString("biztype"))) {
                casPayIds.add(casPayRow.getLong("id"));
            }
            casPayRowMap.put(casPayRow.getLong("entryId"), casPayRow);
            String key = String.valueOf(casPayRow.getLong("e_corebillid")).concat("_").concat(String.valueOf(casPayRow.getLong("e_corebillentryid")));
            Map<String, Object> writeBackParam = result.get(key);
            if (writeBackParam == null) continue;
            BigDecimal ePayableAmt = casPayRow.getBigDecimal("e_payableamt");
            BigDecimal joinPayAmount = (BigDecimal)writeBackParam.get("joinpayamount");
            paidAmount = (BigDecimal)writeBackParam.get("paidamount");
            if (Arrays.asList("D", "F", "I").contains(casPayRow.getString("billstatus"))) {
                writeBackParam.put("paidamount", paidAmount.add(ePayableAmt));
            }
            writeBackParam.put("joinpayamount", joinPayAmount.add(ePayableAmt));
        }
        DataSet settleRecords = QueryServiceHelper.queryDataSet((String)"queryCasRecord", (String)"ap_settlerecord", (String)"totalsettleamt,mainbillid,mainbillentryid,settlerelation", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", casPayIds), new QFilter("settlerelation", "in", Arrays.asList("payself", "payrecsettle"))}, (String)"mainbizdate");
        if (!settleRecords.hasNext()) {
            return;
        }
        for (Row settleRecord : settleRecords) {
            Row casPayRow = (Row)casPayRowMap.get(settleRecord.getLong("mainbillentryid"));
            if (casPayRow == null) continue;
            String key = String.valueOf(casPayRow.getLong("e_corebillid")).concat("_").concat(String.valueOf(casPayRow.getLong("e_corebillentryid")));
            Map<String, Object> amountMap = result.get(key);
            paidAmount = (BigDecimal)amountMap.get("paidamount");
            BigDecimal joinPayAmount = (BigDecimal)amountMap.get("joinpayamount");
            amountMap.put("joinpayamount", joinPayAmount.add(settleRecord.getBigDecimal("totalsettleamt").negate()));
            amountMap.put("paidamount", paidAmount.add(settleRecord.getBigDecimal("totalsettleamt").negate()));
        }
    }

    private static void processApSelfParam(Row recordRow, Map<String, Map<String, Object>> writeBackParamMap, BigDecimal disposeAmt) {
        Long coreBillId = recordRow.getLong("corebillid");
        Long coreBillEntryId = recordRow.getLong("corebillentryid");
        String coreKey = coreBillId + "_" + coreBillEntryId;
        Map<String, Object> writeBackParam = writeBackParamMap.get(coreKey);
        if (writeBackParam == null) {
            writeBackParam = new HashMap<String, Object>(4);
            writeBackParam.put("mainbillid", coreBillId);
            writeBackParam.put("mainbillentryid", coreBillEntryId);
            writeBackParam.put("baseqty", BigDecimal.ZERO);
            writeBackParam.put("qty", BigDecimal.ZERO);
            writeBackParam.put("amount", BigDecimal.ZERO);
        }
        BigDecimal amount = (BigDecimal)writeBackParam.get("amount");
        writeBackParam.put("amount", amount.add(disposeAmt.negate()));
        writeBackParamMap.put(coreKey, writeBackParam);
    }

    private static boolean equals(String str, String str2) {
        if (null == str) {
            return null == str2;
        }
        return str.equals(str2);
    }

    private static Map<String, Object> getCoreBillParam(List<Map<String, Object>> param, String key) {
        if (param == null || param.isEmpty() || key == null) {
            return new HashMap<String, Object>(2);
        }
        for (Map<String, Object> paramMap : param) {
            Object mainBillId = paramMap.get("mainbillid");
            Object mainBillEntryId = paramMap.get("mainbillentryid");
            String str = String.valueOf(mainBillId).concat("_").concat(String.valueOf(mainBillEntryId));
            if (!key.equals(str)) continue;
            return paramMap;
        }
        return new HashMap<String, Object>(2);
    }
}

