/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;

public class ArWriteBackScmcHelper {
    private static final Log logger = LogFactory.getLog(ArWriteBackScmcHelper.class);
    private static int count = 0;

    public static List<Map<String, Object>> constructReceivableData(List<Map<String, Object>> param) {
        if (param == null || param.isEmpty()) {
            return new ArrayList<Map<String, Object>>(2);
        }
        logger.info("constructReceivalbeData \uff1a " + param);
        HashMap<String, Map<String, Object>> receWriteBackParamMap = new HashMap<String, Map<String, Object>>(64);
        for (Map<String, Object> inParam : param) {
            HashMap<String, Object> writeBackParam = new HashMap<String, Object>(8);
            Object mainBillId = inParam.get("mainbillid");
            Object mainBillEntryId = inParam.get("mainbillentryid");
            writeBackParam.put("mainbillid", mainBillId);
            writeBackParam.put("mainbillentryid", mainBillEntryId);
            writeBackParam.put("baseqty", BigDecimal.ZERO);
            writeBackParam.put("amount", BigDecimal.ZERO);
            writeBackParam.put("qty", BigDecimal.ZERO);
            receWriteBackParamMap.put(String.valueOf(mainBillId).concat("_").concat(String.valueOf(mainBillEntryId)), writeBackParam);
        }
        Map<Long, List<Row>> blueBillMap = ArWriteBackScmcHelper.processFinArBill(param, receWriteBackParamMap);
        logger.info("receWriteBackParamMap_1" + receWriteBackParamMap);
        ArWriteBackScmcHelper.processArSelfBill(receWriteBackParamMap, blueBillMap);
        logger.info("receWriteBackParamMap_2" + receWriteBackParamMap);
        return new ArrayList<Map<String, Object>>(receWriteBackParamMap.values());
    }

    public static List<Map<String, Object>> constructConfirmData(List<Map<String, Object>> param) {
        if (param == null || param.isEmpty()) {
            return new ArrayList<Map<String, Object>>(2);
        }
        logger.info("constructConfirmData \uff1a " + param);
        HashMap<String, Map<String, Object>> confirmWriteBackParamMap = new HashMap<String, Map<String, Object>>(64);
        for (Map<String, Object> inParam : param) {
            HashMap<String, Object> writeBackParam = new HashMap<String, Object>(8);
            Object mainBillId = inParam.get("mainbillid");
            Object mainBillEntryId = inParam.get("mainbillentryid");
            writeBackParam.put("mainbillid", mainBillId);
            writeBackParam.put("mainbillentryid", mainBillEntryId);
            writeBackParam.put("baseqty", BigDecimal.ZERO);
            writeBackParam.put("amount", BigDecimal.ZERO);
            writeBackParam.put("qty", BigDecimal.ZERO);
            confirmWriteBackParamMap.put(String.valueOf(mainBillId).concat("_").concat(String.valueOf(mainBillEntryId)), writeBackParam);
        }
        ArWriteBackScmcHelper.processArRevcfmBill(param, confirmWriteBackParamMap);
        return new ArrayList<Map<String, Object>>(confirmWriteBackParamMap.values());
    }

    public static List<Map<String, Object>> writeBackHeadRecAmt(List<Map<String, Object>> params) {
        if (params == null || params.isEmpty()) {
            return new ArrayList<Map<String, Object>>(2);
        }
        Object accessType = params.get(0).get("accessType");
        logger.info("writeBackHeadRecAmt - params : " + params + " accessType:" + accessType);
        Map<Long, Map<String, BigDecimal>> corePreRecMap = ArWriteBackScmcHelper.processCasRecBill(params);
        logger.info("writeBackHeadRecAmt - corePreRecMap : " + corePreRecMap);
        Map<String, Map<String, Object>> settleAmountMap = ArWriteBackScmcHelper.processSettleRecord(params);
        logger.info("writeBackHeadRecAmt - settleAmountMap : " + settleAmountMap);
        HashMap<Long, Map> result = new HashMap<Long, Map>(64);
        for (Map.Entry<String, Map<String, Object>> recordEntry : settleAmountMap.entrySet()) {
            Map<String, Object> recordValue = recordEntry.getValue();
            Long mainBillId = (Long)recordValue.get("mainbillid");
            Map<String, BigDecimal> preRecMap = corePreRecMap.get(mainBillId);
            Map writeBackParam = result.getOrDefault(mainBillId, new HashMap(2));
            BigDecimal preReceiptAllAmount = writeBackParam.getOrDefault("prereceiptallamount", BigDecimal.ZERO);
            BigDecimal receiptAllAmount = writeBackParam.getOrDefault("receiptallamount", BigDecimal.ZERO);
            preReceiptAllAmount = preReceiptAllAmount.add((BigDecimal)recordValue.getOrDefault("prereceiptallamount", BigDecimal.ZERO));
            receiptAllAmount = receiptAllAmount.add((BigDecimal)recordValue.getOrDefault("receiptallamount", BigDecimal.ZERO));
            writeBackParam.put("prereceiptallamount", preReceiptAllAmount);
            writeBackParam.put("receiptallamount", receiptAllAmount);
            if (preRecMap != null) {
                writeBackParam.put("prereceiptallamount", preReceiptAllAmount.add(preRecMap.getOrDefault("prereceiptallamount", BigDecimal.ZERO)));
                writeBackParam.put("receiptallamount", receiptAllAmount.add(preRecMap.getOrDefault("receiptallamount", BigDecimal.ZERO)));
            }
            writeBackParam.put("mainbillid", mainBillId);
            result.put(mainBillId, writeBackParam);
            corePreRecMap.remove(mainBillId);
        }
        logger.info("writeBackHeadRecAmt - finalparam : " + result.values());
        return new ArrayList<Map<String, Object>>(result.values());
    }

    public static List<Map<String, Object>> writeBackPlanRecAmt(List<Map<String, Object>> params) {
        if (params == null || params.isEmpty()) {
            return new ArrayList<Map<String, Object>>(2);
        }
        Map<String, Map<String, Object>> result = ArWriteBackScmcHelper.getInitResult(params);
        HashSet<String> mainBillIds = new HashSet<String>(64);
        HashSet<Long> mainBillEntryIds = new HashSet<Long>(64);
        for (Map<String, Object> param : params) {
            mainBillIds.add(param.get("mainbillid").toString());
            mainBillEntryIds.add((Long)param.get("mainbillentryid"));
        }
        QFilter qFilter = new QFilter("entry.e_corebillid", "in", mainBillIds);
        qFilter.and("entry.e_corebillentryid", "in", mainBillEntryIds);
        DataSet casRecDataSet = QueryServiceHelper.queryDataSet((String)"queryCasRecBill", (String)"cas_recbill", (String)"id,receivingtype.biztype biztype,billstatus,entry.e_corebillid e_corebillid,entry.e_corebillentryid e_corebillentryid,entry.e_receivableamt e_receivableamt, entry.id entryId", (QFilter[])new QFilter[]{qFilter}, (String)"bizdate");
        if (!casRecDataSet.hasNext()) {
            return new ArrayList<Map<String, Object>>(result.values());
        }
        HashSet<Long> casRecIds = new HashSet<Long>(64);
        HashMap<Long, Object> entryCoreMap = new HashMap<Long, Object>(64);
        HashMap<Long, Row> casRecRowMap = new HashMap<Long, Row>(64);
        for (Row casRecRow : casRecDataSet.copy()) {
            casRecIds.add(casRecRow.getLong("id"));
            casRecRowMap.put(casRecRow.getLong("entryId"), casRecRow);
            Long eCoreBillId = casRecRow.getLong("e_corebillid");
            String key = String.valueOf(eCoreBillId).concat("_").concat(String.valueOf(casRecRow.getLong("e_corebillentryid")));
            Map<String, Object> writeBackParam = result.get(key);
            if (writeBackParam == null) continue;
            BigDecimal eReceivableAmt = casRecRow.getBigDecimal("e_receivableamt");
            BigDecimal joinRecAmount = (BigDecimal)writeBackParam.get("joinrecamount");
            BigDecimal recAmount = (BigDecimal)writeBackParam.get("recamount");
            if ("D".equals(casRecRow.getString("billstatus"))) {
                writeBackParam.put("recamount", recAmount.add(eReceivableAmt));
                writeBackParam.put("joinrecamount", joinRecAmount.add(eReceivableAmt));
            }
            entryCoreMap.put(casRecRow.getLong("entryId"), eCoreBillId);
        }
        DataSet settleRecords = QueryServiceHelper.queryDataSet((String)"queryCasRecord", (String)"ar_settlerecord", (String)"totalsettleamt,entry.settleamt settleamt,mainbillid,mainbillentryid,settlerelation,entry.billentryid asstbillentryid", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", casRecIds), new QFilter("settlerelation", "in", Arrays.asList("recself", "recpaysettle", "recclearing"))}, (String)"mainbizdate");
        if (!settleRecords.hasNext()) {
            return new ArrayList<Map<String, Object>>(result.values());
        }
        HashSet<Long> recBillEntryIds = new HashSet<Long>(8);
        for (Object settleRecord : settleRecords.copy()) {
            Long asstBillEntryId = settleRecord.getLong("asstbillentryid");
            recBillEntryIds.add(asstBillEntryId);
        }
        DynamicObjectCollection recBillCol = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.id entryId, entry.e_corebillid coreBillId", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", recBillEntryIds)});
        for (DynamicObject recBillInfo : recBillCol) {
            Long entryId = recBillInfo.getLong("entryId");
            Long coreBillId = recBillInfo.getLong("coreBillId");
            entryCoreMap.put(entryId, coreBillId);
        }
        DynamicObjectCollection payBillCol = QueryServiceHelper.query((String)"cas_paybill", (String)"entry.id entryId, entry.e_corebillid coreBillId", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", recBillEntryIds)});
        for (DynamicObject payBillInfo : payBillCol) {
            Long entryId = payBillInfo.getLong("entryId");
            Long coreBillId = payBillInfo.getLong("coreBillId");
            entryCoreMap.put(entryId, coreBillId);
        }
        for (Row settleRecord : settleRecords) {
            Row casPayRow = (Row)casRecRowMap.get(settleRecord.getLong("mainbillentryid"));
            if (casPayRow == null) continue;
            String key = String.valueOf(casPayRow.getLong("e_corebillid")).concat("_").concat(String.valueOf(casPayRow.getLong("e_corebillentryid")));
            Long asstBillEntryId = settleRecord.getLong("asstbillentryid");
            Long coreBillId = (Long)entryCoreMap.get(asstBillEntryId);
            if (!ObjectUtils.isEmpty((Object)coreBillId) && 0L != coreBillId) continue;
            Map<String, Object> amountMap = result.get(key);
            BigDecimal joinRecAmount = (BigDecimal)amountMap.get("joinrecamount");
            BigDecimal recAmount = (BigDecimal)amountMap.get("recamount");
            BigDecimal settleamt = "recself".equals(settleRecord.getString("settlerelation")) ? settleRecord.getBigDecimal("settleamt") : settleRecord.getBigDecimal("settleamt").negate();
            amountMap.put("joinrecamount", joinRecAmount.add(settleamt));
            amountMap.put("recamount", recAmount.add(settleamt));
        }
        logger.info("writeBackPlanRecAmt - result.values()_2 : " + result.values());
        return new ArrayList<Map<String, Object>>(result.values());
    }

    private static Map<Long, Map<String, BigDecimal>> processCasRecBill(List<Map<String, Object>> params) {
        Object accessType = params.get(0).get("accessType");
        HashMap<Long, Map<String, BigDecimal>> result = new HashMap<Long, Map<String, BigDecimal>>(32);
        HashSet<String> mainBillIds = new HashSet<String>(64);
        for (Map<String, Object> param : params) {
            mainBillIds.add(param.get("mainbillid").toString());
        }
        QFilter filter = new QFilter("billstatus", "=", (Object)"D");
        filter.and("entry.e_corebillid", "in", mainBillIds);
        DataSet recBillDataSet = QueryServiceHelper.queryDataSet((String)"processCasRecBill", (String)"cas_recbill", (String)"id,entry.e_receivableamt e_receivableamt,entry.e_corebillid e_corebillid,receivingtype.biztype biztype,entry.e_corebillentryid e_corebillentryid,entry.id entryId,confirmlogo,entry.e_unsettledamt e_unsettledamt", (QFilter[])new QFilter[]{filter}, (String)"bizdate");
        if (!recBillDataSet.hasNext()) {
            return result;
        }
        HashSet<Long> casRecBillIds = new HashSet<Long>(64);
        HashMap<Long, String> recTypeMap = new HashMap<Long, String>(64);
        HashMap<Long, Object> entryCoreMap = new HashMap<Long, Object>(64);
        for (Row recBill : recBillDataSet) {
            Long eCoreBillId = recBill.getLong("e_corebillid");
            HashMap<String, BigDecimal> amountMap = (HashMap<String, BigDecimal>)result.get(eCoreBillId);
            if (amountMap == null) {
                amountMap = new HashMap<String, BigDecimal>(2);
                amountMap.put("prereceiptallamount", BigDecimal.ZERO);
                amountMap.put("receiptallamount", BigDecimal.ZERO);
            }
            String bizType = recBill.getString("biztype");
            BigDecimal preReceiptAllAmount = (BigDecimal)amountMap.get("prereceiptallamount");
            BigDecimal receiptAllAmount = (BigDecimal)amountMap.get("receiptallamount");
            if ("conm".equals(accessType)) {
                BigDecimal unsettledamt = recBill.getBigDecimal("e_unsettledamt");
                amountMap.put("prereceiptallamount", preReceiptAllAmount.add(unsettledamt));
                amountMap.put("receiptallamount", receiptAllAmount.add(unsettledamt));
            } else {
                if ("101".equals(bizType)) {
                    amountMap.put("prereceiptallamount", preReceiptAllAmount.add(recBill.getBigDecimal("e_receivableamt")));
                }
                amountMap.put("receiptallamount", receiptAllAmount.add(recBill.getBigDecimal("e_receivableamt")));
            }
            result.put(eCoreBillId, amountMap);
            casRecBillIds.add(recBill.getLong("id"));
            recTypeMap.put(recBill.getLong("id"), bizType);
            entryCoreMap.put(recBill.getLong("entryId"), eCoreBillId);
        }
        if ("conm".equals(accessType)) {
            return result;
        }
        DataSet settleRecords = QueryServiceHelper.queryDataSet((String)"queryCasRecord", (String)"ar_settlerecord", (String)"totalsettleamt,entry.settleamt settleamt,mainbillid,settlerelation,mainbillentryid,entry.billid asstbillid,entry.billentryid asstbillentryid", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", casRecBillIds), new QFilter("settlerelation", "in", Arrays.asList("recself", "recpaysettle", "recclearing"))}, (String)"");
        if (!settleRecords.hasNext()) {
            return result;
        }
        HashSet<Long> recBillEntryIds = new HashSet<Long>(8);
        for (Object settleRecord : settleRecords.copy()) {
            Long asstBillEntryId = settleRecord.getLong("asstbillentryid");
            recBillEntryIds.add(asstBillEntryId);
        }
        DynamicObjectCollection recBillCol = QueryServiceHelper.query((String)"cas_recbill", (String)"entry.id entryId, entry.e_corebillid coreBillId", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", recBillEntryIds)});
        for (DynamicObject recBillInfo : recBillCol) {
            Long entryId = recBillInfo.getLong("entryId");
            Long coreBillId = recBillInfo.getLong("coreBillId");
            entryCoreMap.put(entryId, coreBillId);
        }
        DynamicObjectCollection payBillCol = QueryServiceHelper.query((String)"cas_paybill", (String)"entry.id entryId, entry.e_corebillid coreBillId", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", recBillEntryIds)});
        for (DynamicObject payBillInfo : payBillCol) {
            Long entryId = payBillInfo.getLong("entryId");
            Long coreBillId = payBillInfo.getLong("coreBillId");
            entryCoreMap.put(entryId, coreBillId);
        }
        for (Row settleRecord : settleRecords) {
            BigDecimal settleamt;
            String bizType = recTypeMap.getOrDefault(settleRecord.getLong("mainbillid"), "");
            Long eCoreBillId = entryCoreMap.getOrDefault(settleRecord.getLong("mainbillentryid"), 0L);
            HashMap<String, BigDecimal> amountMap = (HashMap<String, BigDecimal>)result.get(eCoreBillId);
            if (amountMap == null) {
                amountMap = new HashMap<String, BigDecimal>(2);
                amountMap.put("prereceiptallamount", BigDecimal.ZERO);
                amountMap.put("receiptallamount", BigDecimal.ZERO);
            }
            BigDecimal preReceiptAllAmount = (BigDecimal)amountMap.get("prereceiptallamount");
            BigDecimal receiptAllAmount = (BigDecimal)amountMap.get("receiptallamount");
            Long asstBillEntryId = settleRecord.getLong("asstbillentryid");
            Long coreBillId = (Long)entryCoreMap.get(asstBillEntryId);
            if (!ObjectUtils.isEmpty((Object)coreBillId) && 0L != coreBillId) continue;
            BigDecimal bigDecimal = settleamt = "recself".equals(settleRecord.getString("settlerelation")) ? settleRecord.getBigDecimal("settleamt") : settleRecord.getBigDecimal("settleamt").negate();
            if ("101".equals(bizType)) {
                amountMap.put("prereceiptallamount", preReceiptAllAmount.add(settleamt));
            }
            amountMap.put("receiptallamount", receiptAllAmount.add(settleamt));
        }
        return result;
    }

    private static Map<String, Map<String, Object>> processSettleRecord(List<Map<String, Object>> params) {
        Map<String, Map<String, Object>> result = ArWriteBackScmcHelper.getInitResult(params);
        Object accessType = params.get(0).get("accessType");
        if ("conm".equals(accessType)) {
            return result;
        }
        HashSet<Long> mainBillIds = new HashSet<Long>(64);
        HashSet<Long> orgIds = new HashSet<Long>(64);
        for (Map<String, Object> param : params) {
            orgIds.add((Long)param.get("settleorgid"));
            mainBillIds.add((Long)param.get("mainbillid"));
        }
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("entry.corebillid", "in", mainBillIds);
        DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"queryFinArBill", (String)"ar_finarbill", (String)"id,org,asstacttype,asstact,entry.e_corebilltype corebilltype,entry.corebillid corebillid,entry.corebillentryid corebillentryid,currency,recamount,unsettleamount,entry.e_recamount e_recamount,entry.e_unsettleamt,entry.e_settledamt,entry.id entryId", (QFilter[])new QFilter[]{filter}, (String)"bizdate");
        HashMap<Long, List<Row>> finArMap = new HashMap<Long, List<Row>>(64);
        HashMap<Long, Row> finArEntryMap = new HashMap<Long, Row>(64);
        HashSet<Long> currencyIds = new HashSet<Long>(32);
        for (Row finArRow : finArDataSet.copy()) {
            Boolean internalCompany;
            String key = String.valueOf(finArRow.getLong("corebillid")).concat("_").concat(String.valueOf(finArRow.getLong("corebillentryid")));
            Map<String, Object> writeParam = result.get(key);
            if (writeParam == null || Boolean.TRUE.equals(internalCompany = (Boolean)writeParam.get("internal_company")) && finArRow.getLong("asstact").compareTo((Long)writeParam.get("asstid")) != 0) continue;
            Long billId = finArRow.getLong("id");
            List details = finArMap.getOrDefault(billId, new ArrayList(2));
            details.add(finArRow);
            finArMap.put(billId, details);
            finArEntryMap.put(finArRow.getLong("entryId"), finArRow);
            currencyIds.add(finArRow.getLong("currency"));
        }
        if (finArMap.isEmpty()) {
            return result;
        }
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((Object[])currencyIds.toArray(new Long[0]), (String)"bd_currency");
        if (currencyMap == null || currencyMap.isEmpty()) {
            return result;
        }
        ArWriteBackScmcHelper.processRecordByFinMain(finArMap, finArEntryMap, result, currencyMap);
        ArWriteBackScmcHelper.processRecordByFinAsst(finArMap, finArEntryMap, result, currencyMap);
        return result;
    }

    private static void processRecordByFinMain(Map<Long, List<Row>> finArMap, Map<Long, Row> finArEntryMap, Map<String, Map<String, Object>> result, Map<Object, DynamicObject> currencyMap) {
        QFilter filter = new QFilter("mainbillid", "in", finArMap.keySet());
        filter.and(new QFilter("settlerelation", "in", Arrays.asList("recsettle", "arapsettle", "artransfer", "arpaysettle", "arliqsettle", "baddebtloss", "recclearing")));
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)"queryArSettleRecord", (String)"ar_settlerecord", (String)"totalsettleamt,settlerelation,settleentry,entry.settleamt settleamt,entry.billid billid,mainbillid,entry.billentryid billentryid,mainbillentryid,entry.e_billentity e_billentity,id", (QFilter[])new QFilter[]{filter}, (String)"mainbizdate");
        if (!recordDataSet.hasNext()) {
            return;
        }
        HashSet<Long> asstBillIds = new HashSet<Long>(64);
        HashMap<Long, List> recordMap = new HashMap<Long, List>(64);
        for (Row recordRow : recordDataSet.copy()) {
            if ("recsettle".equals(recordRow.getString("settlerelation")) || "arpaysettle".equals(recordRow.getString("settlerelation"))) {
                asstBillIds.add(recordRow.getLong("billid"));
            }
            Long recordId = recordRow.getLong("id");
            List recordRows = recordMap.getOrDefault(recordId, new ArrayList(2));
            recordRows.add(recordRow);
            recordMap.put(recordId, recordRows);
        }
        HashMap<Long, String> recTypeMap = new HashMap<Long, String>(64);
        HashMap<Long, Long> casEntryCoreMap = new HashMap<Long, Long>(64);
        HashMap<Long, String> casEntryCoreBillTypeMap = new HashMap<Long, String>(64);
        if (!asstBillIds.isEmpty()) {
            Object casRecRow2;
            DataSet casRecDataSet = QueryServiceHelper.queryDataSet((String)"queryCasRecBill", (String)"cas_recbill", (String)"id,receivingtype.biztype biztype,entry.e_corebillid e_corebillid,entry.id entryId,entry.e_corebilltype e_corebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIds)}, (String)"bizdate");
            for (Object casRecRow2 : casRecDataSet) {
                recTypeMap.put(casRecRow2.getLong("id"), casRecRow2.getString("biztype"));
                if (ObjectUtils.isEmpty((Object)casRecRow2.get("e_corebillid"))) continue;
                casEntryCoreMap.put(casRecRow2.getLong("entryId"), casRecRow2.getLong("e_corebillid"));
                casEntryCoreBillTypeMap.put(casRecRow2.getLong("entryId"), casRecRow2.getString("e_corebilltype"));
            }
            Iterator paidBillDataSet = QueryServiceHelper.queryDataSet((String)"queryReceivedBill", (String)"ar_receivedbill", (String)"id,rectype.biztype biztype", (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIds)}, (String)"bizdate");
            casRecRow2 = paidBillDataSet.iterator();
            while (casRecRow2.hasNext()) {
                Row paidBillRow = (Row)casRecRow2.next();
                recTypeMap.put(paidBillRow.getLong("id"), paidBillRow.getString("biztype"));
            }
        }
        if (!asstBillIds.isEmpty()) {
            DataSet casPayDataSet = QueryServiceHelper.queryDataSet((String)"queryCasRecBill", (String)"cas_paybill", (String)"id,paymenttype.biztype biztype,entry.e_corebillid e_corebillid,entry.id entryId,entry.e_corebilltype e_corebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIds)}, (String)"bizdate");
            for (Row casPayRow : casPayDataSet) {
                recTypeMap.put(casPayRow.getLong("id"), casPayRow.getString("biztype"));
                if (ObjectUtils.isEmpty((Object)casPayRow.get("e_corebillid"))) continue;
                casEntryCoreMap.put(casPayRow.getLong("entryId"), casPayRow.getLong("e_corebillid"));
                casEntryCoreBillTypeMap.put(casPayRow.getLong("entryId"), casPayRow.getString("e_corebilltype"));
            }
        }
        for (Map.Entry longListEntry : recordMap.entrySet()) {
            String key;
            Map<String, Object> writeBackParam;
            Long currencyId;
            DynamicObject currency;
            List recordRows = (List)longListEntry.getValue();
            if (recordRows == null || recordRows.size() == 0) continue;
            Row record = (Row)recordRows.get(0);
            String settleRelation = record.getString("settlerelation");
            long mainBillId = record.getLong("mainbillid");
            List<Row> finArBill = finArMap.get(mainBillId);
            if (finArBill == null || finArBill.isEmpty() || (currency = currencyMap.get(currencyId = finArBill.get(0).getLong("currency"))) == null) continue;
            BigDecimal totalSettleAmt = record.getBigDecimal("totalsettleamt");
            BigDecimal entrySettleTotal = BigDecimal.ZERO;
            for (Object recordRow : recordRows) {
                entrySettleTotal = entrySettleTotal.add(recordRow.getBigDecimal("settleamt"));
            }
            boolean isPlan = "2".equals(record.getString("settleentry"));
            if (isPlan) {
                Object recordRow;
                count = 0;
                recordRow = finArBill.iterator();
                while (recordRow.hasNext()) {
                    Row detailEntry = (Row)recordRow.next();
                    if (BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("e_recamount")) == 0) continue;
                    ++count;
                }
                BigDecimal remainDisDetailAmt = totalSettleAmt;
                HashMap<Long, BigDecimal> curSettleAmtMap = new HashMap<Long, BigDecimal>(8);
                for (Row entryInfo : finArBill) {
                    BigDecimal detailSettleAmt = ArWriteBackScmcHelper.allocationAmtByPlan(entryInfo, currencyMap, remainDisDetailAmt, totalSettleAmt);
                    remainDisDetailAmt = remainDisDetailAmt.subtract(detailSettleAmt);
                    String key2 = String.valueOf(entryInfo.getLong("corebillid")).concat("_").concat(String.valueOf(entryInfo.getLong("corebillentryid")));
                    Map<String, Object> writeBackParam2 = result.get(key2);
                    if (writeBackParam2 == null || !entryInfo.getLong("org").equals((Long)writeBackParam2.get("settleorgid"))) continue;
                    String arCoreBillType = entryInfo.getString("corebilltype");
                    BigDecimal remainSettleEntryAmt = detailSettleAmt;
                    for (int i = 0; i < recordRows.size(); ++i) {
                        String recCoreBillType;
                        Long coreBillId;
                        String asstEntity;
                        Row recordRow2 = (Row)recordRows.get(i);
                        BigDecimal entrySettleAmt = recordRow2.getBigDecimal("settleamt");
                        long asstBillEntryId = recordRow2.getLong("billentryid");
                        BigDecimal recordEntryUseAmt = curSettleAmtMap.getOrDefault(asstBillEntryId, BigDecimal.ZERO);
                        BigDecimal recordEntrySettleAmt = totalSettleAmt;
                        recordEntrySettleAmt = count == 0 ? (entrySettleAmt.signum() != totalSettleAmt.signum() ? entrySettleAmt.negate().subtract(recordEntryUseAmt) : entrySettleAmt.subtract(recordEntryUseAmt)) : (i == recordRows.size() - 1 ? remainSettleEntryAmt : detailSettleAmt.multiply(entrySettleAmt).divide(entrySettleTotal, currency.getInt("amtprecision"), RoundingMode.HALF_UP));
                        if (recordEntrySettleAmt.abs().add(recordEntryUseAmt.abs()).compareTo(entrySettleAmt.abs()) > 0) {
                            recordEntrySettleAmt = totalSettleAmt.signum() != entrySettleAmt.signum() ? entrySettleAmt.abs().subtract(recordEntryUseAmt.abs()).negate() : entrySettleAmt.subtract(recordEntryUseAmt);
                        }
                        remainSettleEntryAmt = remainSettleEntryAmt.subtract(recordEntrySettleAmt);
                        curSettleAmtMap.put(asstBillEntryId, recordEntrySettleAmt.add(recordEntryUseAmt));
                        long asstBillId = recordRow2.getLong("billid");
                        BigDecimal receiotAllAmount = (BigDecimal)writeBackParam2.get("receiptallamount");
                        BigDecimal preReceiptAllAmount = (BigDecimal)writeBackParam2.get("prereceiptallamount");
                        if ("recsettle".equals(settleRelation)) {
                            asstEntity = recordRow2.getString("e_billentity");
                            if ("cas_recbill".equals(asstEntity)) {
                                coreBillId = (Long)casEntryCoreMap.get(recordRow2.getLong("billentryid"));
                                recCoreBillType = (String)casEntryCoreBillTypeMap.get(recordRow2.getLong("billentryid"));
                                if (coreBillId == null || coreBillId == 0L || coreBillId != null && coreBillId != 0L && !arCoreBillType.equals(recCoreBillType)) {
                                    if ("101".equals(recTypeMap.get(asstBillId))) {
                                        writeBackParam2.put("prereceiptallamount", preReceiptAllAmount.add(recordEntrySettleAmt));
                                        writeBackParam2.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                                    } else {
                                        writeBackParam2.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                                    }
                                }
                            } else if ("101".equals(recTypeMap.get(asstBillId))) {
                                writeBackParam2.put("prereceiptallamount", preReceiptAllAmount.add(recordEntrySettleAmt));
                                writeBackParam2.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                            } else {
                                writeBackParam2.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                            }
                        }
                        if ("arpaysettle".equals(settleRelation) && "cas_paybill".equals(asstEntity = recordRow2.getString("e_billentity"))) {
                            coreBillId = (Long)casEntryCoreMap.get(recordRow2.getLong("billentryid"));
                            recCoreBillType = (String)casEntryCoreBillTypeMap.get(recordRow2.getLong("billentryid"));
                            if (coreBillId == null || coreBillId == 0L || coreBillId != null && coreBillId != 0L && !arCoreBillType.equals(recCoreBillType)) {
                                if ("204".equals(recTypeMap.get(asstBillId))) {
                                    writeBackParam2.put("prereceiptallamount", preReceiptAllAmount.add(recordEntrySettleAmt));
                                    writeBackParam2.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                                } else {
                                    writeBackParam2.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                                }
                            }
                        }
                        if (!"arapsettle".equals(settleRelation) && !"artransfer".equals(settleRelation) && !"arliqsettle".equals(settleRelation) && !"baddebtloss".equals(settleRelation)) continue;
                        writeBackParam2.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                    }
                }
                continue;
            }
            long mainBillEntryId = record.getLong("mainbillentryid");
            Row finEntry = finArEntryMap.get(mainBillEntryId);
            if (finEntry == null || (writeBackParam = result.get(key = String.valueOf(finEntry.getLong("corebillid")).concat("_").concat(String.valueOf(finEntry.getLong("corebillentryid"))))) == null || !finEntry.getLong("org").equals((Long)writeBackParam.get("settleorgid"))) continue;
            String arCoreBillType = finEntry.getString("corebilltype");
            BigDecimal remainingAmt = totalSettleAmt;
            for (int i = 0; i < recordRows.size(); ++i) {
                String recCoreBillType;
                Long coreBillId;
                String asstEntity;
                Row recordRow = (Row)recordRows.get(i);
                BigDecimal recordEntrySettleAmt = totalSettleAmt;
                if (i == recordRows.size() - 1) {
                    recordEntrySettleAmt = remainingAmt;
                } else {
                    recordEntrySettleAmt = totalSettleAmt.multiply(recordRow.getBigDecimal("settleamt")).divide(entrySettleTotal, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                    remainingAmt = remainingAmt.subtract(recordEntrySettleAmt);
                }
                long asstBillId = recordRow.getLong("billid");
                BigDecimal receiotAllAmount = (BigDecimal)writeBackParam.get("receiptallamount");
                BigDecimal preReceiptAllAmount = (BigDecimal)writeBackParam.get("prereceiptallamount");
                if ("recsettle".equals(settleRelation)) {
                    asstEntity = recordRow.getString("e_billentity");
                    if ("cas_recbill".equals(asstEntity)) {
                        coreBillId = (Long)casEntryCoreMap.get(recordRow.getLong("billentryid"));
                        recCoreBillType = (String)casEntryCoreBillTypeMap.get(recordRow.getLong("billentryid"));
                        if (coreBillId == null || coreBillId == 0L || coreBillId != null && coreBillId != 0L && !arCoreBillType.equals(recCoreBillType)) {
                            if ("101".equals(recTypeMap.get(asstBillId))) {
                                writeBackParam.put("prereceiptallamount", preReceiptAllAmount.add(recordEntrySettleAmt));
                                writeBackParam.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                            } else {
                                writeBackParam.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                            }
                        }
                    } else if ("101".equals(recTypeMap.get(asstBillId))) {
                        writeBackParam.put("prereceiptallamount", preReceiptAllAmount.add(recordEntrySettleAmt));
                        writeBackParam.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                    } else {
                        writeBackParam.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                    }
                }
                if ("arpaysettle".equals(settleRelation) && "cas_paybill".equals(asstEntity = recordRow.getString("e_billentity"))) {
                    coreBillId = (Long)casEntryCoreMap.get(recordRow.getLong("billentryid"));
                    recCoreBillType = (String)casEntryCoreBillTypeMap.get(recordRow.getLong("billentryid"));
                    if (coreBillId == null || coreBillId == 0L || coreBillId != null && coreBillId == 0L && !arCoreBillType.equals(recCoreBillType)) {
                        if ("204".equals(recTypeMap.get(asstBillId))) {
                            writeBackParam.put("prereceiptallamount", preReceiptAllAmount.add(recordEntrySettleAmt));
                            writeBackParam.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                        } else {
                            writeBackParam.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
                        }
                    }
                }
                if (!"arapsettle".equals(settleRelation) && !"artransfer".equals(settleRelation) && !"arliqsettle".equals(settleRelation) && !"baddebtloss".equals(settleRelation)) continue;
                writeBackParam.put("receiptallamount", receiotAllAmount.add(recordEntrySettleAmt));
            }
        }
    }

    private static void processRecordByFinAsst(Map<Long, List<Row>> finArMap, Map<Long, Row> finArEntryMap, Map<String, Map<String, Object>> result, Map<Object, DynamicObject> currencyMap) {
        QFilter filter = new QFilter("entry.billid", "in", finArMap.keySet());
        filter.and(new QFilter("settlerelation", "=", (Object)"aparsettle"));
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)"queryArSettleRecord", (String)"ar_settlerecord", (String)"totalsettleamt,settlerelation,settleentry,entry.settleamt settleamt,entry.billid billid,mainbillid,entry.billentryid billentryid,mainbillentryid,id", (QFilter[])new QFilter[]{filter}, (String)"mainbizdate");
        if (!recordDataSet.hasNext()) {
            return;
        }
        HashMap<Long, List> recordMap = new HashMap<Long, List>(64);
        for (Row recordRow : recordDataSet.copy()) {
            Long recordId = recordRow.getLong("id");
            List recordRows = recordMap.getOrDefault(recordId, new ArrayList(2));
            recordRows.add(recordRow);
            recordMap.put(recordId, recordRows);
        }
        for (Map.Entry longListEntry : recordMap.entrySet()) {
            List recordRows = (List)longListEntry.getValue();
            if (recordRows == null || recordRows.size() == 0) continue;
            Row record = (Row)recordRows.get(0);
            BigDecimal entrySettleTotal = BigDecimal.ZERO;
            for (Row recordRow : recordRows) {
                entrySettleTotal = entrySettleTotal.add(recordRow.getBigDecimal("settleamt"));
            }
            boolean isPlan = "2".equals(record.getString("settleentry"));
            for (Row recordRow : recordRows) {
                String key;
                Map<String, Object> writeBackParam;
                BigDecimal recordEntrySettleAmt = recordRow.getBigDecimal("settleamt");
                long asstBillId = recordRow.getLong("billid");
                List<Row> finApBill = finArMap.get(asstBillId);
                if (finApBill == null) continue;
                if (isPlan) {
                    count = 0;
                    for (Row detailEntry : finApBill) {
                        if (BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("e_recamount")) == 0) continue;
                        ++count;
                    }
                    BigDecimal remainDisposeAmount = recordEntrySettleAmt;
                    for (Row detailEntry : finApBill) {
                        BigDecimal disposeAmt = ArWriteBackScmcHelper.allocationAmtByPlan(detailEntry, currencyMap, remainDisposeAmount, recordEntrySettleAmt);
                        remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                        String key2 = String.valueOf(detailEntry.getLong("corebillid")).concat("_").concat(String.valueOf(detailEntry.getLong("corebillentryid")));
                        Map<String, Object> writeBackParam2 = result.get(key2);
                        if (writeBackParam2 == null || !detailEntry.getLong("org").equals((Long)writeBackParam2.get("settleorgid"))) continue;
                        BigDecimal receiptAllAmount = (BigDecimal)writeBackParam2.get("receiptallamount");
                        writeBackParam2.put("receiptallamount", receiptAllAmount.add(disposeAmt));
                    }
                    continue;
                }
                long asstBillEntryId = recordRow.getLong("billentryid");
                Row finEntry = finArEntryMap.get(asstBillEntryId);
                if (finEntry == null || (writeBackParam = result.get(key = String.valueOf(finEntry.getLong("corebillid")).concat("_").concat(String.valueOf(finEntry.getLong("corebillentryid"))))) == null || !finEntry.getLong("org").equals((Long)writeBackParam.get("settleorgid"))) continue;
                BigDecimal receiptAllAmount = (BigDecimal)writeBackParam.get("receiptallamount");
                writeBackParam.put("receiptallamount", receiptAllAmount.add(recordEntrySettleAmt));
            }
        }
    }

    private static BigDecimal allocationAmtByPlan(Row detailEntry, Map<Object, DynamicObject> currencyMap, BigDecimal remainDisposeAmount, BigDecimal allocationAllAmt) {
        BigDecimal disposeAmt = BigDecimal.ZERO;
        if (detailEntry == null || currencyMap == null) {
            return disposeAmt;
        }
        DynamicObject currency = currencyMap.get(detailEntry.getLong("currency"));
        BigDecimal headAmt = detailEntry.getBigDecimal("recamount");
        BigDecimal entryAmt = detailEntry.getBigDecimal("e_recamount");
        if (entryAmt.compareTo(BigDecimal.ZERO) == 0) {
            return disposeAmt;
        }
        disposeAmt = --count == 0 ? remainDisposeAmount : allocationAllAmt.multiply(entryAmt).divide(headAmt, currency.getInt("amtprecision"), RoundingMode.HALF_UP);
        return disposeAmt;
    }

    private static Map<String, Map<String, Object>> getInitResult(List<Map<String, Object>> params) {
        if (params == null || params.isEmpty()) {
            return new HashMap<String, Map<String, Object>>(2);
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(64);
        for (Map<String, Object> param : params) {
            HashMap<String, Object> initMap = new HashMap<String, Object>(8);
            initMap.put("mainbillid", param.get("mainbillid"));
            initMap.put("mainbillentryid", param.get("mainbillentryid"));
            initMap.put("settleorgid", param.get("settleorgid"));
            initMap.put("asstid", param.get("asstid"));
            initMap.put("internal_company", param.get("internal_company"));
            initMap.put("prereceiptallamount", BigDecimal.ZERO);
            initMap.put("receiptallamount", BigDecimal.ZERO);
            initMap.put("recamount", BigDecimal.ZERO);
            initMap.put("joinrecamount", BigDecimal.ZERO);
            result.put(String.valueOf(param.get("mainbillid")).concat("_").concat(String.valueOf(param.get("mainbillentryid"))), initMap);
        }
        return result;
    }

    private static void processArRevcfmBill(List<Map<String, Object>> param, Map<String, Map<String, Object>> writeBackParamMap) {
        if (param == null || param.isEmpty()) {
            return;
        }
        HashSet<Long> coreBillIds = new HashSet<Long>(param.size());
        HashSet<Long> coreBillEntryIds = new HashSet<Long>(param.size());
        HashSet<Long> unitIds = new HashSet<Long>(param.size());
        ArrayList<Long> orgIds = new ArrayList<Long>(param.size());
        for (Map<String, Object> map : param) {
            Object mainBillId = map.get("mainbillid");
            Object mainBillEntryId = map.get("mainbillentryid");
            Object settleOrgId = map.get("settleorgid");
            if (mainBillId == null || mainBillEntryId == null || settleOrgId == null) continue;
            coreBillIds.add((Long)mainBillId);
            coreBillEntryIds.add((Long)mainBillEntryId);
            orgIds.add((Long)settleOrgId);
            unitIds.add((Long)map.get("unit"));
        }
        Map unitMap = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(), (String)"bd_measureunits");
        String selector = "id,org,asstacttype,asstact,entry.id entryid,entry.e_confirmamt e_confirmamt,entry.e_confirmqty e_confirmqty,entry.e_corebillentryid corebillentryid,entry.e_corebillid corebillid,currency,entry.e_material e_material,entry.e_baseunitqty e_baseunitqty,entry.e_unitcoefficient e_unitcoefficient";
        DataSet arRevcfmDataSet = QueryServiceHelper.queryDataSet((String)"queryarrevcfmbill", (String)"ar_revcfmbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("entry.e_corebillentryid", "in", coreBillEntryIds), new QFilter("entry.e_corebillid", "in", coreBillIds), new QFilter("billstatus", "=", (Object)"C")}, (String)"bizdate");
        for (Row arRevcfmRow : arRevcfmDataSet) {
            Boolean internalCompany;
            Map<String, Object> inCoreParam;
            String coreKey = arRevcfmRow.getLong("corebillid") + "_" + arRevcfmRow.getLong("corebillentryid");
            Map<String, Object> writeBackParam = writeBackParamMap.get(coreKey);
            if (writeBackParam == null) {
                writeBackParam = new HashMap<String, Object>(8);
                writeBackParam.put("mainbillid", arRevcfmRow.getLong("corebillid"));
                writeBackParam.put("mainbillentryid", arRevcfmRow.getLong("corebillentryid"));
                writeBackParam.put("baseqty", BigDecimal.ZERO);
                writeBackParam.put("amount", BigDecimal.ZERO);
                writeBackParam.put("qty", BigDecimal.ZERO);
            }
            if ((inCoreParam = ArWriteBackScmcHelper.getCoreBillParam(param, coreKey)).isEmpty() || Boolean.TRUE.equals(internalCompany = (Boolean)inCoreParam.get("internal_company")) && arRevcfmRow.getLong("asstact").compareTo((Long)inCoreParam.get("asstid")) != 0 || arRevcfmRow.getLong("org").compareTo((Long)inCoreParam.get("settleorgid")) != 0) continue;
            Long materialId = arRevcfmRow.getLong("e_material");
            DynamicObject materialInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)materialId, (String)"bd_material", (String)"baseunit");
            Long baseUnitId = materialInfo.getLong("baseunit.id");
            DynamicObject srcUnit = (DynamicObject)unitMap.get(baseUnitId);
            DynamicObject desUnit = (DynamicObject)unitMap.get(inCoreParam.get("unit"));
            if (srcUnit == null) {
                srcUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)baseUnitId, (String)"bd_measureunits");
                unitMap.put(baseUnitId, srcUnit);
            }
            BigDecimal confirmQty = arRevcfmRow.getBigDecimal("e_confirmqty");
            BigDecimal unitcoefficient = arRevcfmRow.getBigDecimal("e_unitcoefficient");
            BigDecimal baseQty = ArWriteBackScmcHelper.getBaseUnitQtyByPrecision(confirmQty.multiply(unitcoefficient), srcUnit);
            BigDecimal qtyConv = MaterialHelper.getDesQtyConv((Long)materialId, (DynamicObject)srcUnit, (BigDecimal)baseQty, (DynamicObject)desUnit, (boolean)true);
            BigDecimal qty = (BigDecimal)writeBackParam.get("qty");
            writeBackParam.put("qty", qtyConv.add(qty));
            BigDecimal baseQtyParam = (BigDecimal)writeBackParam.get("baseqty");
            writeBackParam.put("baseqty", baseQty.add(baseQtyParam));
            BigDecimal amount = (BigDecimal)writeBackParam.get("amount");
            writeBackParam.put("amount", arRevcfmRow.getBigDecimal("e_confirmamt").add(amount));
            writeBackParamMap.put(coreKey, writeBackParam);
        }
    }

    private static Map<Long, List<Row>> processFinArBill(List<Map<String, Object>> param, Map<String, Map<String, Object>> writeBackParamMap) {
        HashMap<Long, List<Row>> blueBillMap = new HashMap<Long, List<Row>>(64);
        if (param == null || param.isEmpty()) {
            return blueBillMap;
        }
        HashSet<Long> coreBillIds = new HashSet<Long>(param.size());
        HashSet<Long> coreBillEntryIds = new HashSet<Long>(param.size());
        HashSet<Long> unitIds = new HashSet<Long>(param.size());
        ArrayList<Long> orgIds = new ArrayList<Long>(param.size());
        for (Map<String, Object> map : param) {
            Object mainBillId = map.get("mainbillid");
            Object mainBillEntryId = map.get("mainbillentryid");
            Object settleOrgId = map.get("settleorgid");
            if (mainBillId == null || mainBillEntryId == null || settleOrgId == null) continue;
            coreBillIds.add((Long)mainBillId);
            coreBillEntryIds.add((Long)mainBillEntryId);
            orgIds.add((Long)settleOrgId);
            unitIds.add((Long)map.get("unit"));
        }
        Map unitMap = BusinessDataServiceHelper.loadFromCache((Object[])unitIds.toArray(), (String)"bd_measureunits");
        String selector = "id,org,asstacttype,asstact,entry.id entryid,entry.e_recamount e_recamount,entry.e_quantity e_quantity,entry.corebillentryid corebillentryid,entry.corebillid corebillid,recamount,currency,entry.e_material e_material,entry.e_baseunit e_baseunit,entry.e_baseunitqty e_baseunitqty";
        DataSet finArDataSet = QueryServiceHelper.queryDataSet((String)"queryfinarbill", (String)"ar_finarbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("entry.corebillentryid", "in", coreBillEntryIds), new QFilter("entry.corebillid", "in", coreBillIds), new QFilter("billstatus", "=", (Object)"C")}, (String)"bizdate");
        for (Row finArRow : finArDataSet.copy()) {
            Boolean internalCompany;
            Map<String, Object> inCoreParam;
            String coreKey = finArRow.getLong("corebillid") + "_" + finArRow.getLong("corebillentryid");
            Map<String, Object> writeBackParam = writeBackParamMap.get(coreKey);
            if (writeBackParam == null) {
                writeBackParam = new HashMap<String, Object>(8);
                writeBackParam.put("mainbillid", finArRow.getLong("corebillid"));
                writeBackParam.put("mainbillentryid", finArRow.getLong("corebillentryid"));
                writeBackParam.put("baseqty", BigDecimal.ZERO);
                writeBackParam.put("amount", BigDecimal.ZERO);
                writeBackParam.put("qty", BigDecimal.ZERO);
            }
            if ((inCoreParam = ArWriteBackScmcHelper.getCoreBillParam(param, coreKey)).isEmpty() || Boolean.TRUE.equals(internalCompany = (Boolean)inCoreParam.get("internal_company")) && finArRow.getLong("asstact").compareTo((Long)inCoreParam.get("asstid")) != 0 || finArRow.getLong("org").compareTo((Long)inCoreParam.get("settleorgid")) != 0) continue;
            if (BigDecimal.ZERO.compareTo(finArRow.getBigDecimal("e_recamount")) < 0) {
                Long billId = finArRow.getLong("id");
                List rowList = blueBillMap.getOrDefault(billId, new ArrayList(32));
                rowList.add(finArRow);
                blueBillMap.put(billId, rowList);
            }
            Long baseUnitId = finArRow.getLong("e_baseunit");
            DynamicObject srcUnit = (DynamicObject)unitMap.get(baseUnitId);
            DynamicObject desUnit = (DynamicObject)unitMap.get(inCoreParam.get("unit"));
            if (srcUnit == null) {
                srcUnit = BusinessDataServiceHelper.loadSingleFromCache((Object)baseUnitId, (String)"bd_measureunits");
                unitMap.put(baseUnitId, srcUnit);
            }
            BigDecimal qtyConv = MaterialHelper.getDesQtyConv((Long)finArRow.getLong("e_material"), (DynamicObject)srcUnit, (BigDecimal)finArRow.getBigDecimal("e_baseunitqty"), (DynamicObject)desUnit, (boolean)true);
            BigDecimal qty = (BigDecimal)writeBackParam.get("qty");
            writeBackParam.put("qty", qtyConv.add(qty));
            BigDecimal baseQty = (BigDecimal)writeBackParam.get("baseqty");
            writeBackParam.put("baseqty", baseQty.add(finArRow.getBigDecimal("e_baseunitqty")));
            BigDecimal amount = (BigDecimal)writeBackParam.get("amount");
            writeBackParam.put("amount", finArRow.getBigDecimal("e_recamount").add(amount));
            writeBackParamMap.put(coreKey, writeBackParam);
        }
        return blueBillMap;
    }

    private static Map<String, Object> getCoreBillParam(List<Map<String, Object>> param, String key) {
        if (param == null || param.isEmpty() || key == null) {
            return new HashMap<String, Object>(2);
        }
        for (Map<String, Object> paramMap : param) {
            Object mainBillId = paramMap.get("mainbillid");
            Object mainBillEntryId = paramMap.get("mainbillentryid");
            String str = String.valueOf(mainBillId).concat("_").concat(String.valueOf(mainBillEntryId));
            if (!key.equals(str)) continue;
            return paramMap;
        }
        return new HashMap<String, Object>(2);
    }

    private static void processArSelfParam(Row recordRow, Map<String, Map<String, Object>> writeBackParamMap, BigDecimal disposeAmt) {
        Long coreBillId = recordRow.getLong("corebillid");
        Long coreBillEntryId = recordRow.getLong("corebillentryid");
        String coreKey = coreBillId + "_" + coreBillEntryId;
        Map<String, Object> writeBackParam = writeBackParamMap.get(coreKey);
        if (writeBackParam == null) {
            writeBackParam = new HashMap<String, Object>(4);
            writeBackParam.put("mainbillid", coreBillId);
            writeBackParam.put("mainbillentryid", coreBillEntryId);
            writeBackParam.put("baseqty", BigDecimal.ZERO);
            writeBackParam.put("qty", BigDecimal.ZERO);
            writeBackParam.put("amount", BigDecimal.ZERO);
        }
        BigDecimal amount = (BigDecimal)writeBackParam.get("amount");
        writeBackParam.put("amount", amount.add(disposeAmt.negate()));
        writeBackParamMap.put(coreKey, writeBackParam);
    }

    private static void processArSelfBill(Map<String, Map<String, Object>> writeBackParamMap, Map<Long, List<Row>> blueBillMap) {
        if (writeBackParamMap == null || blueBillMap == null || writeBackParamMap.isEmpty() || blueBillMap.isEmpty()) {
            return;
        }
        String recordSelector = "mainbillid,mainbillentryid,totalsettleamt,entry.billid asstid,entry.billentryid asstentryid,settleentry,corebillentryid,corebillid,maincurrency";
        QFilter recordFilter = new QFilter("settlerelation", "=", (Object)"arself");
        recordFilter.and(new QFilter("mainbillid", "in", blueBillMap.keySet()));
        recordFilter.and(new QFilter("settleentry", "not in", Arrays.asList("", " ")));
        DataSet settleRecordDataSet = QueryServiceHelper.queryDataSet((String)"queryarsettlerocord", (String)"ar_settlerecord", (String)recordSelector, (QFilter[])new QFilter[]{recordFilter}, (String)"mainbizdate");
        HashMap<Long, List> settleRecordMap = new HashMap<Long, List>(64);
        HashSet<Long> currencyIds = new HashSet<Long>(64);
        for (Row settleRecord : settleRecordDataSet.copy()) {
            currencyIds.add(settleRecord.getLong("maincurrency"));
            Long asstId = settleRecord.getLong("asstid");
            List recordList = settleRecordMap.getOrDefault(asstId, new ArrayList(8));
            recordList.add(settleRecord);
            settleRecordMap.put(asstId, recordList);
        }
        QFilter filter = new QFilter("id", "in", settleRecordMap.keySet());
        filter.and(new QFilter("entry.corebillid", "!=", (Object)0L));
        filter.and(new QFilter("entry.corebillentryid", "!=", (Object)0L));
        DataSet asstArBillDataSet = QueryServiceHelper.queryDataSet((String)"queryarcorenotnull", (String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"bizdate");
        HashSet<Long> noCorrectAsst = new HashSet<Long>(64);
        for (Row asstRow : asstArBillDataSet) {
            noCorrectAsst.add(asstRow.getLong("id"));
        }
        if (noCorrectAsst.size() == settleRecordMap.size()) {
            return;
        }
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)});
        for (Map.Entry entrySet : settleRecordMap.entrySet()) {
            Long asstId = (Long)entrySet.getKey();
            List recordRows = (List)entrySet.getValue();
            if (noCorrectAsst.contains(asstId) || recordRows == null || recordRows.isEmpty()) continue;
            for (Row recordRow : recordRows) {
                BigDecimal totalSettleAmt = recordRow.getBigDecimal("totalsettleamt");
                boolean isPlanSettle = "2".equals(recordRow.getString("settleentry"));
                if (isPlanSettle) {
                    List<Row> mainBillRows = blueBillMap.get(recordRow.getLong("mainbillid"));
                    if (mainBillRows == null || mainBillRows.isEmpty()) continue;
                    BigDecimal remainDisposeAmount = totalSettleAmt;
                    BigDecimal disposeAmt = BigDecimal.ZERO;
                    for (int i = 0; i < mainBillRows.size(); ++i) {
                        int precision;
                        Row mainBillRow = mainBillRows.get(i);
                        BigDecimal headAmt = mainBillRow.getBigDecimal("recamount");
                        DynamicObject currency = (DynamicObject)currencyMap.get(mainBillRow.getLong("currency"));
                        int n = precision = currency == null ? 2 : currency.getInt("amtprecision");
                        if (i != mainBillRows.size() - 1) {
                            BigDecimal entryAmt = mainBillRow.getBigDecimal("e_recamount");
                            BigDecimal proportion = entryAmt.divide(headAmt, 10, RoundingMode.HALF_UP);
                            disposeAmt = totalSettleAmt.multiply(proportion).setScale(precision, RoundingMode.HALF_UP);
                            remainDisposeAmount = remainDisposeAmount.subtract(disposeAmt);
                        } else {
                            disposeAmt = remainDisposeAmount;
                        }
                        ArWriteBackScmcHelper.processArSelfParam(mainBillRow, writeBackParamMap, disposeAmt);
                    }
                    continue;
                }
                ArWriteBackScmcHelper.processArSelfParam(recordRow, writeBackParamMap, totalSettleAmt);
            }
        }
        settleRecordDataSet.close();
    }

    private static BigDecimal getBaseUnitQtyByPrecision(BigDecimal baseQty, DynamicObject baseUnitInfo) {
        int precision = baseUnitInfo.getInt("precision") == 0 ? 10 : baseUnitInfo.getInt("precision");
        String precisionAccount = baseUnitInfo.getString("precisionaccount");
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if ("3".equals(precisionAccount)) {
            roundingMode = RoundingMode.UP;
        } else if ("2".equals(precisionAccount)) {
            roundingMode = RoundingMode.DOWN;
        }
        return baseQty.setScale(precision, roundingMode);
    }
}

