/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.conm;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.inspect.conm.pojo.InspectData;

public abstract class ArApQtyAndAmountPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(ArApQtyAndAmountPlugin.class);
    public Map<Object, DynamicObject> unitMap = new HashMap<Object, DynamicObject>();
    public Map<Long, Long> entryIdMapping = new HashMap<Long, Long>();

    public abstract String getOrderEntity();

    public abstract List<String> getContractSelectFields();

    public abstract List<String> getOrderSelectFields();

    public abstract List<Map<String, Object>> calculate(List<Map<String, Object>> var1);

    public abstract String inspect(InspectData var1);

    public abstract String updateSql();

    public abstract List<FixLogInfo> log(InspectData var1);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(this.getContractSelectFields());
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet contracts) {
        List<InspectData> fiDataList = this.calculateData(contracts);
        List<InspectData> inspectDataList = this.inspect(fiDataList);
        List<OperateErrorInfo> errorInfo = this.wrapperErrorMsg(inspectDataList);
        return errorInfo;
    }

    @Override
    public List<FixLogInfo> fixMainDataSet(DataSet contracts) {
        List<InspectData> fiData = this.calculateData(contracts);
        List<InspectData> inspectDataList = this.inspect(fiData);
        List<FixLogInfo> result = this.fixed(inspectDataList);
        return result;
    }

    private List<InspectData> calculateData(DataSet contracts) {
        DataSet queryResult = this.queryContractAndOrder(contracts);
        HashMap<Long, InspectData> fiDataMap = new HashMap<Long, InspectData>();
        ArrayList<Map<String, Object>> orderParamList = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> contractParamList = new ArrayList<Map<String, Object>>(16);
        HashSet<Long> unitIds = new HashSet<Long>(16);
        while (queryResult.hasNext()) {
            InspectData fiData;
            Row row = queryResult.next();
            unitIds.add(row.getLong("cunit"));
            unitIds.add(row.getLong("cbaseunit"));
            Long centryId = row.getLong("centryid");
            Long oid = row.getLong("oid");
            Long oentryId = row.getLong("oentryid");
            if (oid != null && oid != 0L && oentryId != null && oentryId != 0L) {
                orderParamList.add(this.wrapperOrderData(row));
                this.entryIdMapping.put(oentryId, centryId);
            } else {
                contractParamList.add(this.wrapperContractData(row));
            }
            if ((fiData = fiDataMap.get(centryId)) != null) continue;
            fiDataMap.put(centryId, this.buildInspectData(row));
        }
        this.unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id, precision, precisionaccount", (QFilter[])new QFilter("id", "in", unitIds).toArray(), null);
        this.calculateByOrder(fiDataMap, orderParamList);
        this.calculateByContract(fiDataMap, contractParamList);
        return fiDataMap.values().stream().collect(Collectors.toList());
    }

    private DataSet queryContractAndOrder(DataSet contracts) {
        List<String> orderSelectFields = this.getOrderSelectFields();
        StringJoiner joiner = new StringJoiner(",");
        for (String field : orderSelectFields) {
            joiner.add(field);
        }
        DataSet orders = QueryServiceHelper.queryDataSet((String)"QueryOrderBillwhichFromContract", (String)this.getOrderEntity(), (String)joiner.toString(), (QFilter[])new QFilter("billstatus", "=", (Object)"C").and(new QFilter("billentry.conbillentity", "=", (Object)this.getExeDmfUnitInfo().getEntityNumber())).toArray(), null);
        return contracts.copy().join(orders, JoinType.LEFT).on("cid", "conbillid").on("centryid", "conbillentryid").select(new String[]{"cid", "cbillno", "cbizpartner", "cinorg", "centryid", "cseq", "cunit", "csettleorg", "cbaseunit", "material", "cqty", "cbaseqty", "camount"}, new String[]{"oid", "obillno", "obizpartner", "oinorg", "oentryid", "oseq", "ounit", "osettleorg"}).finish();
    }

    private void calculateByContract(HashMap<Long, InspectData> fiDataMap, List<Map<String, Object>> contractParamList) {
        List<Map<String, Object>> contractWriteBackPurParam = this.calculate(contractParamList);
        for (Map<String, Object> obj : contractWriteBackPurParam) {
            Object mainbillentryid = obj.get("mainbillentryid");
            BigDecimal amount = (BigDecimal)obj.get("amount");
            BigDecimal qty = (BigDecimal)obj.get("qty");
            BigDecimal baseqty = (BigDecimal)obj.get("baseqty");
            InspectData fiData = fiDataMap.get(mainbillentryid);
            if (fiData == null) continue;
            fiData.setCalQty(qty);
            fiData.setCalBaseQty(baseqty);
            fiData.setCalAmount(amount);
        }
    }

    private void calculateByOrder(HashMap<Long, InspectData> fiDataMap, List<Map<String, Object>> orderParamList) {
        List<Map<String, Object>> orderWriteBackPurParam = this.calculate(orderParamList);
        for (Map<String, Object> obj : orderWriteBackPurParam) {
            Object mainbillentryid = obj.get("mainbillentryid");
            Long contractEntryId = this.entryIdMapping.get(mainbillentryid);
            if (contractEntryId == null) continue;
            BigDecimal amount = (BigDecimal)obj.get("amount");
            BigDecimal baseqty = (BigDecimal)obj.get("baseqty");
            InspectData fiData = fiDataMap.get(contractEntryId);
            if (fiData == null) continue;
            Long unit = fiData.getUnit();
            Long baseUnit = fiData.getBaseUnit();
            Long material = fiData.getMaterial();
            BigDecimal qty = MaterialHelper.getDesQtyConv((Long)material, (DynamicObject)this.unitMap.get(baseUnit), (BigDecimal)baseqty, (DynamicObject)this.unitMap.get(unit), (boolean)true);
            fiData.setCalQty(fiData.getCalQty().add(qty));
            fiData.setCalBaseQty(fiData.getCalBaseQty().add(baseqty));
            fiData.setCalAmount(fiData.getCalAmount().add(amount));
        }
    }

    private InspectData buildInspectData(Row row) {
        Long cid = row.getLong("cid");
        String cBillNo = row.getString("cbillno");
        Long material = row.getLong("material");
        Long centryId = row.getLong("centryid");
        Long cunit = row.getLong("cunit");
        Long cbaseunit = row.getLong("cbaseunit");
        InspectData fiData = new InspectData(cid, centryId);
        fiData.setBillNo(cBillNo);
        fiData.setSeq(row.getInteger("cseq"));
        fiData.setMaterial(material);
        fiData.setUnit(cunit);
        fiData.setBaseUnit(cbaseunit);
        BigDecimal cqty = row.getBigDecimal("cqty");
        fiData.setCurQty(cqty != null ? cqty : BigDecimal.ZERO);
        BigDecimal cbaseqty = row.getBigDecimal("cbaseqty");
        fiData.setCurBaseQty(cbaseqty != null ? cbaseqty : BigDecimal.ZERO);
        BigDecimal camount = row.getBigDecimal("camount");
        fiData.setCurAmount(camount != null ? camount : BigDecimal.ZERO);
        return fiData;
    }

    private List<InspectData> inspect(List<InspectData> data) {
        ArrayList<InspectData> result = new ArrayList<InspectData>(16);
        for (InspectData value : data) {
            String msg = this.inspect(value);
            if (!StringUtils.isNotEmpty((String)msg)) continue;
            value.setErrorMsg(msg);
            result.add(value);
        }
        return result;
    }

    private List<FixLogInfo> fixed(List<InspectData> inspectData) {
        ArrayList<FixLogInfo> expMsg = new ArrayList<FixLogInfo>(16);
        ArrayList<Object[]> parameterList = new ArrayList<Object[]>(inspectData.size());
        String updateSql = this.updateSql();
        for (InspectData value : inspectData) {
            Object[] obj = new Object[]{value.getCalQty(), value.getCalBaseQty(), value.getCalAmount(), value.getBillentryId()};
            parameterList.add(obj);
            expMsg.addAll(this.log(value));
        }
        if (parameterList.size() > 1000) {
            List partition = DmfSchemeExecuteHelper.partition(parameterList, 1000);
            partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, (List)row));
        } else {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, parameterList);
        }
        return expMsg;
    }

    private List<OperateErrorInfo> wrapperErrorMsg(List<InspectData> dataList) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(16);
        for (InspectData value : dataList) {
            errorInfo.add(this.getExpMsg(this.getClass().getName(), value.getErrorMsg(), value.getBillId(), value.getBillentryId(), value.getBillNo()));
        }
        return errorInfo;
    }

    private Map<String, Object> wrapperContractData(Row row) {
        Long cid = row.getLong("cid");
        Long centryId = row.getLong("centryid");
        Long cBizPartnerId = row.getLong("cbizpartner");
        Long ccompany = row.getLong("cinorg");
        Long cunit = row.getLong("cunit");
        Long centrysettleorg = row.getLong("csettleorg");
        Map<String, Object> param = this.wrapper(cid, centryId, cBizPartnerId, ccompany, cunit, centrysettleorg);
        return param;
    }

    private Map<String, Object> wrapperOrderData(Row row) {
        Long oid = row.getLong("oid");
        Long oentryId = row.getLong("oentryid");
        Long oBizPartnerId = row.getLong("obizpartner");
        Long ocompany = row.getLong("oinorg");
        Long ounit = row.getLong("ounit");
        Long oentrysettleorg = row.getLong("osettleorg");
        Map<String, Object> param = this.wrapper(oid, oentryId, oBizPartnerId, ocompany, ounit, oentrysettleorg);
        return param;
    }

    private Map<String, Object> wrapper(Long id, Long entryId, Long supplier, Long internal, Long unit, Long entrysettleorg) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("mainbillid", id);
        param.put("asstid", supplier);
        param.put("internal_company", internal != null && internal != 0L);
        param.put("mainbillentryid", entryId);
        param.put("unit", unit);
        param.put("settleorgid", entrysettleorg);
        return param;
    }

    private Map logInfo() {
        HashMap<String, String> logDetail = new HashMap<String, String>(16);
        logDetail.put(ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"ArApQtyAndAmountPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), RequestContext.get().getUserName());
        logDetail.put(ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4", (String)"ArApQtyAndAmountPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), FORMATTER.format(LocalDateTime.now()));
        return logDetail;
    }
}

