/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.conm;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.inspect.conm.pojo.AmountInspectData;

public class PurContractOrderAmountPlugin
extends AbstractDmfPlugin {
    private static final Log logger = LogFactory.getLog(PurContractOrderAmountPlugin.class);

    @Override
    public void onPrepareInspectUnitQFilter(List<QFilter> inspectUnitQFilter) {
        DataSet orgs = QueryServiceHelper.queryDataSet((String)"queryOrgs", (String)"conm_purcontract", (String)"org", (QFilter[])inspectUnitQFilter.toArray(new QFilter[inspectUnitQFilter.size()]), null).distinct();
        HashSet<Long> orgSet = new HashSet<Long>(16);
        while (orgs.hasNext()) {
            Row org = orgs.next();
            orgSet.add(org.getLong("org"));
        }
        if (orgSet.size() > 0) {
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)"conm");
            AppParam appParam = new AppParam();
            appParam.setActBookId(Long.valueOf(0L));
            appParam.setAppId(appId);
            appParam.setViewType("15");
            Map paramMap = SystemParamServiceHelper.loadBatchAppParameterByOrg((AppParam)appParam, new ArrayList(orgSet));
            orgSet.clear();
            if (paramMap != null) {
                paramMap.entrySet().stream().forEach(e -> {
                    Map value = (Map)e.getValue();
                    Object fpurorderctrl = value.get("fpurorderctrl");
                    if ("true".equals(String.valueOf(fpurorderctrl))) {
                        orgSet.add(Long.valueOf((String)e.getKey()));
                    }
                });
            }
            if (orgSet.size() > 0) {
                inspectUnitQFilter.add(new QFilter("org", "in", orgSet));
            }
        }
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(this.getContractSelectFields());
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet contracts) {
        List<AmountInspectData> fiDataList = this.calculateData(contracts);
        List<AmountInspectData> inspectDataList = this.inspect(fiDataList);
        List<OperateErrorInfo> errorInfo = this.wrapperErrorMsg(inspectDataList);
        return errorInfo;
    }

    @Override
    public List<FixLogInfo> fixMainDataSet(DataSet contracts) {
        List<AmountInspectData> fiData = this.calculateData(contracts);
        List<AmountInspectData> inspectDataList = this.inspect(fiData);
        List<FixLogInfo> result = this.fixed(inspectDataList);
        return result;
    }

    private List<String> getContractSelectFields() {
        ArrayList<String> list = new ArrayList<String>(3);
        list.add("id as cid");
        list.add("billno as cbillno");
        list.add("orderallamount as corderallamount");
        return list;
    }

    private List<String> getOrderSelectFields() {
        ArrayList<String> list = new ArrayList<String>(4);
        list.add("billentry.amountandtax as oamountandtax");
        list.add("billentry.conbillentity as conbillentity");
        list.add("billentry.conbillid as conbillid");
        list.add("billentry.conbillentryid as conbillentryid");
        return list;
    }

    private List<AmountInspectData> inspect(List<AmountInspectData> inspectDataList) {
        ArrayList<AmountInspectData> errorList = new ArrayList<AmountInspectData>(16);
        String kdMsg = ResManager.loadKDString((String)"\u5df2\u8ba2\u8d27\u91d1\u989d%1$s\u4e0e\u8ba1\u7b97\u51fa\u7684\u5df2\u8ba2\u8d27\u91d1\u989d%2$s\u4e0d\u76f8\u7b49\u3002", (String)"PurContractOrderAmountPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
        for (AmountInspectData inspectData : inspectDataList) {
            BigDecimal calOrderAmount;
            BigDecimal curOrderAmount = inspectData.getCurOrderAmount();
            if (curOrderAmount.compareTo(calOrderAmount = inspectData.getCalOrderAmount()) == 0) continue;
            String msg = String.format(kdMsg, curOrderAmount.toPlainString(), calOrderAmount.toPlainString());
            inspectData.setErrorMsg(msg);
            errorList.add(inspectData);
        }
        return errorList;
    }

    private List<AmountInspectData> calculateData(DataSet contracts) {
        ArrayList<AmountInspectData> result = new ArrayList<AmountInspectData>(16);
        HashMap<Long, AmountInspectData> conMap = new HashMap<Long, AmountInspectData>(16);
        HashMap<Object, List> orderEntryMap = new HashMap<Object, List>(16);
        DataSet copy = contracts.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            Long cid = row.getLong("cid");
            AmountInspectData inspectData = this.buildInspectData(row);
            conMap.put(cid, inspectData);
        }
        DataSet orders = this.queryOrder(contracts);
        while (orders.hasNext()) {
            Row orderEntry = orders.next();
            Long conBillId = orderEntry.getLong("conbillid");
            List orderEntryList = orderEntryMap.computeIfAbsent(conBillId, a -> new ArrayList());
            orderEntryList.add(this.buildOrderData(orderEntry));
        }
        for (Map.Entry contractEntry : conMap.entrySet()) {
            Object key = contractEntry.getKey();
            AmountInspectData contractEntryValue = (AmountInspectData)contractEntry.getValue();
            List mapList = (List)orderEntryMap.get(key);
            if (mapList != null) {
                for (Map map : mapList) {
                    BigDecimal amountAndTax = (BigDecimal)map.get("oamountandtax");
                    BigDecimal calOrderAmount = contractEntryValue.getCalOrderAmount();
                    if (amountAndTax == null) {
                        amountAndTax = BigDecimal.ZERO;
                    }
                    contractEntryValue.setCalOrderAmount(amountAndTax.add(calOrderAmount));
                }
            }
            result.add(contractEntryValue);
        }
        return result;
    }

    private List<OperateErrorInfo> wrapperErrorMsg(List<AmountInspectData> dataList) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(16);
        for (AmountInspectData value : dataList) {
            String errorMsg = value.getErrorMsg();
            if (!StringUtils.isNotEmpty((String)errorMsg)) continue;
            errorInfo.add(this.getExpMsg(this.getClass().getName(), errorMsg, value.getId(), null, value.getBillNo()));
        }
        return errorInfo;
    }

    private Map<String, Object> buildOrderData(Row row) {
        HashMap<String, Object> orderEntryInfo = new HashMap<String, Object>();
        orderEntryInfo.put("oamountandtax", row.getBigDecimal("oamountandtax"));
        return orderEntryInfo;
    }

    private AmountInspectData buildInspectData(Row row) {
        AmountInspectData inspectData = new AmountInspectData();
        inspectData.setId(row.getLong("cid"));
        inspectData.setBillNo(row.getString("cbillno"));
        BigDecimal corderallamount = row.getBigDecimal("corderallamount");
        if (corderallamount != null) {
            inspectData.setCurOrderAmount(corderallamount);
        }
        return inspectData;
    }

    private DataSet queryOrder(DataSet contracts) {
        HashSet<Long> contractIds = new HashSet<Long>(16);
        DataSet copy = contracts.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            contractIds.add(row.getLong("cid"));
        }
        List<String> orderSelectFields = this.getOrderSelectFields();
        StringJoiner joiner = new StringJoiner(",");
        for (String field : orderSelectFields) {
            joiner.add(field);
        }
        DataSet orders = QueryServiceHelper.queryDataSet((String)"QueryOrderBillwhichFromContract", (String)"pm_purorderbill", (String)joiner.toString(), (QFilter[])new QFilter("billentry.conbillentity", "=", (Object)this.getExeDmfUnitInfo().getEntityNumber()).and(new QFilter("billentry.conbillid", "in", contractIds)).and(new QFilter("billstatus", "=", (Object)"C")).toArray(), null);
        return orders;
    }

    private List<FixLogInfo> fixed(List<AmountInspectData> inspectData) {
        ArrayList<FixLogInfo> expMsg = new ArrayList<FixLogInfo>(16);
        ArrayList<Object[]> parameterList = new ArrayList<Object[]>(inspectData.size());
        String updateSql = "update t_conm_purcontract_f set forderallamount=? where fid=?";
        for (AmountInspectData value : inspectData) {
            Object[] obj = new Object[]{value.getCalOrderAmount(), value.getId()};
            parameterList.add(obj);
            expMsg.addAll(this.log(value));
        }
        logger.info(JSON.toJSONString(parameterList));
        if (parameterList.size() > 0) {
            if (parameterList.size() > 1000) {
                List partition = DmfSchemeExecuteHelper.partition(parameterList, 1000);
                partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, (List)row));
            } else {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, parameterList);
            }
        }
        return expMsg;
    }

    public List<FixLogInfo> log(AmountInspectData value) {
        Map<String, String> fieldName = DmfSchemeExecuteHelper.getFieldName(this.getExeDmfUnitInfo().getEntityNumber(), "orderallamount");
        ArrayList<FixLogInfo> list = new ArrayList<FixLogInfo>();
        list.add(new FixLogInfo(value.getId(), value.getBillNo(), null, null, "orderallamount", fieldName.get("orderallamount"), value.getCurOrderAmount().toPlainString(), value.getCalOrderAmount().toPlainString()));
        return list;
    }
}

