/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.conm;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.MaterialHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.inspect.conm.pojo.InspectData;

public class PurContractOrderQtyPlugin
extends AbstractDmfPlugin {
    private static final Log logger = LogFactory.getLog(PurContractOrderQtyPlugin.class);

    @Override
    public void onPrepareInspectUnitQFilter(List<QFilter> inspectUnitQFilter) {
        DataSet orgs = QueryServiceHelper.queryDataSet((String)"queryOrgs", (String)"conm_purcontract", (String)"org", (QFilter[])inspectUnitQFilter.toArray(new QFilter[inspectUnitQFilter.size()]), null).distinct();
        HashSet<Long> orgSet = new HashSet<Long>(16);
        while (orgs.hasNext()) {
            Row org = orgs.next();
            orgSet.add(org.getLong("org"));
        }
        if (orgSet.size() > 0) {
            String appId = BizAppServiceHelp.getAppIdByAppNumber((String)"conm");
            AppParam appParam = new AppParam();
            appParam.setActBookId(Long.valueOf(0L));
            appParam.setAppId(appId);
            appParam.setViewType("15");
            Map paramMap = SystemParamServiceHelper.loadBatchAppParameterByOrg((AppParam)appParam, new ArrayList(orgSet));
            orgSet.clear();
            if (paramMap != null) {
                paramMap.entrySet().stream().forEach(e -> {
                    Map value = (Map)e.getValue();
                    Object fpurorderctrl = value.get("fpurorderctrl");
                    if ("true".equals(String.valueOf(fpurorderctrl))) {
                        orgSet.add(Long.valueOf((String)e.getKey()));
                    }
                });
            }
            if (orgSet.size() > 0) {
                inspectUnitQFilter.add(new QFilter("org", "in", orgSet));
            }
        }
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(this.getContractSelectFields());
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet contracts) {
        List<InspectData> fiDataList = this.calculateData(contracts);
        List<InspectData> inspectDataList = this.inspect(fiDataList);
        List<OperateErrorInfo> errorList = this.wrapperErrorMsg(inspectDataList);
        return errorList;
    }

    @Override
    public List<FixLogInfo> fixMainDataSet(DataSet contracts) {
        List<InspectData> fiData = this.calculateData(contracts);
        List<InspectData> inspectDataList = this.inspect(fiData);
        List<FixLogInfo> result = this.fixed(inspectDataList);
        return result;
    }

    private List<String> getContractSelectFields() {
        ArrayList<String> list = new ArrayList<String>(9);
        list.add("id as cid");
        list.add("billno as cbillno");
        list.add("billentry.id as centryid");
        list.add("billentry.seq as cseq");
        list.add("billentry.material.masterid as material");
        list.add("billentry.unit as cunit");
        list.add("billentry.baseunit as cbaseunit");
        list.add("billentry.orderqty as corderqty");
        list.add("billentry.orderbaseqty as corderbaseqty");
        return list;
    }

    private List<String> getOrderSelectFields() {
        ArrayList<String> list = new ArrayList<String>(7);
        list.add("billentry.qty as oqty");
        list.add("billentry.baseqty as obaseqty");
        list.add("billentry.unit as ounit");
        list.add("billentry.baseunit as obaseunit");
        list.add("billentry.conbillentity as conbillentity");
        list.add("billentry.conbillid as conbillid");
        list.add("billentry.conbillentryid as conbillentryid");
        return list;
    }

    private List<InspectData> inspect(List<InspectData> inspectDataList) {
        ArrayList<InspectData> errorList = new ArrayList<InspectData>(16);
        String kdMsg1 = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u5df2\u8ba2\u8d27\u6570\u91cf%2$s\u4e0e\u8ba1\u7b97\u51fa\u7684\u5df2\u8ba2\u8d27\u6570\u91cf%3$s\u4e0d\u76f8\u7b49\u3002", (String)"PurContractOrderQtyPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
        String kdMsg2 = ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u5df2\u8ba2\u8d27\u57fa\u672c\u6570\u91cf%2$s\u4e0e\u8ba1\u7b97\u51fa\u7684\u5df2\u8ba2\u8d27\u57fa\u672c\u6570\u91cf%3$s\u4e0d\u76f8\u7b49\u3002", (String)"PurContractOrderQtyPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
        for (InspectData inspectData : inspectDataList) {
            BigDecimal calOrderBaseQty;
            BigDecimal curOrderBaseQty;
            BigDecimal curOrderQty = inspectData.getCurOrderQty();
            BigDecimal calOrderQty = inspectData.getCalOrderQty();
            String msg = "";
            if (curOrderQty.compareTo(calOrderQty) != 0) {
                msg = msg + String.format(kdMsg1, inspectData.getSeq(), curOrderQty.toPlainString(), calOrderQty.toPlainString());
            }
            if ((curOrderBaseQty = inspectData.getCurOrderBaseQty()).compareTo(calOrderBaseQty = inspectData.getCalOrderBaseQty()) != 0) {
                msg = msg + String.format(kdMsg2, inspectData.getSeq(), curOrderBaseQty.toPlainString(), calOrderBaseQty.toPlainString());
            }
            if (!StringUtils.isNotEmpty((String)msg)) continue;
            inspectData.setErrorMsg(msg);
            errorList.add(inspectData);
        }
        return errorList;
    }

    private List<InspectData> calculateData(DataSet contracts) {
        ArrayList<InspectData> result = new ArrayList<InspectData>(16);
        HashMap<Long, InspectData> conEntryMap = new HashMap<Long, InspectData>(16);
        HashMap<Object, List> orderEntryMap = new HashMap<Object, List>(16);
        HashSet<Long> unitIds = new HashSet<Long>(16);
        DataSet copy = contracts.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            Long centryid = row.getLong("centryid");
            unitIds.add(row.getLong("cunit"));
            unitIds.add(row.getLong("cbaseunit"));
            InspectData inspectData = this.buildInspectData(row);
            conEntryMap.put(centryid, inspectData);
        }
        DataSet orders = this.queryOrder(contracts);
        while (orders.hasNext()) {
            Row orderEntry = orders.next();
            unitIds.add(orderEntry.getLong("ounit"));
            Long conBillEntryId = orderEntry.getLong("conbillentryid");
            List orderEntryList = orderEntryMap.computeIfAbsent(conBillEntryId, a -> new ArrayList());
            orderEntryList.add(this.buildOrderData(orderEntry));
        }
        Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id, precision, precisionaccount", (QFilter[])new QFilter("id", "in", unitIds).toArray(), null);
        for (Map.Entry contractEntry : conEntryMap.entrySet()) {
            Object key = contractEntry.getKey();
            InspectData contractEntryValue = (InspectData)contractEntry.getValue();
            Long unit = contractEntryValue.getUnit();
            Long material = contractEntryValue.getMaterial();
            Long baseUnit = contractEntryValue.getBaseUnit();
            List mapList = (List)orderEntryMap.get(key);
            if (mapList != null) {
                for (Map map : mapList) {
                    BigDecimal oQty = (BigDecimal)map.get("oqty");
                    BigDecimal oBaseQty = (BigDecimal)map.get("obaseqty");
                    Long oUnit = (Long)map.get("ounit");
                    BigDecimal calQty = contractEntryValue.getCalOrderQty();
                    if (unit.equals(oUnit)) {
                        contractEntryValue.setCalOrderQty(calQty.add(oQty));
                    } else {
                        oQty = MaterialHelper.getDesQtyConv((Long)material, (DynamicObject)((DynamicObject)unitMap.get(baseUnit)), (BigDecimal)oBaseQty, (DynamicObject)((DynamicObject)unitMap.get(unit)), (boolean)true);
                        contractEntryValue.setCalOrderQty(calQty.add(oQty));
                    }
                    BigDecimal calBaseQty = contractEntryValue.getCalOrderBaseQty();
                    contractEntryValue.setCalOrderBaseQty(calBaseQty.add(oBaseQty));
                }
            }
            result.add(contractEntryValue);
        }
        return result;
    }

    private List<OperateErrorInfo> wrapperErrorMsg(List<InspectData> dataList) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(16);
        for (InspectData value : dataList) {
            String errorMsg = value.getErrorMsg();
            if (!StringUtils.isNotEmpty((String)errorMsg)) continue;
            errorInfo.add(this.getExpMsg(this.getClass().getName(), errorMsg, value.getBillId(), value.getBillentryId(), value.getBillNo()));
        }
        return errorInfo;
    }

    private Map<String, Object> buildOrderData(Row row) {
        HashMap<String, Object> orderEntryInfo = new HashMap<String, Object>(3);
        orderEntryInfo.put("oqty", row.getBigDecimal("oqty"));
        orderEntryInfo.put("obaseqty", row.getBigDecimal("obaseqty"));
        orderEntryInfo.put("ounit", row.getLong("ounit"));
        return orderEntryInfo;
    }

    private InspectData buildInspectData(Row row) {
        BigDecimal corderbaseqty;
        InspectData inspectData = new InspectData(row.getLong("cid"), row.getLong("centryid"));
        inspectData.setBillNo(row.getString("cbillno"));
        inspectData.setSeq(row.getInteger("cseq"));
        inspectData.setMaterial(row.getLong("material"));
        inspectData.setUnit(row.getLong("cunit"));
        inspectData.setBaseUnit(row.getLong("cbaseunit"));
        BigDecimal corderqty = row.getBigDecimal("corderqty");
        if (corderqty != null) {
            inspectData.setCurOrderQty(corderqty);
        }
        if ((corderbaseqty = row.getBigDecimal("corderbaseqty")) != null) {
            inspectData.setCurOrderBaseQty(corderbaseqty);
        }
        return inspectData;
    }

    private DataSet queryOrder(DataSet contracts) {
        HashSet<Long> contractEntryIds = new HashSet<Long>(16);
        DataSet copy = contracts.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            Long centryid = row.getLong("centryid");
            if (centryid == null || centryid == 0L) continue;
            contractEntryIds.add(centryid);
        }
        List<String> orderSelectFields = this.getOrderSelectFields();
        StringJoiner joiner = new StringJoiner(",");
        for (String field : orderSelectFields) {
            joiner.add(field);
        }
        DataSet orders = QueryServiceHelper.queryDataSet((String)"QueryOrderBillwhichFromContract", (String)"pm_purorderbill", (String)joiner.toString(), (QFilter[])new QFilter("billentry.conbillentity", "=", (Object)this.getExeDmfUnitInfo().getEntityNumber()).and(new QFilter("billentry.conbillentryid", "in", contractEntryIds)).and(new QFilter("billstatus", "=", (Object)"C")).toArray(), null);
        return orders;
    }

    private List<FixLogInfo> fixed(List<InspectData> inspectData) {
        ArrayList<FixLogInfo> expMsg = new ArrayList<FixLogInfo>(16);
        ArrayList<Object[]> parameterList = new ArrayList<Object[]>(inspectData.size());
        String updateSql = "update t_conm_purcontractentry_r set forderqty=?,forderbaseqty=?  where fentryid=?";
        for (InspectData value : inspectData) {
            Object[] obj = new Object[]{value.getCalOrderQty(), value.getCalOrderBaseQty(), value.getBillentryId()};
            parameterList.add(obj);
            expMsg.addAll(this.logEntry(value));
        }
        logger.info(JSON.toJSONString(parameterList));
        if (parameterList.size() > 0) {
            if (parameterList.size() > 1000) {
                List partition = DmfSchemeExecuteHelper.partition(parameterList, 1000);
                partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, (List)row));
            } else {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, parameterList);
            }
        }
        return expMsg;
    }

    public List<FixLogInfo> logEntry(InspectData value) {
        Map<String, String> fieldName = DmfSchemeExecuteHelper.getFieldName(this.getExeDmfUnitInfo().getEntityNumber(), "orderqty", "orderbaseqty");
        ArrayList<FixLogInfo> list = new ArrayList<FixLogInfo>();
        list.add(new FixLogInfo(value.getBillId(), value.getBillNo(), value.getSeq(), value.getBillentryId(), "orderqty", fieldName.get("orderqty"), value.getCurOrderQty().toPlainString(), value.getCalOrderQty().toPlainString()));
        list.add(new FixLogInfo(value.getBillId(), value.getBillNo(), value.getSeq(), value.getBillentryId(), "orderbaseqty", fieldName.get("orderbaseqty"), value.getCurOrderBaseQty().toPlainString(), value.getCalOrderBaseQty().toPlainString()));
        return list;
    }
}

