/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.conm;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.inspect.common.ArWriteBackScmcHelper;
import kd.mpscmm.msbd.datamanage.inspect.conm.ArApQtyAndAmountPlugin;
import kd.mpscmm.msbd.datamanage.inspect.conm.pojo.InspectData;

public class SalContractArQtyAndAmountPlugin
extends ArApQtyAndAmountPlugin {
    public static final TrackLogService logger = new TrackLogService(SalContractArQtyAndAmountPlugin.class, "conm");

    @Override
    public String getOrderEntity() {
        return "sm_salorder";
    }

    @Override
    public List<String> getContractSelectFields() {
        ArrayList<String> list = new ArrayList<String>(13);
        list.add("id as cid");
        list.add("billno as cbillno");
        list.add("billentry.id as centryid");
        list.add("billentry.seq as cseq");
        list.add("billentry.material.masterid as material");
        list.add("billentry.unit as cunit");
        list.add("billentry.baseunit as cbaseunit");
        list.add("billentry.entrysettleorg as csettleorg");
        list.add("customer as cbizpartner");
        list.add("customer.internal_company as cinorg");
        list.add("billentry.joinpriceqty as cqty");
        list.add("billentry.joinpricebaseqty as cbaseqty");
        list.add("billentry.aramount as camount");
        return list;
    }

    @Override
    public List<String> getOrderSelectFields() {
        ArrayList<String> list = new ArrayList<String>(11);
        list.add("id as oid");
        list.add("billno as obillno");
        list.add("customer as obizpartner");
        list.add("customer.internal_company as oinorg");
        list.add("billentry.id as oentryid");
        list.add("billentry.seq as oseq");
        list.add("billentry.unit as ounit");
        list.add("billentry.entrysettleorg as osettleorg");
        list.add("billentry.conbillentity as conbillentity");
        list.add("billentry.conbillid as conbillid");
        list.add("billentry.conbillentryid as conbillentryid");
        return list;
    }

    @Override
    public List<Map<String, Object>> calculate(List<Map<String, Object>> paramList) {
        logger.info("before invoke order ArCalculate params:" + JSON.toJSONString(paramList));
        List<Map<String, Object>> writeBackPurParam = ArWriteBackScmcHelper.constructReceivableData(paramList);
        logger.info("after invoke order ArCalculate returns:" + JSON.toJSONString(writeBackPurParam));
        return writeBackPurParam;
    }

    @Override
    public String inspect(InspectData data) {
        boolean flag = true;
        String msg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"SalContractArQtyAndAmountPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), data.getSeq());
        msg = msg + "\uff0c";
        BigDecimal calQty = data.getCalQty();
        BigDecimal curQty = data.getCurQty();
        if (calQty != null && curQty != null && calQty.compareTo(curQty) != 0) {
            msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e00: \u5e94\u6536\u6570\u91cf\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u6536\u6570\u91cf\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"SalContractArQtyAndAmountPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), curQty.toPlainString(), calQty.toPlainString());
            flag = false;
        }
        BigDecimal calBaseQty = data.getCalBaseQty();
        BigDecimal curBaseQty = data.getCurBaseQty();
        if (calBaseQty != null && curBaseQty != null && calBaseQty.compareTo(curBaseQty) != 0) {
            msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e8c: \u5e94\u6536\u57fa\u672c\u6570\u91cf\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u6536\u57fa\u672c\u6570\u91cf\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"SalContractArQtyAndAmountPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), curBaseQty.toPlainString(), calBaseQty.toPlainString());
            flag = false;
        }
        BigDecimal calAmount = data.getCalAmount();
        BigDecimal curAmount = data.getCurAmount();
        if (calAmount != null && curAmount != null && calAmount.compareTo(curAmount) != 0) {
            msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e09: \u5e94\u6536\u91d1\u989d\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5e94\u6536\u91d1\u989d\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"SalContractArQtyAndAmountPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), curAmount.toPlainString(), calAmount.toPlainString());
            flag = false;
        }
        return flag ? null : msg;
    }

    @Override
    public String updateSql() {
        return "update t_conm_salcontractentry_r set fjoinpriceqty=? ,fjoinpricebaseqty=?,faramount=? where fentryid=?";
    }

    @Override
    public List<FixLogInfo> log(InspectData value) {
        Map<String, String> fieldName = DmfSchemeExecuteHelper.getFieldName(this.getExeDmfUnitInfo().getEntityNumber(), "joinpriceqty", "joinpricebaseqty", "aramount");
        ArrayList<FixLogInfo> list = new ArrayList<FixLogInfo>();
        list.add(new FixLogInfo(value.getBillId(), value.getBillNo(), value.getSeq(), value.getBillentryId(), "joinpriceqty", fieldName.get("joinpriceqty"), value.getCurQty().toPlainString(), value.getCalQty().toPlainString()));
        list.add(new FixLogInfo(value.getBillId(), value.getBillNo(), value.getSeq(), value.getBillentryId(), "joinpricebaseqty", fieldName.get("joinpricebaseqty"), value.getCurBaseQty().toPlainString(), value.getCalBaseQty().toPlainString()));
        list.add(new FixLogInfo(value.getBillId(), value.getBillNo(), value.getSeq(), value.getBillentryId(), "aramount", fieldName.get("aramount"), value.getCurAmount().toPlainString(), value.getCalAmount().toPlainString()));
        return list;
    }
}

