/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.conm;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.inspect.common.ArWriteBackScmcHelper;
import kd.mpscmm.msbd.datamanage.inspect.conm.pojo.AmountInspectData;
import kd.mpscmm.msbd.datamanage.inspect.conm.pojo.EntryInspectData;

public class SalRecAmountDmfPlugin
extends AbstractDmfPlugin {
    private static Log logger = LogFactory.getLog(SalRecAmountDmfPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id");
        fields.add("billno");
        fields.add("prereceiptallamount");
        fields.add("receiptallamount");
        fields.add("billentry.id as entryid");
        fields.add("billentry.seq as seq");
        fields.add("billentry.entrysettleorg as entrysettleorg");
        e.getFieldKeys().addAll(fields);
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet dataSet) {
        List<AmountInspectData> calDataList = this.calculateData(dataSet);
        List<OperateErrorInfo> errorList = this.getErrorInfos(calDataList);
        return errorList;
    }

    private List<OperateErrorInfo> getErrorInfos(List<AmountInspectData> calDataList) {
        ArrayList<OperateErrorInfo> errorList = new ArrayList<OperateErrorInfo>();
        for (AmountInspectData data : calDataList) {
            Map<Long, EntryInspectData> entryDatas;
            String msg;
            BigDecimal calAmount = data.getCalAmount();
            BigDecimal calPreAmount = data.getCalPreAmount();
            BigDecimal curAmount = data.getCurAmount();
            BigDecimal curPreAmount = data.getCurPreAmount();
            String billNo = data.getBillNo();
            if (curAmount.compareTo(calAmount) != 0) {
                msg = ResManager.loadKDString((String)"\u5355\u636e\u5934.\u5df2\u6536\u91d1\u989d%1$s\u4e0e\u8ba1\u7b97\u51fa\u7684\u7ed3\u679c%2$s\u4e0d\u76f8\u7b49\u3002", (String)"SalRecAmountDmfPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
                errorList.add(this.getExpMsg(this.getClass().getSimpleName(), String.format(msg, curAmount.toPlainString(), calAmount.toPlainString()), data.getId(), null, billNo));
            }
            if (curPreAmount.compareTo(calPreAmount) != 0) {
                msg = ResManager.loadKDString((String)"\u5355\u636e\u5934.\u5df2\u9884\u6536\u91d1\u989d%1$s\u4e0e\u8ba1\u7b97\u51fa\u7684\u7ed3\u679c%2$s\u4e0d\u76f8\u7b49\u3002", (String)"SalRecAmountDmfPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
                errorList.add(this.getExpMsg(this.getClass().getSimpleName(), String.format(msg, curPreAmount.toPlainString(), calPreAmount.toPlainString()), data.getId(), null, billNo));
            }
            if ((entryDatas = data.getEntryDatas()) == null || entryDatas.size() <= 0) continue;
            for (EntryInspectData entryInspectData : entryDatas.values()) {
                String msg2;
                BigDecimal curJoinAmount = entryInspectData.getCurJoinAmount();
                BigDecimal curRealAmount = entryInspectData.getCurRealAmount();
                BigDecimal calJoinAmount = entryInspectData.getCalJoinAmount();
                BigDecimal calRealAmount = entryInspectData.getCalRealAmount();
                Integer seq = entryInspectData.getSeq();
                if (curJoinAmount.compareTo(calJoinAmount) != 0) {
                    msg2 = ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u5173\u8054\u6536\u6b3e\u91d1\u989d%2$s\u4e0e\u8ba1\u7b97\u51fa\u7684\u7ed3\u679c%3$s\u4e0d\u76f8\u7b49\u3002", (String)"SalRecAmountDmfPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
                    errorList.add(this.getExpMsg(this.getClass().getSimpleName(), String.format(msg2, String.valueOf(seq), curJoinAmount.toPlainString(), calJoinAmount.toPlainString()), data.getId(), entryInspectData.getEntryid(), billNo));
                }
                if (curRealAmount.compareTo(calRealAmount) == 0) continue;
                msg2 = ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u5df2\u6536\u91d1\u989d%2$s\u4e0e\u8ba1\u7b97\u51fa\u7684\u7ed3\u679c%3$s\u4e0d\u76f8\u7b49\u3002", (String)"SalRecAmountDmfPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
                errorList.add(this.getExpMsg(this.getClass().getSimpleName(), String.format(msg2, String.valueOf(seq), curRealAmount.toPlainString(), calRealAmount.toPlainString()), data.getId(), entryInspectData.getEntryid(), billNo));
            }
        }
        return errorList;
    }

    private List<AmountInspectData> calculateData(DataSet data) {
        ArrayList<AmountInspectData> datas = new ArrayList<AmountInspectData>();
        HashSet<Long> contractIds = new HashSet<Long>(16);
        while (data.hasNext()) {
            Row row = data.next();
            Long id = row.getLong("id");
            contractIds.add(id);
        }
        DynamicObject[] contractBills = BusinessDataServiceHelper.load((String)"conm_salcontract", (String)"id,billno,customer,customer.internal_company,prereceiptallamount,receiptallamount,billentry.id.billentry.seq,billentry.entrysettleorg,payentry.id,payentry.seq,payentry.joinpayamount,payentry.paidamount", (QFilter[])new QFilter("id", "in", contractIds).toArray());
        HashMap<Long, AmountInspectData> inspectDataMap = this.record(contractBills);
        this.calHeadAmount(contractBills, inspectDataMap);
        this.calPayEntryAmount(contractBills, inspectDataMap);
        datas.addAll(inspectDataMap.values());
        return datas;
    }

    private void calHeadAmount(DynamicObject[] contractBills, HashMap<Long, AmountInspectData> inspectDataMap) {
        Set contractIds = Arrays.stream(contractBills).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        DynamicObjectCollection orderEntrys = QueryServiceHelper.query((String)"sm_salorder", (String)"id,prereceiptamount,receiptamount,billentry.conbillid as conbillid", (QFilter[])new QFilter("billstatus", "=", (Object)"C").and(new QFilter("billentry.seq", "=", (Object)1)).and(new QFilter("billentry.conbillentity", "=", (Object)this.getExeDmfUnitInfo().getEntityNumber())).and(new QFilter("billentry.conbillid", "in", contractIds)).toArray());
        HashSet<Long> hasOrderContract = new HashSet<Long>();
        for (DynamicObject orderEntry : orderEntrys) {
            long conbillid = orderEntry.getLong("conbillid");
            BigDecimal prereceiptallamount = orderEntry.getBigDecimal("prereceiptamount");
            BigDecimal receiptallamount = orderEntry.getBigDecimal("receiptamount");
            AmountInspectData amountInpectData = inspectDataMap.get(conbillid);
            if (amountInpectData == null) continue;
            amountInpectData.setCalAmount(amountInpectData.getCalAmount().add(receiptallamount));
            amountInpectData.setCalPreAmount(amountInpectData.getCalPreAmount().add(prereceiptallamount));
            hasOrderContract.add(conbillid);
        }
        ArrayList selfPayEntryParams = new ArrayList();
        ArrayList<Map<String, Object>> selfBillEntryParams = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> orderBillEntryParams = new ArrayList<Map<String, Object>>();
        for (DynamicObject bill : contractBills) {
            Object pkValue = bill.getPkValue();
            long partner = bill.getLong("customer.id");
            boolean inOrg = bill.getDynamicObject("customer.internal_company") != null;
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            if (billentry.size() <= 0) continue;
            for (DynamicObject entry : billentry) {
                Object entryPk = entry.getPkValue();
                long settleOrgId = entry.getLong("entrysettleorg.id");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("mainbillid", pkValue);
                map.put("mainbillentryid", entryPk);
                map.put("settleorgid", settleOrgId);
                map.put("asstid", partner);
                map.put("internal_company", inOrg);
                if (hasOrderContract.contains(pkValue)) {
                    map.put("accessType", "conm");
                    orderBillEntryParams.add(map);
                    continue;
                }
                map.put("accessType", "self");
                selfBillEntryParams.add(map);
            }
            long settleOrgId = ((DynamicObject)billentry.get(0)).getLong("entrysettleorg.id");
            DynamicObjectCollection payentry = bill.getDynamicObjectCollection("payentry");
            for (DynamicObject entry : payentry) {
                Object entryPk = entry.getPkValue();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("mainbillid", pkValue);
                map.put("mainbillentryid", entryPk);
                map.put("settleorgid", settleOrgId);
                map.put("asstid", partner);
                map.put("internal_company", inOrg);
                if (hasOrderContract.contains(pkValue)) {
                    map.put("accessType", "conm");
                    orderBillEntryParams.add(map);
                    continue;
                }
                map.put("accessType", "self");
                selfPayEntryParams.add(map);
            }
        }
        selfBillEntryParams.addAll(selfPayEntryParams);
        orderBillEntryParams.addAll(selfPayEntryParams);
        this.calSelfHeadAmount(inspectDataMap, selfBillEntryParams);
        this.calSelfHeadAmount(inspectDataMap, orderBillEntryParams);
    }

    private void calPayEntryAmount(DynamicObject[] contractBills, HashMap<Long, AmountInspectData> inspectDataMap) {
        List<Map<String, Object>> planAmountResult;
        ArrayList<Map<String, Object>> allPayEntryParams = new ArrayList<Map<String, Object>>();
        for (DynamicObject bill : contractBills) {
            Object pkValue = bill.getPkValue();
            long partner = bill.getLong("customer.id");
            boolean inOrg = bill.getDynamicObject("customer.internal_company") != null;
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            if (billentry.size() <= 0) continue;
            long settleOrgId = ((DynamicObject)billentry.get(0)).getLong("entrysettleorg.id");
            DynamicObjectCollection payentry = bill.getDynamicObjectCollection("payentry");
            for (DynamicObject entry : payentry) {
                Object entryPk = entry.getPkValue();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("mainbillid", pkValue);
                map.put("mainbillentryid", entryPk);
                map.put("settleorgid", settleOrgId);
                map.put("asstid", partner);
                map.put("internal_company", inOrg);
                allPayEntryParams.add(map);
            }
        }
        if (allPayEntryParams != null && allPayEntryParams.size() > 0 && (planAmountResult = ArWriteBackScmcHelper.writeBackPlanRecAmt(allPayEntryParams)) != null) {
            for (Map<String, Object> map : planAmountResult) {
                Map<Long, EntryInspectData> entryDatas;
                EntryInspectData entryInspectData;
                Object mainbillid = map.get("mainbillid");
                Object mainbillentryid = map.get("mainbillentryid");
                BigDecimal joinpayamount = (BigDecimal)map.get("joinrecamount");
                BigDecimal paidamount = (BigDecimal)map.get("recamount");
                AmountInspectData amountInpectData = inspectDataMap.get(mainbillid);
                if (amountInpectData == null || joinpayamount == null || paidamount == null || (entryInspectData = (entryDatas = amountInpectData.getEntryDatas()).get(mainbillentryid)) == null) continue;
                BigDecimal calJoinAmount = entryInspectData.getCalJoinAmount();
                BigDecimal calRealAmount = entryInspectData.getCalRealAmount();
                entryInspectData.setCalJoinAmount(calJoinAmount.add(joinpayamount));
                entryInspectData.setCalRealAmount(calRealAmount.add(paidamount));
            }
        }
    }

    private HashMap<Long, AmountInspectData> record(DynamicObject[] contractBills) {
        HashMap<Long, AmountInspectData> inspectDataMap = new HashMap<Long, AmountInspectData>();
        for (DynamicObject bill : contractBills) {
            Object pkValue = bill.getPkValue();
            String billNo = bill.getString("billno");
            BigDecimal prereceiptallamount = bill.getBigDecimal("prereceiptallamount");
            BigDecimal receiptallamount = bill.getBigDecimal("receiptallamount");
            long customer = bill.getLong("customer.id");
            boolean inOrg = bill.getDynamicObject("customer.internal_company") != null;
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            if (billentry == null || billentry.size() <= 0) continue;
            DynamicObject firstEntry = (DynamicObject)billentry.get(0);
            long settleOrgId = firstEntry.getLong("entrysettleorg.id");
            DynamicObjectCollection payentry = bill.getDynamicObjectCollection("payentry");
            AmountInspectData inspectData = new AmountInspectData();
            inspectData.setId((Long)pkValue);
            inspectData.setBillNo(billNo);
            inspectData.setPartner(customer);
            inspectData.setInOrg(inOrg);
            inspectData.setCurPreAmount(inspectData.getCurPreAmount().add(prereceiptallamount));
            inspectData.setCurAmount(inspectData.getCalAmount().add(receiptallamount));
            if (payentry != null && payentry.size() > 0) {
                Map<Long, EntryInspectData> entryDatas = inspectData.getEntryDatas();
                if (entryDatas == null) {
                    entryDatas = new HashMap<Long, EntryInspectData>();
                    inspectData.setEntryDatas(entryDatas);
                }
                for (DynamicObject entry : payentry) {
                    Object entryPk = entry.getPkValue();
                    int seq = entry.getInt("seq");
                    BigDecimal joinpayamount = entry.getBigDecimal("joinpayamount");
                    BigDecimal paidamount = entry.getBigDecimal("paidamount");
                    EntryInspectData entryInspectData = new EntryInspectData();
                    entryInspectData.setEntryid((Long)entryPk);
                    entryInspectData.setSeq(seq);
                    entryInspectData.setSettleOrg(settleOrgId);
                    entryInspectData.setCurJoinAmount(entryInspectData.getCurJoinAmount().add(joinpayamount));
                    entryInspectData.setCurRealAmount(entryInspectData.getCurRealAmount().add(paidamount));
                    entryDatas.put((Long)entryPk, entryInspectData);
                }
            }
            inspectDataMap.put((Long)pkValue, inspectData);
        }
        return inspectDataMap;
    }

    private void calSelfHeadAmount(HashMap<Long, AmountInspectData> inspectDataMap, List<Map<String, Object>> materialBillEntryParams) {
        List<Map<String, Object>> noOrderHeadAmountResult;
        if (materialBillEntryParams != null && materialBillEntryParams.size() > 0 && (noOrderHeadAmountResult = ArWriteBackScmcHelper.writeBackHeadRecAmt(materialBillEntryParams)) != null) {
            for (Map<String, Object> map : noOrderHeadAmountResult) {
                Object mainbillid = map.get("mainbillid");
                BigDecimal paidpreallamount = (BigDecimal)map.get("prereceiptallamount");
                BigDecimal paidallamount = (BigDecimal)map.get("receiptallamount");
                AmountInspectData amountInpectData = inspectDataMap.get(mainbillid);
                if (amountInpectData == null) continue;
                BigDecimal calAmount = amountInpectData.getCalAmount();
                BigDecimal calPreAmount = amountInpectData.getCalPreAmount();
                amountInpectData.setCalAmount(paidallamount.add(calAmount));
                amountInpectData.setCalPreAmount(paidpreallamount.add(calPreAmount));
            }
        }
    }

    @Override
    public List<FixLogInfo> fixMainDataSet(DataSet dataSet) {
        List partition;
        Map<String, String> fieldName = DmfSchemeExecuteHelper.getFieldName(this.getExeDmfUnitInfo().getEntityNumber(), "prereceiptallamount", "receiptallamount", "joinpayamount", "paidamount");
        ArrayList<FixLogInfo> list = new ArrayList<FixLogInfo>();
        ArrayList<Object[]> headList = new ArrayList<Object[]>();
        ArrayList<Object[]> entryList = new ArrayList<Object[]>();
        List<AmountInspectData> fiDataList = this.calculateData(dataSet);
        for (AmountInspectData data : fiDataList) {
            Map<Long, EntryInspectData> entryDatas;
            BigDecimal calAmount = data.getCalAmount();
            BigDecimal calPreAmount = data.getCalPreAmount();
            BigDecimal curAmount = data.getCurAmount();
            BigDecimal curPreAmount = data.getCurPreAmount();
            if (curAmount.compareTo(calAmount) != 0 || curPreAmount.compareTo(calPreAmount) != 0) {
                Object[] param = new Object[]{data.getCalPreAmount(), data.getCalAmount(), data.getId()};
                headList.add(param);
                FixLogInfo preAmountLogInfo = new FixLogInfo(data.getId(), data.getBillNo(), 0, 0L, "prereceiptallamount", fieldName.get("prereceiptallamount"), curPreAmount.toPlainString(), calPreAmount.toPlainString());
                FixLogInfo amountLogInfo = new FixLogInfo(data.getId(), data.getBillNo(), 0, 0L, "receiptallamount", fieldName.get("receiptallamount"), curAmount.toPlainString(), calAmount.toPlainString());
                list.add(preAmountLogInfo);
                list.add(amountLogInfo);
            }
            if ((entryDatas = data.getEntryDatas()) == null || entryDatas.size() <= 0) continue;
            for (EntryInspectData entryInspectData : entryDatas.values()) {
                BigDecimal curJoinAmount = entryInspectData.getCurJoinAmount();
                BigDecimal curRealAmount = entryInspectData.getCurRealAmount();
                BigDecimal calJoinAmount = entryInspectData.getCalJoinAmount();
                BigDecimal calRealAmount = entryInspectData.getCalRealAmount();
                if (curJoinAmount.compareTo(calJoinAmount) == 0 && curRealAmount.compareTo(calRealAmount) == 0) continue;
                Object[] param = new Object[]{entryInspectData.getCalJoinAmount(), entryInspectData.getCalRealAmount(), entryInspectData.getEntryid()};
                entryList.add(param);
                FixLogInfo joinAmountLogInfo = new FixLogInfo(data.getId(), data.getBillNo(), entryInspectData.getSeq(), entryInspectData.getEntryid(), "joinpayamount", fieldName.get("joinpayamount"), curJoinAmount.toPlainString(), calJoinAmount.toPlainString());
                FixLogInfo realAmountLogInfo = new FixLogInfo(data.getId(), data.getBillNo(), entryInspectData.getSeq(), entryInspectData.getEntryid(), "paidamount", fieldName.get("paidamount"), curRealAmount.toPlainString(), calRealAmount.toPlainString());
                list.add(joinAmountLogInfo);
                list.add(realAmountLogInfo);
            }
        }
        String headSql = "update t_conm_salcontract_f set fprereceiptallamount=?,freceiptallamount=? where fid=?";
        String entrySql = "update t_conm_salcontractpentry set fjoinpayamount=?,fpaidamount=? where fentryid=?";
        if (headList != null && headList.size() > 0) {
            if (headList.size() > 1000) {
                partition = DmfSchemeExecuteHelper.partition(headList, 1000);
                partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)headSql, (List)row));
            } else {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)headSql, headList);
            }
        }
        if (entryList != null && entryList.size() > 0) {
            if (entryList.size() > 1000) {
                partition = DmfSchemeExecuteHelper.partition(entryList, 1000);
                partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)entrySql, (List)row));
            } else {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)entrySql, entryList);
            }
        }
        return list;
    }
}

