/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.fmm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class BOMCheckPlugin
extends AbstractDmfPlugin {
    private static final Log log = LogFactory.getLog(BOMCheckPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBizDataType(1);
        }
        e.getFieldKeys().add("number");
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>();
        ArrayList<String> bomNumber = new ArrayList<String>();
        for (Row row : args) {
            bomNumber.add(row.getString("number"));
        }
        log.warn("BOMCheckPlugin:bomNumber = " + ((Object)bomNumber).toString());
        ArrayList nestingBom = (ArrayList)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"fmm", (String)"BOMNestingCheckService", (String)"bomCheck", (Object[])new Object[]{bomNumber});
        long count = 1L;
        for (List list : nestingBom) {
            for (HashMap map : list) {
                String number = String.valueOf(map.get("number"));
                String concatenationString = String.valueOf(map.get("materialname")) + "," + String.valueOf(map.get("entrymaterialname")) + "," + String.valueOf(map.get("entryreplaceplan"));
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), concatenationString, count, count, number));
            }
            ++count;
        }
        return errorInfo;
    }

    @Override
    public boolean extExpDataBizLink(Map<String, Object> extParameter) {
        try {
            log.warn("BOMCheckPlugin-extExpDataBizLink:extParameter = " + extParameter.toString());
            String pageId = (String)extParameter.get("pageId");
            IFormView formView = SessionManager.getCurrent().getView(pageId);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("msplan_bom_nested");
            DynamicObjectCollection dynamicObject = formView.getModel().getEntryEntity("entryentity");
            DynamicObjectCollection dynamicObjectCollection = null;
            if (dynamicObject != null && dynamicObject.size() > 0) {
                dynamicObjectCollection = ((DynamicObject)dynamicObject.get(0)).getDynamicObjectCollection("subentryentity");
            }
            if (dynamicObjectCollection == null) {
                return false;
            }
            log.warn("BOMCheckPlugin-extExpDataBizLink:dynamicObjectCollection = " + String.valueOf(dynamicObjectCollection.size()));
            ArrayList list = new ArrayList();
            String nowNestedId = null;
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                if (!extParameter.get("biznumber").equals(((DynamicObject)dynamicObjectCollection.get(i)).getString("bizuniquesympol"))) continue;
                nowNestedId = ((DynamicObject)dynamicObjectCollection.get(i)).getString("objid");
                break;
            }
            if (nowNestedId == null) {
                return false;
            }
            log.warn("BOMCheckPlugin-extExpDataBizLink:nowNestedId = " + nowNestedId);
            HashMap replaceMaterial = new HashMap();
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject nowMessage = (DynamicObject)dynamicObjectCollection.get(i);
                if (!nowNestedId.equals(nowMessage.getString("objid"))) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("bomNumber", nowMessage.getString("bizuniquesympol"));
                map.put("fatherMaterial", nowMessage.getString("objdes").split(",")[0]);
                String replaceNum = nowMessage.getString("objdes").split(",")[2];
                if ("0".equals(replaceNum)) {
                    map.put("childMaterial", nowMessage.getString("objdes").split(",")[1]);
                    map.put("alternativeMaterial", "0");
                } else {
                    List relpaceList;
                    if (replaceMaterial.get(replaceNum) == null) {
                        relpaceList = new ArrayList<String>();
                        ((ArrayList)relpaceList).add(nowMessage.getString("objdes").split(",")[1]);
                        replaceMaterial.put(replaceNum, relpaceList);
                        continue;
                    }
                    relpaceList = (List)replaceMaterial.get(replaceNum);
                    map.put("childMaterial", (String)relpaceList.get(0));
                    map.put("alternativeMaterial", nowMessage.getString("objdes").split(",")[1]);
                }
                list.add(map);
            }
            log.warn("BOMCheckPlugin-extExpDataBizLink:list.size = " + list.size());
            log.warn("BOMCheckPlugin-extExpDataBizLink:list.context = " + ((Object)list).toString());
            formShowParameter.setCustomParam("list", list);
            formView.showForm(formShowParameter);
            return true;
        }
        catch (RuntimeException e) {
            log.error("BOMCheckPlugin-extExpDataBizLink:errorMessage = " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

