/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.im;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.im.InvAddFieldsUnit;
import kd.mpscmm.msbd.datamanage.common.consts.im.InvBillEntryConst;
import kd.mpscmm.msbd.datamanage.common.pojo.DmfExpMsgInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillEntryModel;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillModel;

public class InvBillPrecisionPlugin
extends AbstractDmfPlugin {
    private static final long serialVersionUID = -8049113967144250617L;

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        String formId = this.getExeDmfUnitInfo().getEntityNumber();
        e.getFieldKeys().addAll(InvAddFieldsUnit.getPrecisionFields(formId));
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet data) {
        List<OperateErrorInfo> inspectUnitExtPlugin = super.exeInspectUnitExtPlugin(data);
        List<DmfExpMsgInfo> dmfExpMsgInfos = this.checkPrecision(data);
        dmfExpMsgInfos.forEach(v -> inspectUnitExtPlugin.add(this.getExpMsg(v.getClassName(), v.getMsg(), v.getPkValue(), v.getEntryId(), v.getBillno())));
        return inspectUnitExtPlugin;
    }

    private List<DmfExpMsgInfo> checkPrecision(DataSet data) {
        ArrayList<DmfExpMsgInfo> dmfExpMsgInfos = new ArrayList<DmfExpMsgInfo>(16);
        HashMap<Long, InvBillModel> invBillModeMap = new HashMap<Long, InvBillModel>(16);
        HashSet<Long> currencyIds = new HashSet<Long>(16);
        HashSet<Long> unitIds = new HashSet<Long>(16);
        while (data.hasNext()) {
            Row row = data.next();
            Long id = row.getLong("id");
            Long currencyId = row.getLong("settlecurrency");
            Long unitId = row.getLong(InvBillEntryConst.getEntryField("unit"));
            Long baseUnitId = row.getLong(InvBillEntryConst.getEntryField("baseunit"));
            currencyIds.add(currencyId);
            unitIds.add(unitId);
            unitIds.add(baseUnitId);
            InvBillModel billModel = (InvBillModel)invBillModeMap.get(id);
            if (billModel == null) {
                billModel = InvBillModel.getInstance();
                billModel.setPkValue(id);
                invBillModeMap.put(id, billModel);
            }
            billModel.setBillNo(row.getString("billno"));
            billModel.setSettleCurrency(currencyId);
            InvBillEntryModel entry = billModel.addNewEntry();
            entry.setEntryId(row.getLong(InvBillEntryConst.getEntryField("id")));
            entry.setSeq(row.getInteger(InvBillEntryConst.getEntryField("seq")));
            entry.setUnit(unitId);
            entry.setBaseUnit(baseUnitId);
            entry.setQty(row.getBigDecimal(InvBillEntryConst.getEntryField("qty")));
            entry.setBaseQty(row.getBigDecimal(InvBillEntryConst.getEntryField("baseqty")));
            entry.setAmount(row.getBigDecimal(InvBillEntryConst.getEntryField("amount")));
        }
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter("id", "in", currencyIds).toArray());
        Map unitMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"precision", (QFilter[])new QFilter("id", "in", unitIds).toArray());
        for (InvBillModel billModel : invBillModeMap.values()) {
            String billNo = billModel.getBillNo();
            Long pkValue = billModel.getPkValue();
            Long currencyId = billModel.getSettleCurrency();
            DynamicObject currency = null;
            if (currencyId != null && !currencyId.equals(0L)) {
                currency = (DynamicObject)currencyMap.get(currencyId);
            }
            for (InvBillEntryModel entry : billModel.getBillEntrys()) {
                Long unitId = entry.getUnit();
                Long baseUnitId = entry.getBaseUnit();
                BigDecimal qty = entry.getQty();
                BigDecimal baseQty = entry.getBaseQty();
                BigDecimal amount = entry.getAmount();
                if (!this.checkAmountPrecision(amount, currency)) {
                    dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u91d1\u989d\u201d\u5c0f\u6570\u4f4d\u6570\u4e0e\u7ed3\u7b97\u5e01\u7cbe\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"InvBillPrecisionPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), entry.getSeq()), pkValue, entry.getEntryId(), billNo));
                }
                if (!this.checkQtyPrecision(qty, unitId, unitMap)) {
                    dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u6570\u91cf\u201d\u5c0f\u6570\u4f4d\u6570\u4e0e\u8ba1\u91cf\u5355\u4f4d\u7cbe\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"InvBillPrecisionPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), entry.getSeq()), pkValue, entry.getEntryId(), billNo));
                }
                if (this.checkQtyPrecision(baseQty, baseUnitId, unitMap)) continue;
                dmfExpMsgInfos.add(DmfExpMsgInfo.getInstance(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\u201c\u57fa\u672c\u6570\u91cf\u201d\u5c0f\u6570\u4f4d\u6570\u4e0e\u57fa\u672c\u5355\u4f4d\u7cbe\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"InvBillPrecisionPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), entry.getSeq()), pkValue, entry.getEntryId(), billNo));
            }
        }
        return dmfExpMsgInfos;
    }

    private boolean checkAmountPrecision(BigDecimal amount, DynamicObject currency) {
        if (currency == null) {
            return true;
        }
        return (amount = new BigDecimal(amount.stripTrailingZeros().toPlainString())).scale() <= currency.getInt("amtprecision");
    }

    private boolean checkQtyPrecision(BigDecimal qty, Long unitId, Map<Object, DynamicObject> unitMap) {
        if (qty == null || unitId == null || BigDecimal.ZERO.compareTo(qty) == 0 || unitId.equals(0L)) {
            return true;
        }
        DynamicObject unit = unitMap.get(unitId);
        if (unit == null) {
            return true;
        }
        return (qty = new BigDecimal(qty.stripTrailingZeros().toPlainString())).scale() <= unit.getInt("precision");
    }
}

