/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.im;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.im.LogisticsBillModel;
import kd.mpscmm.msbd.datamanage.common.consts.im.InvBillEntryConst;
import kd.mpscmm.msbd.datamanage.common.pojo.DmfExpMsgInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillEntryModel;
import kd.mpscmm.msbd.datamanage.common.pojo.InvBillModel;

public class InvLogisticsBillPlugin
extends AbstractDmfPlugin {
    private static final long serialVersionUID = -2128778162292463655L;
    private LogisticsBillModel logisticsBillModel = LogisticsBillModel.getInstance();

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        String formId = this.getExeDmfUnitInfo().getEntityNumber();
        e.getFieldKeys().addAll(this.logisticsBillModel.getKeySet(formId));
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("billentry");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet data) {
        List<OperateErrorInfo> inspectUnitExtPlugin = super.exeInspectUnitExtPlugin(data);
        List<DmfExpMsgInfo> dmfExpMsgInfos = this.logisticsBillModel.matchLogisticsBill(this.getExeDmfUnitInfo().getEntityNumber(), this.buildBillModel(data));
        dmfExpMsgInfos.forEach(v -> inspectUnitExtPlugin.add(this.getExpMsg(v.getClassName(), v.getMsg(), v.getPkValue(), v.getEntryId(), v.getBillno())));
        return inspectUnitExtPlugin;
    }

    private List<InvBillModel> buildBillModel(DataSet data) {
        ArrayList<InvBillModel> invBills = new ArrayList<InvBillModel>(16);
        HashMap<Long, InvBillModel> invBillModeMap = new HashMap<Long, InvBillModel>(16);
        String[] logisticKeys = data.getRowMeta().getFieldNames();
        while (data.hasNext()) {
            Row row = data.next();
            Long id = row.getLong("id");
            InvBillModel billModel = (InvBillModel)invBillModeMap.get(id);
            if (billModel == null) {
                billModel = InvBillModel.getInstance();
                billModel.setPkValue(id);
                billModel.setBillNo(row.getString("billno"));
                Map<String, Object> otherPropMaps = billModel.getOtherPropMaps();
                for (String logisticKey : logisticKeys) {
                    otherPropMaps.put(logisticKey, row.get(logisticKey));
                }
                invBillModeMap.put(id, billModel);
            }
            InvBillEntryModel entry = billModel.addNewEntry();
            entry.setEntryId(row.getLong(InvBillEntryConst.getEntryField("id")));
            entry.setSeq(row.getInteger(InvBillEntryConst.getEntryField("seq")));
            entry.setIslogisticsBill(row.getBoolean(InvBillEntryConst.getEntryField("logisticsbill")));
            Map<String, Object> entryOtherMap = entry.getOtherPropMaps();
            for (String logisticKey : logisticKeys) {
                entryOtherMap.put(logisticKey, row.get(logisticKey));
            }
        }
        invBills.addAll(invBillModeMap.values());
        return invBills;
    }
}

