/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.im;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.id.IDRange;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.ExeDmfUnitInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InvRealBalanceModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class InvRealBalanceIdAndStatusPlugin
extends AbstractDmfPlugin {
    private static final long serialVersionUID = -7049491265360479882L;
    private static final int BATCH_SIZE = 5000;
    private static final String SYSTEM_TYPE = "mpscmm-msbd-datamanage";
    public static final String ID = "id";
    public static final String BILL_NO = "billno";
    public static final String BILL_STATUS = "billstatus";
    private static final int DATA_DATASET = 1;

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(Arrays.asList(ID, BILL_NO));
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet data) {
        super.exeInspectUnitExtPlugin(data);
        data.close();
        ExeDmfUnitInfo exeDmfUnitInfo = this.getExeDmfUnitInfo();
        Long[] dateRange = this.parseUpdateTimeId(exeDmfUnitInfo.getInspectUnitQFilter());
        List<OperateErrorInfo> operateErrorInfoList = this.batchCheckIdAndStatus(dateRange);
        return operateErrorInfoList.stream().sorted(Comparator.comparing(OperateInfo::getEntityKey).thenComparing(OperateInfo::getMessage).thenComparing(OperateInfo::getTitle)).collect(Collectors.toList());
    }

    private OperateErrorInfo generateErrorInfo(String className, String msg, String entityNumber, Object pkValue, Object entryId, String bizUniqueSympol) {
        OperateErrorInfo operateerrorinfo = new OperateErrorInfo(className, ErrorLevel.Error, pkValue, entryId);
        operateerrorinfo.setEntityKey(entityNumber);
        operateerrorinfo.setMessage(msg);
        operateerrorinfo.setTitle(bizUniqueSympol);
        return operateerrorinfo;
    }

    private List<OperateErrorInfo> batchCheckIdAndStatus(Long[] dateRange) {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(16);
        try (DataSet dateSet = this.queryDatasetFromInvRealBalance(dateRange);){
            while (dateSet.hasNext()) {
                List<InvRealBalanceModel> batch = this.nextBatch(dateSet, 5000);
                Map<String, List<InvRealBalanceModel>> mapList = batch.stream().collect(Collectors.groupingBy(InvRealBalanceModel::getEntityNumber));
                errorInfos.addAll(this.checkIdAndStatus(mapList));
            }
        }
        return errorInfos;
    }

    private List<InvRealBalanceModel> nextBatch(DataSet dataSet, int batchSize) {
        ArrayList<InvRealBalanceModel> invRealBalanceModelList = new ArrayList<InvRealBalanceModel>(batchSize);
        for (int i = 0; i < batchSize && dataSet.hasNext(); ++i) {
            Row next = dataSet.next();
            String entityNumber = next.getString("fbillname");
            Long billId = next.getLong("fbillid");
            String billNo = next.getString("fbillno");
            InvRealBalanceModel invRealBalanceModel = new InvRealBalanceModel();
            invRealBalanceModel.setEntityNumber(entityNumber);
            invRealBalanceModel.setBillId(billId);
            invRealBalanceModel.setBillNo(billNo);
            invRealBalanceModelList.add(invRealBalanceModel);
        }
        return invRealBalanceModelList;
    }

    private List<OperateErrorInfo> checkIdAndStatus(Map<String, List<InvRealBalanceModel>> mapList) {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(16);
        mapList.forEach((entityNumber, invRealBalanceModels) -> {
            List billIds = invRealBalanceModels.stream().map(InvRealBalanceModel::getBillId).collect(Collectors.toList());
            QFilter qFilter = new QFilter(ID, "in", billIds);
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entityNumber, (String)"id,billno,billstatus", (QFilter[])qFilter.toArray());
            Set<Long> existBillIds = dynamicObjectCollection.stream().map(dynamicObject -> dynamicObject.getLong(ID)).collect(Collectors.toSet());
            if (billIds.size() != existBillIds.size()) {
                errorInfos.addAll(this.generateDelMsg((List<InvRealBalanceModel>)invRealBalanceModels, existBillIds));
            }
            List<OperateErrorInfo> unAuditBills = this.generateUnAuditMsg((String)entityNumber, dynamicObjectCollection);
            errorInfos.addAll(unAuditBills);
        });
        return errorInfos;
    }

    private List<OperateErrorInfo> generateUnAuditMsg(String entityNumber, DynamicObjectCollection dynamicObjectCollection) {
        Object[] auditStatus = new String[]{"C", "D"};
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>(16);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            if (ArrayUtils.contains((Object[])auditStatus, (Object)dynamicObject.getString(BILL_STATUS))) continue;
            errorInfos.add(this.generateErrorInfo(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff1a\u5355\u636e\u672a\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvRealBalanceIdAndStatusPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]), entityNumber, dynamicObject.getLong(ID), null, dynamicObject.getString(BILL_NO)));
        }
        return errorInfos;
    }

    private List<OperateErrorInfo> generateDelMsg(List<InvRealBalanceModel> invRealBalanceModels, Set<Long> existIds) {
        ArrayList<OperateErrorInfo> dmfExpMsgInfoList = new ArrayList<OperateErrorInfo>(16);
        for (InvRealBalanceModel invRealBalanceModel : invRealBalanceModels) {
            if (existIds.contains(invRealBalanceModel.getBillId())) continue;
            dmfExpMsgInfoList.add(this.generateErrorInfo(this.getClass().getSimpleName(), String.format(ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff1a\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvRealBalanceIdAndStatusPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), new Object[0]), invRealBalanceModel.getEntityNumber(), invRealBalanceModel.getBillId(), null, invRealBalanceModel.getBillNo()));
        }
        return dmfExpMsgInfoList;
    }

    private Long[] parseUpdateTimeId(List<QFilter> inspectUnitQFilter) {
        if (CollectionUtils.isEmpty(inspectUnitQFilter)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef\uff1a\u8bf7\u5728\u5de1\u68c0\u6a21\u578b\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u5ba1\u6838\u65f6\u95f4\u3002", (String)"InvRealBalanceIdAndStatusPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        List qFilters = inspectUnitQFilter.stream().filter(Objects::nonNull).map(new Function<QFilter, List<QFilter>>(){

            @Override
            public List<QFilter> apply(QFilter item) {
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
                qFilterList.add(item);
                List nestList = item.getNests(true);
                qFilterList.addAll(nestList.stream().map(QFilter.QFilterNest::getFilter).collect(Collectors.toList()));
                return qFilterList;
            }
        }).flatMap(list -> list.stream()).filter(item -> item.getProperty().equals("auditdate")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(qFilters)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef\uff1a\u8bf7\u5728\u5de1\u68c0\u6a21\u578b\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u5ba1\u6838\u65f6\u95f4\u3002", (String)"InvRealBalanceIdAndStatusPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        Long[] updateTimeIds = new Long[2];
        for (QFilter auditDateQFilter : qFilters) {
            if (auditDateQFilter.getCP().equals(">=") || auditDateQFilter.getCP().equals(">")) {
                IDRange startRange = kd.bos.id.ID.getIDRangeOfDay((Date)((Date)auditDateQFilter.getValue()));
                updateTimeIds[0] = startRange.getMinId();
                continue;
            }
            if (!auditDateQFilter.getCP().equals("<=") && !auditDateQFilter.getCP().equals("<")) continue;
            IDRange endRange = kd.bos.id.ID.getIDRangeOfDay((Date)((Date)auditDateQFilter.getValue()));
            updateTimeIds[1] = endRange.getMaxId();
        }
        if (null == updateTimeIds[0]) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef\uff1a\u8bf7\u5728\u5de1\u68c0\u6a21\u578b\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u5ba1\u6838\u5f00\u59cb\u65f6\u95f4\u3002", (String)"InvRealBalanceIdAndStatusPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        if (null == updateTimeIds[1]) {
            throw new KDBizException(ResManager.loadKDString((String)"\u914d\u7f6e\u9519\u8bef\uff1a\u8bf7\u5728\u5de1\u68c0\u6a21\u578b\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u5ba1\u6838\u7ed3\u675f\u65f6\u95f4\u3002", (String)"InvRealBalanceIdAndStatusPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return updateTimeIds;
    }

    private DataSet queryDatasetFromInvRealBalance(Long[] dateRange) {
        String sql = "select distinct fbillid,fbillno,fbillname from t_im_inv_realbalance_sp t1 where fstatus = 'A' and fupdatetime >= ? and fupdatetime <= ?";
        DataSet tableSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"scm"), (String)sql, (Object[])dateRange);
        return tableSet;
    }
}

