/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.pm.purorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class PurOrderCompletenessPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(PurOrderCompletenessPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "billentry.seq", "qty", "baseqty", "receivebaseqtydown", "receivebaseqtyup", "receiveqtydown", "receiveqtyup");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        inspectOptionInfo.setBillEntrySympol("billentry");
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DynamicObject[] args) {
        logger.info("\u63d2\u4ef6\u5de1\u68c0\u6267\u884c\u5f00\u59cb\u65f6\u95f4\uff1a{},\u6267\u884c\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)args.length);
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>();
        for (DynamicObject bill : args) {
            String billNo = bill.getString("billno");
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billEntry) {
                BigDecimal receiveqtyup;
                BigDecimal receiveqtydown;
                BigDecimal receivebaseqtyup;
                BigDecimal receivebaseqtydown;
                BigDecimal qty = row.getBigDecimal("qty");
                if (qty.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal baseqty = row.getBigDecimal("baseqty");
                if (baseqty.compareTo(BigDecimal.ZERO) == 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u57fa\u672c\u6570\u91cf\u4e3a\u7a7a\u3002", (String)"PurOrderCompletenessPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("seq"));
                    errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, bill.getPkValue(), bill.getPkValue(), billNo));
                }
                if ((receivebaseqtydown = row.getBigDecimal("receivebaseqtydown")).compareTo(BigDecimal.ZERO) == 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u6536\u8d27\u4e0b\u9650\u57fa\u672c\u6570\u91cf\u4e3a\u7a7a\u3002", (String)"PurOrderCompletenessPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("seq"));
                    errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, bill.getPkValue(), bill.getPkValue(), billNo));
                }
                if ((receivebaseqtyup = row.getBigDecimal("receivebaseqtyup")).compareTo(BigDecimal.ZERO) == 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u6536\u8d27\u4e0a\u9650\u57fa\u672c\u6570\u91cf\u4e3a\u7a7a\u3002", (String)"PurOrderCompletenessPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("seq"));
                    errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, bill.getPkValue(), bill.getPkValue(), billNo));
                }
                if ((receiveqtydown = row.getBigDecimal("receiveqtydown")).compareTo(BigDecimal.ZERO) == 0) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u6536\u8d27\u4e0b\u9650\u6570\u91cf\u4e3a\u7a7a\u3002", (String)"PurOrderCompletenessPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("seq"));
                    errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, bill.getPkValue(), bill.getPkValue(), billNo));
                }
                if ((receiveqtyup = row.getBigDecimal("receiveqtyup")).compareTo(BigDecimal.ZERO) != 0) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u7684\u884c\u53f7\u201c%2$s\u201d\u5b58\u5728\u6536\u8d27\u4e0a\u9650\u6570\u91cf\u4e3a\u7a7a\u3002", (String)"PurOrderCompletenessPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, row.get("seq"));
                errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, bill.getPkValue(), bill.getPkValue(), billNo));
            }
        }
        logger.info("\u672c\u6279\u6b21\u5de1\u68c0\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{},\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfo.size());
        return errorInfo;
    }
}

