/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.pm.purorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class PurOrderIsEmptyPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(PurOrderIsEmptyPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "org", "billtype", "biztype", "settlecurrency", "currency", "exratetable", "exratedate", "exchangerate");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        inspectOptionInfo.setBillEntrySympol("billentry");
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>();
        for (Row row : args) {
            BigDecimal exchangerate;
            Date exratedate;
            String msg;
            String msg2;
            String billNo = row.getString("billno");
            Long org = row.getLong("org");
            Long billType = row.getLong("billtype");
            Long bizType = row.getLong("biztype");
            String commonMsg = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"PurOrderIsEmptyPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]);
            Long id = row.getLong("id");
            String className = this.getClass().getSimpleName();
            if (org == null || org == 0L) {
                msg2 = String.format(commonMsg, billNo, ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"PurOrderIsEmptyPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                errorInfo.add(this.getExpMsg(className, msg2, id, id, billNo));
            }
            if (billType == null || billType == 0L) {
                msg2 = String.format(commonMsg, billNo, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"PurOrderIsEmptyPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                errorInfo.add(this.getExpMsg(className, msg2, id, id, billNo));
            }
            if (bizType == null || bizType == 0L) {
                msg2 = String.format(commonMsg, billNo, ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"PurOrderIsEmptyPlugin_3", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                errorInfo.add(this.getExpMsg(className, msg2, id, id, billNo));
            }
            Long settlecurrency = row.getLong("settlecurrency");
            Long currency = row.getLong("currency");
            Long exratetable = row.getLong("exratetable");
            if (settlecurrency == null || settlecurrency == 0L) {
                msg = String.format(commonMsg, billNo, ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u522b\u4e3a\u7a7a", (String)"PurOrderIsEmptyPlugin_4", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                errorInfo.add(this.getExpMsg(className, msg, id, id, billNo));
            }
            if (currency == null || currency == 0L) {
                msg = String.format(commonMsg, billNo, ResManager.loadKDString((String)"\u5e01\u522b\u4e3a\u7a7a", (String)"PurOrderIsEmptyPlugin_5", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                errorInfo.add(this.getExpMsg(className, msg, id, id, billNo));
            }
            if (exratetable == null || exratetable == 0L) {
                msg = String.format(commonMsg, billNo, ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e3a\u7a7a", (String)"PurOrderIsEmptyPlugin_6", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                errorInfo.add(this.getExpMsg(className, msg, id, id, billNo));
            }
            if ((exratedate = row.getDate("exratedate")) == null) {
                String msg3 = String.format(commonMsg, billNo, ResManager.loadKDString((String)"\u6c47\u7387\u65e5\u671f\u4e3a\u7a7a", (String)"PurOrderIsEmptyPlugin_7", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
                errorInfo.add(this.getExpMsg(className, msg3, id, id, billNo));
            }
            if ((exchangerate = row.getBigDecimal("exchangerate")) != null) continue;
            String msg4 = String.format(commonMsg, billNo, ResManager.loadKDString((String)"\u6c47\u7387\u4e3a\u7a7a", (String)"PurOrderIsEmptyPlugin_8", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            errorInfo.add(this.getExpMsg(className, msg4, id, id, billNo));
        }
        logger.info("\u672c\u6279\u6b21\u5de1\u68c0\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{},\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfo.size());
        return errorInfo;
    }
}

