/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.pm.purorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.business.helper.DmfSchemeExecuteHelper;
import kd.mpscmm.msbd.datamanage.common.pojo.FixLogInfo;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;
import kd.mpscmm.msbd.datamanage.inspect.common.ApWriteBackScmcHelper;

public class PurOrderPayPlanAmountPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(PurOrderPayPlanAmountPlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "purbillentry_pay.id", "purbillentry_pay.seq", "purbillentry_pay.paidamount", "purbillentry_pay.joinpayamount");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBillEntrySympol("purbillentry_pay");
            inspectOptionInfo.setBizDataType(1);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet args) {
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>(16);
        DataSet inspectDataSet = args.copy();
        Map<Long, PayPlanResult> result = this.calculate(args);
        try (DataSet inspectData = inspectDataSet.select(new String[]{"id", "billno", "purbillentry_pay.id entryId", "purbillentry_pay.seq seq", "purbillentry_pay.paidamount paidamount ", "purbillentry_pay.joinpayamount joinpayamount"});){
            for (Row row : inspectData) {
                PayPlanResult payPlanResult;
                String billNo = row.getString("billno");
                Long entryId = row.getLong("entryId");
                if (entryId == null || (payPlanResult = result.get(entryId)) == null) continue;
                BigDecimal joinpayamount = row.getBigDecimal("joinpayamount");
                BigDecimal paidamount = row.getBigDecimal("paidamount");
                BigDecimal receiveJoinpayamount = payPlanResult.getJoinpayamount();
                String msg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%s\u884c", (String)"PurOrderPayPlanAmountPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), row.get("seq"));
                msg = msg + "\uff0c";
                boolean flag = false;
                if (joinpayamount == null || receiveJoinpayamount == null) continue;
                if (joinpayamount.compareTo(receiveJoinpayamount) != 0) {
                    msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e00\uff1a\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\uff1a%1$s\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\uff1a%2$s\u4e0d\u4e00\u81f4\u3002", (String)"PurOrderPayPlanAmountPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), joinpayamount, receiveJoinpayamount);
                    flag = true;
                }
                BigDecimal receivePaidamount = payPlanResult.getPaidamount();
                if (paidamount == null || receivePaidamount == null) continue;
                if (paidamount.compareTo(receivePaidamount) != 0) {
                    msg = msg + String.format(ResManager.loadKDString((String)"\u5b58\u5728\u95ee\u9898\u4e8c\uff1a\u5df2\u4ed8\u91d1\u989d\uff08%1$s\uff09\u4e0e\u8ba1\u7b97\u51fa\u6765\u7684\u5df2\u4ed8\u91d1\u989d\uff08%2$s\uff09\u4e0d\u4e00\u81f4\u3002", (String)"PurOrderPayPlanAmountPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), paidamount, receivePaidamount);
                    flag = true;
                }
                if (!flag) continue;
                errorInfo.add(this.getExpMsg(this.getClass().getName(), msg, row.getLong("id"), row.getLong("entryId"), billNo));
            }
        }
        return errorInfo;
    }

    private Map<Long, PayPlanResult> calculate(DataSet inspectDataSet) {
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>(16);
        try (DataSet selectData = inspectDataSet.select(new String[]{"id", "purbillentry_pay.id"});){
            for (Row row : selectData) {
                HashMap<String, Long> param = new HashMap<String, Long>(16);
                param.put("mainbillid", row.getLong("id"));
                Long entryId = row.getLong("purbillentry_pay.id");
                if (entryId == null) continue;
                param.put("mainbillentryid", entryId);
                paramList.add(param);
            }
        }
        List<Map<String, Object>> writeBackPayPlanAmt = ApWriteBackScmcHelper.writeBackPayPlanAmt(paramList);
        HashMap<Long, PayPlanResult> receiveResult = new HashMap<Long, PayPlanResult>(16);
        if (writeBackPayPlanAmt != null && writeBackPayPlanAmt.size() > 0) {
            for (Map<String, Object> obj : writeBackPayPlanAmt) {
                receiveResult.put((Long)obj.get("mainbillentryid"), PayPlanResult.assertResult((BigDecimal)obj.get("joinpayamount"), (BigDecimal)obj.get("paidamount")));
            }
        }
        return receiveResult;
    }

    @Override
    public List<FixLogInfo> fixDataSet(DataSet args) {
        DataSet inspectDataSet = args.copy();
        Map<Long, PayPlanResult> receiveResult = this.calculate(args);
        ArrayList<FixLogInfo> expMsg = new ArrayList<FixLogInfo>(16);
        Map<String, String> fieldName = DmfSchemeExecuteHelper.getFieldName(this.getExeDmfUnitInfo().getEntityNumber(), "paidamount", "joinpayamount");
        try (DataSet inspectData = inspectDataSet.select(new String[]{"id", "billno", "purbillentry_pay.id entryId", "purbillentry_pay.seq seq", "purbillentry_pay.paidamount paidamount ", "purbillentry_pay.joinpayamount joinpayamount"});){
            String updateSql = "update t_pm_purorderpayentry  set fjoinpayamount=?,fpaidamount=?  where  fentryid=?";
            ArrayList<Object[]> parameterList = new ArrayList<Object[]>();
            for (Row row2 : inspectData) {
                PayPlanResult payPlanResult;
                Object[] parameter = new Object[3];
                String billNo = row2.getString("billno");
                Long entryId = row2.getLong("entryId");
                if (entryId == null || (payPlanResult = receiveResult.get(entryId)) == null) continue;
                BigDecimal paidamount = row2.getBigDecimal("paidamount");
                BigDecimal joinpayamount = row2.getBigDecimal("joinpayamount");
                BigDecimal receiveJoinpayamount = payPlanResult.getJoinpayamount();
                BigDecimal receivePaidamount = payPlanResult.getPaidamount();
                if (paidamount.compareTo(receivePaidamount) == 0 && joinpayamount.compareTo(receiveJoinpayamount) == 0) continue;
                String entryMsg = "";
                if (paidamount.compareTo(receivePaidamount) != 0) {
                    expMsg.add(new FixLogInfo(row2.getLong("id"), billNo, row2.getInteger("seq"), entryId, "paidamount", fieldName.get("paidamount"), paidamount.toString(), receivePaidamount.toString()));
                    paidamount = receivePaidamount;
                }
                if (joinpayamount.compareTo(receiveJoinpayamount) != 0) {
                    expMsg.add(new FixLogInfo(row2.getLong("id"), billNo, row2.getInteger("seq"), entryId, "joinpayamount", fieldName.get("joinpayamount"), joinpayamount.toString(), receiveJoinpayamount.toString()));
                    joinpayamount = receiveJoinpayamount;
                }
                parameter[0] = joinpayamount;
                parameter[1] = paidamount;
                parameter[2] = entryId;
                parameterList.add(parameter);
            }
            int updateDataNum = parameterList.size();
            if (updateDataNum > 0) {
                if (updateDataNum > 1000) {
                    List partition = DmfSchemeExecuteHelper.partition(parameterList, 1000);
                    partition.forEach(row -> DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, (List)row));
                } else {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSql, parameterList);
                }
            }
        }
        return expMsg;
    }

    static class PayPlanResult {
        private BigDecimal joinpayamount;
        private BigDecimal paidamount;

        public static PayPlanResult assertResult(BigDecimal joinpayamount, BigDecimal paidamount) {
            return new PayPlanResult(joinpayamount, paidamount);
        }

        public PayPlanResult(BigDecimal joinpayamount, BigDecimal paidamount) {
            this.paidamount = paidamount;
            this.joinpayamount = joinpayamount;
        }

        public BigDecimal getJoinpayamount() {
            return this.joinpayamount;
        }

        public BigDecimal getPaidamount() {
            return this.paidamount;
        }

        public String toString() {
            return "PayPlanResult{joinpayamount=" + this.joinpayamount + ", paidamount=" + this.paidamount + '}';
        }
    }
}

