/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.pm.purorder;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class PurOrderRelevancePlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(PurOrderRelevancePlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "settlecurrency", "currency");
        InspectOptionInfo inspectOptionInfo = this.getInspectOptionInfo();
        inspectOptionInfo.setBillEntrySympol("billentry");
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DynamicObject[] args) {
        logger.info("\u63d2\u4ef6\u5de1\u68c0\u6267\u884c\u5f00\u59cb\u65f6\u95f4\uff1a{},\u6267\u884c\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)args.length);
        ArrayList<OperateErrorInfo> errorInfo = new ArrayList<OperateErrorInfo>();
        for (DynamicObject bill : args) {
            String billNo = bill.getString("billno");
            DynamicObject settlecurrency = bill.getDynamicObject("settlecurrency");
            DynamicObject currency = bill.getDynamicObject("currency");
            if (settlecurrency == null || currency != null) continue;
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s,\u5b58\u5728\u5982\u4e0b\u95ee\u9898\uff1a%2$s", (String)"PurOrderRelevancePlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), billNo, ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u522b\u4e0d\u4e3a\u7a7a\u7684\u60c5\u51b5\u4e0b\uff0c\u672c\u4f4d\u5e01\u4e3a\u7a7a\u3002", (String)"PurOrderRelevancePlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]));
            errorInfo.add(this.getExpMsg(this.getClass().getSimpleName(), msg, bill.getPkValue(), bill.getPkValue(), billNo));
        }
        logger.info("\u672c\u6279\u6b21\u5de1\u68c0\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{},\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfo.size());
        return errorInfo;
    }
}

