/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.datamanage.inspect.pm.vmi;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.datamanage.business.AbstractDmfPlugin;
import kd.mpscmm.msbd.datamanage.common.pojo.InspectOptionInfo;

public class VMISettleInspectPlugin
extends AbstractDmfPlugin {
    public static final Log logger = LogFactory.getLog(VMISettleInspectPlugin.class);
    private static final String ENTITY_TRANSFERBILL = "pm_transferbill";
    private static final String ENTITY_PURINBILL = "im_purinbill";
    private static final String ENTRY_NO = "billentry";
    private String purInBillDisplayName;
    private String invEntity;
    private String invBillDisplayName;
    private Long purInTableId;

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Collections.addAll(e.getFieldKeys(), "id", "billno", "isintertransaction", "srcbillform", "billentry.id");
    }

    @Override
    public void beginInspectOperation(InspectOptionInfo inspectOptionInfo) {
        if (inspectOptionInfo != null) {
            inspectOptionInfo.setBizDataType(2);
            inspectOptionInfo.setBillEntrySympol(null);
        }
    }

    @Override
    public List<OperateErrorInfo> exeInspectUnitExtPlugin(DataSet dataSet) {
        logger.info("VMISettleInspectPlugin:\u63d2\u4ef6\u5de1\u68c0\u6267\u884c\u5f00\u59cb\u65f6\u95f4\uff1a{}", (Object)FORMATTER.format(LocalDateTime.now()));
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        HashMap<String, TranserBillInfo> groupBySrcBillForm = new HashMap<String, TranserBillInfo>(10);
        for (Row row : dataSet) {
            String srcbillform = row.getString("srcbillform");
            if (StringUtils.isEmpty((String)srcbillform)) continue;
            TranserBillInfo transerBillInfo = (TranserBillInfo)groupBySrcBillForm.get(srcbillform);
            if (transerBillInfo == null) {
                transerBillInfo = new TranserBillInfo();
            }
            String billNo = row.getString("billno");
            Long id = row.getLong("id");
            transerBillInfo.addBillIdAndBillNo(id, billNo);
            Long entryId = row.getLong("billentry.id");
            Boolean isinnerdeal = row.getBoolean("isintertransaction");
            if (isinnerdeal.booleanValue()) {
                transerBillInfo.addInnerDealEntryIdAndBillId(entryId, id);
            } else {
                transerBillInfo.addIsNotInnerDealEntryIdAndBillId(entryId, id);
            }
            groupBySrcBillForm.put(srcbillform, transerBillInfo);
        }
        if (CommonUtils.isNull(groupBySrcBillForm)) {
            return errorInfos;
        }
        this.purInBillDisplayName = MetadataServiceHelper.getDataEntityType((String)ENTITY_PURINBILL).getDisplayName().toString();
        groupBySrcBillForm.entrySet().forEach(entry -> errorInfos.addAll(this.checkTargetBill((String)entry.getKey(), (TranserBillInfo)entry.getValue())));
        logger.info("VMISettleInspectPlugin:\u672c\u6279\u6b21\u5de1\u68c0\u6267\u884c\u7ed3\u675f\u65f6\u95f4\uff1a{},\u6570\u636e\u5f02\u5e38\u7684\u6570\u91cf\u662f{}", (Object)FORMATTER.format(LocalDateTime.now()), (Object)errorInfos.size());
        return errorInfos;
    }

    private List<OperateErrorInfo> checkTargetBill(String srcEntity, TranserBillInfo transerBillInfo) {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        if (StringUtils.isEmpty((String)srcEntity)) {
            return errorInfos;
        }
        this.invEntity = srcEntity;
        HashMap<Long, Long> allEntryIdANdBillId = new HashMap<Long, Long>(10);
        Map<Long, Long> innerDealEntryIdAndBillId = transerBillInfo.getInnerDealEntryIdAndBillId();
        Map<Long, Long> isNotInnerDealEntryIdAndBillId = transerBillInfo.getIsNotInnerDealEntryIdAndBillId();
        allEntryIdANdBillId.putAll(innerDealEntryIdAndBillId);
        allEntryIdANdBillId.putAll(isNotInnerDealEntryIdAndBillId);
        List bfRows = BFTrackerServiceHelper.loadTargetRowIds((String)ENTITY_TRANSFERBILL, (String)ENTRY_NO, (Long[])allEntryIdANdBillId.values().toArray(new Long[0]), (Long[])allEntryIdANdBillId.keySet().toArray(new Long[0]), (OperateOption)this.getBFTrackerOperateOption());
        if (CommonUtils.isNull((Object)bfRows)) {
            return errorInfos;
        }
        TableDefine purInTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)ENTITY_PURINBILL, (String)ENTRY_NO);
        this.purInTableId = purInTableDefine.getTableId();
        errorInfos.addAll(this.checkInnerDealData(innerDealEntryIdAndBillId, transerBillInfo.getBillIdAndBillNo(), bfRows));
        errorInfos.addAll(this.checkIsNotInnerDealData(srcEntity, isNotInnerDealEntryIdAndBillId, transerBillInfo.getBillIdAndBillNo(), bfRows));
        return errorInfos;
    }

    private List<OperateErrorInfo> checkInnerDealData(Map<Long, Long> innerDealEntryIdAndBillId, Map<Long, String> billIdAndBillNo, List<BFRow> innderBfRows) {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        if (CommonUtils.isNull(innerDealEntryIdAndBillId) || CommonUtils.isNull(innderBfRows)) {
            return errorInfos;
        }
        HashMap<Long, Set<Long>> sEntryIdAndTBillIds = new HashMap<Long, Set<Long>>(10);
        HashSet<Long> hasTargetBillSrcEntryIds = new HashSet<Long>(10);
        for (BFRow bfRow : innderBfRows) {
            BFRowId tId = bfRow.getId();
            BFRowId sId = bfRow.getSId();
            Long tTableId = tId.getTableId();
            if (!this.purInTableId.equals(tTableId)) continue;
            Long sEntryId = sId.getEntryId();
            Long tBillId = tId.getBillId();
            Long sBillId2 = innerDealEntryIdAndBillId.get(sEntryId);
            if (sBillId2 == null) continue;
            sEntryIdAndTBillIds.put(sEntryId, Collections.singleton(tBillId));
            hasTargetBillSrcEntryIds.add(sEntryId);
        }
        if (sEntryIdAndTBillIds.size() > 0) {
            HashMap<Long, Set<Long>> targetIsNotAuditSrcBillMap = this.getTargetIsNotAuditSEntryIdMap(sEntryIdAndTBillIds, ENTITY_PURINBILL);
            for (Long sEntryId : targetIsNotAuditSrcBillMap.keySet()) {
                Long sBillId3 = innerDealEntryIdAndBillId.get(sEntryId);
                if (sBillId3 == null) continue;
                errorInfos.add(this.getExpMsg(this.getClass().getName(), ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u5b58\u5728\u4e0b\u6e38\u865a\u5355\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u5230\u201cVMI\u91c7\u8d2d\u7ed3\u7b97>\u7ed3\u7b97\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u539f\u56e0\u5e76\u91cd\u8bd5\u3002", (String)"VMISettleInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), sBillId3, sBillId3, billIdAndBillNo.get(sBillId3)));
            }
        }
        if (hasTargetBillSrcEntryIds.size() != innerDealEntryIdAndBillId.size()) {
            innerDealEntryIdAndBillId.keySet().removeAll(hasTargetBillSrcEntryIds);
            if (innerDealEntryIdAndBillId.size() > 0) {
                innerDealEntryIdAndBillId.values().forEach(sBillId -> errorInfos.add(this.getExpMsg(this.getClass().getName(), ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u751f\u6210\u7684\u7ed3\u7b97\u865a\u5355\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5230\u201cVMI\u91c7\u8d2d\u7ed3\u7b97>\u7ed3\u7b97\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u3002", (String)"VMISettleInspectPlugin_1", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), sBillId, sBillId, (String)billIdAndBillNo.get(sBillId))));
            }
        }
        innerDealEntryIdAndBillId = null;
        return errorInfos;
    }

    private List<OperateErrorInfo> checkIsNotInnerDealData(String invEntity, Map<Long, Long> isNotInnerDealEntryIdAndBillId, Map<Long, String> billIdAndBillNo, List<BFRow> isNotInnerBfRows) {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        if (CommonUtils.isNull(isNotInnerDealEntryIdAndBillId) || CommonUtils.isNull(isNotInnerBfRows)) {
            return errorInfos;
        }
        this.invBillDisplayName = MetadataServiceHelper.getDataEntityType((String)invEntity).getDisplayName().toString();
        TableDefine invTableDefine = ConvertMetaServiceHelper.loadTableDefine((String)invEntity, (String)ENTRY_NO);
        Map<Long, VirtualBillMapping> sEntryIdAndVirtualBillMap = this.getTargetBillMapping(invTableDefine, isNotInnerDealEntryIdAndBillId, billIdAndBillNo, isNotInnerBfRows);
        isNotInnerBfRows = null;
        errorInfos.addAll(this.checkTargetIsCouple(sEntryIdAndVirtualBillMap, isNotInnerDealEntryIdAndBillId, billIdAndBillNo));
        errorInfos.addAll(this.checkTargetIsAudit(sEntryIdAndVirtualBillMap, isNotInnerDealEntryIdAndBillId, billIdAndBillNo));
        return errorInfos;
    }

    private List<OperateErrorInfo> checkTargetIsAudit(Map<Long, VirtualBillMapping> sEntryIdAndVirtualBillMap, Map<Long, Long> isNotInnerDealEntryIdAndBillId, Map<Long, String> billIdAndBillNo) {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        HashSet<Long> allHasIsNotAuditsEntryIds = new HashSet<Long>(10);
        allHasIsNotAuditsEntryIds.addAll(this.getHasNotAuditsEntryId(sEntryIdAndVirtualBillMap, ENTITY_PURINBILL));
        allHasIsNotAuditsEntryIds.addAll(this.getHasNotAuditsEntryId(sEntryIdAndVirtualBillMap, this.invEntity));
        sEntryIdAndVirtualBillMap = null;
        HashSet allHasIsNotAuditsBillIds = new HashSet(10);
        allHasIsNotAuditsEntryIds.forEach(sEntryId -> {
            Long sBillId = (Long)isNotInnerDealEntryIdAndBillId.get(sEntryId);
            if (sBillId != null) {
                allHasIsNotAuditsBillIds.add(sBillId);
            }
        });
        if (!allHasIsNotAuditsBillIds.isEmpty()) {
            allHasIsNotAuditsBillIds.forEach(sBillId -> errorInfos.add(this.getExpMsg(this.getClass().getName(), ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u5b58\u5728\u4e0b\u6e38\u865a\u5355\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u8bf7\u5230\u201cVMI\u91c7\u8d2d\u7ed3\u7b97>\u7ed3\u7b97\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u539f\u56e0\u5e76\u91cd\u8bd5\u3002", (String)"VMISettleInspectPlugin_0", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), sBillId, sBillId, (String)billIdAndBillNo.get(sBillId))));
        }
        return errorInfos;
    }

    private Set<Long> getHasNotAuditsEntryId(Map<Long, VirtualBillMapping> sEntryIdAndVirtualBillMap, String entity) {
        HashSet<Long> result = new HashSet<Long>(10);
        HashMap<Long, Set<Long>> sEntryIdAndTBillId = new HashMap<Long, Set<Long>>(10);
        if (this.invEntity.equals(entity)) {
            sEntryIdAndVirtualBillMap.entrySet().forEach(entry -> {
                HashSet<Long> invBillIds = ((VirtualBillMapping)entry.getValue()).getInvBillIds();
                if (invBillIds != null && invBillIds.size() != 0) {
                    sEntryIdAndTBillId.put((Long)entry.getKey(), (Set<Long>)invBillIds);
                }
            });
            return this.getTargetIsNotAuditSEntryIdMap(sEntryIdAndTBillId, this.invEntity).keySet();
        }
        if (ENTITY_PURINBILL.equals(entity)) {
            sEntryIdAndVirtualBillMap.entrySet().forEach(entry -> {
                HashSet<Long> purInBillIds = ((VirtualBillMapping)entry.getValue()).getPurInBillIds();
                if (purInBillIds != null && purInBillIds.size() != 0) {
                    sEntryIdAndTBillId.put((Long)entry.getKey(), (Set<Long>)purInBillIds);
                }
            });
            return this.getTargetIsNotAuditSEntryIdMap(sEntryIdAndTBillId, ENTITY_PURINBILL).keySet();
        }
        return result;
    }

    private List<OperateErrorInfo> checkTargetIsCouple(Map<Long, VirtualBillMapping> sEntryIdAndVirtualBillMap, Map<Long, Long> isNotInnerDealEntryIdAndBillId, Map<Long, String> billIdAndBillNo) {
        ArrayList<OperateErrorInfo> errorInfos = new ArrayList<OperateErrorInfo>();
        for (Map.Entry<Long, VirtualBillMapping> entry : sEntryIdAndVirtualBillMap.entrySet()) {
            VirtualBillMapping virtualBillMapping = entry.getValue();
            if (virtualBillMapping.isCouple()) continue;
            Long sEntryId = entry.getKey();
            Long sBillId = isNotInnerDealEntryIdAndBillId.get(sEntryId);
            String singleBillType = virtualBillMapping.getSingleBillType();
            if (sBillId == null || singleBillType == null) continue;
            String entityDisplayName = ENTITY_PURINBILL.equals(singleBillType) ? this.invBillDisplayName : this.purInBillDisplayName;
            errorInfos.add(this.getExpMsg(this.getClass().getName(), String.format(ResManager.loadKDString((String)"\u7269\u6743\u8f6c\u79fb\u5355\u53ea\u751f\u6210%1$s\u865a\u5355\uff0c\u8bf7\u5230\u201cVMI\u91c7\u8d2d\u7ed3\u7b97>\u7ed3\u7b97\u8bb0\u5f55\u201d\u4e2d\u67e5\u770b\u539f\u56e0\u3002", (String)"VMISettleInspectPlugin_2", (String)"mpscmm-msbd-datamanage", (Object[])new Object[0]), entityDisplayName), sBillId, sBillId, billIdAndBillNo.get(sBillId)));
        }
        return errorInfos;
    }

    private Map<Long, VirtualBillMapping> getTargetBillMapping(TableDefine invTableDefine, Map<Long, Long> isNotInnerDealEntryIdAndBillId, Map<Long, String> billIdAndBillNo, List<BFRow> isNotInnerBfRows) {
        HashMap<Long, VirtualBillMapping> sEntryIdAndVirBillId = new HashMap<Long, VirtualBillMapping>(10);
        Long invTableId = invTableDefine.getTableId();
        for (BFRow bfRow : isNotInnerBfRows) {
            VirtualBillMapping virtualBillMapping;
            BFRowId tId = bfRow.getId();
            BFRowId sId = bfRow.getSId();
            Long tableId = tId.getTableId();
            Long sEntryId = sId.getEntryId();
            Long tBillId = tId.getBillId();
            Long sBillId = isNotInnerDealEntryIdAndBillId.get(sEntryId);
            if (tableId.equals(invTableId) && sBillId != null) {
                virtualBillMapping = (VirtualBillMapping)sEntryIdAndVirBillId.get(sEntryId);
                if (virtualBillMapping == null) {
                    virtualBillMapping = new VirtualBillMapping();
                }
                virtualBillMapping.addInvBillId(tBillId);
                sEntryIdAndVirBillId.put(sEntryId, virtualBillMapping);
                continue;
            }
            if (!tableId.equals(this.purInTableId) || sBillId == null) continue;
            virtualBillMapping = (VirtualBillMapping)sEntryIdAndVirBillId.get(sEntryId);
            if (virtualBillMapping == null) {
                virtualBillMapping = new VirtualBillMapping();
            }
            virtualBillMapping.addPurInBillId(tBillId);
            sEntryIdAndVirBillId.put(sEntryId, virtualBillMapping);
        }
        return sEntryIdAndVirBillId;
    }

    private HashMap<Long, Set<Long>> getTargetIsNotAuditSEntryIdMap(HashMap<Long, Set<Long>> sEntryIdAndTBillIds, String entityNo) {
        if (sEntryIdAndTBillIds.size() > 0) {
            HashSet billIds = new HashSet(10);
            sEntryIdAndTBillIds.entrySet().forEach(entry -> {
                if (entry.getValue() != null) {
                    billIds.addAll((Collection)entry.getValue());
                }
            });
            DynamicObjectCollection tarBillCol = QueryServiceHelper.query((String)entityNo, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds), new QFilter("billstatus", "=", (Object)"C")});
            if (tarBillCol.isEmpty()) {
                return sEntryIdAndTBillIds;
            }
            ArrayList auditTBillIds = new ArrayList(10);
            tarBillCol.forEach(bill -> auditTBillIds.add((Long)bill.get("id")));
            Iterator<Map.Entry<Long, Set<Long>>> iterator = sEntryIdAndTBillIds.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, Set<Long>> next = iterator.next();
                Set<Long> tarBillIds = next.getValue();
                if (tarBillIds == null || tarBillIds.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                ArrayList<Long> tarBillIdList = new ArrayList<Long>(tarBillIds);
                tarBillIdList.removeAll(auditTBillIds);
                if (!tarBillIdList.isEmpty()) continue;
                iterator.remove();
            }
        }
        return sEntryIdAndTBillIds;
    }

    private OperateOption getBFTrackerOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("botp_track_only_dirt_link", Boolean.TRUE.toString());
        return option;
    }

    class VirtualBillMapping {
        HashSet<Long> invBillIds;
        HashSet<Long> purInBillIds;

        VirtualBillMapping() {
        }

        public void addInvBillId(Long invBillId) {
            if (this.invBillIds == null) {
                this.invBillIds = new HashSet(5);
            }
            this.invBillIds.add(invBillId);
        }

        public void addPurInBillId(Long purInBillId) {
            if (this.purInBillIds == null) {
                this.purInBillIds = new HashSet(5);
            }
            this.purInBillIds.add(purInBillId);
        }

        public HashSet<Long> getInvBillIds() {
            return this.invBillIds;
        }

        public HashSet<Long> getPurInBillIds() {
            return this.purInBillIds;
        }

        public boolean isCouple() {
            return this.purInBillIds != null && this.invBillIds != null && this.purInBillIds.size() == this.invBillIds.size();
        }

        public String getSingleBillType() {
            if (this.purInBillIds == null) {
                return VMISettleInspectPlugin.ENTITY_PURINBILL;
            }
            if (this.invBillIds == null) {
                return VMISettleInspectPlugin.this.invEntity;
            }
            if (this.invBillIds.size() > this.purInBillIds.size()) {
                return VMISettleInspectPlugin.ENTITY_PURINBILL;
            }
            if (this.invBillIds.size() < this.purInBillIds.size()) {
                return VMISettleInspectPlugin.this.invEntity;
            }
            return null;
        }
    }

    static class TranserBillInfo {
        private Map<Long, Long> innerDealEntryIdAndBillId = new HashMap<Long, Long>(10);
        private Map<Long, Long> isNotInnerDealEntryIdAndBillId = new HashMap<Long, Long>(10);
        private Map<Long, String> billIdAndBillNo = new HashMap<Long, String>(10);

        TranserBillInfo() {
        }

        public Map<Long, Long> getInnerDealEntryIdAndBillId() {
            return this.innerDealEntryIdAndBillId;
        }

        public Map<Long, Long> getIsNotInnerDealEntryIdAndBillId() {
            return this.isNotInnerDealEntryIdAndBillId;
        }

        public Map<Long, String> getBillIdAndBillNo() {
            return this.billIdAndBillNo;
        }

        public void addInnerDealEntryIdAndBillId(Long innerEntryId, Long innerBillId) {
            this.innerDealEntryIdAndBillId.put(innerEntryId, innerBillId);
        }

        public void addIsNotInnerDealEntryIdAndBillId(Long isNotInnerEntryId, Long isNotInnerBillId) {
            this.isNotInnerDealEntryIdAndBillId.put(isNotInnerEntryId, isNotInnerBillId);
        }

        public void addBillIdAndBillNo(Long billId, String billNo) {
            this.billIdAndBillNo.put(billId, billNo);
        }
    }
}

